/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.api.impl.SessionInfos;
import org.bonitasoft.engine.bpm.process.ActivationState;
import org.bonitasoft.engine.bpm.process.ProcessActivationException;
import org.bonitasoft.engine.bpm.process.ProcessDefinitionNotFoundException;
import org.bonitasoft.engine.bpm.process.ProcessExecutionException;
import org.bonitasoft.engine.bpm.process.ProcessInstance;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.SProcessDefinitionNotFoundException;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinitionDeployInfo;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.exception.BonitaRuntimeException;
import org.bonitasoft.engine.exception.RetrieveException;
import org.bonitasoft.engine.execution.Filter;
import org.bonitasoft.engine.execution.FlowNodeNameFilter;
import org.bonitasoft.engine.execution.FlowNodeSelector;
import org.bonitasoft.engine.execution.ProcessExecutor;
import org.bonitasoft.engine.execution.StartFlowNodeFilter;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.operation.Operation;
import org.bonitasoft.engine.service.ModelConvertor;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceSingleton;
import org.bonitasoft.engine.service.impl.ServiceAccessorFactory;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;

public class ProcessStarter {
    private final long userId;
    private final long processDefinitionId;
    private final List<Operation> operations;
    private final Map<String, Serializable> context;
    private final Filter<SFlowNodeDefinition> filter;

    private ProcessStarter(long userId, long processDefinitionId, List<Operation> operations, Map<String, Serializable> context, Filter<SFlowNodeDefinition> filter) {
        this.userId = userId;
        this.processDefinitionId = processDefinitionId;
        this.operations = operations;
        this.context = context;
        this.filter = filter;
    }

    public ProcessStarter(long userId, long processDefinitionId, List<Operation> operations, Map<String, Serializable> context) {
        this(userId, processDefinitionId, operations, context, new StartFlowNodeFilter());
    }

    public ProcessStarter(long userId, long processDefinitionId, List<Operation> operations, Map<String, Serializable> context, List<String> activityNames) {
        this(userId, processDefinitionId, operations, context, new FlowNodeNameFilter(activityNames));
    }

    public ProcessInstance start() throws ProcessDefinitionNotFoundException, ProcessActivationException, ProcessExecutionException {
        SProcessInstance startedInstance;
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SProcessDefinition sProcessDefinition = this.retrieveProcessDefinition(processDefinitionService);
        ProcessExecutor processExecutor = tenantAccessor.getProcessExecutor();
        long userIdFromSession = SessionInfos.getUserIdFromSession();
        long starterId = this.userId == 0L ? userIdFromSession : this.userId;
        try {
            List<SOperation> sOperations = ModelConvertor.toSOperation(this.operations);
            Map<String, Object> operationContext = this.context != null ? new HashMap<String, Serializable>(this.context) : Collections.emptyMap();
            startedInstance = processExecutor.start(starterId, userIdFromSession, sOperations, operationContext, null, new FlowNodeSelector(sProcessDefinition, this.filter));
        }
        catch (SBonitaException e) {
            throw new ProcessExecutionException((Throwable)e);
        }
        ProcessInstance processInstance = ModelConvertor.toProcessInstance(sProcessDefinition, startedInstance);
        TechnicalLoggerService logger = tenantAccessor.getTechnicalLoggerService();
        this.logInstanceStarted(sProcessDefinition, starterId, userIdFromSession, processInstance, logger);
        return processInstance;
    }

    private SProcessDefinition retrieveProcessDefinition(ProcessDefinitionService processDefinitionService) throws ProcessActivationException, ProcessDefinitionNotFoundException {
        SProcessDefinition sProcessDefinition;
        try {
            SProcessDefinitionDeployInfo deployInfo = processDefinitionService.getProcessDeploymentInfo(this.processDefinitionId);
            if (ActivationState.DISABLED.name().equals(deployInfo.getActivationState())) {
                throw new ProcessActivationException("Process disabled");
            }
            sProcessDefinition = processDefinitionService.getProcessDefinition(this.processDefinitionId);
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
        return sProcessDefinition;
    }

    private void logInstanceStarted(SProcessDefinition sProcessDefinition, long starterId, long userIdFromSession, ProcessInstance processInstance, TechnicalLoggerService logger) {
        if (logger.isLoggable(this.getClass(), TechnicalLogSeverity.INFO)) {
            StringBuilder stb = new StringBuilder();
            stb.append("The user <");
            stb.append(SessionInfos.getUserNameFromSession());
            if (starterId != userIdFromSession) {
                stb.append("> acting as delegate of user with id <");
                stb.append(starterId);
            }
            stb.append("> has started instance <");
            stb.append(processInstance.getId());
            stb.append("> of process <");
            stb.append(sProcessDefinition.getName());
            stb.append("> in version <");
            stb.append(sProcessDefinition.getVersion());
            stb.append("> and id <");
            stb.append(sProcessDefinition.getId());
            stb.append(">");
            logger.log(this.getClass(), TechnicalLogSeverity.INFO, stb.toString());
        }
    }

    protected TenantServiceAccessor getTenantAccessor() {
        try {
            SessionAccessor sessionAccessor = ServiceAccessorFactory.getInstance().createSessionAccessor();
            long tenantId = sessionAccessor.getTenantId();
            return TenantServiceSingleton.getInstance(tenantId);
        }
        catch (Exception e) {
            throw new BonitaRuntimeException((Throwable)e);
        }
    }
}

