/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.api.ProfileAPI;
import org.bonitasoft.engine.api.impl.transaction.profile.CreateProfileMember;
import org.bonitasoft.engine.api.impl.transaction.profile.DeleteProfileMember;
import org.bonitasoft.engine.api.impl.transaction.profile.GetNumberOfProfileMembers;
import org.bonitasoft.engine.api.impl.transaction.profile.GetProfile;
import org.bonitasoft.engine.api.impl.transaction.profile.GetProfileEntry;
import org.bonitasoft.engine.api.impl.transaction.profile.GetProfilesForUser;
import org.bonitasoft.engine.command.SGroupProfileMemberAlreadyExistsException;
import org.bonitasoft.engine.command.SRoleProfileMemberAlreadyExistsException;
import org.bonitasoft.engine.command.SUserMembershipProfileMemberAlreadyExistsException;
import org.bonitasoft.engine.command.SUserProfileMemberAlreadyExistsException;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.exception.AlreadyExistsException;
import org.bonitasoft.engine.exception.BonitaRuntimeException;
import org.bonitasoft.engine.exception.CreationException;
import org.bonitasoft.engine.exception.DeletionException;
import org.bonitasoft.engine.exception.RetrieveException;
import org.bonitasoft.engine.exception.SearchException;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.MemberType;
import org.bonitasoft.engine.persistence.SBonitaSearchException;
import org.bonitasoft.engine.profile.Profile;
import org.bonitasoft.engine.profile.ProfileEntry;
import org.bonitasoft.engine.profile.ProfileEntryNotFoundException;
import org.bonitasoft.engine.profile.ProfileMember;
import org.bonitasoft.engine.profile.ProfileMemberCreator;
import org.bonitasoft.engine.profile.ProfileNotFoundException;
import org.bonitasoft.engine.profile.ProfileService;
import org.bonitasoft.engine.profile.exception.profile.SProfileNotFoundException;
import org.bonitasoft.engine.profile.model.SProfile;
import org.bonitasoft.engine.profile.model.SProfileMember;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.SearchOptionsBuilder;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.search.descriptor.SearchEntitiesDescriptor;
import org.bonitasoft.engine.search.descriptor.SearchEntityDescriptor;
import org.bonitasoft.engine.search.descriptor.SearchProfileMemberUserDescriptor;
import org.bonitasoft.engine.search.profile.SearchProfileEntries;
import org.bonitasoft.engine.search.profile.SearchProfileMembersForProfile;
import org.bonitasoft.engine.search.profile.SearchProfiles;
import org.bonitasoft.engine.service.ModelConvertor;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceSingleton;
import org.bonitasoft.engine.service.impl.ServiceAccessorFactory;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;

public class ProfileAPIImpl
implements ProfileAPI {
    protected TenantServiceAccessor getTenantAccessor() {
        try {
            SessionAccessor sessionAccessor = ServiceAccessorFactory.getInstance().createSessionAccessor();
            long tenantId = sessionAccessor.getTenantId();
            return TenantServiceSingleton.getInstance(tenantId);
        }
        catch (Exception e) {
            throw new BonitaRuntimeException((Throwable)e);
        }
    }

    public Profile getProfile(long id) throws ProfileNotFoundException {
        SProfile profile;
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProfileService profileService = tenantAccessor.getProfileService();
        GetProfile getProfileTransaction = new GetProfile(profileService, id);
        try {
            getProfileTransaction.execute();
            profile = getProfileTransaction.getResult();
        }
        catch (SProfileNotFoundException e) {
            throw new ProfileNotFoundException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
        return ModelConvertor.toProfile(profile);
    }

    public List<Profile> getProfilesForUser(long userId) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProfileService profileService = tenantAccessor.getProfileService();
        GetProfilesForUser getProfilesForUser = new GetProfilesForUser(profileService, userId);
        try {
            getProfilesForUser.execute();
            Object profiles = getProfilesForUser.getResult();
            return ModelConvertor.toProfiles((List<SProfile>)profiles);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public SearchResult<Profile> searchProfiles(SearchOptions options) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProfileService profileService = tenantAccessor.getProfileService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        SearchProfiles searchProfileTransaction = new SearchProfiles(profileService, searchEntitiesDescriptor.getSearchProfileDescriptor(), options);
        try {
            searchProfileTransaction.execute();
            return searchProfileTransaction.getResult();
        }
        catch (SBonitaException sbe) {
            throw new SearchException((Throwable)sbe);
        }
    }

    protected String getQuerySuffix(MemberType memberType) {
        String suffix = null;
        switch (memberType) {
            case USER: {
                suffix = "ForUser";
                break;
            }
            case GROUP: {
                suffix = "ForGroup";
                break;
            }
            case ROLE: {
                suffix = "ForRole";
                break;
            }
            case MEMBERSHIP: {
                suffix = "ForRoleAndGroup";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return suffix;
    }

    public Map<Long, Long> getNumberOfProfileMembers(List<Long> profileIds) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProfileService profileService = tenantAccessor.getProfileService();
        GetNumberOfProfileMembers numberOfProfileMembers = new GetNumberOfProfileMembers(profileIds, profileService);
        try {
            numberOfProfileMembers.execute();
            Object listOfProfileMembers = numberOfProfileMembers.getResult();
            HashMap<Long, SProfileMember> profileMembers = new HashMap<Long, SProfileMember>();
            HashMap<Long, Long> result = new HashMap<Long, Long>();
            Iterator<Object> i$ = listOfProfileMembers.iterator();
            while (i$.hasNext()) {
                SProfileMember p = (SProfileMember)i$.next();
                profileMembers.put(p.getProfileId(), p);
            }
            for (Long obj : profileMembers.keySet()) {
                long number = 0L;
                Iterator i$2 = listOfProfileMembers.iterator();
                while (i$2.hasNext()) {
                    SProfileMember listOfProfileMember = (SProfileMember)i$2.next();
                    long tempProfileId = listOfProfileMember.getProfileId();
                    if (obj != tempProfileId) continue;
                    ++number;
                }
                result.put(obj, number);
            }
            return result;
        }
        catch (SBonitaException sbe) {
            throw new RetrieveException((Throwable)sbe);
        }
    }

    public SearchResult<ProfileMember> searchProfileMembers(String memberType, SearchOptions options) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProfileService profileService = tenantAccessor.getProfileService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        try {
            SearchProfileMembersForProfile searchProfileMembersForProfile = new SearchProfileMembersForProfile(this.getProfileMemberQuerySuffix(memberType), profileService, this.getProfileMemberDescriptor(searchEntitiesDescriptor, memberType), options);
            searchProfileMembersForProfile.execute();
            return searchProfileMembersForProfile.getResult();
        }
        catch (SBonitaException sbe) {
            throw new SearchException((Throwable)sbe);
        }
    }

    private SearchEntityDescriptor getProfileMemberDescriptor(SearchEntitiesDescriptor searchEntitiesDescriptor, String memberType) throws SBonitaSearchException {
        if ("user".equals(memberType)) {
            return searchEntitiesDescriptor.getSearchProfileMemberUserDescriptor();
        }
        if ("group".equals(memberType)) {
            return searchEntitiesDescriptor.getSearchProfileMemberGroupDescriptor();
        }
        if ("role".equals(memberType)) {
            return searchEntitiesDescriptor.getSearchProfileMemberRoleDescriptor();
        }
        if ("roleAndGroup".equals(memberType)) {
            return searchEntitiesDescriptor.getSearchProfileMemberRoleAndGroupDescriptor();
        }
        throw new SBonitaSearchException("Member type must be equalse to user,group,role or roleAndGroup.");
    }

    private String getProfileMemberQuerySuffix(String memberType) throws SBonitaSearchException {
        if ("user".equals(memberType)) {
            return "ForUser";
        }
        if ("group".equals(memberType)) {
            return "ForGroup";
        }
        if ("role".equals(memberType)) {
            return "ForRole";
        }
        if ("roleAndGroup".equals(memberType)) {
            return "ForRoleAndGroup";
        }
        throw new SBonitaSearchException("Member type must be equalse to user,group,role or roleAndGroup.");
    }

    public SearchResult<ProfileEntry> searchProfileEntries(SearchOptions options) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProfileService profileService = tenantAccessor.getProfileService();
        SearchProfileEntries searchProfileEntries = new SearchProfileEntries(profileService, tenantAccessor.getSearchEntitiesDescriptor().getSearchProfileEntryDescriptor(), options);
        try {
            searchProfileEntries.execute();
            return searchProfileEntries.getResult();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
    }

    public ProfileEntry getProfileEntry(long id) throws ProfileEntryNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProfileService profileService = tenantAccessor.getProfileService();
        GetProfileEntry getProfileEntryTransaction = new GetProfileEntry(profileService, id);
        try {
            getProfileEntryTransaction.execute();
        }
        catch (SBonitaException e) {
            throw new ProfileEntryNotFoundException((Throwable)e);
        }
        return ModelConvertor.toProfileEntry(getProfileEntryTransaction.getResult());
    }

    public ProfileMember createProfileMember(Long profileId, Long userId, Long groupId, Long roleId) throws CreationException, AlreadyExistsException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProfileService profileService = tenantAccessor.getProfileService();
        IdentityService identityService = tenantAccessor.getIdentityService();
        MemberType memberType = this.getMemberType(userId, groupId, roleId);
        CreateProfileMember createProfileMember = new CreateProfileMember(profileService, identityService, profileId, userId, groupId, roleId, memberType);
        try {
            this.checkIfProfileMemberExists(tenantAccessor, profileService, profileId, userId, groupId, roleId, memberType);
        }
        catch (SBonitaException e1) {
            throw new AlreadyExistsException((Throwable)e1);
        }
        try {
            createProfileMember.execute();
            ProfileMember profileMember = ModelConvertor.toProfileMember(createProfileMember.getResult());
            return profileMember;
        }
        catch (SBonitaException e) {
            throw new CreationException((Throwable)e);
        }
    }

    public ProfileMember createProfileMember(ProfileMemberCreator creator) throws CreationException, AlreadyExistsException {
        if (creator == null) {
            throw new CreationException("Unable to create a profile member with a null creator!");
        }
        SProfileMember sProfileMember = ModelConvertor.constructSProfileMember(creator);
        return this.createProfileMember(sProfileMember.getProfileId(), sProfileMember.getUserId(), sProfileMember.getGroupId(), sProfileMember.getRoleId());
    }

    protected void checkIfProfileMemberExists(TenantServiceAccessor tenantAccessor, ProfileService profileService, Long profileId, Long userId, Long groupId, Long roleId, MemberType memberType) throws SBonitaException {
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        SearchProfileMemberUserDescriptor searchDescriptor = searchEntitiesDescriptor.getSearchProfileMemberUserDescriptor();
        SearchOptionsBuilder searchOptionsBuilder = new SearchOptionsBuilder(0, 1);
        searchOptionsBuilder.filter("profileId", (Serializable)profileId);
        switch (memberType) {
            case USER: {
                SearchProfileMembersForProfile searchProfileMembersForProfile = new SearchProfileMembersForProfile("ForUser", profileService, searchDescriptor, searchOptionsBuilder.done());
                searchOptionsBuilder.filter("userId", (Serializable)userId);
                searchProfileMembersForProfile.execute();
                if (searchProfileMembersForProfile.getResult().getCount() == 0L) break;
                throw new SUserProfileMemberAlreadyExistsException("A profileMember with userId \"" + userId + "\" already exists");
            }
            case GROUP: {
                SearchProfileMembersForProfile searchProfileMembersForProfile = new SearchProfileMembersForProfile("ForGroup", profileService, searchDescriptor, searchOptionsBuilder.done());
                searchOptionsBuilder.filter("groupId", (Serializable)groupId);
                searchProfileMembersForProfile.execute();
                if (searchProfileMembersForProfile.getResult().getCount() == 0L) break;
                throw new SGroupProfileMemberAlreadyExistsException("A profileMember with groupId \"" + groupId + "\" already exists");
            }
            case ROLE: {
                SearchProfileMembersForProfile searchProfileMembersForProfile = new SearchProfileMembersForProfile("ForRole", profileService, searchDescriptor, searchOptionsBuilder.done());
                searchOptionsBuilder.filter("roleId", (Serializable)roleId);
                searchProfileMembersForProfile.execute();
                if (searchProfileMembersForProfile.getResult().getCount() == 0L) break;
                throw new SRoleProfileMemberAlreadyExistsException("A profileMember with roleId \"" + roleId + "\" already exists");
            }
            default: {
                SearchProfileMembersForProfile searchProfileMembersForProfile = new SearchProfileMembersForProfile("ForRoleAndGroup", profileService, searchDescriptor, searchOptionsBuilder.done());
                searchOptionsBuilder.filter("roleId", (Serializable)roleId);
                searchOptionsBuilder.filter("groupId", (Serializable)groupId);
                searchProfileMembersForProfile.execute();
                if (searchProfileMembersForProfile.getResult().getCount() == 0L) break;
                throw new SUserMembershipProfileMemberAlreadyExistsException("A profileMember with groupId \"" + groupId + "\" and roleId \"" + roleId + "\" already exists");
            }
        }
    }

    public MemberType getMemberType(Long userId, Long groupId, Long roleId) throws CreationException {
        MemberType memberType = null;
        if (userId != null) {
            memberType = MemberType.USER;
        } else if (groupId != null && roleId == null) {
            memberType = MemberType.GROUP;
        } else if (roleId != null && groupId == null) {
            memberType = MemberType.ROLE;
        } else if (roleId != null && groupId != null) {
            memberType = MemberType.MEMBERSHIP;
        } else {
            StringBuilder stb = new StringBuilder("Parameters map must contain at least one of entries: ");
            stb.append("userId");
            stb.append(", ");
            stb.append("groupId");
            stb.append(", ");
            stb.append("roleId");
            throw new CreationException(stb.toString());
        }
        return memberType;
    }

    public void deleteProfileMember(Long profilMemberId) throws DeletionException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProfileService profileService = tenantAccessor.getProfileService();
        DeleteProfileMember deleteUserProfileTransaction = new DeleteProfileMember(profileService, profilMemberId);
        try {
            deleteUserProfileTransaction.execute();
        }
        catch (SBonitaException e) {
            throw new DeletionException((Throwable)e);
        }
    }
}

