/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.identity;

import java.util.List;
import org.bonitasoft.engine.actor.mapping.ActorMappingService;
import org.bonitasoft.engine.actor.mapping.SActorMemberDeletionException;
import org.bonitasoft.engine.actor.mapping.SActorMemberNotFoundException;
import org.bonitasoft.engine.actor.mapping.model.SActorMember;
import org.bonitasoft.engine.api.impl.transaction.identity.DeleteWithActorMembers;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.SIdentityException;
import org.bonitasoft.engine.identity.SUserNotFoundException;
import org.bonitasoft.engine.identity.model.SUserMembership;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.profile.ProfileService;
import org.bonitasoft.engine.profile.builder.SProfileMemberBuilderFactory;
import org.bonitasoft.engine.profile.model.SProfileMember;

public class DeleteUser
extends DeleteWithActorMembers
implements TransactionContent {
    private final IdentityService identityService;
    private final ActorMappingService actorMappingService;
    private final ProfileService profileService;
    private final long userId;
    private final String userName;

    public DeleteUser(IdentityService identityService, ActorMappingService actorMappingService, ProfileService profileService, long userId) {
        this.identityService = identityService;
        this.actorMappingService = actorMappingService;
        this.profileService = profileService;
        this.userId = userId;
        this.userName = null;
    }

    public DeleteUser(IdentityService identityService, ActorMappingService actorMappingService, ProfileService profileService, String userName) {
        this.identityService = identityService;
        this.actorMappingService = actorMappingService;
        this.profileService = profileService;
        this.userId = -1L;
        this.userName = userName;
    }

    @Override
    public void execute() throws SBonitaException {
        try {
            long id = this.userId;
            if (id == -1L) {
                id = this.identityService.getUserByUserName(this.userName).getId();
            }
            this.deleteUserMembershipsByUser(id);
            this.deleteActorMembers(id);
            this.deleteProfileMembers(id);
            this.identityService.deleteUser(id);
        }
        catch (SUserNotFoundException sUserNotFoundException) {
            // empty catch block
        }
    }

    private void deleteProfileMembers(long id) throws SBonitaException {
        List<SProfileMember> profileMembersOfUser;
        String field = BuilderFactory.get(SProfileMemberBuilderFactory.class).getIdKey();
        do {
            profileMembersOfUser = this.profileService.getProfileMembersOfUser(id, 0, 20, field, OrderByType.ASC);
            for (SProfileMember sProfileMember : profileMembersOfUser) {
                this.profileService.deleteProfileMember(sProfileMember);
            }
        } while (profileMembersOfUser.size() == 20);
    }

    private void deleteActorMembers(long id) throws SActorMemberNotFoundException, SActorMemberDeletionException, SBonitaReadException {
        List<SActorMember> actorMembers = this.actorMappingService.getActorMembersOfUser(id);
        for (SActorMember sActorMember : actorMembers) {
            this.setActorIdsOfRemovedElements(this.actorMappingService.removeActorMember(sActorMember.getId()));
        }
    }

    private void deleteUserMembershipsByUser(long id) throws SIdentityException {
        List<SUserMembership> sUserMemberships = this.identityService.getUserMembershipsOfUser(id);
        for (SUserMembership sUserMembership : sUserMemberships) {
            this.identityService.deleteUserMembership(sUserMembership.getId());
        }
    }
}

