/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.builder;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class BuilderFactory {
    private static final String BUILDER_FACTORIES_DEFAULT_FILE = "builder-factories.properties";
    private static final String BUILDER_FACTORIES_EXTENSION_FILE = "builder-factories-ext.properties";
    private final Map<String, Object> factoryCache;
    private final Properties properties;
    private static final Object MUTEX = new Object();
    private static BuilderFactory INSTANCE = null;

    private BuilderFactory(Properties properties) {
        this.properties = properties;
        this.factoryCache = new HashMap<String, Object>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BuilderFactory getInstance() {
        if (INSTANCE == null) {
            Object object = MUTEX;
            synchronized (object) {
                if (INSTANCE == null) {
                    URL defaultFileURL = null;
                    try {
                        defaultFileURL = BuilderFactory.class.getResource(BUILDER_FACTORIES_DEFAULT_FILE);
                        Properties defaultProperties = BuilderFactory.getProperties(defaultFileURL);
                        Properties allProperties = new Properties(defaultProperties);
                        URL extensionFileURL = BuilderFactory.class.getResource(BUILDER_FACTORIES_EXTENSION_FILE);
                        if (extensionFileURL != null) {
                            Properties extensionProperties = BuilderFactory.getProperties(extensionFileURL);
                            allProperties.putAll((Map<?, ?>)extensionProperties);
                        }
                        INSTANCE = new BuilderFactory(allProperties);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to load builder factories from : fileURL=" + defaultFileURL);
                    }
                }
            }
        }
        return INSTANCE;
    }

    private synchronized void cacheFactory(String interfaceName, String className) {
        try {
            if ("null".equals(className)) {
                throw new Exception("Factory implementation of " + interfaceName + " is required.");
            }
            Class<?> clazz = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            Object factory = clazz.newInstance();
            this.factoryCache.put(interfaceName, factory);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T get(Class<T> clazz) {
        T factoryImplementation = BuilderFactory.getInstance().getInternalBuilderFactory(clazz);
        if (factoryImplementation == null) {
            throw new RuntimeException("No factory found for interface: " + clazz);
        }
        return factoryImplementation;
    }

    private <T> T getInternalBuilderFactory(Class<T> clazz) {
        if (!this.factoryCache.containsKey(clazz)) {
            this.cacheFactory(clazz.getName(), this.properties.getProperty(clazz.getName()));
        }
        return (T)this.factoryCache.get(clazz.getName());
    }

    public static Properties getProperties(URL url) throws IOException {
        InputStreamReader reader = new InputStreamReader(url.openStream());
        return BuilderFactory.getProperties(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getProperties(Reader reader) throws IOException {
        Properties properties = new Properties();
        try {
            properties.load(reader);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            reader.close();
        }
    }
}

