/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.classloader;

import java.io.InputStream;
import org.bonitasoft.engine.classloader.ClassLoaderException;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.classloader.ParentClassLoaderResolver;

public class ParentRedirectClassLoader
extends ClassLoader {
    private static final String UNABLE_TO_FIND_THE_PARENT_CLASSLOADER_DYNAMICALLY = "Unable to find the parent classloader dynamically.";
    private final ParentClassLoaderResolver parentClassLoaderResolver;
    private final ClassLoaderService classLoaderService;
    private final String childClassLoaderType;
    private final long childClassLoaderId;

    public ParentRedirectClassLoader(ClassLoader globalClassLoader, ParentClassLoaderResolver parentClassLoaderResolver, ClassLoaderService classLoaderService, String childClassLoaderType, long childClassLoaderId) {
        super(globalClassLoader);
        this.parentClassLoaderResolver = parentClassLoaderResolver;
        this.classLoaderService = classLoaderService;
        this.childClassLoaderType = childClassLoaderType;
        this.childClassLoaderId = childClassLoaderId;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        try {
            return this.parentClassLoaderResolver.getParent(this.classLoaderService, this.childClassLoaderType, this.childClassLoaderId).loadClass(name);
        }
        catch (ClassLoaderException e) {
            throw new ClassNotFoundException(UNABLE_TO_FIND_THE_PARENT_CLASSLOADER_DYNAMICALLY, e);
        }
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        try {
            return this.parentClassLoaderResolver.getParent(this.classLoaderService, this.childClassLoaderType, this.childClassLoaderId).getResourceAsStream(name);
        }
        catch (ClassLoaderException e) {
            throw new RuntimeException(UNABLE_TO_FIND_THE_PARENT_CLASSLOADER_DYNAMICALLY, e);
        }
    }
}

