/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.command;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.api.impl.ProcessStarter;
import org.bonitasoft.engine.bpm.process.ProcessActivationException;
import org.bonitasoft.engine.bpm.process.ProcessDefinitionNotFoundException;
import org.bonitasoft.engine.bpm.process.ProcessExecutionException;
import org.bonitasoft.engine.bpm.process.ProcessInstance;
import org.bonitasoft.engine.command.SCommandExecutionException;
import org.bonitasoft.engine.command.SCommandParameterizationException;
import org.bonitasoft.engine.command.system.CommandWithParameters;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.execution.AdvancedStartProcessValidator;
import org.bonitasoft.engine.operation.Operation;
import org.bonitasoft.engine.service.TenantServiceAccessor;

public class AdvancedStartProcessCommand
extends CommandWithParameters {
    public static final String STARTED_BY = "started_by";
    public static final String PROCESS_DEFINITION_ID = "process_definition_id";
    public static final String ACTIVITY_NAME = "activity_name";
    public static final String OPERATIONS = "operations";
    public static final String CONTEXT = "context";

    @Override
    public Serializable execute(Map<String, Serializable> parameters, TenantServiceAccessor serviceAccessor) throws SCommandParameterizationException, SCommandExecutionException {
        ProcessInstance processInstance;
        long processDefinitionId = this.getProcessDefinitionId(parameters);
        List<String> activityNames = Collections.singletonList(this.getActivityName(parameters));
        long startedBy = this.getStartedBy(parameters);
        Map<String, Serializable> context = this.getContext(parameters);
        List<Operation> operations = this.getOperations(parameters);
        try {
            this.validateInputs(serviceAccessor, processDefinitionId, activityNames);
            processInstance = this.startProcess(processDefinitionId, activityNames, startedBy, context, operations);
        }
        catch (Exception e) {
            throw new SCommandExecutionException(e);
        }
        return processInstance;
    }

    private ProcessInstance startProcess(long processDefinitionId, List<String> activityNames, long startedBy, Map<String, Serializable> context, List<Operation> operations) throws ProcessDefinitionNotFoundException, ProcessActivationException, ProcessExecutionException {
        ProcessStarter starter = new ProcessStarter(startedBy, processDefinitionId, operations, context, activityNames);
        ProcessInstance processInstance = starter.start();
        return processInstance;
    }

    private void validateInputs(TenantServiceAccessor serviceAccessor, long processDefinitionId, List<String> activityNames) throws SBonitaException, SCommandExecutionException {
        AdvancedStartProcessValidator validator = new AdvancedStartProcessValidator(serviceAccessor.getProcessDefinitionService(), processDefinitionId);
        List<String> problems = validator.validate(activityNames);
        this.handleProblems(problems);
    }

    private void handleProblems(List<String> problems) throws SCommandExecutionException {
        if (!problems.isEmpty()) {
            StringBuilder stb = new StringBuilder();
            for (String problem : problems) {
                stb.append(problem);
                stb.append("\n");
            }
            throw new SCommandExecutionException(stb.toString());
        }
    }

    private Long getStartedBy(Map<String, Serializable> parameters) throws SCommandParameterizationException {
        return (Long)this.getMandatory(STARTED_BY, parameters);
    }

    private Long getProcessDefinitionId(Map<String, Serializable> parameters) throws SCommandParameterizationException {
        return (Long)this.getMandatory(PROCESS_DEFINITION_ID, parameters);
    }

    private List<Operation> getOperations(Map<String, Serializable> parameters) throws SCommandParameterizationException {
        return (List)this.get(OPERATIONS, parameters);
    }

    private Map<String, Serializable> getContext(Map<String, Serializable> parameters) throws SCommandParameterizationException {
        return (Map)this.get(CONTEXT, parameters);
    }

    private String getActivityName(Map<String, Serializable> parameters) throws SCommandParameterizationException {
        return (String)this.getMandatory(ACTIVITY_NAME, parameters);
    }

    private <T> T get(String parameter, Map<String, Serializable> parameters) throws SCommandParameterizationException {
        return this.getParameter(parameters, parameter, "An error occurred while parsing " + parameter);
    }

    private <T> T getMandatory(String parameter, Map<String, Serializable> parameters) throws SCommandParameterizationException {
        return this.getMandatoryParameter(parameters, parameter, "Missing mandatory field: " + parameter);
    }
}

