/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.filter.impl;

import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.api.APIAccessor;
import org.bonitasoft.engine.connector.EngineExecutionContext;
import org.bonitasoft.engine.connector.SConnector;
import org.bonitasoft.engine.connector.exception.SConnectorException;
import org.bonitasoft.engine.filter.AbstractUserFilter;
import org.bonitasoft.engine.filter.UserFilter;
import org.bonitasoft.engine.filter.UserFilterException;

public class SConnectorUserFilterAdapter
implements SConnector {
    private final UserFilter filter;
    private List<Long> userIds;
    private boolean shouldAutoAssignTaskIfSingleResult;
    private final String actorName;

    public SConnectorUserFilterAdapter(UserFilter filter, String actorName) {
        this.filter = filter;
        this.actorName = actorName;
    }

    @Override
    public void setInputParameters(Map<String, Object> parameters) {
        APIAccessor apiAccessor = (APIAccessor)parameters.remove("connectorApiAccessor");
        EngineExecutionContext executionContext = (EngineExecutionContext)parameters.remove("engineExecutionContext");
        if (this.filter instanceof AbstractUserFilter) {
            ((AbstractUserFilter)this.filter).setAPIAccessor(apiAccessor);
            if (executionContext != null) {
                ((AbstractUserFilter)this.filter).setExecutionContext(executionContext);
            }
        }
        this.filter.setInputParameters(parameters);
    }

    @Override
    public void validate() {
    }

    @Override
    public Map<String, Object> execute() throws SConnectorException {
        try {
            this.userIds = this.filter.filter(this.actorName);
            this.shouldAutoAssignTaskIfSingleResult = this.filter.shouldAutoAssignTaskIfSingleResult();
        }
        catch (UserFilterException e) {
            throw new SConnectorException(e);
        }
        return null;
    }

    public List<Long> getUserIds() {
        return this.userIds;
    }

    public boolean shouldAutoAssignTaskIfSingleResult() {
        return this.shouldAutoAssignTaskIfSingleResult;
    }

    @Override
    public void connect() {
    }

    @Override
    public void disconnect() {
    }
}

