/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.login;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.bonitasoft.engine.authentication.AuthenticationException;
import org.bonitasoft.engine.authentication.AuthenticationService;
import org.bonitasoft.engine.core.login.LoginService;
import org.bonitasoft.engine.core.login.SLoginException;
import org.bonitasoft.engine.core.login.TechnicalUser;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.home.BonitaHomeServer;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.SUserNotFoundException;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.io.PropertiesManager;
import org.bonitasoft.engine.session.SSessionException;
import org.bonitasoft.engine.session.SSessionNotFoundException;
import org.bonitasoft.engine.session.SessionService;
import org.bonitasoft.engine.session.model.SSession;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;

public class SecuredLoginServiceImpl
implements LoginService {
    private final AuthenticationService authenticationService;
    private final SessionService sessionService;
    private final SessionAccessor sessionAccessor;
    private final IdentityService identityService;

    public SecuredLoginServiceImpl(AuthenticationService authenticationService, SessionService sessionService, SessionAccessor sessionAccessor, IdentityService identityService) {
        this.authenticationService = authenticationService;
        this.sessionService = sessionService;
        this.sessionAccessor = sessionAccessor;
        this.identityService = identityService;
    }

    @Override
    public SSession login(long tenantId, String userName, String password) throws SLoginException {
        long userId;
        boolean isTechnicalUser;
        block12: {
            this.sessionAccessor.setSessionInfo(-1L, tenantId);
            isTechnicalUser = false;
            try {
                boolean valid = this.authenticationService.checkUserCredentials(userName, password);
                if (valid) {
                    SUser user = this.identityService.getUserByUserName(userName);
                    userId = user.getId();
                    break block12;
                }
                TechnicalUser technicalUser = this.getTechnicalUser(tenantId);
                if (technicalUser.getUserName().equals(userName) && technicalUser.getPassword().equals(password)) {
                    isTechnicalUser = true;
                    userId = -1L;
                    break block12;
                }
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    throw new SLoginException("User name or password is not valid!");
                }
                throw new SLoginException("User name or password is not valid!");
            }
            catch (AuthenticationException ae) {
                throw new SLoginException(ae);
            }
            catch (SUserNotFoundException e) {
                throw new SLoginException("Unable to found user " + userName);
            }
            finally {
                this.sessionAccessor.deleteSessionId();
            }
        }
        try {
            return this.sessionService.createSession(tenantId, userId, userName, isTechnicalUser);
        }
        catch (SSessionException e) {
            throw new SLoginException(e);
        }
    }

    @Override
    public void logout(long sessionId) throws SSessionNotFoundException {
        this.sessionService.deleteSession(sessionId);
    }

    @Override
    public boolean isValid(long sessionId) {
        try {
            return this.sessionService.isValid(sessionId);
        }
        catch (SSessionNotFoundException e) {
            return false;
        }
    }

    private TechnicalUser getTechnicalUser(long tenantId) throws SLoginException {
        try {
            String technicalUserPropertiesPath = BonitaHomeServer.getInstance().getTenantConfFolder(tenantId) + File.separator + "bonita-server.properties";
            Properties properties = PropertiesManager.getProperties((File)new File(technicalUserPropertiesPath));
            String userName = (String)properties.get("userName");
            String password = (String)properties.get("userPassword");
            return new TechnicalUser(userName, password);
        }
        catch (BonitaHomeNotSetException e) {
            throw new SLoginException(e);
        }
        catch (IOException e) {
            throw new SLoginException(e);
        }
    }
}

