/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.document.api.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.exceptions.SObjectModificationException;
import org.bonitasoft.engine.core.process.document.api.ProcessDocumentService;
import org.bonitasoft.engine.core.process.document.api.SProcessDocumentContentNotFoundException;
import org.bonitasoft.engine.core.process.document.api.SProcessDocumentCreationException;
import org.bonitasoft.engine.core.process.document.api.SProcessDocumentDeletionException;
import org.bonitasoft.engine.core.process.document.api.impl.SDocumentDownloadURLProvider;
import org.bonitasoft.engine.core.process.document.mapping.DocumentMappingService;
import org.bonitasoft.engine.core.process.document.mapping.exception.SDocumentMappingDeletionException;
import org.bonitasoft.engine.core.process.document.mapping.exception.SDocumentMappingException;
import org.bonitasoft.engine.core.process.document.mapping.exception.SDocumentMappingNotFoundException;
import org.bonitasoft.engine.core.process.document.mapping.model.SDocumentMapping;
import org.bonitasoft.engine.core.process.document.mapping.model.archive.SADocumentMapping;
import org.bonitasoft.engine.core.process.document.mapping.model.builder.SDocumentMappingBuilder;
import org.bonitasoft.engine.core.process.document.mapping.model.builder.SDocumentMappingBuilderFactory;
import org.bonitasoft.engine.core.process.document.model.SAProcessDocument;
import org.bonitasoft.engine.core.process.document.model.SProcessDocument;
import org.bonitasoft.engine.core.process.document.model.builder.SAProcessDocumentBuilder;
import org.bonitasoft.engine.core.process.document.model.builder.SAProcessDocumentBuilderFactory;
import org.bonitasoft.engine.core.process.document.model.builder.SProcessDocumentBuilder;
import org.bonitasoft.engine.core.process.document.model.builder.SProcessDocumentBuilderFactory;
import org.bonitasoft.engine.document.DocumentService;
import org.bonitasoft.engine.document.SDocumentException;
import org.bonitasoft.engine.document.SDocumentNotFoundException;
import org.bonitasoft.engine.document.model.SDocument;
import org.bonitasoft.engine.document.model.SDocumentBuilder;
import org.bonitasoft.engine.document.model.SDocumentBuilderFactory;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaSearchException;

public class ProcessDocumentServiceImpl
implements ProcessDocumentService {
    private final DocumentService documentService;
    private final DocumentMappingService documentMappingService;
    private final SDocumentDownloadURLProvider urlProvider;

    public ProcessDocumentServiceImpl(DocumentService documentService, DocumentMappingService documentMappingService, SDocumentDownloadURLProvider urlProvider) {
        this.documentService = documentService;
        this.documentMappingService = documentMappingService;
        this.urlProvider = urlProvider;
    }

    @Override
    public SProcessDocument attachDocumentToProcessInstance(SProcessDocument document) throws SProcessDocumentCreationException {
        try {
            SDocumentMapping docMapping = this.toDocumentMapping(document);
            docMapping = this.documentMappingService.create(docMapping);
            return this.toProcessDocument(docMapping);
        }
        catch (SBonitaException e) {
            throw new SProcessDocumentCreationException(e.getMessage(), e);
        }
    }

    @Override
    public SProcessDocument attachDocumentToProcessInstance(SProcessDocument document, byte[] documentContent) throws SProcessDocumentCreationException {
        try {
            SDocument sDocument = this.toSDocument(document);
            sDocument = this.documentService.storeDocumentContent(sDocument, documentContent);
            SDocumentMapping docMapping = this.buildDocumentMapping(document, sDocument);
            docMapping = this.documentMappingService.create(docMapping);
            return this.toProcessDocument(docMapping);
        }
        catch (SBonitaException e) {
            throw new SProcessDocumentCreationException(e.getMessage(), e);
        }
    }

    private SDocumentMapping buildDocumentMapping(SProcessDocument document, SDocument sDocument) {
        SDocumentMappingBuilder builder = this.initDocumentMappingBuilder(document);
        builder.setDocumentStorageId(sDocument.getStorageId());
        builder.setHasContent(true);
        return builder.done();
    }

    @Override
    public void deleteArchivedDocuments(long instanceId) throws SDocumentMappingDeletionException {
        List<SADocumentMapping> documents;
        FilterOption filterOption = new FilterOption(SADocumentMapping.class, "processInstanceId", instanceId);
        ArrayList<FilterOption> filters = new ArrayList<FilterOption>();
        filters.add(filterOption);
        QueryOptions queryOptions = new QueryOptions(filters, null);
        try {
            documents = this.documentMappingService.searchArchivedDocuments(queryOptions);
        }
        catch (SBonitaSearchException e) {
            throw new SDocumentMappingDeletionException(e);
        }
        for (SADocumentMapping document : documents) {
            this.documentMappingService.delete(document);
        }
    }

    @Override
    public void deleteDocumentsFromProcessInstance(Long processInstanceId) throws SDocumentException, SProcessDocumentDeletionException {
        List<SProcessDocument> sProcessDocuments;
        SDocumentMappingBuilderFactory fact = BuilderFactory.get(SDocumentMappingBuilderFactory.class);
        do {
            sProcessDocuments = this.getDocumentsOfProcessInstance(processInstanceId, 0, 100, fact.getDocumentNameKey(), OrderByType.ASC);
            this.removeDocuments(sProcessDocuments);
        } while (!sProcessDocuments.isEmpty());
    }

    private String generateDocumentURL(String name, String contentStorageId) {
        return this.urlProvider.generateURL(name, contentStorageId);
    }

    @Override
    public SAProcessDocument getArchivedDocument(long archivedProcessDocumentId) throws SDocumentNotFoundException {
        try {
            SADocumentMapping aDocMapping = this.documentMappingService.getArchivedDocument(archivedProcessDocumentId);
            return this.toAProcessDocument(aDocMapping);
        }
        catch (SDocumentMappingNotFoundException e) {
            throw new SDocumentNotFoundException("Document not found with identifer: " + archivedProcessDocumentId, e);
        }
    }

    @Override
    public SAProcessDocument getArchivedVersionOfProcessDocument(long documentId) throws SDocumentNotFoundException {
        try {
            SADocumentMapping aDocMapping = this.documentMappingService.getArchivedVersionOfDocument(documentId);
            return this.toAProcessDocument(aDocMapping);
        }
        catch (SDocumentMappingNotFoundException e) {
            throw new SDocumentNotFoundException("Document not found with identifer: " + documentId, e);
        }
    }

    @Override
    public SProcessDocument getDocument(long documentId) throws SDocumentNotFoundException {
        try {
            SDocumentMapping docMapping = this.documentMappingService.get(documentId);
            return this.toProcessDocument(docMapping);
        }
        catch (SDocumentMappingNotFoundException e) {
            throw new SDocumentNotFoundException("Document not found: " + documentId, e);
        }
    }

    @Override
    public SProcessDocument getDocument(long processInstanceId, String documentName) throws SDocumentNotFoundException {
        try {
            SDocumentMapping docMapping = this.documentMappingService.get(processInstanceId, documentName);
            return this.toProcessDocument(docMapping);
        }
        catch (SDocumentMappingNotFoundException e) {
            throw new SDocumentNotFoundException("Document not found: " + documentName + " for process instance: " + processInstanceId, e);
        }
    }

    @Override
    public SProcessDocument getDocument(long processInstanceId, String documentName, long time) throws SDocumentNotFoundException {
        try {
            SProcessDocument processDocument;
            SADocumentMapping archDocMapping;
            try {
                archDocMapping = this.documentMappingService.get(processInstanceId, documentName, time);
            }
            catch (SDocumentMappingNotFoundException e) {
                archDocMapping = null;
            }
            if (archDocMapping == null) {
                SDocumentMapping docMapping = this.documentMappingService.get(processInstanceId, documentName);
                processDocument = this.toProcessDocument(docMapping);
            } else {
                processDocument = this.toProcessDocument(archDocMapping);
            }
            return processDocument;
        }
        catch (SDocumentMappingNotFoundException e) {
            throw new SDocumentNotFoundException("Document not found: " + documentName + " for process instance: " + processInstanceId, e);
        }
    }

    @Override
    public byte[] getDocumentContent(String documentStorageId) throws SProcessDocumentContentNotFoundException {
        try {
            return this.documentService.getContent(documentStorageId);
        }
        catch (Exception e) {
            throw new SProcessDocumentContentNotFoundException(e.getMessage());
        }
    }

    @Override
    public List<SProcessDocument> getDocumentsOfProcessInstance(long processInstanceId, int fromIndex, int numberPerPage, String field, OrderByType order) throws SDocumentException {
        try {
            List<SDocumentMapping> docMappings = this.documentMappingService.getDocumentMappingsForProcessInstance(processInstanceId, fromIndex, numberPerPage, field, order);
            if (docMappings != null && !docMappings.isEmpty()) {
                ArrayList<SProcessDocument> result = new ArrayList<SProcessDocument>(docMappings.size());
                for (SDocumentMapping docMapping : docMappings) {
                    result.add(this.toProcessDocument(docMapping));
                }
                return result;
            }
            return Collections.emptyList();
        }
        catch (SBonitaException e) {
            throw new SDocumentException("Unable to list documents of process instance: " + processInstanceId, e);
        }
    }

    private String getDocumentUrl(SADocumentMapping docMapping) {
        if (docMapping.documentHasContent()) {
            return this.generateDocumentURL(docMapping.getDocumentContentFileName(), docMapping.getContentStorageId());
        }
        return docMapping.getDocumentURL();
    }

    private String getDocumentUrl(SDocumentMapping docMapping) {
        if (docMapping.documentHasContent()) {
            return this.generateDocumentURL(docMapping.getDocumentContentFileName(), docMapping.getContentStorageId());
        }
        return docMapping.getDocumentURL();
    }

    @Override
    public long getNumberOfArchivedDocuments(QueryOptions queryOptions) throws SBonitaSearchException {
        return this.documentMappingService.getNumberOfArchivedDocuments(queryOptions);
    }

    @Override
    public long getNumberOfArchivedDocumentsSupervisedBy(long userId, QueryOptions queryOptions) throws SBonitaSearchException {
        return this.documentMappingService.getNumberOfArchivedDocumentsSupervisedBy(userId, queryOptions);
    }

    @Override
    public long getNumberOfDocuments(QueryOptions queryOptions) throws SBonitaSearchException {
        return this.documentMappingService.getNumberOfDocuments(queryOptions);
    }

    @Override
    public long getNumberOfDocumentsOfProcessInstance(long processInstanceId) throws SDocumentException {
        try {
            return this.documentMappingService.getNumberOfDocumentMappingsForProcessInstance(processInstanceId);
        }
        catch (SBonitaException e) {
            throw new SDocumentException("Unable to count documents of process instance: " + processInstanceId, e);
        }
    }

    @Override
    public long getNumberOfDocumentsSupervisedBy(long userId, QueryOptions queryOptions) throws SBonitaSearchException {
        return this.documentMappingService.getNumberOfDocumentsSupervisedBy(userId, queryOptions);
    }

    private SDocumentMappingBuilder initDocumentMappingBuilder(SProcessDocument document) {
        SDocumentMappingBuilder builder = BuilderFactory.get(SDocumentMappingBuilderFactory.class).createNewInstance();
        builder.setProcessInstanceId(document.getProcessInstanceId());
        builder.setDocumentName(document.getName());
        builder.setDocumentAuthor(document.getAuthor());
        builder.setDocumentCreationDate(document.getCreationDate());
        builder.setHasContent(document.hasContent());
        builder.setDocumentContentFileName(document.getContentFileName());
        builder.setDocumentContentMimeType(document.getContentMimeType());
        builder.setDocumentStorageId(document.getContentStorageId());
        return builder;
    }

    @Override
    public void removeCurrentVersion(long processInstanceId, String documentName) throws SDocumentNotFoundException, SObjectModificationException {
        try {
            SDocumentMapping docMapping = this.documentMappingService.get(processInstanceId, documentName);
            this.documentMappingService.archive(docMapping, System.currentTimeMillis());
        }
        catch (SDocumentMappingNotFoundException e) {
            throw new SDocumentNotFoundException(e);
        }
        catch (SDocumentMappingException e) {
            throw new SObjectModificationException(e);
        }
    }

    @Override
    public void removeDocument(SProcessDocument sProcessDocument) throws SProcessDocumentDeletionException {
        try {
            if (sProcessDocument.hasContent()) {
                this.documentService.deleteDocumentContent(sProcessDocument.getContentStorageId());
            }
            this.documentMappingService.delete(sProcessDocument.getId());
        }
        catch (SBonitaException e) {
            throw new SProcessDocumentDeletionException(e.getMessage(), e);
        }
    }

    @Override
    public void removeDocuments(List<SProcessDocument> sProcessDocuments) throws SProcessDocumentDeletionException {
        try {
            for (SProcessDocument sProcessDocument : sProcessDocuments) {
                this.removeDocument(sProcessDocument);
            }
        }
        catch (SBonitaException e) {
            throw new SProcessDocumentDeletionException(e.getMessage(), e);
        }
    }

    @Override
    public List<SAProcessDocument> searchArchivedDocuments(QueryOptions queryOptions) throws SBonitaSearchException {
        List<SADocumentMapping> docMappings = this.documentMappingService.searchArchivedDocuments(queryOptions);
        ArrayList<SAProcessDocument> result = new ArrayList<SAProcessDocument>(docMappings.size());
        if (!docMappings.isEmpty()) {
            for (SADocumentMapping docMapping : docMappings) {
                result.add(this.toAProcessDocument(docMapping));
            }
        }
        return result;
    }

    @Override
    public List<SAProcessDocument> searchArchivedDocumentsSupervisedBy(long userId, QueryOptions queryOptions) throws SBonitaSearchException {
        List<SADocumentMapping> docMappings = this.documentMappingService.searchArchivedDocumentsSupervisedBy(userId, queryOptions);
        ArrayList<SAProcessDocument> result = new ArrayList<SAProcessDocument>(docMappings.size());
        if (!docMappings.isEmpty()) {
            for (SADocumentMapping docMapping : docMappings) {
                result.add(this.toAProcessDocument(docMapping));
            }
        }
        return result;
    }

    @Override
    public List<SProcessDocument> searchDocuments(QueryOptions queryOptions) throws SBonitaSearchException {
        List<SDocumentMapping> docMappings = this.documentMappingService.searchDocuments(queryOptions);
        ArrayList<SProcessDocument> result = new ArrayList<SProcessDocument>(docMappings.size());
        if (!docMappings.isEmpty()) {
            for (SDocumentMapping docMapping : docMappings) {
                result.add(this.toProcessDocument(docMapping));
            }
        }
        return result;
    }

    @Override
    public List<SProcessDocument> searchDocumentsSupervisedBy(long userId, QueryOptions queryOptions) throws SBonitaSearchException {
        List<SDocumentMapping> docMappings = this.documentMappingService.searchDocumentsSupervisedBy(userId, queryOptions);
        ArrayList<SProcessDocument> result = new ArrayList<SProcessDocument>(docMappings.size());
        if (!docMappings.isEmpty()) {
            for (SDocumentMapping docMapping : docMappings) {
                result.add(this.toProcessDocument(docMapping));
            }
        }
        return result;
    }

    private SAProcessDocument toAProcessDocument(SADocumentMapping docMapping) {
        SAProcessDocumentBuilder builder = BuilderFactory.get(SAProcessDocumentBuilderFactory.class).createNewInstance();
        builder.setAuthor(docMapping.getDocumentAuthor());
        builder.setContentMimeType(docMapping.getDocumentContentMimeType());
        builder.setCreationDate(docMapping.getDocumentCreationDate());
        builder.setFileName(docMapping.getDocumentContentFileName());
        builder.setHasContent(docMapping.documentHasContent());
        builder.setId(docMapping.getId());
        builder.setName(docMapping.getDocumentName());
        builder.setProcessInstanceId(docMapping.getProcessInstanceId());
        builder.setURL(this.getDocumentUrl(docMapping));
        builder.setContentStorageId(docMapping.getContentStorageId());
        builder.setArchiveDate(docMapping.getArchiveDate());
        builder.setSourceObjectId(docMapping.getSourceObjectId());
        return builder.done();
    }

    private SDocumentMapping toDocumentMapping(SProcessDocument document) {
        SDocumentMappingBuilder builder = this.initDocumentMappingBuilder(document);
        builder.setDocumentURL(document.getURL());
        return builder.done();
    }

    private SProcessDocument toProcessDocument(SADocumentMapping docMapping) {
        SProcessDocumentBuilder builder = BuilderFactory.get(SProcessDocumentBuilderFactory.class).createNewInstance();
        builder.setAuthor(docMapping.getDocumentAuthor());
        builder.setContentMimeType(docMapping.getDocumentContentMimeType());
        builder.setCreationDate(docMapping.getDocumentCreationDate());
        builder.setFileName(docMapping.getDocumentContentFileName());
        builder.setHasContent(docMapping.documentHasContent());
        builder.setId(docMapping.getSourceObjectId());
        builder.setName(docMapping.getDocumentName());
        builder.setProcessInstanceId(docMapping.getProcessInstanceId());
        builder.setURL(this.getDocumentUrl(docMapping));
        builder.setContentStorageId(docMapping.getContentStorageId());
        return builder.done();
    }

    private SProcessDocument toProcessDocument(SDocumentMapping docMapping) {
        SProcessDocumentBuilder builder = BuilderFactory.get(SProcessDocumentBuilderFactory.class).createNewInstance();
        builder.setAuthor(docMapping.getDocumentAuthor());
        builder.setContentMimeType(docMapping.getDocumentContentMimeType());
        builder.setCreationDate(docMapping.getDocumentCreationDate());
        builder.setFileName(docMapping.getDocumentContentFileName());
        builder.setHasContent(docMapping.documentHasContent());
        builder.setId(docMapping.getId());
        builder.setName(docMapping.getDocumentName());
        builder.setProcessInstanceId(docMapping.getProcessInstanceId());
        builder.setURL(this.getDocumentUrl(docMapping));
        builder.setContentStorageId(docMapping.getContentStorageId());
        return builder.done();
    }

    private SDocument toSDocument(SProcessDocument document) {
        SDocumentBuilder builder = BuilderFactory.get(SDocumentBuilderFactory.class).createNewInstance();
        builder.setAuthor(document.getAuthor());
        builder.setContentFileName(document.getContentFileName());
        builder.setContentMimeType(document.getContentMimeType());
        builder.setContentSize(document.getContentSize());
        builder.setCreationDate(document.getCreationDate());
        builder.setDocumentId(document.getContentStorageId());
        return builder.done();
    }

    @Override
    public SProcessDocument updateDocumentOfProcessInstance(SProcessDocument document) throws SProcessDocumentCreationException {
        try {
            SDocumentMapping docMapping = this.toDocumentMapping(document);
            docMapping = this.documentMappingService.update(docMapping);
            return this.toProcessDocument(docMapping);
        }
        catch (SBonitaException e) {
            throw new SProcessDocumentCreationException(e.getMessage(), e);
        }
    }

    @Override
    public SProcessDocument updateDocumentOfProcessInstance(SProcessDocument document, byte[] documentContent) throws SProcessDocumentCreationException {
        try {
            SDocument sDocument = this.toSDocument(document);
            sDocument = this.documentService.storeDocumentContent(sDocument, documentContent);
            SDocumentMapping docMapping = this.buildDocumentMapping(document, sDocument);
            docMapping = this.documentMappingService.update(docMapping);
            return this.toProcessDocument(docMapping);
        }
        catch (SBonitaException e) {
            throw new SProcessDocumentCreationException(e.getMessage(), e);
        }
    }
}

