/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.instance.impl;

import java.util.Collections;
import java.util.List;
import org.bonitasoft.engine.archive.ArchiveInsertRecord;
import org.bonitasoft.engine.archive.ArchiveService;
import org.bonitasoft.engine.archive.SDefinitiveArchiveNotFound;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.core.process.definition.model.STransitionDefinition;
import org.bonitasoft.engine.core.process.definition.model.TransitionState;
import org.bonitasoft.engine.core.process.instance.api.TransitionService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.STransitionCreationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.STransitionDeletionException;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SATransitionInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.builder.SATransitionInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.STransitionInstanceLogBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.STransitionInstanceLogBuilderFactory;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.ReadPersistenceService;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SBonitaSearchException;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLogSeverity;
import org.bonitasoft.engine.queriablelogger.model.builder.ActionType;
import org.bonitasoft.engine.queriablelogger.model.builder.HasCRUDEAction;
import org.bonitasoft.engine.queriablelogger.model.builder.SLogBuilder;
import org.bonitasoft.engine.recorder.SRecorderException;
import org.bonitasoft.engine.recorder.model.DeleteRecord;
import org.bonitasoft.engine.services.QueriableLoggerService;

public class TransitionServiceImpl
implements TransitionService {
    private final ReadPersistenceService persistenceRead;
    private final ArchiveService archiveService;

    public TransitionServiceImpl(ReadPersistenceService persistenceRead, ArchiveService archiveService, QueriableLoggerService queriableLoggerService) {
        this.persistenceRead = persistenceRead;
        this.archiveService = archiveService;
    }

    private <T extends SLogBuilder> void initializeLogBuilder(T logBuilder, String message) {
        logBuilder.actionStatus(0).severity(SQueriableLogSeverity.INTERNAL).rawMessage(message);
    }

    private <T extends HasCRUDEAction> void updateLog(ActionType actionType, T logBuilder) {
        logBuilder.setActionType(actionType);
    }

    @Override
    public long getNumberOfArchivedTransitionInstances(QueryOptions countOptions) throws SBonitaSearchException {
        try {
            return this.persistenceRead.getNumberOfEntities(SATransitionInstance.class, countOptions, null);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaSearchException(e);
        }
    }

    @Override
    public List<SATransitionInstance> searchArchivedTransitionInstances(QueryOptions queryOptions) throws SBonitaSearchException {
        try {
            return this.persistenceRead.searchEntity(SATransitionInstance.class, queryOptions, null);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaSearchException(e);
        }
    }

    @Override
    public void archive(STransitionDefinition sTransitionDefinition, SFlowNodeInstance sFlowNodeInstance, TransitionState transitionState) throws STransitionCreationException {
        SATransitionInstance saTransitionInstance = BuilderFactory.get(SATransitionInstanceBuilderFactory.class).createNewTransitionInstance(sTransitionDefinition, sFlowNodeInstance, transitionState).done();
        long archiveDate = System.currentTimeMillis();
        try {
            this.archiveTransitionInstanceInsertRecord(saTransitionInstance, archiveDate);
        }
        catch (SRecorderException e) {
            throw new STransitionCreationException(e);
        }
        catch (SDefinitiveArchiveNotFound e) {
            throw new STransitionCreationException(e);
        }
    }

    private void archiveTransitionInstanceInsertRecord(SATransitionInstance saTransitionInstance, long archiveDate) throws SRecorderException, SDefinitiveArchiveNotFound {
        ArchiveInsertRecord insertRecord = new ArchiveInsertRecord(saTransitionInstance);
        this.archiveService.recordInsert(archiveDate, insertRecord);
    }

    protected STransitionInstanceLogBuilder getQueriableLog(ActionType actionType, String message) {
        STransitionInstanceLogBuilder logBuilder = BuilderFactory.get(STransitionInstanceLogBuilderFactory.class).createNewInstance();
        this.initializeLogBuilder(logBuilder, message);
        this.updateLog(actionType, logBuilder);
        return logBuilder;
    }

    @Override
    public void delete(SATransitionInstance saTransitionInstance) throws STransitionDeletionException {
        DeleteRecord deleteRecord = new DeleteRecord(saTransitionInstance);
        try {
            this.archiveService.recordDelete(deleteRecord);
        }
        catch (SRecorderException e) {
            throw new STransitionDeletionException(e);
        }
    }

    @Override
    public void deleteArchivedTransitionsOfProcessInstance(long processInstanceId) throws STransitionDeletionException, SBonitaSearchException {
        List<SATransitionInstance> transitionInstances;
        SATransitionInstanceBuilderFactory saTransitionInstanceBuilder = BuilderFactory.get(SATransitionInstanceBuilderFactory.class);
        String rootContainerIdKey = saTransitionInstanceBuilder.getRootContainerIdKey();
        String idKey = saTransitionInstanceBuilder.getIdKey();
        do {
            List<FilterOption> filters = Collections.singletonList(new FilterOption(SATransitionInstance.class, rootContainerIdKey, processInstanceId));
            List<OrderByOption> orderByOptions = Collections.singletonList(new OrderByOption(SATransitionInstance.class, idKey, OrderByType.ASC));
            QueryOptions queryOptions = new QueryOptions(0, 10, orderByOptions, filters, null);
            transitionInstances = this.searchArchivedTransitionInstances(queryOptions);
            for (SATransitionInstance saTransitionInstance : transitionInstances) {
                this.delete(saTransitionInstance);
            }
        } while (!transitionInstances.isEmpty());
    }
}

