/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.expression.control.api.ExpressionResolverService;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeType;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SEndEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SStartEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SEventTriggerDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.STimerEventTriggerDefinition;
import org.bonitasoft.engine.core.process.instance.model.SFlowElementsContainerType;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.core.process.instance.model.event.SCatchEventInstance;
import org.bonitasoft.engine.core.process.instance.model.event.SThrowEventInstance;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SWaitingEvent;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.execution.event.EventHandlerStrategy;
import org.bonitasoft.engine.execution.event.OperationsWithContext;
import org.bonitasoft.engine.execution.job.JobNameBuilder;
import org.bonitasoft.engine.execution.state.EndingIntermediateCatchEventExceptionStateImpl;
import org.bonitasoft.engine.expression.exception.SInvalidExpressionException;
import org.bonitasoft.engine.jobs.TriggerTimerEventJob;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.scheduler.SchedulerService;
import org.bonitasoft.engine.scheduler.builder.SJobDescriptorBuilderFactory;
import org.bonitasoft.engine.scheduler.builder.SJobParameterBuilderFactory;
import org.bonitasoft.engine.scheduler.model.SJobDescriptor;
import org.bonitasoft.engine.scheduler.model.SJobParameter;
import org.bonitasoft.engine.scheduler.trigger.OneShotTrigger;
import org.bonitasoft.engine.scheduler.trigger.Trigger;
import org.bonitasoft.engine.scheduler.trigger.UnixCronTrigger;

public class TimerEventHandlerStrategy
extends EventHandlerStrategy {
    private static final OperationsWithContext EMPTY = new OperationsWithContext(null, null);
    private final SchedulerService schedulerService;
    private final ExpressionResolverService expressionResolverService;
    private final TechnicalLoggerService logger;

    public TimerEventHandlerStrategy(ExpressionResolverService expressionResolverService, SchedulerService schedulerService, TechnicalLoggerService logger) {
        this.schedulerService = schedulerService;
        this.expressionResolverService = expressionResolverService;
        this.logger = logger;
    }

    @Override
    public void handleCatchEvent(SProcessDefinition processDefinition, SEventDefinition eventDefinition, SCatchEventInstance eventInstance, SEventTriggerDefinition sEventTriggerDefinition) throws SBonitaException {
        String jobName = JobNameBuilder.getTimerEventJobName(processDefinition.getId(), eventDefinition, eventInstance);
        SJobDescriptor jobDescriptor = this.getJobDescriptor(jobName);
        List<SJobParameter> jobParameters = this.getJobParameters(processDefinition, eventDefinition, eventInstance);
        this.scheduleJob(processDefinition, eventInstance, sEventTriggerDefinition, jobDescriptor, jobParameters);
    }

    protected Trigger getTrigger(STimerEventTriggerDefinition timerTrigger, SCatchEventInstance eventInstance, long processDefinitionId) throws SBonitaException {
        SExpressionContext expressionContext;
        if (eventInstance != null) {
            expressionContext = new SExpressionContext((Long)eventInstance.getParentProcessInstanceId(), DataInstanceContainer.PROCESS_INSTANCE.name(), processDefinitionId);
        } else {
            expressionContext = new SExpressionContext();
            expressionContext.setProcessDefinitionId(processDefinitionId);
        }
        Object result = this.expressionResolverService.evaluate(timerTrigger.getTimerExpression(), expressionContext);
        Date startDate = null;
        OneShotTrigger trigger = null;
        if (result == null) {
            throw new SInvalidExpressionException("The duration cannot be null");
        }
        switch (timerTrigger.getTimerType()) {
            case DURATION: {
                startDate = new Date(System.currentTimeMillis() + (Long)result);
                trigger = new OneShotTrigger("OneShotTrigger" + UUID.randomUUID().getLeastSignificantBits(), startDate);
                break;
            }
            case DATE: {
                startDate = (Date)result;
                trigger = new OneShotTrigger("OneShotTrigger" + UUID.randomUUID().getLeastSignificantBits(), startDate);
                break;
            }
            case CYCLE: {
                startDate = new Date();
                trigger = new UnixCronTrigger("UnixCronTrigger" + UUID.randomUUID().getLeastSignificantBits(), startDate, (String)result);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return trigger;
    }

    @Override
    public void handleThrowEvent(SProcessDefinition processDefinition, SEventDefinition eventDefinition, SThrowEventInstance eventInstance, SEventTriggerDefinition sEventTriggerDefinition) {
    }

    @Override
    public OperationsWithContext getOperations(SWaitingEvent waitingEvent, Long triggeringElementID) {
        return EMPTY;
    }

    @Override
    public void handleThrowEvent(SEventTriggerDefinition sEventTriggerDefinition) {
    }

    @Override
    public void handleEventSubProcess(SProcessDefinition processDefinition, SEventDefinition eventDefinition, SEventTriggerDefinition sEventTriggerDefinition, long subProcessId, SProcessInstance parentProcessInstance) throws SBonitaException {
        String jobName = JobNameBuilder.getTimerEventJobName(processDefinition.getId(), eventDefinition, parentProcessInstance.getId(), subProcessId);
        SJobDescriptor jobDescriptor = this.getJobDescriptor(jobName);
        List<SJobParameter> jobParameters = this.getJobParameters(processDefinition, eventDefinition, null, subProcessId, parentProcessInstance);
        this.scheduleJob(processDefinition, null, sEventTriggerDefinition, jobDescriptor, jobParameters);
    }

    private void scheduleJob(SProcessDefinition processDefinition, SCatchEventInstance eventInstance, SEventTriggerDefinition sEventTriggerDefinition, SJobDescriptor jobDescriptor, List<SJobParameter> jobParameters) throws SBonitaException {
        Trigger trigger = this.getTrigger((STimerEventTriggerDefinition)sEventTriggerDefinition, eventInstance, processDefinition.getId());
        this.schedulerService.schedule(jobDescriptor, jobParameters, trigger);
    }

    private List<SJobParameter> getJobParameters(SProcessDefinition processDefinition, SEventDefinition eventDefinition, SCatchEventInstance eventInstance) {
        ArrayList<SJobParameter> jobParameters = new ArrayList<SJobParameter>();
        jobParameters.add(BuilderFactory.get(SJobParameterBuilderFactory.class).createNewInstance("processDefinitionId", processDefinition.getId()).done());
        jobParameters.add(BuilderFactory.get(SJobParameterBuilderFactory.class).createNewInstance("containerType", (Serializable)((Object)SFlowElementsContainerType.PROCESS.name())).done());
        jobParameters.add(BuilderFactory.get(SJobParameterBuilderFactory.class).createNewInstance("eventType", (Serializable)((Object)eventDefinition.getType().name())).done());
        jobParameters.add(BuilderFactory.get(SJobParameterBuilderFactory.class).createNewInstance("targetSFlowNodeDefinitionId", eventDefinition.getId()).done());
        if (SFlowNodeType.START_EVENT.equals((Object)eventDefinition.getType())) {
            SStartEventDefinition startEvent = (SStartEventDefinition)eventDefinition;
            jobParameters.add(BuilderFactory.get(SJobParameterBuilderFactory.class).createNewInstance("isInterrupting", Boolean.valueOf(startEvent.isInterrupting())).done());
        }
        if (eventInstance != null) {
            jobParameters.add(BuilderFactory.get(SJobParameterBuilderFactory.class).createNewInstance("flowNodeInstanceId", Long.valueOf(eventInstance.getId())).done());
        }
        return jobParameters;
    }

    private List<SJobParameter> getJobParameters(SProcessDefinition processDefinition, SEventDefinition eventDefinition, SCatchEventInstance eventInstance, long subProcessId, SProcessInstance parentProcessInstance) {
        ArrayList<SJobParameter> jobParameters = new ArrayList<SJobParameter>();
        jobParameters.addAll(this.getJobParameters(processDefinition, eventDefinition, eventInstance));
        jobParameters.add(BuilderFactory.get(SJobParameterBuilderFactory.class).createNewInstance("subProcessId", Long.valueOf(subProcessId)).done());
        jobParameters.add(BuilderFactory.get(SJobParameterBuilderFactory.class).createNewInstance("processInstanceId", Long.valueOf(parentProcessInstance.getId())).done());
        jobParameters.add(BuilderFactory.get(SJobParameterBuilderFactory.class).createNewInstance("rootProcessInstanceId", Long.valueOf(parentProcessInstance.getRootProcessInstanceId())).done());
        return jobParameters;
    }

    private SJobDescriptor getJobDescriptor(String jobName) {
        return BuilderFactory.get(SJobDescriptorBuilderFactory.class).createNewInstance(TriggerTimerEventJob.class.getName(), jobName, false).done();
    }

    @Override
    public void unregisterCatchEvent(SProcessDefinition processDefinition, SEventDefinition eventDefinition, SEventTriggerDefinition sEventTriggerDefinition, long subProcessId, SProcessInstance parentProcessIsnstance) throws SBonitaException {
        String jobName = JobNameBuilder.getTimerEventJobName(processDefinition.getId(), eventDefinition, parentProcessIsnstance.getId(), subProcessId);
        boolean delete = this.schedulerService.delete(jobName);
        if (!delete && this.logger.isLoggable(EndingIntermediateCatchEventExceptionStateImpl.class, TechnicalLogSeverity.DEBUG)) {
            StringBuilder stb = new StringBuilder();
            stb.append("No job found with name '");
            stb.append(jobName);
            stb.append("' when interrupting timer catch event named '");
            stb.append(eventDefinition.getName());
            stb.append(". In process [name: ");
            stb.append(processDefinition.getName());
            stb.append(", version: ");
            stb.append(processDefinition.getVersion());
            stb.append("]");
            stb.append("'. It was probably already triggered.");
            String message = stb.toString();
            this.logger.log(EndingIntermediateCatchEventExceptionStateImpl.class, TechnicalLogSeverity.DEBUG, message);
        }
    }

    @Override
    public boolean handlePostThrowEvent(SProcessDefinition processDefinition, SEndEventDefinition sEventDefinition, SThrowEventInstance sThrowEventInstance, SEventTriggerDefinition sEventTriggerDefinition, SFlowNodeInstance sFlowNodeInstance) {
        return false;
    }
}

