/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.flowmerger;

import org.bonitasoft.engine.commons.exceptions.SObjectCreationException;
import org.bonitasoft.engine.commons.exceptions.SObjectNotFoundException;
import org.bonitasoft.engine.commons.exceptions.SObjectReadException;
import org.bonitasoft.engine.core.process.instance.api.TokenService;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.core.process.instance.model.SToken;
import org.bonitasoft.engine.execution.TokenProvider;
import org.bonitasoft.engine.execution.flowmerger.FlowNodeTransitionsWrapper;
import org.bonitasoft.engine.execution.flowmerger.SFlowNodeWrapper;
import org.bonitasoft.engine.execution.flowmerger.TokenInfo;

public class FlowNodeCompletionTokenProvider
implements TokenProvider {
    private SFlowNodeWrapper flowNodeWrapper;
    private TokenService tokenService;
    private SFlowNodeInstance child;
    private SProcessInstance processInstance;
    private FlowNodeTransitionsWrapper transitionsDescriptor;
    private TokenInfo tokenInfo = null;

    public FlowNodeCompletionTokenProvider(SFlowNodeInstance child, SProcessInstance sProcessInstance, SFlowNodeWrapper flowNodeWrapper, FlowNodeTransitionsWrapper transitionsDescriptor, TokenService tokenService) {
        this.child = child;
        this.processInstance = sProcessInstance;
        this.flowNodeWrapper = flowNodeWrapper;
        this.transitionsDescriptor = transitionsDescriptor;
        this.tokenService = tokenService;
    }

    @Override
    public TokenInfo getOutputTokenInfo() throws SObjectReadException, SObjectNotFoundException, SObjectCreationException {
        if (this.tokenInfo != null) {
            return this.tokenInfo;
        }
        this.tokenInfo = this.calculateTokenInfo();
        return this.tokenInfo;
    }

    private TokenInfo calculateTokenInfo() throws SObjectReadException, SObjectNotFoundException, SObjectCreationException {
        if (this.flowNodeWrapper.isNull() || this.transitionsDescriptor.isLastFlowNode()) {
            return new TokenInfo();
        }
        if (this.flowNodeWrapper.isBoundaryEvent() && this.flowNodeWrapper.isInterrupting()) {
            return this.tansmitAllTokenInfo();
        }
        if (this.flowNodeWrapper.isExclusive() || this.transitionsDescriptor.isSimpleMerge() || this.isNonInterruptingBoundaryEvent()) {
            return this.transmitOnlyTokenRefId();
        }
        if (this.transitionsDescriptor.isSimpleToMany()) {
            return new TokenInfo(this.child.getId(), this.child.getTokenRefId());
        }
        if (this.transitionsDescriptor.isManyToMany()) {
            if (this.flowNodeWrapper.isParalleleOrInclusive()) {
                return new TokenInfo(this.child.getId(), this.getParentTokenRefId());
            }
            return new TokenInfo(this.child.getId(), this.child.getTokenRefId());
        }
        if (this.transitionsDescriptor.isManyToOne()) {
            if (this.flowNodeWrapper.isParalleleOrInclusive()) {
                Long parentTokenRefId = this.getParentTokenRefId();
                return new TokenInfo(parentTokenRefId);
            }
            return new TokenInfo(this.child.getTokenRefId());
        }
        return new TokenInfo();
    }

    private boolean isNonInterruptingBoundaryEvent() {
        return this.flowNodeWrapper.isBoundaryEvent() && !this.flowNodeWrapper.isInterrupting();
    }

    private Long getParentTokenRefId() throws SObjectReadException, SObjectNotFoundException {
        SToken token = this.tokenService.getToken(this.processInstance.getId(), this.child.getTokenRefId());
        return token.getParentRefId();
    }

    private TokenInfo transmitOnlyTokenRefId() {
        return new TokenInfo(this.child.getTokenRefId());
    }

    private TokenInfo tansmitAllTokenInfo() throws SObjectReadException, SObjectNotFoundException {
        SToken token = this.tokenService.getToken(this.child.getParentProcessInstanceId(), this.child.getTokenRefId());
        return new TokenInfo(token.getRefId(), token.getParentRefId());
    }
}

