/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.state;

import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityStateExecutionException;
import org.bonitasoft.engine.core.process.instance.api.states.FlowNodeState;
import org.bonitasoft.engine.core.process.instance.api.states.StateCode;
import org.bonitasoft.engine.core.process.instance.model.SActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SFlowElementsContainerType;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SStateCategory;
import org.bonitasoft.engine.core.process.instance.model.builder.SFlowNodeInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.SUserTaskInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.event.SBoundaryEventInstance;
import org.bonitasoft.engine.execution.ContainerRegistry;

public class ExecutingBoundaryEventStateImpl
implements FlowNodeState {
    private final ActivityInstanceService activityInstanceService;
    private final ContainerRegistry containerRegistry;

    public ExecutingBoundaryEventStateImpl(ActivityInstanceService activityInstanceService, ContainerRegistry containerRegistry) {
        this.activityInstanceService = activityInstanceService;
        this.containerRegistry = containerRegistry;
    }

    @Override
    public boolean shouldExecuteState(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) {
        return true;
    }

    @Override
    public boolean mustAddSystemComment(SFlowNodeInstance flowNodeInstance) {
        return false;
    }

    @Override
    public String getSystemComment(SFlowNodeInstance flowNodeInstance) {
        return "executing boundary event";
    }

    @Override
    public StateCode execute(SProcessDefinition processDefinition, SFlowNodeInstance instance) throws SActivityStateExecutionException {
        SBoundaryEventInstance boundaryEventInstance = (SBoundaryEventInstance)instance;
        if (boundaryEventInstance.isInterrupting()) {
            this.aborteRelatedActivity(boundaryEventInstance);
        }
        return StateCode.DONE;
    }

    private void aborteRelatedActivity(SBoundaryEventInstance boundaryEventInstance) throws SActivityStateExecutionException {
        SFlowNodeInstanceBuilderFactory flowNodeKeyProvider = BuilderFactory.get(SUserTaskInstanceBuilderFactory.class);
        if (SStateCategory.NORMAL.equals((Object)boundaryEventInstance.getStateCategory())) {
            try {
                SActivityInstance relatedActivityInst = this.activityInstanceService.getActivityInstance(boundaryEventInstance.getActivityInstanceId());
                this.activityInstanceService.setStateCategory(relatedActivityInst, SStateCategory.ABORTING);
                this.activityInstanceService.setAbortedByBoundaryEvent(relatedActivityInst, boundaryEventInstance.getId());
                if (relatedActivityInst.isStable() || relatedActivityInst.isStateExecuting()) {
                    String containerType = SFlowElementsContainerType.PROCESS.name();
                    long parentActivityInstanceId = relatedActivityInst.getParentActivityInstanceId();
                    if (parentActivityInstanceId > 0L) {
                        containerType = SFlowElementsContainerType.FLOWNODE.name();
                    }
                    this.containerRegistry.executeFlowNode(relatedActivityInst.getId(), null, null, containerType, boundaryEventInstance.getLogicalGroup(flowNodeKeyProvider.getParentProcessInstanceIndex()));
                }
            }
            catch (SBonitaException e) {
                throw new SActivityStateExecutionException(e);
            }
        }
    }

    @Override
    public boolean hit(SProcessDefinition processDefinition, SFlowNodeInstance parentInstance, SFlowNodeInstance childInstance) {
        return true;
    }

    @Override
    public int getId() {
        return 65;
    }

    @Override
    public String getName() {
        return "executing";
    }

    @Override
    public boolean isInterrupting() {
        return false;
    }

    @Override
    public boolean isStable() {
        return false;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public SStateCategory getStateCategory() {
        return SStateCategory.NORMAL;
    }
}

