/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.external.identitymapping;

import java.io.Serializable;
import java.util.Map;
import org.bonitasoft.engine.command.SCommandExecutionException;
import org.bonitasoft.engine.command.SCommandParameterizationException;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.external.identitymapping.EntityMemberCommand;
import org.bonitasoft.engine.identity.MemberType;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.descriptor.SearchEntityMemberDescriptor;
import org.bonitasoft.engine.search.descriptor.SearchEntityMemberGroupDescriptor;
import org.bonitasoft.engine.search.descriptor.SearchEntityMemberRoleAndGroupDescriptor;
import org.bonitasoft.engine.search.descriptor.SearchEntityMemberRoleDescriptor;
import org.bonitasoft.engine.search.descriptor.SearchEntityMemberUserDescriptor;
import org.bonitasoft.engine.service.TenantServiceAccessor;

public class SearchEntityMembersCommand
extends EntityMemberCommand {
    private static final String MEMBER_TYPE_KEY = "MEMBER_TYPE_KEY";

    @Override
    public Serializable execute(Map<String, Serializable> parameters, TenantServiceAccessor serviceAccessor) throws SCommandParameterizationException, SCommandExecutionException {
        this.serviceAccessor = serviceAccessor;
        String kind = this.getStringMandadoryParameter(parameters, "DISCRIMINATOR_ID_KEY");
        SearchOptions searchOptions = (SearchOptions)this.getMandatoryParameter(parameters, "SEARCH_OPTIONS_KEY", "Parameters map must contain an entry SEARCH_OPTIONS_KEY with a SearchOptions value");
        MemberType memberType = (MemberType)this.getMandatoryParameter(parameters, MEMBER_TYPE_KEY, "Parameters map must contain an entry MEMBER_TYPE_KEY with a MemberType value (USER, GROUP, ROLE, MEMBERSHIP)");
        String querySuffix = this.getQuerySuffix(memberType);
        SearchEntityMemberDescriptor searchDescriptor = this.getSearchDescriptor(memberType);
        try {
            return this.searchEntityMembers(searchDescriptor, kind, searchOptions, querySuffix);
        }
        catch (SBonitaException e) {
            throw new SCommandExecutionException("Error executing command 'SearchEntityMembersCommand'", e);
        }
    }

    private SearchEntityMemberDescriptor getSearchDescriptor(MemberType memberType) {
        SearchEntityMemberDescriptor searchDescriptor = null;
        switch (memberType) {
            case USER: {
                searchDescriptor = new SearchEntityMemberUserDescriptor();
                break;
            }
            case GROUP: {
                searchDescriptor = new SearchEntityMemberGroupDescriptor();
                break;
            }
            case ROLE: {
                searchDescriptor = new SearchEntityMemberRoleDescriptor();
                break;
            }
            case MEMBERSHIP: {
                searchDescriptor = new SearchEntityMemberRoleAndGroupDescriptor();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return searchDescriptor;
    }
}

