/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.identity.recorder;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.identity.model.SContactInfo;
import org.bonitasoft.engine.identity.model.SGroup;
import org.bonitasoft.engine.identity.model.SProfileMetadataDefinition;
import org.bonitasoft.engine.identity.model.SRole;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.identity.model.SUserMembership;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SelectByIdDescriptor;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;

public class SelectDescriptorBuilder {
    public static SelectListDescriptor<SGroup> getChildrenOfGroup(SGroup group) {
        return SelectDescriptorBuilder.getChildrenOfGroup(group, null);
    }

    public static SelectListDescriptor<SGroup> getChildrenOfGroup(SGroup group, int fromIndex, int numberOfGroups) {
        List<OrderByOption> orderByOptions = Arrays.asList(new OrderByOption(SGroup.class, "id", OrderByType.ASC));
        QueryOptions queryOptions = new QueryOptions(fromIndex, numberOfGroups, orderByOptions);
        return SelectDescriptorBuilder.getChildrenOfGroup(group, queryOptions);
    }

    public static SelectListDescriptor<SGroup> getChildrenOfGroup(SGroup group, QueryOptions queryOptions) {
        Map<String, Object> parameters = Collections.singletonMap("groupPath", group.getPath());
        return new SelectListDescriptor<SGroup>("getChildrenOfGroup", parameters, SGroup.class, queryOptions);
    }

    public static SelectListDescriptor<SGroup> getChildrenOfGroup(SGroup group, String field, OrderByType order, int fromIndex, int numberOfGroups) {
        QueryOptions queryOptions = new QueryOptions(fromIndex, numberOfGroups, SGroup.class, field, order);
        return SelectDescriptorBuilder.getChildrenOfGroup(group, queryOptions);
    }

    public static <T extends PersistentObject> SelectByIdDescriptor<T> getElementById(Class<T> clazz, String elementName, long id) {
        return new SelectByIdDescriptor<T>("get" + elementName + "ById", clazz, id);
    }

    public static <T extends PersistentObject> SelectListDescriptor<T> getElements(Class<T> clazz, String elementName, int fromIndex, int numberOfElements) {
        QueryOptions queryOptions = new QueryOptions(fromIndex, numberOfElements);
        return SelectDescriptorBuilder.getElements(clazz, elementName, queryOptions);
    }

    public static <T extends PersistentObject> SelectListDescriptor<T> getElements(Class<T> clazz, String elementName, QueryOptions queryOptions) {
        Map<String, Object> parameters = Collections.emptyMap();
        return new SelectListDescriptor("get" + elementName + "s", parameters, clazz, queryOptions);
    }

    public static <T extends PersistentObject> SelectListDescriptor<T> getElements(Class<T> clazz, String elementName, String field, OrderByType order, int fromIndex, int numberOfElements) {
        QueryOptions queryOptions = new QueryOptions(fromIndex, numberOfElements, clazz, field, order);
        return SelectDescriptorBuilder.getElements(clazz, elementName, queryOptions);
    }

    public static <T extends PersistentObject> SelectListDescriptor<T> getElementsByIds(Class<T> clazz, String elementName, Collection<Long> ids) {
        Map<String, Object> parameters = Collections.singletonMap("ids", ids);
        int maxResults = ids != null ? ids.size() : 0;
        return new SelectListDescriptor("get" + elementName + "sByIds", parameters, clazz, new QueryOptions(0, maxResults));
    }

    public static SelectOneDescriptor<SGroup> getGroupByName(String groupName) {
        Map<String, Object> parameters = Collections.singletonMap("name", groupName);
        return new SelectOneDescriptor<SGroup>("getGroupByName", parameters, SGroup.class);
    }

    public static SelectOneDescriptor<SGroup> getGroupByPath(String parentPath, String groupName) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("name", groupName);
        parameters.put("parentPath", parentPath);
        return new SelectOneDescriptor<SGroup>("getGroupByNameAndPath", parameters, SGroup.class);
    }

    public static SelectListDescriptor<SGroup> getGroupsByName(String groupName) {
        Map<String, Object> parameters = Collections.singletonMap("name", groupName);
        return new SelectListDescriptor<SGroup>("getGroupsByName", parameters, SGroup.class);
    }

    public static <T extends PersistentObject> SelectByIdDescriptor<T> getLightElementById(Class<T> clazz, String elementName, long id) {
        return new SelectByIdDescriptor<T>("getLight" + elementName + "ById", clazz, id);
    }

    public static SelectOneDescriptor<SUserMembership> getLightUserMembership(long userId, long groupId, long roleId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("userId", userId);
        parameters.put("roleId", roleId);
        parameters.put("groupId", groupId);
        return new SelectOneDescriptor<SUserMembership>("getLightUserMembershipWithIds", parameters, SUserMembership.class);
    }

    public static SelectOneDescriptor<SProfileMetadataDefinition> getMetadataByName(String metadataName) {
        Map<String, Object> parameters = Collections.singletonMap("name", metadataName);
        return new SelectOneDescriptor<SProfileMetadataDefinition>("getMetadataByName", parameters, SProfileMetadataDefinition.class);
    }

    public static SelectOneDescriptor<Long> getNumberOfElement(String elementName, Class<? extends PersistentObject> clazz) {
        Map<String, Object> emptyMap = Collections.emptyMap();
        return new SelectOneDescriptor<Long>("getNumberOf" + elementName, emptyMap, clazz, Long.class);
    }

    public static SelectOneDescriptor<Long> getNumberOfGroupChildren(String groupParentPath) {
        Map<String, Object> parameters = Collections.singletonMap("parentPath", groupParentPath);
        return new SelectOneDescriptor<Long>("getNumberOfGroupChildren", parameters, SGroup.class, Long.class);
    }

    public static SelectOneDescriptor<Long> getNumberOfUserMembershipsOfUser(long userId) {
        Map<String, Object> parameters = Collections.singletonMap("userId", userId);
        return new SelectOneDescriptor<Long>("getNumberOfUserMembershipsOfUser", parameters, SUserMembership.class, Long.class);
    }

    public static SelectOneDescriptor<Long> getNumberOfUsersByGroup(long groupId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("groupId", groupId);
        return new SelectOneDescriptor<Long>("getNumberOfUsersByGroup", parameters, SUser.class, Long.class);
    }

    public static SelectOneDescriptor<Long> getNumberOfUsersByMembership(long groupId, long roleId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("roleId", roleId);
        parameters.put("groupId", groupId);
        return new SelectOneDescriptor<Long>("getNumberOfUsersByMembership", parameters, SUser.class, Long.class);
    }

    public static SelectOneDescriptor<Long> getNumberOfUsersByRole(long roleId) {
        Map<String, Object> parameters = Collections.singletonMap("roleId", roleId);
        return new SelectOneDescriptor<Long>("getNumberOfUsersByRole", parameters, SUser.class, Long.class);
    }

    public static SelectOneDescriptor<SRole> getRoleByName(String roleName) {
        Map<String, Object> parameters = Collections.singletonMap("name", roleName);
        return new SelectOneDescriptor<SRole>("getRoleByName", parameters, SRole.class);
    }

    public static SelectOneDescriptor<SUser> getUserByUserName(String userName) {
        Map<String, Object> parameters = Collections.singletonMap("userName", userName);
        return new SelectOneDescriptor<SUser>("getUserByUserName", parameters, SUser.class);
    }

    public static SelectOneDescriptor<SContactInfo> getUserContactInfo(long userId, boolean isPersonal) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("userId", userId);
        parameters.put("personal", isPersonal);
        return new SelectOneDescriptor<SContactInfo>("getUserContactInfo", parameters, SContactInfo.class);
    }

    public static SelectOneDescriptor<SUserMembership> getUserMembership(long userId, long groupId, long roleId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("userId", userId);
        parameters.put("roleId", roleId);
        parameters.put("groupId", groupId);
        return new SelectOneDescriptor<SUserMembership>("getUserMembershipWithIds", parameters, SUserMembership.class);
    }

    public static SelectListDescriptor<SUserMembership> getUserMembershipsByGroup(long groupId, int startIndex, int maxResults) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("groupId", groupId);
        return new SelectListDescriptor<SUserMembership>("getUserMembershipsByGroup", parameters, SUserMembership.class, new QueryOptions(startIndex, maxResults));
    }

    public static SelectListDescriptor<SUserMembership> getUserMembershipsByRole(long roleId, int startIndex, int maxResults) {
        Map<String, Object> parameters = Collections.singletonMap("roleId", roleId);
        return new SelectListDescriptor<SUserMembership>("getUserMembershipsByRole", parameters, SUserMembership.class, new QueryOptions(startIndex, maxResults));
    }

    public static SelectListDescriptor<SUserMembership> getUserMembershipsOfUser(long userId) {
        return SelectDescriptorBuilder.getUserMembershipsOfUser(userId, new QueryOptions(Arrays.asList(new OrderByOption(SUserMembership.class, "id", OrderByType.ASC))));
    }

    public static SelectListDescriptor<SUserMembership> getUserMembershipsOfUser(long userId, int fromIndex, int numberOfMemberships) {
        QueryOptions queryOptions = new QueryOptions(fromIndex, numberOfMemberships, Arrays.asList(new OrderByOption(SUserMembership.class, "id", OrderByType.ASC)));
        return SelectDescriptorBuilder.getUserMembershipsOfUser(userId, queryOptions);
    }

    public static SelectListDescriptor<SUserMembership> getUserMembershipsOfUser(long userId, QueryOptions queryOptions) {
        Map<String, Object> parameters = Collections.singletonMap("userId", userId);
        return new SelectListDescriptor<SUserMembership>("getUserMembershipsOfUser", parameters, SUserMembership.class, queryOptions);
    }

    public static SelectListDescriptor<SUserMembership> getUserMembershipsOfUser(long userId, String field, OrderByType order, int fromIndex, int numberOfMemberships) {
        QueryOptions queryOptions = new QueryOptions(fromIndex, numberOfMemberships, SUserMembership.class, field, order);
        return SelectDescriptorBuilder.getUserMembershipsOfUser(userId, queryOptions);
    }

    public static SelectListDescriptor<SUserMembership> getUserMembershipsWithGroup(QueryOptions queryOptions) {
        Map<String, Object> parameters = Collections.emptyMap();
        return new SelectListDescriptor<SUserMembership>("getUserMembershipsWithGroup", parameters, SUserMembership.class, queryOptions);
    }

    public static SelectListDescriptor<SUserMembership> getUserMembershipsWithRole(QueryOptions queryOptions) {
        Map<String, Object> parameters = Collections.emptyMap();
        return new SelectListDescriptor<SUserMembership>("getUserMembershipsWithRole", parameters, SUserMembership.class, queryOptions);
    }

    public static SelectListDescriptor<SUser> getUsersByDelegee(String delegeeUserName) {
        Map<String, Object> parameters = Collections.singletonMap("delegeeUserName", delegeeUserName);
        return new SelectListDescriptor<SUser>("getUsersByDelegee", parameters, SUser.class);
    }

    public static SelectListDescriptor<SUser> getUsersByGroup(long groupId) {
        return SelectDescriptorBuilder.getUsersByGroup(groupId, null);
    }

    public static SelectListDescriptor<SUser> getUsersByGroup(long groupId, int fromIndex, int numberOfUsers) {
        QueryOptions queryOptions = new QueryOptions(fromIndex, numberOfUsers);
        return SelectDescriptorBuilder.getUsersByGroup(groupId, queryOptions);
    }

    private static SelectListDescriptor<SUser> getUsersByGroup(long groupId, QueryOptions queryOptions) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("groupId", groupId);
        return new SelectListDescriptor<SUser>("getUsersByGroup", parameters, SUser.class, queryOptions);
    }

    public static SelectListDescriptor<SUser> getUsersByGroup(long groupId, String field, OrderByType order, int fromIndex, int numberOfUsers) {
        QueryOptions queryOptions = new QueryOptions(fromIndex, numberOfUsers, SUser.class, field, order);
        return SelectDescriptorBuilder.getUsersByGroup(groupId, queryOptions);
    }

    public static SelectListDescriptor<SUser> getUsersByManager(long managerUserId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("managerUserId", managerUserId);
        return new SelectListDescriptor<SUser>("getUsersByManager", parameters, SUser.class);
    }

    public static SelectListDescriptor<SUser> getUsersByMembership(long groupId, long roleId) {
        return SelectDescriptorBuilder.getUsersByMembership(groupId, roleId, null);
    }

    public static SelectListDescriptor<SUser> getUsersByMembership(long groupId, long roleId, int fromIndex, int numberOfUsers) {
        QueryOptions queryOptions = new QueryOptions(fromIndex, numberOfUsers, SUser.class, "id", OrderByType.DESC);
        return SelectDescriptorBuilder.getUsersByMembership(groupId, roleId, queryOptions);
    }

    private static SelectListDescriptor<SUser> getUsersByMembership(long groupId, long roleId, QueryOptions queryOptions) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("roleId", roleId);
        parameters.put("groupId", groupId);
        return new SelectListDescriptor<SUser>("getUsersByMembership", parameters, SUser.class, queryOptions);
    }

    public static SelectListDescriptor<SUser> getUsersByMembership(long groupId, long roleId, String field, OrderByType order, int fromIndex, int numberOfUsers) {
        QueryOptions queryOptions = new QueryOptions(fromIndex, numberOfUsers, SUser.class, field, order);
        return SelectDescriptorBuilder.getUsersByMembership(groupId, roleId, queryOptions);
    }

    public static SelectListDescriptor<SUser> getUsersByRole(long roleId) {
        return SelectDescriptorBuilder.getUsersByRole(roleId, null);
    }

    public static SelectListDescriptor<SUser> getUsersByRole(long roleId, int fromIndex, int numberOfUsers) {
        QueryOptions queryOptions = new QueryOptions(fromIndex, numberOfUsers);
        return SelectDescriptorBuilder.getUsersByRole(roleId, queryOptions);
    }

    public static SelectListDescriptor<SUser> getUsersByRole(long roleId, QueryOptions queryOptions) {
        Map<String, Object> parameters = Collections.singletonMap("roleId", roleId);
        return new SelectListDescriptor<SUser>("getUsersByRole", parameters, SUser.class, queryOptions);
    }

    public static SelectListDescriptor<SUser> getUsersByRole(long roleId, String field, OrderByType order, int fromIndex, int numberOfUsers) {
        QueryOptions queryOptions = new QueryOptions(fromIndex, numberOfUsers, SUser.class, field, order);
        return SelectDescriptorBuilder.getUsersByRole(roleId, queryOptions);
    }
}

