/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.persistence;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.bonitasoft.engine.commons.ClassReflector;
import org.bonitasoft.engine.commons.EnumToObjectConvertible;
import org.bonitasoft.engine.commons.StringUtil;
import org.bonitasoft.engine.commons.io.IOUtil;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.AbstractDBPersistenceService;
import org.bonitasoft.engine.persistence.AbstractSelectDescriptor;
import org.bonitasoft.engine.persistence.ConfigurationException;
import org.bonitasoft.engine.persistence.DBConfigurationsProvider;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.HibernateConfigurationProvider;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.PersistentObjectId;
import org.bonitasoft.engine.persistence.PostgresInterceptor;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SQLServerInterceptor;
import org.bonitasoft.engine.persistence.SRetryableException;
import org.bonitasoft.engine.persistence.SearchFields;
import org.bonitasoft.engine.persistence.SelectByIdDescriptor;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;
import org.bonitasoft.engine.persistence.search.FilterOperationType;
import org.bonitasoft.engine.sequence.SequenceManager;
import org.bonitasoft.engine.services.SPersistenceException;
import org.bonitasoft.engine.services.UpdateDescriptor;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.StaleStateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.stat.Statistics;

public abstract class AbstractHibernatePersistenceService
extends AbstractDBPersistenceService {
    private final SessionFactory sessionFactory;
    private final Map<String, String> classAliasMappings;
    protected final Map<String, String> cacheQueries;
    protected final List<Class<? extends PersistentObject>> classMapping;
    protected final Map<String, Class<? extends PersistentObject>> interfaceToClassMapping;
    protected final List<String> mappingExclusions;
    Statistics statistics;
    int stat_display_count;
    TechnicalLoggerService logger;

    public AbstractHibernatePersistenceService(String name, HibernateConfigurationProvider hbmConfigurationProvider, DBConfigurationsProvider tenantConfigurationsProvider, String statementDelimiter, String likeEscapeCharacter, TechnicalLoggerService logger, SequenceManager sequenceManager, DataSource datasource) throws SPersistenceException {
        super(name, tenantConfigurationsProvider, statementDelimiter, likeEscapeCharacter, sequenceManager, datasource);
        String className;
        Configuration configuration;
        try {
            configuration = hbmConfigurationProvider.getConfiguration();
        }
        catch (ConfigurationException e) {
            throw new SPersistenceException(e);
        }
        String dialect = configuration.getProperty("hibernate.dialect");
        if (dialect != null) {
            if (dialect.contains("PostgreSQL")) {
                configuration.setInterceptor((Interceptor)new PostgresInterceptor());
            } else if (dialect.contains("SQLServer")) {
                configuration.setInterceptor((Interceptor)new SQLServerInterceptor());
            }
        }
        if ((className = configuration.getProperty("hibernate.interceptor")) != null && !className.isEmpty()) {
            try {
                Interceptor interceptor = (Interceptor)Class.forName(className).newInstance();
                configuration.setInterceptor(interceptor);
            }
            catch (ClassNotFoundException cnfe) {
                throw new SPersistenceException(cnfe);
            }
            catch (InstantiationException e) {
                throw new SPersistenceException(e);
            }
            catch (IllegalAccessException e) {
                throw new SPersistenceException(e);
            }
        }
        this.sessionFactory = configuration.buildSessionFactory();
        this.statistics = this.sessionFactory.getStatistics();
        Iterator classMappingsIterator = configuration.getClassMappings();
        this.classMapping = new ArrayList<Class<? extends PersistentObject>>();
        while (classMappingsIterator.hasNext()) {
            this.classMapping.add(((PersistentClass)classMappingsIterator.next()).getMappedClass());
        }
        this.classAliasMappings = hbmConfigurationProvider.getClassAliasMappings();
        this.interfaceToClassMapping = hbmConfigurationProvider.getInterfaceToClassMapping();
        this.mappingExclusions = hbmConfigurationProvider.getMappingExclusions();
        this.cacheQueries = hbmConfigurationProvider.getCacheQueries();
        this.logger = logger;
    }

    private void appendClassAlias(StringBuilder builder, Class<? extends PersistentObject> clazz) throws SBonitaReadException {
        String className = clazz.getName();
        String classAlias = this.getClassAliasMappings().get(className);
        if (classAlias == null || classAlias.trim().isEmpty()) {
            throw new SBonitaReadException("No class alias found for class " + className);
        }
        builder.append(classAlias);
        builder.append('.');
    }

    private StringBuilder appendFilterClause(StringBuilder clause, FilterOption filterOption) {
        Object fieldValue;
        FilterOperationType type = filterOption.getFilterOperationType();
        StringBuilder completeField = null;
        if (filterOption.getPersistentClass() != null) {
            completeField = new StringBuilder(this.getClassAliasMappings().get(filterOption.getPersistentClass().getName())).append('.').append(filterOption.getFieldName());
        }
        if ((fieldValue = filterOption.getValue()) instanceof String) {
            fieldValue = "'" + fieldValue + "'";
        } else if (fieldValue instanceof EnumToObjectConvertible) {
            fieldValue = ((EnumToObjectConvertible)fieldValue).fromEnum();
        }
        switch (type) {
            case EQUALS: {
                if (fieldValue == null) {
                    clause.append((CharSequence)completeField).append(" IS NULL");
                    break;
                }
                clause.append((CharSequence)completeField).append(" = ").append(fieldValue);
                break;
            }
            case GREATER: {
                clause.append((CharSequence)completeField).append(" > ").append(fieldValue);
                break;
            }
            case GREATER_OR_EQUALS: {
                clause.append((CharSequence)completeField).append(" >= ").append(fieldValue);
                break;
            }
            case LESS: {
                clause.append((CharSequence)completeField).append(" < ").append(fieldValue);
                break;
            }
            case LESS_OR_EQUALS: {
                clause.append((CharSequence)completeField).append(" <= ").append(fieldValue);
                break;
            }
            case DIFFERENT: {
                clause.append((CharSequence)completeField).append(" != ").append(fieldValue);
                break;
            }
            case IN: {
                break;
            }
            case BETWEEN: {
                Object from = filterOption.getFrom() instanceof String ? "'" + filterOption.getFrom() + "'" : filterOption.getFrom();
                Object to = filterOption.getTo() instanceof String ? "'" + filterOption.getTo() + "'" : filterOption.getTo();
                clause.append("(").append(from).append(" <= ").append((CharSequence)completeField);
                clause.append(" AND ").append((CharSequence)completeField).append(" <= ").append(to).append(")");
                break;
            }
            case LIKE: {
                clause.append((CharSequence)completeField).append(" LIKE '%").append(filterOption.getValue()).append("%'");
                break;
            }
            case L_PARENTHESIS: {
                clause.append(" (");
                break;
            }
            case R_PARENTHESIS: {
                clause.append(" )");
                break;
            }
            case AND: {
                clause.append(" AND ");
                break;
            }
            case OR: {
                clause.append(" OR ");
                break;
            }
        }
        return completeField;
    }

    private <T> void appendOrderByClause(StringBuilder builder, SelectListDescriptor<T> selectDescriptor) throws SBonitaReadException {
        builder.append(" ORDER BY ");
        boolean startWithComma = false;
        boolean sortedById = false;
        for (OrderByOption orderByOption : selectDescriptor.getQueryOptions().getOrderByOptions()) {
            String fieldName;
            Class<? extends PersistentObject> clazz;
            if (startWithComma) {
                builder.append(',');
            }
            if ((clazz = orderByOption.getClazz()) != null) {
                this.appendClassAlias(builder, clazz);
            }
            if ("id".equalsIgnoreCase(fieldName = orderByOption.getFieldName()) || "sourceObjectId".equalsIgnoreCase(fieldName)) {
                sortedById = true;
            }
            builder.append(fieldName);
            builder.append(' ');
            builder.append(orderByOption.getOrderByType().toString());
            startWithComma = true;
        }
        if (!sortedById) {
            if (startWithComma) {
                builder.append(',');
            }
            this.appendClassAlias(builder, selectDescriptor.getEntityType());
            builder.append("id");
            builder.append(' ');
            builder.append("ASC");
        }
    }

    protected void checkClassMapping(Class<? extends PersistentObject> entityClass) throws SPersistenceException {
        if (!(this.classMapping.contains(entityClass) || this.interfaceToClassMapping.containsKey(entityClass.getName()) || this.mappingExclusions.contains(entityClass.getName()))) {
            throw new SPersistenceException("Unable to locate class " + entityClass + " in Hibernate configuration");
        }
    }

    private <T> void checkOrderByClause(SelectListDescriptor<T> selectDescriptor, Query query) {
        boolean needOrderBy = this.needOrderBy(selectDescriptor, query);
        if (needOrderBy) {
            this.logWarningMessage(selectDescriptor, query);
        }
    }

    private <T> boolean needOrderBy(SelectListDescriptor<T> selectDescriptor, Query query) {
        boolean needOrderBy = true;
        if (selectDescriptor.getQueryName().startsWith("getNumberOf")) {
            needOrderBy = false;
        }
        if (query.toString().toLowerCase().contains("order by")) {
            needOrderBy = false;
        }
        if (selectDescriptor.getPageSize() == Integer.MAX_VALUE) {
            needOrderBy = false;
        }
        return needOrderBy;
    }

    @Override
    public void delete(List<Long> ids, Class<? extends PersistentObject> entityClass) throws SPersistenceException {
        Class<? extends PersistentObject> mappedClass = this.getMappedClass(entityClass);
        Query query = this.getSession(true).getNamedQuery("deleteByIds" + mappedClass.getSimpleName());
        query.setParameterList("ids", ids);
        try {
            query.executeUpdate();
        }
        catch (AssertionFailure af) {
            throw new SRetryableException(af);
        }
        catch (LockAcquisitionException lae) {
            throw new SRetryableException(lae);
        }
        catch (StaleStateException sse) {
            throw new SRetryableException(sse);
        }
        catch (HibernateException he) {
            throw new SPersistenceException(he);
        }
    }

    @Override
    public void delete(long id, Class<? extends PersistentObject> entityClass) throws SPersistenceException {
        Class<? extends PersistentObject> mappedClass = this.getMappedClass(entityClass);
        Query query = this.getSession(true).getNamedQuery("delete" + mappedClass.getSimpleName());
        query.setLong("id", id);
        try {
            query.executeUpdate();
        }
        catch (AssertionFailure af) {
            throw new SRetryableException(af);
        }
        catch (LockAcquisitionException lae) {
            throw new SRetryableException(lae);
        }
        catch (StaleStateException sse) {
            throw new SRetryableException(sse);
        }
        catch (HibernateException he) {
            throw new SPersistenceException(he);
        }
    }

    @Override
    public void delete(PersistentObject entity) throws SPersistenceException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, "Deleting instance of class " + entity.getClass().getSimpleName() + " with id=" + entity.getId());
        }
        Class<? extends PersistentObject> mappedClass = this.getMappedClass(entity.getClass());
        org.hibernate.Session session = this.getSession(true);
        try {
            if (session.contains((Object)entity)) {
                session.delete((Object)entity);
            } else {
                Object pe = session.get(mappedClass, (Serializable)new PersistentObjectId(entity.getId(), 0L));
                session.delete(pe);
            }
        }
        catch (AssertionFailure af) {
            throw new SRetryableException(af);
        }
        catch (LockAcquisitionException lae) {
            throw new SRetryableException(lae);
        }
        catch (StaleStateException sse) {
            throw new SRetryableException(sse);
        }
        catch (HibernateException he) {
            throw new SPersistenceException(he);
        }
    }

    @Override
    public void deleteAll(Class<? extends PersistentObject> entityClass) throws SPersistenceException {
        Class<? extends PersistentObject> mappedClass = this.getMappedClass(entityClass);
        Query query = this.getSession(true).getNamedQuery("deleteAll" + mappedClass.getSimpleName());
        try {
            query.executeUpdate();
        }
        catch (AssertionFailure af) {
            throw new SRetryableException(af);
        }
        catch (LockAcquisitionException lae) {
            throw new SRetryableException(lae);
        }
        catch (StaleStateException sse) {
            throw new SRetryableException(sse);
        }
        catch (HibernateException he) {
            throw new SPersistenceException(he);
        }
    }

    public void destroy() {
        this.logger.log(this.getClass(), TechnicalLogSeverity.INFO, "Closing Hibernate session factory of " + this.getClass().getName());
        this.sessionFactory.close();
    }

    @Override
    protected void doExecuteSQL(String sqlResource, String statementDelimiter, Map<String, String> replacements, boolean useDataSourceConnection) throws SPersistenceException, IOException {
        String[] tmp;
        URL url = this.getClass().getResource(sqlResource);
        if (url == null) {
            throw new IOException("SQL file not found, path=" + sqlResource);
        }
        String fileContent = new String(IOUtil.getAllContentFrom(url));
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, "Processing SQL resource : " + sqlResource);
        }
        String regex = statementDelimiter.concat("\r?\n");
        ArrayList<String> commands = new ArrayList<String>();
        for (String command : tmp = fileContent.split(regex)) {
            String filledCommand = this.fillTemplate(replacements, command);
            if (filledCommand.isEmpty()) continue;
            commands.add(filledCommand);
        }
        if (commands.isEmpty()) {
            return;
        }
        int lastIndex = commands.size() - 1;
        String lastCommand = (String)commands.get(lastIndex);
        int index = lastCommand.lastIndexOf(statementDelimiter);
        if (index > 0) {
            lastCommand = lastCommand.substring(0, index);
            commands.remove(lastIndex);
            commands.add(lastCommand);
        }
        if (useDataSourceConnection) {
            this.doExecuteSQLThroughJDBC(commands);
        } else {
            this.doExecuteSQLThroughHibernate(sqlResource, commands);
        }
    }

    private void doExecuteSQLThroughHibernate(String sqlResource, List<String> commands) throws SPersistenceException {
        org.hibernate.Session session = this.getSession(false);
        for (String command : commands) {
            try {
                session.createSQLQuery(command).executeUpdate();
            }
            catch (AssertionFailure af) {
                throw new SRetryableException("Unable to execute command of file " + sqlResource + " content:\n " + command, af);
            }
            catch (LockAcquisitionException lae) {
                throw new SRetryableException("Unable to execute command of file " + sqlResource + " content:\n " + command, lae);
            }
            catch (StaleStateException sse) {
                throw new SRetryableException("Unable to execute command of file " + sqlResource + " content:\n " + command, sse);
            }
            catch (HibernateException e) {
                throw new SPersistenceException("Unable to execute command of file " + sqlResource + " content:\n " + command, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecuteSQLThroughJDBC(List<String> commands) throws SPersistenceException {
        try {
            Connection connection = this.datasource.getConnection();
            connection.setAutoCommit(false);
            try {
                for (String command : commands) {
                    Statement stmt = connection.createStatement();
                    try {
                        stmt.execute(command);
                    }
                    finally {
                        stmt.close();
                    }
                }
                connection.commit();
            }
            catch (SQLException sqe) {
                connection.rollback();
                throw sqe;
            }
            finally {
                connection.close();
            }
        }
        catch (SQLException e) {
            throw new SPersistenceException(e);
        }
    }

    private String fillTemplate(Map<String, String> replacements, String command) {
        String trimmedCommand = command.trim();
        if (trimmedCommand.isEmpty() || replacements == null) {
            return trimmedCommand;
        }
        for (Map.Entry<String, String> tableMapping : replacements.entrySet()) {
            String stringToReplace = tableMapping.getKey();
            String value = tableMapping.getValue();
            trimmedCommand = trimmedCommand.replaceAll(stringToReplace, value);
        }
        return trimmedCommand;
    }

    protected void flushStatements(boolean useTenant) throws SPersistenceException {
        org.hibernate.Session session = this.getSession(useTenant);
        session.flush();
    }

    public Map<String, String> getClassAliasMappings() {
        return this.classAliasMappings;
    }

    protected Class<? extends PersistentObject> getMappedClass(Class<? extends PersistentObject> entityClass) throws SPersistenceException {
        if (this.classMapping.contains(entityClass)) {
            return entityClass;
        }
        if (this.interfaceToClassMapping.containsKey(entityClass.getName())) {
            return this.interfaceToClassMapping.get(entityClass.getName());
        }
        throw new SPersistenceException("Unable to locate class " + entityClass + " in Hibernate configuration");
    }

    protected String getQueryWithFilters(String query, List<FilterOption> filters, SearchFields multipleFilter) {
        StringBuilder builder = new StringBuilder(query);
        HashSet<String> specificFilters = new HashSet<String>(filters.size());
        FilterOption previousFilter = null;
        if (!filters.isEmpty()) {
            if (!query.contains("WHERE")) {
                builder.append(" WHERE (");
            } else {
                builder.append(" AND (");
            }
            for (FilterOption filterOption : filters) {
                StringBuilder aliasBuilder;
                if (previousFilter != null) {
                    FilterOperationType prevOp = previousFilter.getFilterOperationType();
                    FilterOperationType currOp = filterOption.getFilterOperationType();
                    if ((FilterOperationType.isNormalOperator(prevOp) || prevOp == FilterOperationType.R_PARENTHESIS) && (FilterOperationType.isNormalOperator(currOp) || currOp == FilterOperationType.L_PARENTHESIS)) {
                        builder.append(" AND ");
                    }
                }
                if ((aliasBuilder = this.appendFilterClause(builder, filterOption)) != null) {
                    specificFilters.add(aliasBuilder.toString());
                }
                previousFilter = filterOption;
            }
            builder.append(")");
        }
        if (multipleFilter != null && multipleFilter.getTerms() != null && !multipleFilter.getTerms().isEmpty()) {
            Map<Class<? extends PersistentObject>, Set<String>> allTextFields = multipleFilter.getFields();
            HashSet<String> fields = new HashSet<String>();
            for (Map.Entry<Class<? extends PersistentObject>, Set<String>> entry : allTextFields.entrySet()) {
                String alias = this.getClassAliasMappings().get(entry.getKey().getName());
                for (String field : entry.getValue()) {
                    StringBuilder aliasBuilder = new StringBuilder(alias);
                    aliasBuilder.append('.').append(field);
                    fields.add(aliasBuilder.toString());
                }
            }
            fields.removeAll(specificFilters);
            Iterator fieldIterator = fields.iterator();
            List<String> terms = multipleFilter.getTerms();
            if (!fields.isEmpty()) {
                if (!builder.toString().contains("WHERE")) {
                    builder.append(" WHERE (");
                } else {
                    builder.append(" AND (");
                }
                while (fieldIterator.hasNext()) {
                    Iterator<String> termIterator = terms.iterator();
                    String currentField = (String)fieldIterator.next();
                    while (termIterator.hasNext()) {
                        String currentTerm = termIterator.next();
                        builder.append(currentField).append(this.getLikeEscapeClause(currentTerm));
                        if (!termIterator.hasNext() && !fieldIterator.hasNext()) continue;
                        builder.append(" OR ");
                    }
                }
                builder.append(")");
            }
        }
        return builder.toString();
    }

    private <T> String getQueryWithOrderByClause(String query, SelectListDescriptor<T> selectDescriptor) throws SBonitaReadException {
        StringBuilder builder = new StringBuilder(query);
        this.appendOrderByClause(builder, selectDescriptor);
        return builder.toString();
    }

    protected org.hibernate.Session getSession(boolean useTenant) throws SPersistenceException {
        this.logStats();
        try {
            Session currentSession = this.sessionFactory.getCurrentSession();
            return currentSession;
        }
        catch (HibernateException e) {
            throw new SPersistenceException(e);
        }
    }

    @Override
    public void insert(PersistentObject entity) throws SPersistenceException {
        Class<?> entityClass = entity.getClass();
        this.checkClassMapping(entityClass);
        org.hibernate.Session session = this.getSession(true);
        this.setId(entity);
        try {
            session.save((Object)entity);
        }
        catch (AssertionFailure af) {
            throw new SRetryableException(af);
        }
        catch (LockAcquisitionException lae) {
            throw new SRetryableException(lae);
        }
        catch (StaleStateException sse) {
            throw new SRetryableException(sse);
        }
        catch (HibernateException he) {
            throw new SPersistenceException(he);
        }
    }

    @Override
    public void insertInBatch(List<PersistentObject> entities) throws SPersistenceException {
        if (!entities.isEmpty()) {
            org.hibernate.Session session = this.getSession(true);
            for (PersistentObject entity : entities) {
                Class<?> entityClass = entity.getClass();
                this.checkClassMapping(entityClass);
                this.setId(entity);
                session.save((Object)entity);
            }
        }
    }

    protected void logStats() {
        if (!this.statistics.isStatisticsEnabled()) {
            return;
        }
        if (this.stat_display_count == 10 || this.stat_display_count == 100 || this.stat_display_count == 1000 || this.stat_display_count % 10000 == 0) {
            long query_cache_hit = this.statistics.getQueryCacheHitCount();
            long query_cache_miss = this.statistics.getQueryCacheMissCount();
            long query_cahe_put = this.statistics.getQueryCachePutCount();
            long level_2_cache_hit = this.statistics.getSecondLevelCacheHitCount();
            long level_2_cache_miss = this.statistics.getSecondLevelCacheMissCount();
            long level_2_put = this.statistics.getSecondLevelCachePutCount();
            this.logger.log(this.getClass(), TechnicalLogSeverity.INFO, "Query Cache Ratio " + (int)((double)query_cache_hit / (double)(query_cache_hit + query_cache_miss) * 100.0) + "% " + query_cache_hit + " hits " + query_cache_miss + " miss " + query_cahe_put + " puts");
            this.logger.log(this.getClass(), TechnicalLogSeverity.INFO, "2nd Level Cache Ratio " + (int)((double)level_2_cache_hit / (double)(level_2_cache_hit + level_2_cache_miss) * 100.0) + "% " + level_2_cache_hit + " hits " + level_2_cache_miss + " miss " + level_2_put + " puts");
        }
        ++this.stat_display_count;
    }

    protected <T> void logWarningMessage(SelectListDescriptor<T> selectDescriptor, Query query) {
        StringBuilder message = new StringBuilder();
        message.append("selectList call without \"order by\" clause ");
        message.append("\n");
        message.append(query.toString());
        message.append("\n");
        message.append(String.format("query name:%s\nentity:%s\nstart index:%d\npage size:%d", selectDescriptor.getQueryName(), selectDescriptor.getEntityType().getCanonicalName(), selectDescriptor.getStartIndex(), selectDescriptor.getPageSize()));
        this.logger.log(this.getClass(), TechnicalLogSeverity.WARNING, message.toString());
    }

    @Override
    public void purge(String classToPurge) throws SPersistenceException {
        int index = classToPurge.lastIndexOf(46);
        String suffix = classToPurge;
        if (index != -1) {
            suffix = classToPurge.substring(index + 1, classToPurge.length());
        }
        Query query = this.getSession(true).getNamedQuery("purge" + suffix);
        try {
            query.executeUpdate();
        }
        catch (AssertionFailure af) {
            throw new SRetryableException(af);
        }
        catch (LockAcquisitionException lae) {
            throw new SRetryableException(lae);
        }
        catch (StaleStateException sse) {
            throw new SRetryableException(sse);
        }
        catch (HibernateException he) {
            throw new SPersistenceException(he);
        }
    }

    @Override
    public <T extends PersistentObject> T selectById(SelectByIdDescriptor<T> selectDescriptor) throws SBonitaReadException {
        try {
            return this.selectById(this.getSession(true), selectDescriptor);
        }
        catch (SPersistenceException e) {
            throw new SBonitaReadException((Throwable)e, selectDescriptor);
        }
    }

    <T extends PersistentObject> T selectById(org.hibernate.Session session, SelectByIdDescriptor<T> selectDescriptor) throws SBonitaReadException {
        Class<? extends PersistentObject> mappedClass = null;
        try {
            mappedClass = this.getMappedClass(selectDescriptor.getEntityType());
        }
        catch (SPersistenceException e) {
            throw new SBonitaReadException(e);
        }
        try {
            return (T)((PersistentObject)session.get(mappedClass, (Serializable)Long.valueOf(selectDescriptor.getId())));
        }
        catch (AssertionFailure af) {
            throw new SRetryableException(af);
        }
        catch (LockAcquisitionException lae) {
            throw new SRetryableException(lae);
        }
        catch (StaleStateException sse) {
            throw new SRetryableException(sse);
        }
        catch (HibernateException he) {
            throw new SBonitaReadException(he);
        }
    }

    @Override
    public <T> List<T> selectList(SelectListDescriptor<T> selectDescriptor) throws SBonitaReadException {
        try {
            Class<PersistentObject> entityClass = selectDescriptor.getEntityType();
            this.checkClassMapping(entityClass);
            org.hibernate.Session session = this.getSession(true);
            Query query = session.getNamedQuery(selectDescriptor.getQueryName());
            String builtQuery = query.getQueryString();
            if (selectDescriptor.hasAFilter()) {
                QueryOptions queryOptions = selectDescriptor.getQueryOptions();
                builtQuery = this.getQueryWithFilters(builtQuery, queryOptions.getFilters(), queryOptions.getMultipleFilter());
            }
            if (selectDescriptor.hasOrderByParameters()) {
                builtQuery = this.getQueryWithOrderByClause(builtQuery, selectDescriptor);
            }
            if (!builtQuery.equals(query.getQueryString())) {
                query = session.createQuery(builtQuery);
            }
            this.setQueryCache(query, selectDescriptor.getQueryName());
            if (selectDescriptor != null) {
                this.setParameters(query, selectDescriptor.getInputParameters());
            }
            query.setFirstResult(selectDescriptor.getStartIndex());
            query.setMaxResults(selectDescriptor.getPageSize());
            List list = query.list();
            if (list != null) {
                return list;
            }
            return Collections.emptyList();
        }
        catch (AssertionFailure af) {
            throw new SRetryableException(af);
        }
        catch (LockAcquisitionException lae) {
            throw new SRetryableException(lae);
        }
        catch (StaleStateException sse) {
            throw new SRetryableException(sse);
        }
        catch (HibernateException e) {
            throw new SBonitaReadException((Throwable)e, selectDescriptor);
        }
        catch (SPersistenceException e) {
            throw new SBonitaReadException((Throwable)e, selectDescriptor);
        }
    }

    @Override
    public <T> T selectOne(SelectOneDescriptor<T> selectDescriptor) throws SBonitaReadException {
        try {
            org.hibernate.Session session = this.getSession(true);
            return this.selectOne(session, selectDescriptor, selectDescriptor.getInputParameters());
        }
        catch (SPersistenceException e) {
            throw new SBonitaReadException((Throwable)e, selectDescriptor);
        }
    }

    private <T> T selectOne(org.hibernate.Session session, AbstractSelectDescriptor<T> selectDescriptor, Map<String, Object> parameters) throws SBonitaReadException {
        try {
            this.checkClassMapping(selectDescriptor.getEntityType());
        }
        catch (SPersistenceException e) {
            throw new SBonitaReadException(e);
        }
        Query query = session.getNamedQuery(selectDescriptor.getQueryName());
        this.setQueryCache(query, selectDescriptor.getQueryName());
        if (parameters != null) {
            this.setParameters(query, parameters);
        }
        query.setMaxResults(1);
        try {
            return (T)query.uniqueResult();
        }
        catch (AssertionFailure af) {
            throw new SRetryableException(af);
        }
        catch (LockAcquisitionException lae) {
            throw new SRetryableException(lae);
        }
        catch (StaleStateException sse) {
            throw new SRetryableException(sse);
        }
        catch (HibernateException he) {
            throw new SBonitaReadException(he);
        }
    }

    private void setField(PersistentObject entity, String fieldName, Object parameterValue) throws SPersistenceException {
        Long id = null;
        try {
            id = entity.getId();
            String setterName = "set" + StringUtil.firstCharToUpperCase(fieldName);
            ClassReflector.invokeMethodByName(entity, setterName, parameterValue);
        }
        catch (Exception e) {
            throw new SPersistenceException("Problem while updating entity: " + entity + " with id: " + id, e);
        }
    }

    protected void setParameters(Query query, Map<String, Object> inputParameters) {
        for (Map.Entry<String, Object> entry : inputParameters.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Collection) {
                query.setParameterList(entry.getKey(), (Collection)value);
                continue;
            }
            query.setParameter(entry.getKey(), value);
        }
    }

    protected void setQueryCache(Query query, String name) {
        if (this.cacheQueries != null && this.cacheQueries.containsKey(name)) {
            query.setCacheable(true);
        }
    }

    @Override
    public void update(UpdateDescriptor updateDescriptor) throws SPersistenceException {
        Class<?> entityClass = updateDescriptor.getEntity().getClass();
        this.checkClassMapping(entityClass);
        PersistentObject entity = updateDescriptor.getEntity();
        org.hibernate.Session session = this.getSession(false);
        if (!session.contains((Object)entity)) {
            throw new SPersistenceException("The object cannot be updated because it's deconnected " + entity);
        }
        for (Map.Entry<String, Object> field : updateDescriptor.getFields().entrySet()) {
            this.setField(entity, field.getKey(), field.getValue());
        }
    }
}

