/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.persistence;

import java.io.Serializable;
import java.util.List;
import javax.sql.DataSource;
import org.bonitasoft.engine.commons.ClassReflector;
import org.bonitasoft.engine.commons.ReflectException;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.AbstractHibernatePersistenceService;
import org.bonitasoft.engine.persistence.DBConfigurationsProvider;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.HibernateConfigurationProvider;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.PersistentObjectId;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SRetryableException;
import org.bonitasoft.engine.persistence.SelectByIdDescriptor;
import org.bonitasoft.engine.sequence.SequenceManager;
import org.bonitasoft.engine.services.SPersistenceException;
import org.bonitasoft.engine.sessionaccessor.ReadSessionAccessor;
import org.bonitasoft.engine.sessionaccessor.TenantIdNotSetException;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.StaleStateException;
import org.hibernate.exception.LockAcquisitionException;

public class TenantHibernatePersistenceService
extends AbstractHibernatePersistenceService {
    private static final String TENANT_FILTER = "tenantFilter";
    private final ReadSessionAccessor sessionAccessor;

    public TenantHibernatePersistenceService(String name, ReadSessionAccessor sessionAccessor, HibernateConfigurationProvider hbmConfigurationProvider, DBConfigurationsProvider tenantConfigurationsProvider, String statementDelimiter, String likeEscapeCharacter, TechnicalLoggerService logger, SequenceManager sequenceManager, DataSource datasource) throws SPersistenceException {
        super(name, hbmConfigurationProvider, tenantConfigurationsProvider, statementDelimiter, likeEscapeCharacter, logger, sequenceManager, datasource);
        this.sessionAccessor = sessionAccessor;
    }

    protected void updateTenantFilter(Session session, boolean useTenant) throws SPersistenceException {
        if (useTenant) {
            try {
                session.enableFilter(TENANT_FILTER).setParameter("tenantId", (Object)this.getTenantId());
            }
            catch (TenantIdNotSetException e) {
                throw new SPersistenceException(e);
            }
        } else {
            session.disableFilter(TENANT_FILTER);
        }
    }

    protected void setTenant(PersistentObject entity) throws SPersistenceException {
        if (entity == null) {
            return;
        }
        Long tenantId = null;
        try {
            tenantId = (Long)ClassReflector.invokeGetter(entity, "getTenantId");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (tenantId == null || tenantId == -1L || tenantId == 0L) {
            try {
                tenantId = this.getTenantId();
                ClassReflector.invokeSetter(entity, "setTenantId", Long.TYPE, tenantId);
            }
            catch (ReflectException e) {
                throw new SPersistenceException("Can't set tenantId " + tenantId + " on entity " + entity, e);
            }
            catch (TenantIdNotSetException e) {
                throw new SPersistenceException("Can't set tenantId on entity " + entity, e);
            }
        }
    }

    @Override
    protected Session getSession(boolean useTenant) throws SPersistenceException {
        Session session = super.getSession(useTenant);
        this.updateTenantFilter(session, useTenant);
        return session;
    }

    @Override
    public void flushStatements() throws SPersistenceException {
        super.flushStatements(true);
    }

    @Override
    public void delete(PersistentObject entity) throws SPersistenceException {
        try {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, "[Tenant] Deleting instance of class " + entity.getClass().getSimpleName() + " with id=" + entity.getId());
            }
            Class<? extends PersistentObject> mappedClass = this.getMappedClass(entity.getClass());
            Session session = this.getSession(true);
            Object pe = session.get(mappedClass, (Serializable)new PersistentObjectId(entity.getId(), this.getTenantId()));
            session.delete(pe);
        }
        catch (TenantIdNotSetException e) {
            throw new SPersistenceException(e);
        }
        catch (AssertionFailure af) {
            throw new SRetryableException(af);
        }
        catch (LockAcquisitionException lae) {
            throw new SRetryableException(lae);
        }
        catch (StaleStateException sse) {
            throw new SRetryableException(sse);
        }
        catch (HibernateException he) {
            throw new SPersistenceException(he);
        }
    }

    @Override
    public void insert(PersistentObject entity) throws SPersistenceException {
        this.setTenant(entity);
        super.insert(entity);
    }

    @Override
    public void insertInBatch(List<PersistentObject> entities) throws SPersistenceException {
        for (PersistentObject entity : entities) {
            this.setTenant(entity);
        }
        super.insertInBatch(entities);
    }

    @Override
    protected long getTenantId() throws TenantIdNotSetException {
        return this.sessionAccessor.getTenantId();
    }

    @Override
    <T extends PersistentObject> T selectById(Session session, SelectByIdDescriptor<T> selectDescriptor) throws SBonitaReadException {
        try {
            PersistentObjectId id = new PersistentObjectId(selectDescriptor.getId(), this.getTenantId());
            Class<? extends PersistentObject> mappedClass = null;
            try {
                mappedClass = this.getMappedClass(selectDescriptor.getEntityType());
            }
            catch (SPersistenceException e) {
                throw new SBonitaReadException(e);
            }
            return (T)((PersistentObject)session.get(mappedClass, (Serializable)id));
        }
        catch (TenantIdNotSetException e) {
            return super.selectById(session, selectDescriptor);
        }
        catch (AssertionFailure af) {
            throw new SRetryableException(af);
        }
        catch (LockAcquisitionException lae) {
            throw new SRetryableException(lae);
        }
        catch (StaleStateException sse) {
            throw new SRetryableException(sse);
        }
        catch (HibernateException he) {
            throw new SBonitaReadException(he);
        }
    }

    @Override
    public void deleteByTenant(Class<? extends PersistentObject> entityClass, List<FilterOption> filters) throws SPersistenceException {
        try {
            Session session = this.getSession(true);
            String entityClassName = entityClass.getCanonicalName();
            Query query = session.createQuery(this.getQueryWithFilters("DELETE FROM " + entityClassName + " " + this.getClassAliasMappings().get(entityClassName) + " WHERE tenantId= :tenantId", filters, null));
            query.setLong("tenantId", this.getTenantId());
            query.executeUpdate();
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, "[Tenant] Deleting all instance of class " + entityClass.getClass().getSimpleName());
            }
        }
        catch (TenantIdNotSetException e) {
            throw new SPersistenceException(e);
        }
    }
}

