/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.scheduler.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.LogUtil;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.events.EventService;
import org.bonitasoft.engine.events.model.FireEventException;
import org.bonitasoft.engine.events.model.SEvent;
import org.bonitasoft.engine.events.model.builders.SEventBuilderFactory;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaSearchException;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLogSeverity;
import org.bonitasoft.engine.queriablelogger.model.builder.ActionType;
import org.bonitasoft.engine.queriablelogger.model.builder.HasCRUDEAction;
import org.bonitasoft.engine.queriablelogger.model.builder.SLogBuilder;
import org.bonitasoft.engine.scheduler.JobIdentifier;
import org.bonitasoft.engine.scheduler.JobService;
import org.bonitasoft.engine.scheduler.SchedulerExecutor;
import org.bonitasoft.engine.scheduler.SchedulerService;
import org.bonitasoft.engine.scheduler.StatelessJob;
import org.bonitasoft.engine.scheduler.builder.SSchedulerQueriableLogBuilder;
import org.bonitasoft.engine.scheduler.builder.SSchedulerQueriableLogBuilderFactory;
import org.bonitasoft.engine.scheduler.exception.SSchedulerException;
import org.bonitasoft.engine.scheduler.impl.JobWrapper;
import org.bonitasoft.engine.scheduler.model.SJobDescriptor;
import org.bonitasoft.engine.scheduler.model.SJobParameter;
import org.bonitasoft.engine.scheduler.trigger.Trigger;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;
import org.bonitasoft.engine.sessionaccessor.TenantIdNotSetException;
import org.bonitasoft.engine.transaction.TransactionService;

public class SchedulerServiceImpl
implements SchedulerService {
    private final TechnicalLoggerService logger;
    private final SchedulerExecutor schedulerExecutor;
    private final JobService jobService;
    private final EventService eventService;
    private final SEvent schedulStarted;
    private final SEvent schedulStopped;
    private final SEvent jobFailed;
    private final SessionAccessor sessionAccessor;
    private final TransactionService transactionService;

    public SchedulerServiceImpl(SchedulerExecutor schedulerExecutor, JobService jobService, TechnicalLoggerService logger, EventService eventService, TransactionService transactionService, SessionAccessor sessionAccessor) {
        this.schedulerExecutor = schedulerExecutor;
        this.jobService = jobService;
        this.logger = logger;
        this.schedulStarted = BuilderFactory.get(SEventBuilderFactory.class).createNewInstance("SCHEDULER_STARTED").done();
        this.schedulStopped = BuilderFactory.get(SEventBuilderFactory.class).createNewInstance("SCHEDULER_STOPPED").done();
        this.jobFailed = BuilderFactory.get(SEventBuilderFactory.class).createNewInstance("JOB_FAILED").done();
        this.eventService = eventService;
        this.transactionService = transactionService;
        this.sessionAccessor = sessionAccessor;
        schedulerExecutor.setBOSSchedulerService(this);
    }

    private Callable<JobWrapper> buildGetPersistedJobCallable(final JobIdentifier jobIdentifier) {
        return new Callable<JobWrapper>(){

            @Override
            public JobWrapper call() throws Exception {
                SJobDescriptor sJobDescriptor = SchedulerServiceImpl.this.jobService.getJobDescriptor(jobIdentifier.getId());
                if (sJobDescriptor == null) {
                    return null;
                }
                String jobClassName = sJobDescriptor.getJobClassName();
                Class<?> jobClass = Class.forName(jobClassName);
                StatelessJob statelessJob = (StatelessJob)jobClass.newInstance();
                FilterOption filterOption = new FilterOption(SJobParameter.class, "jobDescriptorId", jobIdentifier.getId());
                List<OrderByOption> orderByoptions = Arrays.asList(new OrderByOption(SJobParameter.class, "id", OrderByType.ASC));
                QueryOptions queryOptions = new QueryOptions(0, Integer.MAX_VALUE, orderByoptions, Collections.singletonList(filterOption), null);
                List<SJobParameter> parameters = SchedulerServiceImpl.this.jobService.searchJobParameters(queryOptions);
                HashMap<String, Serializable> parameterMap = new HashMap<String, Serializable>();
                for (SJobParameter sJobParameterImpl : parameters) {
                    parameterMap.put(sJobParameterImpl.getKey(), sJobParameterImpl.getValue());
                }
                statelessJob.setAttributes(parameterMap);
                JobWrapper jobWrapper = new JobWrapper(jobIdentifier.getJobName(), statelessJob, SchedulerServiceImpl.this.logger, jobIdentifier.getTenantId(), SchedulerServiceImpl.this.eventService, SchedulerServiceImpl.this.sessionAccessor, SchedulerServiceImpl.this.transactionService);
                return jobWrapper;
            }
        };
    }

    private SJobDescriptor createJobDescriptor(SJobDescriptor sJobDescriptor, List<SJobParameter> parameters) throws SSchedulerException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "createJobDescriptor");
        long tenantId = this.getTenantId();
        try {
            SJobDescriptor createdJobDescriptor = this.jobService.createJobDescriptor(sJobDescriptor, tenantId);
            this.jobService.createJobParameters(parameters, tenantId, createdJobDescriptor.getId());
            this.logAfterMethod(TechnicalLogSeverity.TRACE, "createJobDescriptor");
            return createdJobDescriptor;
        }
        catch (SBonitaException sbe) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "createJobDescriptor", sbe);
            throw new SSchedulerException(sbe);
        }
    }

    @Override
    public boolean delete(String jobName) throws SSchedulerException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "delete");
        boolean delete = this.schedulerExecutor.delete(jobName);
        ArrayList<FilterOption> filters = new ArrayList<FilterOption>();
        filters.add(new FilterOption(SJobDescriptor.class, "jobName", jobName));
        QueryOptions queryOptions = new QueryOptions(0, 1, null, filters, null);
        try {
            List<SJobDescriptor> jobDescriptors = this.jobService.searchJobDescriptors(queryOptions);
            if (!jobDescriptors.isEmpty()) {
                SJobDescriptor sJobDescriptor = jobDescriptors.get(0);
                this.jobService.deleteJobDescriptor(sJobDescriptor);
            }
        }
        catch (SBonitaSearchException sbse) {
            throw new SSchedulerException(sbse);
        }
        this.logAfterMethod(TechnicalLogSeverity.TRACE, "delete");
        return delete;
    }

    @Override
    public void deleteJobs() throws SSchedulerException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "deleteJobs");
        this.schedulerExecutor.deleteJobs();
        ArrayList<FilterOption> filters = new ArrayList<FilterOption>();
        QueryOptions queryOptions = new QueryOptions(0, 100, null, filters, null);
        try {
            List<SJobDescriptor> jobDescriptors = this.jobService.searchJobDescriptors(queryOptions);
            for (SJobDescriptor sJobDescriptor : jobDescriptors) {
                this.jobService.deleteJobDescriptor(sJobDescriptor);
            }
        }
        catch (SBonitaSearchException sbse) {
            throw new SSchedulerException(sbse);
        }
        this.logAfterMethod(TechnicalLogSeverity.TRACE, "deleteJobs");
    }

    @Override
    public void executeAgain(long jobDescriptorId) throws SSchedulerException {
        SJobDescriptor jobDescriptor = this.jobService.getJobDescriptor(jobDescriptorId);
        this.schedulerExecutor.executeAgain(jobDescriptorId, this.getTenantId(), jobDescriptor.getJobName(), jobDescriptor.disallowConcurrentExecution());
    }

    @Override
    public void executeAgain(long jobDescriptorId, List<SJobParameter> parameters) throws SSchedulerException {
        SJobDescriptor jobDescriptor = this.jobService.getJobDescriptor(jobDescriptorId);
        this.jobService.setJobParameters(this.getTenantId(), jobDescriptor.getId(), parameters);
        this.schedulerExecutor.executeAgain(jobDescriptorId, this.getTenantId(), jobDescriptor.getJobName(), jobDescriptor.disallowConcurrentExecution());
    }

    @Override
    public void executeNow(SJobDescriptor jobDescriptor, List<SJobParameter> parameters) throws SSchedulerException {
        SJobDescriptor createdJobDescriptor = this.createJobDescriptor(jobDescriptor, parameters);
        this.internalSchedule(createdJobDescriptor, null);
    }

    @Override
    public List<String> getAllJobs() throws SSchedulerException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "getAllJobs");
        List<String> list = this.schedulerExecutor.getAllJobs();
        this.logAfterMethod(TechnicalLogSeverity.TRACE, "getAllJobs");
        return list;
    }

    @Override
    public List<String> getJobs() throws SSchedulerException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "getJobs");
        List<String> list = this.schedulerExecutor.getJobs();
        this.logAfterMethod(TechnicalLogSeverity.TRACE, "getJobs");
        return list;
    }

    private SSchedulerQueriableLogBuilder getLogBuilder(ActionType actionType, String message, String scope) {
        SSchedulerQueriableLogBuilder logBuilder = BuilderFactory.get(SSchedulerQueriableLogBuilderFactory.class).createNewInstance();
        this.initializeLogBuilder(logBuilder, message);
        this.updateLog(actionType, logBuilder);
        logBuilder.actionScope(scope);
        return logBuilder;
    }

    public StatelessJob getPersistedJob(JobIdentifier jobIdentifier) throws SSchedulerException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "getPersistedJob");
        try {
            this.sessionAccessor.setTenantId(jobIdentifier.getTenantId());
            Callable<JobWrapper> callable = this.buildGetPersistedJobCallable(jobIdentifier);
            this.logAfterMethod(TechnicalLogSeverity.TRACE, "getPersistedJob");
            StatelessJob statelessJob = this.transactionService.executeInTransaction(callable);
            return statelessJob;
        }
        catch (Exception e) {
            throw new SSchedulerException("The job class couldn't be instantiated", e);
        }
        finally {
            this.sessionAccessor.deleteTenantId();
        }
    }

    private long getTenantId() throws SSchedulerException {
        long tenantId;
        try {
            tenantId = this.sessionAccessor.getTenantId();
        }
        catch (TenantIdNotSetException e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "getTenantId", e);
            throw new SSchedulerException(e);
        }
        return tenantId;
    }

    private <T extends SLogBuilder> void initializeLogBuilder(T logBuilder, String message) {
        logBuilder.actionStatus(0).severity(SQueriableLogSeverity.INTERNAL).rawMessage(message);
    }

    private void internalSchedule(SJobDescriptor jobDescriptor, Trigger trigger) throws SSchedulerException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "internalSchedule");
        long tenantId = this.getTenantId();
        SSchedulerQueriableLogBuilder schedulingLogBuilder = this.getLogBuilder(ActionType.SCHEDULED, "Scheduled job with name " + jobDescriptor.getJobName(), jobDescriptor.getJobName());
        try {
            if (trigger == null) {
                this.schedulerExecutor.executeNow(jobDescriptor.getId(), tenantId, jobDescriptor.getJobName(), jobDescriptor.disallowConcurrentExecution());
            } else {
                this.schedulerExecutor.schedule(jobDescriptor.getId(), tenantId, jobDescriptor.getJobName(), trigger, jobDescriptor.disallowConcurrentExecution());
            }
            schedulingLogBuilder.actionStatus(1);
        }
        catch (Throwable e) {
            schedulingLogBuilder.actionStatus(0);
            this.logger.log(this.getClass(), TechnicalLogSeverity.ERROR, e);
            try {
                this.eventService.fireEvent(this.jobFailed);
            }
            catch (FireEventException e1) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.ERROR, e1);
            }
            throw new SSchedulerException(e);
        }
        this.logAfterMethod(TechnicalLogSeverity.TRACE, "internalSchedule");
    }

    @Override
    public boolean isStarted() throws SSchedulerException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "isStarted");
        boolean isStarted = this.schedulerExecutor.isStarted();
        this.logAfterMethod(TechnicalLogSeverity.TRACE, "isStarted");
        return isStarted;
    }

    @Override
    public boolean isStillScheduled(SJobDescriptor jobDescriptor) throws SSchedulerException {
        return this.schedulerExecutor.isStillScheduled(this.getTenantId(), jobDescriptor.getJobName());
    }

    @Override
    public boolean isStopped() throws SSchedulerException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "isShutdown");
        boolean isShutdown = this.schedulerExecutor.isShutdown();
        this.logAfterMethod(TechnicalLogSeverity.TRACE, "isShutdown");
        return isShutdown;
    }

    private void logAfterMethod(TechnicalLogSeverity technicalLogSeverity, String methodName) {
        if (this.logger.isLoggable(this.getClass(), technicalLogSeverity)) {
            this.logger.log(this.getClass(), technicalLogSeverity, LogUtil.getLogAfterMethod(this.getClass(), methodName));
        }
    }

    private void logBeforeMethod(TechnicalLogSeverity technicalLogSeverity, String methodName) {
        if (this.logger.isLoggable(this.getClass(), technicalLogSeverity)) {
            this.logger.log(this.getClass(), technicalLogSeverity, LogUtil.getLogBeforeMethod(this.getClass(), methodName));
        }
    }

    private void logOnExceptionMethod(TechnicalLogSeverity technicalLogSeverity, String methodName, Exception e) {
        if (this.logger.isLoggable(this.getClass(), technicalLogSeverity)) {
            this.logger.log(this.getClass(), technicalLogSeverity, LogUtil.getLogOnExceptionMethod(this.getClass(), methodName, e));
        }
    }

    @Override
    public void rescheduleErroneousTriggers() throws SSchedulerException {
        this.schedulerExecutor.rescheduleErroneousTriggers();
    }

    @Override
    public void schedule(SJobDescriptor jobDescriptor, List<SJobParameter> parameters, Trigger trigger) throws SSchedulerException {
        if (trigger == null) {
            throw new SSchedulerException("The trigger is null");
        }
        SJobDescriptor createdJobDescriptor = this.createJobDescriptor(jobDescriptor, parameters);
        this.internalSchedule(createdJobDescriptor, trigger);
    }

    @Override
    public void schedule(SJobDescriptor jobDescriptor, Trigger trigger) throws SSchedulerException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "schedule");
        SJobDescriptor createdJobDescriptor = this.createJobDescriptor(jobDescriptor, Collections.<SJobParameter>emptyList());
        this.internalSchedule(createdJobDescriptor, trigger);
        this.logAfterMethod(TechnicalLogSeverity.TRACE, "schedule");
    }

    @Override
    public void start() throws SSchedulerException, FireEventException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "start");
        this.schedulerExecutor.start();
        this.eventService.fireEvent(this.schedulStarted);
        this.logAfterMethod(TechnicalLogSeverity.TRACE, "start");
    }

    @Override
    public void stop() throws SSchedulerException, FireEventException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "shutdown");
        this.schedulerExecutor.shutdown();
        this.eventService.fireEvent(this.schedulStopped);
        this.logAfterMethod(TechnicalLogSeverity.TRACE, "shutdown");
    }

    private <T extends HasCRUDEAction> void updateLog(ActionType actionType, T logBuilder) {
        logBuilder.setActionType(actionType);
    }
}

