/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.theme.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.LogUtil;
import org.bonitasoft.engine.commons.NullCheckingUtil;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.events.EventActionType;
import org.bonitasoft.engine.events.EventService;
import org.bonitasoft.engine.events.model.SDeleteEvent;
import org.bonitasoft.engine.events.model.SInsertEvent;
import org.bonitasoft.engine.events.model.SUpdateEvent;
import org.bonitasoft.engine.events.model.builders.SEventBuilderFactory;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.ReadPersistenceService;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SBonitaSearchException;
import org.bonitasoft.engine.persistence.SelectByIdDescriptor;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLog;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLogSeverity;
import org.bonitasoft.engine.queriablelogger.model.builder.ActionType;
import org.bonitasoft.engine.queriablelogger.model.builder.HasCRUDEAction;
import org.bonitasoft.engine.queriablelogger.model.builder.SLogBuilder;
import org.bonitasoft.engine.queriablelogger.model.builder.SPersistenceLogBuilder;
import org.bonitasoft.engine.recorder.Recorder;
import org.bonitasoft.engine.recorder.SRecorderException;
import org.bonitasoft.engine.recorder.model.DeleteAllRecord;
import org.bonitasoft.engine.recorder.model.DeleteRecord;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.recorder.model.InsertRecord;
import org.bonitasoft.engine.recorder.model.UpdateRecord;
import org.bonitasoft.engine.services.QueriableLoggerService;
import org.bonitasoft.engine.theme.ThemeService;
import org.bonitasoft.engine.theme.builder.SThemeBuilderFactory;
import org.bonitasoft.engine.theme.builder.impl.SThemeLogBuilderImpl;
import org.bonitasoft.engine.theme.exception.SRestoreThemeException;
import org.bonitasoft.engine.theme.exception.SThemeCreationException;
import org.bonitasoft.engine.theme.exception.SThemeDeletionException;
import org.bonitasoft.engine.theme.exception.SThemeNotFoundException;
import org.bonitasoft.engine.theme.exception.SThemeReadException;
import org.bonitasoft.engine.theme.exception.SThemeUpdateException;
import org.bonitasoft.engine.theme.model.STheme;
import org.bonitasoft.engine.theme.model.SThemeType;
import org.bonitasoft.engine.theme.persistence.SelectDescriptorBuilder;

public class ThemeServiceImpl
implements ThemeService {
    private final ReadPersistenceService persistenceService;
    private final Recorder recorder;
    private final EventService eventService;
    private final TechnicalLoggerService logger;
    private final QueriableLoggerService queriableLoggerService;

    public ThemeServiceImpl(ReadPersistenceService persistenceService, Recorder recorder, EventService eventService, TechnicalLoggerService logger, QueriableLoggerService queriableLoggerService) {
        this.persistenceService = persistenceService;
        this.recorder = recorder;
        this.eventService = eventService;
        this.logger = logger;
        this.queriableLoggerService = queriableLoggerService;
    }

    @Override
    public STheme createTheme(STheme theme) throws SThemeCreationException {
        this.logBeforeMethod("createTheme");
        SThemeLogBuilderImpl logBuilder = this.getSThemeLog(ActionType.CREATED, "Adding a new theme");
        InsertRecord insertRecord = new InsertRecord(theme);
        SInsertEvent insertEvent = null;
        if (this.eventService.hasHandlers("THEME", EventActionType.CREATED)) {
            insertEvent = (SInsertEvent)BuilderFactory.get(SEventBuilderFactory.class).createInsertEvent("THEME").setObject(theme).done();
        }
        try {
            this.recorder.recordInsert(insertRecord, insertEvent);
            this.initiateLogBuilder(theme.getId(), 1, logBuilder, "createTheme");
            this.logAfterMethod("createTheme");
            return theme;
        }
        catch (SRecorderException re) {
            this.logOnExceptionMethod("createTheme", re);
            this.initiateLogBuilder(theme.getId(), 0, logBuilder, "createTheme");
            throw new SThemeCreationException(re);
        }
    }

    @Override
    public void deleteTheme(long id) throws SThemeNotFoundException, SThemeDeletionException {
        STheme theme;
        this.logBeforeMethod("deleteTheme");
        try {
            theme = this.getTheme(id);
        }
        catch (SThemeReadException e) {
            throw new SThemeDeletionException(e);
        }
        this.deleteTheme(theme);
        this.logAfterMethod("deleteTheme");
    }

    @Override
    public void deleteTheme(STheme theme) throws SThemeDeletionException {
        this.logBeforeMethod("deleteTheme");
        SThemeLogBuilderImpl logBuilder = this.getSThemeLog(ActionType.DELETED, "Deleting theme");
        DeleteRecord deleteRecord = new DeleteRecord(theme);
        SDeleteEvent deleteEvent = null;
        if (this.eventService.hasHandlers("THEME", EventActionType.DELETED)) {
            deleteEvent = (SDeleteEvent)BuilderFactory.get(SEventBuilderFactory.class).createDeleteEvent("THEME").setObject(theme).done();
        }
        try {
            this.recorder.recordDelete(deleteRecord, deleteEvent);
            this.initiateLogBuilder(theme.getId(), 1, logBuilder, "deleteTheme");
            this.logAfterMethod("deleteTheme");
        }
        catch (SRecorderException re) {
            this.logOnExceptionMethod("deleteTheme", re);
            this.initiateLogBuilder(theme.getId(), 0, logBuilder, "deleteTheme");
            throw new SThemeDeletionException(re);
        }
    }

    @Override
    public void restoreDefaultTheme(SThemeType type) throws SRestoreThemeException {
        try {
            FilterOption defaultFilter = new FilterOption(STheme.class, "isDefault", false);
            FilterOption typeFilter = new FilterOption(STheme.class, "type", type.name());
            ArrayList<FilterOption> filterOptions = new ArrayList<FilterOption>();
            filterOptions.add(defaultFilter);
            filterOptions.add(typeFilter);
            DeleteAllRecord record = new DeleteAllRecord(STheme.class, filterOptions);
            this.recorder.recordDeleteAll(record);
        }
        catch (SRecorderException e) {
            throw new SRestoreThemeException("Can't delete custom themes for type = " + (Object)((Object)type), e);
        }
    }

    @Override
    public STheme getTheme(SThemeType type, boolean isDefault) throws SThemeNotFoundException, SThemeReadException {
        SelectOneDescriptor<STheme> selectDescriptor = SelectDescriptorBuilder.getTheme(type, isDefault);
        try {
            STheme theme = this.persistenceService.selectOne(selectDescriptor);
            if (theme == null) {
                throw new SThemeNotFoundException("No theme exists with type = " + (Object)((Object)type) + ", and isDefault = " + isDefault);
            }
            return theme;
        }
        catch (SBonitaReadException e) {
            throw new SThemeReadException(e);
        }
    }

    @Override
    public STheme getTheme(long id) throws SThemeNotFoundException, SThemeReadException {
        this.logBeforeMethod("getTheme");
        try {
            SelectByIdDescriptor<STheme> descriptor = SelectDescriptorBuilder.getElementById(STheme.class, "Theme", id);
            STheme theme = this.persistenceService.selectById(descriptor);
            if (theme == null) {
                throw new SThemeNotFoundException("No theme exists with id : " + id);
            }
            this.logAfterMethod("getTheme");
            return theme;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getTheme", e);
            throw new SThemeReadException(e);
        }
    }

    @Override
    public STheme getLastModifiedTheme(SThemeType type) throws SThemeNotFoundException, SThemeReadException {
        SelectOneDescriptor<STheme> selectDescriptor = SelectDescriptorBuilder.getLastModifiedTheme(type);
        try {
            STheme theme = this.persistenceService.selectOne(selectDescriptor);
            if (theme == null) {
                throw new SThemeNotFoundException("No theme exists with type = " + (Object)((Object)type));
            }
            return theme;
        }
        catch (SBonitaReadException e) {
            throw new SThemeReadException(e);
        }
    }

    @Override
    public STheme updateTheme(STheme sTheme, EntityUpdateDescriptor descriptor) throws SThemeUpdateException {
        this.logBeforeMethod("updateTheme");
        NullCheckingUtil.checkArgsNotNull(sTheme);
        SThemeLogBuilderImpl logBuilder = this.getSThemeLog(ActionType.UPDATED, "Updating theme");
        STheme oldUser = BuilderFactory.get(SThemeBuilderFactory.class).createNewInstance(sTheme).done();
        UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)sTheme, descriptor);
        SUpdateEvent updateEvent = null;
        if (this.eventService.hasHandlers("THEME", EventActionType.UPDATED)) {
            updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent("THEME").setObject(sTheme).done();
            updateEvent.setOldObject(oldUser);
        }
        try {
            this.recorder.recordUpdate(updateRecord, updateEvent);
            this.initiateLogBuilder(sTheme.getId(), 1, logBuilder, "updateTheme");
            this.logAfterMethod("updateTheme");
        }
        catch (SRecorderException re) {
            this.logOnExceptionMethod("updateTheme", re);
            this.initiateLogBuilder(sTheme.getId(), 0, logBuilder, "updateTheme");
            throw new SThemeUpdateException(re);
        }
        return sTheme;
    }

    @Override
    public long getNumberOfThemes(QueryOptions queryOptions) throws SBonitaSearchException {
        try {
            Map<String, Object> parameters = Collections.emptyMap();
            return this.persistenceService.getNumberOfEntities(STheme.class, queryOptions, parameters);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaSearchException(e);
        }
    }

    @Override
    public List<STheme> searchThemes(QueryOptions queryOptions) throws SBonitaSearchException {
        try {
            Map<String, Object> parameters = Collections.emptyMap();
            return this.persistenceService.searchEntity(STheme.class, queryOptions, parameters);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaSearchException(e);
        }
    }

    private void logBeforeMethod(String methodName) {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), methodName));
        }
    }

    private void logAfterMethod(String methodName) {
        Class<?> thisClass = this.getClass();
        if (this.logger.isLoggable(thisClass, TechnicalLogSeverity.TRACE)) {
            this.logger.log(thisClass, TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(thisClass, methodName));
        }
    }

    private void logOnExceptionMethod(String methodName, SBonitaException e) {
        Class<?> thisClass = this.getClass();
        if (this.logger.isLoggable(thisClass, TechnicalLogSeverity.TRACE)) {
            this.logger.log(thisClass, TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(thisClass, methodName, e));
        }
    }

    private SThemeLogBuilderImpl getSThemeLog(ActionType actionType, String message) {
        SThemeLogBuilderImpl logBuilder = new SThemeLogBuilderImpl();
        this.initializeLogBuilder(logBuilder, message);
        this.updateLog(actionType, logBuilder);
        return logBuilder;
    }

    private void initiateLogBuilder(long objectId, int sQueriableLogStatus, SPersistenceLogBuilder logBuilder, String callerMethodName) {
        logBuilder.actionScope(String.valueOf(objectId));
        logBuilder.actionStatus(sQueriableLogStatus);
        logBuilder.objectId(objectId);
        SQueriableLog log = logBuilder.done();
        if (this.queriableLoggerService.isLoggable(log.getActionType(), log.getSeverity())) {
            this.queriableLoggerService.log(this.getClass().getName(), callerMethodName, log);
        }
    }

    private <T extends SLogBuilder> void initializeLogBuilder(T logBuilder, String message) {
        logBuilder.actionStatus(0).severity(SQueriableLogSeverity.INTERNAL).rawMessage(message);
    }

    private <T extends HasCRUDEAction> void updateLog(ActionType actionType, T logBuilder) {
        logBuilder.setActionType(actionType);
    }
}

