/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.work;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class WorkerThreadFactory
implements ThreadFactory {
    private final AtomicInteger nbThread = new AtomicInteger(1);
    private final String name;
    private final int padding;

    public WorkerThreadFactory(String name, int maximumPoolSize) {
        this.name = name;
        this.padding = WorkerThreadFactory.guessPadding(maximumPoolSize);
    }

    static int guessPadding(int maximumPoolSize) {
        int tmpPadding = 0;
        int poolSize = maximumPoolSize;
        while (poolSize > 0) {
            poolSize /= 10;
            ++tmpPadding;
        }
        return tmpPadding;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        return new Thread(runnable, String.format(this.name + "-" + "%0" + this.padding + "d", this.nbThread.getAndIncrement()));
    }
}

