/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.actor;

import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.engine.actor.mapping.ActorMappingService;
import org.bonitasoft.engine.actor.mapping.model.SActor;
import org.bonitasoft.engine.actor.mapping.model.SActorMember;
import org.bonitasoft.engine.bpm.process.Problem;
import org.bonitasoft.engine.bpm.process.impl.internal.ProblemImpl;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;

public class CheckActorMappingList
implements TransactionContent {
    private final ActorMappingService actorMappingService;
    private final long processDefinitionId;
    private List<Problem> problems;

    public CheckActorMappingList(ActorMappingService actorMappingService, long processDefinitionId) {
        this.actorMappingService = actorMappingService;
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public void execute() throws SBonitaException {
        List<SActor> actors = this.actorMappingService.getActors(this.processDefinitionId);
        this.problems = new ArrayList<Problem>();
        for (SActor sActor : actors) {
            List<SActorMember> actorMembers = this.actorMappingService.getActorMembers(sActor.getId(), 0, 1);
            if (!actorMembers.isEmpty()) continue;
            ProblemImpl problem = new ProblemImpl(Problem.Level.ERROR, sActor.getId(), "actor", "Actor '" + sActor.getName() + "' does not contain any members");
            this.problems.add((Problem)problem);
        }
    }

    public List<Problem> getProblems() {
        return this.problems;
    }
}

