/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.instance.event.impl;

import java.util.Collections;
import java.util.List;
import org.bonitasoft.engine.archive.ArchiveService;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.core.process.instance.api.event.EventInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeReadException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.SEventInstanceCreationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.SEventInstanceNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.SEventInstanceReadException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SEventTriggerInstanceCreationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SEventTriggerInstanceDeletionException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SEventTriggerInstanceNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SEventTriggerInstanceReadException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SMessageInstanceCreationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SMessageInstanceNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SMessageInstanceReadException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SMessageModificationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SWaitingEventCreationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SWaitingEventModificationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SWaitingEventNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SWaitingEventReadException;
import org.bonitasoft.engine.core.process.instance.impl.FlowNodeInstancesServiceImpl;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.builder.event.handling.SMessageInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.event.handling.SWaitingMessageEventBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.event.SBoundaryEventInstance;
import org.bonitasoft.engine.core.process.instance.model.event.SEventInstance;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SMessageEventCouple;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SMessageInstance;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SWaitingErrorEvent;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SWaitingEvent;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SWaitingMessageEvent;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SWaitingSignalEvent;
import org.bonitasoft.engine.core.process.instance.model.event.trigger.SEventTriggerInstance;
import org.bonitasoft.engine.core.process.instance.recorder.SelectDescriptorBuilder;
import org.bonitasoft.engine.events.EventActionType;
import org.bonitasoft.engine.events.EventService;
import org.bonitasoft.engine.events.model.SDeleteEvent;
import org.bonitasoft.engine.events.model.SInsertEvent;
import org.bonitasoft.engine.events.model.SUpdateEvent;
import org.bonitasoft.engine.events.model.builders.SEventBuilderFactory;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SBonitaSearchException;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.recorder.Recorder;
import org.bonitasoft.engine.recorder.SRecorderException;
import org.bonitasoft.engine.recorder.model.DeleteRecord;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.recorder.model.InsertRecord;
import org.bonitasoft.engine.recorder.model.UpdateRecord;
import org.bonitasoft.engine.services.PersistenceService;
import org.bonitasoft.engine.services.SPersistenceException;

public class SEventInstanceServiceImpl
extends FlowNodeInstancesServiceImpl
implements EventInstanceService {
    private static final String QUERY_RESET_PROGRESS_MESSAGE_INSTANCES = "resetProgressMessageInstances";
    public static final String QUERY_RESET_IN_PROGRESS_WAITING_EVENTS = "resetInProgressWaitingEvents";
    private final EventService eventService;

    public SEventInstanceServiceImpl(Recorder recorder, PersistenceService persistenceService, EventService eventService, TechnicalLoggerService logger, ArchiveService archiveService) {
        super(recorder, persistenceService, eventService, logger, archiveService);
        this.eventService = eventService;
    }

    @Override
    public void createEventInstance(SEventInstance eventInstance) throws SEventInstanceCreationException {
        try {
            InsertRecord insertRecord = new InsertRecord(eventInstance);
            SInsertEvent insertEvent = null;
            if (this.eventService.hasHandlers("EVENT_INSTANCE", EventActionType.CREATED)) {
                insertEvent = (SInsertEvent)BuilderFactory.get(SEventBuilderFactory.class).createInsertEvent("EVENT_INSTANCE").setObject(eventInstance).done();
            }
            this.getRecorder().recordInsert(insertRecord, insertEvent);
        }
        catch (SRecorderException e) {
            throw new SEventInstanceCreationException(e);
        }
        if (this.getLogger().isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
            StringBuilder stb = new StringBuilder();
            stb.append("Created ");
            stb.append(eventInstance.getType().getValue());
            stb.append(" <");
            stb.append(eventInstance.getName());
            stb.append("> with id = <");
            stb.append(eventInstance.getId());
            stb.append(">, parent process instance id = <");
            stb.append(eventInstance.getParentProcessInstanceId());
            stb.append(">, root process instance id = <");
            stb.append(eventInstance.getRootProcessInstanceId());
            stb.append(">, process definition id = <");
            stb.append(eventInstance.getProcessDefinitionId());
            stb.append(">");
            String message = stb.toString();
            this.getLogger().log(this.getClass(), TechnicalLogSeverity.DEBUG, message);
        }
    }

    @Override
    public void createEventTriggerInstance(SEventTriggerInstance eventTriggerInstance) throws SEventTriggerInstanceCreationException {
        try {
            InsertRecord insertRecord = new InsertRecord(eventTriggerInstance);
            SInsertEvent insertEvent = null;
            if (this.eventService.hasHandlers("EVENT_TRIGGER_INSTANCE", EventActionType.CREATED)) {
                insertEvent = (SInsertEvent)BuilderFactory.get(SEventBuilderFactory.class).createInsertEvent("EVENT_TRIGGER_INSTANCE").setObject(eventTriggerInstance).done();
            }
            this.getRecorder().recordInsert(insertRecord, insertEvent);
        }
        catch (SRecorderException e) {
            throw new SEventTriggerInstanceCreationException(e);
        }
    }

    @Override
    public void createMessageInstance(SMessageInstance messageInstance) throws SMessageInstanceCreationException {
        try {
            InsertRecord insertRecord = new InsertRecord(messageInstance);
            SInsertEvent insertEvent = null;
            if (this.eventService.hasHandlers("MESSAGE_INSTANCE", EventActionType.CREATED)) {
                insertEvent = (SInsertEvent)BuilderFactory.get(SEventBuilderFactory.class).createInsertEvent("MESSAGE_INSTANCE").setObject(messageInstance).done();
            }
            this.getRecorder().recordInsert(insertRecord, insertEvent);
        }
        catch (SRecorderException e) {
            throw new SMessageInstanceCreationException(e);
        }
    }

    @Override
    public void createWaitingEvent(SWaitingEvent waitingEvent) throws SWaitingEventCreationException {
        try {
            InsertRecord insertRecord = new InsertRecord(waitingEvent);
            SInsertEvent insertEvent = null;
            if (this.eventService.hasHandlers("EVENT_TRIGGER_INSTANCE", EventActionType.CREATED)) {
                insertEvent = (SInsertEvent)BuilderFactory.get(SEventBuilderFactory.class).createInsertEvent("EVENT_TRIGGER_INSTANCE").setObject(waitingEvent).done();
            }
            this.getRecorder().recordInsert(insertRecord, insertEvent);
        }
        catch (SRecorderException e) {
            throw new SWaitingEventCreationException(e);
        }
    }

    @Override
    public void deleteEventTriggerInstance(SEventTriggerInstance eventTriggerInstance) throws SEventTriggerInstanceDeletionException {
        try {
            DeleteRecord deleteRecord = new DeleteRecord(eventTriggerInstance);
            SDeleteEvent deleteEvent = null;
            if (this.eventService.hasHandlers("EVENT_TRIGGER_INSTANCE", EventActionType.DELETED)) {
                deleteEvent = (SDeleteEvent)BuilderFactory.get(SEventBuilderFactory.class).createDeleteEvent("EVENT_TRIGGER_INSTANCE").setObject(eventTriggerInstance).done();
            }
            this.getRecorder().recordDelete(deleteRecord, deleteEvent);
        }
        catch (SRecorderException e) {
            throw new SEventTriggerInstanceDeletionException(e);
        }
    }

    @Override
    public void deleteEventTriggerInstances(long eventInstanceId) throws SEventTriggerInstanceReadException, SEventTriggerInstanceDeletionException {
        List<SEventTriggerInstance> triggerInstances = this.getEventTriggerInstances(eventInstanceId);
        for (SEventTriggerInstance eventTriggerInstance : triggerInstances) {
            this.deleteEventTriggerInstance(eventTriggerInstance);
        }
    }

    @Override
    public void deleteMessageInstance(SMessageInstance messageInstance) throws SMessageModificationException {
        try {
            SDeleteEvent deleteEvent = null;
            if (this.eventService.hasHandlers("MESSAGE_INSTANCE", EventActionType.DELETED)) {
                deleteEvent = (SDeleteEvent)BuilderFactory.get(SEventBuilderFactory.class).createDeleteEvent("MESSAGE_INSTANCE").setObject(messageInstance).done();
            }
            this.getRecorder().recordDelete(new DeleteRecord(messageInstance), deleteEvent);
        }
        catch (SRecorderException e) {
            throw new SMessageModificationException(e);
        }
    }

    @Override
    public void deleteWaitingEvent(SWaitingEvent waitingEvent) throws SWaitingEventModificationException {
        try {
            SDeleteEvent deleteEvent = null;
            if (this.eventService.hasHandlers("EVENT_TRIGGER_INSTANCE", EventActionType.DELETED)) {
                deleteEvent = (SDeleteEvent)BuilderFactory.get(SEventBuilderFactory.class).createDeleteEvent("EVENT_TRIGGER_INSTANCE").setObject(waitingEvent).done();
            }
            DeleteRecord deleteRecord = new DeleteRecord(waitingEvent);
            this.getRecorder().recordDelete(deleteRecord, deleteEvent);
        }
        catch (SRecorderException e) {
            throw new SWaitingEventModificationException(e);
        }
    }

    @Override
    public void deleteWaitingEvents(SFlowNodeInstance flowNodeInstance) throws SWaitingEventModificationException, SFlowNodeReadException {
        OrderByOption orderByOption = new OrderByOption(SWaitingEvent.class, BuilderFactory.get(SWaitingMessageEventBuilderFactory.class).getFlowNodeNameKey(), OrderByType.ASC);
        FilterOption filterOption = new FilterOption(SWaitingEvent.class, BuilderFactory.get(SWaitingMessageEventBuilderFactory.class).getFlowNodeInstanceIdKey(), flowNodeInstance.getId());
        List<FilterOption> filters = Collections.singletonList(filterOption);
        try {
            QueryOptions queryOptions = new QueryOptions(0, 10, Collections.singletonList(orderByOption), filters, null);
            List<SWaitingEvent> waitingEvents = this.searchWaitingEvents(SWaitingEvent.class, queryOptions);
            do {
                for (SWaitingEvent sWaitingEvent : waitingEvents) {
                    this.deleteWaitingEvent(sWaitingEvent);
                }
            } while ((waitingEvents = this.searchWaitingEvents(SWaitingEvent.class, queryOptions = new QueryOptions(0, 10, Collections.singletonList(orderByOption), filters, null))).size() > 0);
        }
        catch (SBonitaSearchException e) {
            throw new SFlowNodeReadException(e);
        }
    }

    @Override
    public List<SBoundaryEventInstance> getActivityBoundaryEventInstances(long activityInstanceId) throws SEventInstanceReadException {
        SelectListDescriptor<SBoundaryEventInstance> selectDescriptor = SelectDescriptorBuilder.getActivityBoundaryEvents(activityInstanceId);
        try {
            return this.getPersistenceService().selectList(selectDescriptor);
        }
        catch (SBonitaReadException e) {
            throw new SEventInstanceReadException(e);
        }
    }

    @Override
    public SWaitingErrorEvent getBoundaryWaitingErrorEvent(long relatedActivityInstanceId, String errorCode) throws SWaitingEventReadException {
        SWaitingErrorEvent waitingError;
        block3: {
            SelectListDescriptor<SWaitingErrorEvent> selectDescriptor = errorCode == null ? SelectDescriptorBuilder.getCaughtError(relatedActivityInstanceId) : SelectDescriptorBuilder.getCaughtError(relatedActivityInstanceId, errorCode);
            waitingError = null;
            try {
                List<SWaitingErrorEvent> selectList = this.getPersistenceService().selectList(selectDescriptor);
                if (selectList == null || selectList.isEmpty()) break block3;
                if (selectList.size() == 1) {
                    waitingError = selectList.get(0);
                    break block3;
                }
                StringBuilder stb = new StringBuilder();
                stb.append("Only one catch error event was expected to handle the error code ");
                stb.append(errorCode);
                stb.append(" in the activity instance with id ");
                stb.append(relatedActivityInstanceId);
                stb.append(", but ");
                stb.append(selectList.size());
                stb.append(" was found.");
                throw new SWaitingEventReadException(stb.toString());
            }
            catch (SBonitaReadException e) {
                throw new SWaitingEventReadException(e);
            }
        }
        return waitingError;
    }

    @Override
    public SEventInstance getEventInstance(long eventInstanceId) throws SEventInstanceNotFoundException, SEventInstanceReadException {
        SEventInstance selectOne;
        try {
            selectOne = this.getPersistenceService().selectById(SelectDescriptorBuilder.getElementById(SEventInstance.class, "SEventInstance", eventInstanceId));
        }
        catch (SBonitaReadException e) {
            throw new SEventInstanceReadException(e);
        }
        if (selectOne == null) {
            throw new SEventInstanceNotFoundException(eventInstanceId);
        }
        return selectOne;
    }

    @Override
    public List<SEventInstance> getEventInstances(long rootContainerId, int fromIndex, int maxResults, String fieldName, OrderByType orderByType) throws SEventInstanceReadException {
        SelectListDescriptor<SEventInstance> selectDescriptor = SelectDescriptorBuilder.getEventsFromRootContainer(rootContainerId, fromIndex, maxResults, fieldName, orderByType);
        try {
            return this.getPersistenceService().selectList(selectDescriptor);
        }
        catch (SBonitaReadException e) {
            throw new SEventInstanceReadException(e);
        }
    }

    @Override
    public SEventTriggerInstance getEventTriggerInstance(long eventTriggerInstanceId) throws SEventTriggerInstanceNotFoundException, SEventTriggerInstanceReadException {
        SEventTriggerInstance selectOne;
        try {
            selectOne = this.getPersistenceService().selectById(SelectDescriptorBuilder.getElementById(SEventTriggerInstance.class, "EventTriggerInstance", eventTriggerInstanceId));
        }
        catch (SBonitaReadException e) {
            throw new SEventTriggerInstanceReadException(e);
        }
        if (selectOne == null) {
            throw new SEventTriggerInstanceNotFoundException(eventTriggerInstanceId);
        }
        return selectOne;
    }

    @Override
    public List<SEventTriggerInstance> getEventTriggerInstances(long eventInstanceId) throws SEventTriggerInstanceReadException {
        SelectListDescriptor<SEventTriggerInstance> selectDescriptor = SelectDescriptorBuilder.getEventTriggers(eventInstanceId);
        try {
            return this.getPersistenceService().selectList(selectDescriptor);
        }
        catch (SBonitaReadException e) {
            throw new SEventTriggerInstanceReadException(e);
        }
    }

    @Override
    public List<SEventTriggerInstance> getEventTriggerInstances(long eventInstanceId, int fromIndex, int maxResults, String fieldName, OrderByType orderByType) throws SEventTriggerInstanceReadException {
        SelectListDescriptor<SEventTriggerInstance> selectDescriptor = SelectDescriptorBuilder.getEventTriggers(eventInstanceId, fromIndex, maxResults, fieldName, orderByType);
        try {
            return this.getPersistenceService().selectList(selectDescriptor);
        }
        catch (SBonitaReadException e) {
            throw new SEventTriggerInstanceReadException(e);
        }
    }

    @Override
    public int resetProgressMessageInstances() throws SMessageModificationException {
        try {
            return this.getPersistenceService().update(QUERY_RESET_PROGRESS_MESSAGE_INSTANCES);
        }
        catch (SPersistenceException e) {
            throw new SMessageModificationException(e);
        }
    }

    @Override
    public int resetInProgressWaitingEvents() throws SWaitingEventModificationException {
        try {
            return this.getPersistenceService().update(QUERY_RESET_IN_PROGRESS_WAITING_EVENTS);
        }
        catch (SPersistenceException e) {
            throw new SWaitingEventModificationException(e);
        }
    }

    @Override
    public List<SMessageEventCouple> getMessageEventCouples() throws SEventTriggerInstanceReadException {
        SelectListDescriptor<SMessageEventCouple> selectDescriptor = SelectDescriptorBuilder.getMessageEventCouples();
        try {
            return this.getPersistenceService().selectList(selectDescriptor);
        }
        catch (SBonitaReadException e) {
            throw new SEventTriggerInstanceReadException(e);
        }
    }

    @Override
    public SMessageInstance getMessageInstance(long messageInstanceId) throws SMessageInstanceNotFoundException, SMessageInstanceReadException {
        SMessageInstance selectOne;
        try {
            selectOne = this.getPersistenceService().selectById(SelectDescriptorBuilder.getElementById(SMessageInstance.class, "MessageInstance", messageInstanceId));
        }
        catch (SBonitaReadException e) {
            throw new SMessageInstanceReadException(e);
        }
        if (selectOne == null) {
            throw new SMessageInstanceNotFoundException(messageInstanceId);
        }
        return selectOne;
    }

    @Override
    public long getNumberOfEventTriggerInstances(Class<? extends SEventTriggerInstance> entityClass, QueryOptions countOptions) throws SBonitaSearchException {
        try {
            return this.getPersistenceService().getNumberOfEntities(entityClass, countOptions, null);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaSearchException(e);
        }
    }

    @Override
    public long getNumberOfWaitingEvents(Class<? extends SWaitingEvent> entityClass, QueryOptions countOptions) throws SBonitaSearchException {
        try {
            return this.getPersistenceService().getNumberOfEntities(entityClass, countOptions, null);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaSearchException(e);
        }
    }

    @Override
    public List<SWaitingEvent> getStartWaitingEvents(long processDefinitionId) throws SEventTriggerInstanceReadException {
        SelectListDescriptor<SWaitingEvent> descriptor = SelectDescriptorBuilder.getStartWaitingEvents(processDefinitionId);
        try {
            return this.getPersistenceService().selectList(descriptor);
        }
        catch (SBonitaReadException e) {
            throw new SEventTriggerInstanceReadException(e);
        }
    }

    @Override
    public List<SMessageInstance> getThrownMessages(String messageName, String targetProcess, String targetFlowNode) throws SEventTriggerInstanceReadException {
        SelectListDescriptor<SMessageInstance> selectDescriptor = SelectDescriptorBuilder.getMessageInstancesByNameAndTarget(messageName, targetProcess, targetFlowNode);
        try {
            return this.getPersistenceService().selectList(selectDescriptor);
        }
        catch (SBonitaReadException e) {
            throw new SEventTriggerInstanceReadException(e);
        }
    }

    @Override
    public SWaitingEvent getWaitingEvent(Long waitingEvent) throws SWaitingEventNotFoundException, SWaitingEventReadException {
        SWaitingEvent selectOne;
        try {
            selectOne = this.getPersistenceService().selectById(SelectDescriptorBuilder.getElementById(SWaitingEvent.class, "WaitingEvent", waitingEvent));
        }
        catch (SBonitaReadException e) {
            throw new SWaitingEventReadException(e);
        }
        if (selectOne == null) {
            throw new SWaitingEventNotFoundException(waitingEvent);
        }
        return selectOne;
    }

    @Override
    public SWaitingMessageEvent getWaitingMessage(long waitingMessageId) throws SWaitingEventNotFoundException, SWaitingEventReadException {
        SWaitingMessageEvent selectOne;
        try {
            selectOne = this.getPersistenceService().selectById(SelectDescriptorBuilder.getElementById(SWaitingMessageEvent.class, "WaitingMessageEvent", waitingMessageId));
        }
        catch (SBonitaReadException e) {
            throw new SWaitingEventReadException(e);
        }
        if (selectOne == null) {
            throw new SWaitingEventNotFoundException(waitingMessageId);
        }
        return selectOne;
    }

    @Override
    public List<SWaitingMessageEvent> getWaitingMessages(String messageName, String processName, String flowNodeName) throws SEventTriggerInstanceReadException {
        SelectListDescriptor<SWaitingMessageEvent> selectDescriptor = SelectDescriptorBuilder.getCaughtMessages(messageName, processName, flowNodeName);
        try {
            return this.getPersistenceService().selectList(selectDescriptor);
        }
        catch (SBonitaReadException e) {
            throw new SEventTriggerInstanceReadException(e);
        }
    }

    @Override
    public List<SWaitingSignalEvent> getWaitingSignalEvents(String signalName) throws SEventTriggerInstanceReadException {
        SelectListDescriptor<SWaitingSignalEvent> descriptor = SelectDescriptorBuilder.getListeningSignals(signalName);
        try {
            return this.getPersistenceService().selectList(descriptor);
        }
        catch (SBonitaReadException e) {
            throw new SEventTriggerInstanceReadException(e);
        }
    }

    @Override
    public <T extends SEventTriggerInstance> List<T> searchEventTriggerInstances(Class<T> entityClass, QueryOptions searchOptions) throws SBonitaSearchException {
        try {
            return this.getPersistenceService().searchEntity(entityClass, searchOptions, null);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaSearchException(e);
        }
    }

    @Override
    public <T extends SWaitingEvent> List<T> searchWaitingEvents(Class<T> entityClass, QueryOptions searchOptions) throws SBonitaSearchException {
        try {
            return this.getPersistenceService().searchEntity(entityClass, searchOptions, null);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaSearchException(e);
        }
    }

    @Override
    public void updateMessageInstance(SMessageInstance messageInstance, EntityUpdateDescriptor descriptor) throws SMessageModificationException {
        try {
            SMessageInstance oldMessage = BuilderFactory.get(SMessageInstanceBuilderFactory.class).createNewInstance(messageInstance).done();
            UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)messageInstance, descriptor);
            SUpdateEvent updateEvent = null;
            if (this.eventService.hasHandlers("MESSAGE_INSTANCE", EventActionType.UPDATED)) {
                updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent("MESSAGE_INSTANCE").setObject(oldMessage).done();
                updateEvent.setOldObject(oldMessage);
            }
            this.getRecorder().recordUpdate(updateRecord, updateEvent);
        }
        catch (SRecorderException re) {
            throw new SMessageModificationException(re);
        }
    }

    @Override
    public void updateWaitingMessage(SWaitingMessageEvent waitingMessageEvent, EntityUpdateDescriptor descriptor) throws SWaitingEventModificationException {
        try {
            SWaitingMessageEvent oldWaitingMessage = BuilderFactory.get(SWaitingMessageEventBuilderFactory.class).createNewInstance(waitingMessageEvent).done();
            UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)waitingMessageEvent, descriptor);
            SUpdateEvent updateEvent = null;
            if (this.eventService.hasHandlers("MESSAGE_INSTANCE", EventActionType.UPDATED)) {
                updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent("MESSAGE_INSTANCE").setObject(waitingMessageEvent).done();
                updateEvent.setOldObject(oldWaitingMessage);
            }
            this.getRecorder().recordUpdate(updateRecord, updateEvent);
        }
        catch (SRecorderException e) {
            throw new SWaitingEventModificationException(e);
        }
    }
}

