/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.data.instance.model.archive.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import org.bonitasoft.engine.commons.exceptions.SBonitaRuntimeException;
import org.bonitasoft.engine.data.instance.model.SDataInstance;
import org.bonitasoft.engine.data.instance.model.archive.impl.SADataInstanceImpl;
import org.bonitasoft.engine.persistence.PersistentObject;

public final class SABlobDataInstanceImpl
extends SADataInstanceImpl {
    private static final long serialVersionUID = 2420374967139131312L;
    private byte[] value;

    public SABlobDataInstanceImpl() {
    }

    public SABlobDataInstanceImpl(SDataInstance sDataInstance) {
        super(sDataInstance);
        this.setValue(sDataInstance.getValue());
    }

    @Override
    public String getDiscriminator() {
        return SABlobDataInstanceImpl.class.getSimpleName();
    }

    @Override
    public Serializable getValue() {
        return this.revert(this.value);
    }

    @Override
    public void setValue(Serializable value) {
        this.value = this.convert(value);
    }

    @Override
    public Class<? extends PersistentObject> getPersistentObjectInterface() {
        return SDataInstance.class;
    }

    private byte[] convert(Serializable value) {
        ObjectOutputStream oos = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(value);
            oos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException ioe) {
            throw new SBonitaRuntimeException(ioe);
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (IOException ioe) {
                throw new SBonitaRuntimeException(ioe);
            }
        }
    }

    private Serializable revert(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ObjectInputStream ois = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ois = new ObjectInputStream(bais){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws ClassNotFoundException {
                    String className = desc.getName();
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    return Class.forName(className, true, classLoader);
                }
            };
            Serializable serializable = (Serializable)ois.readObject();
            return serializable;
        }
        catch (IOException ioe) {
            throw new SBonitaRuntimeException(ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new SBonitaRuntimeException(cnfe);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException ioe) {
                    throw new SBonitaRuntimeException(ioe);
                }
            }
        }
    }
}

