/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.archive;

import java.text.MessageFormat;
import java.util.List;
import org.bonitasoft.engine.SArchivingException;
import org.bonitasoft.engine.archive.ArchiveInsertRecord;
import org.bonitasoft.engine.archive.ArchiveService;
import org.bonitasoft.engine.archive.SDefinitiveArchiveNotFound;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.connector.ConnectorInstanceService;
import org.bonitasoft.engine.core.process.comment.api.SCommentService;
import org.bonitasoft.engine.core.process.comment.model.SComment;
import org.bonitasoft.engine.core.process.comment.model.archive.SAComment;
import org.bonitasoft.engine.core.process.comment.model.archive.builder.SACommentBuilderFactory;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.model.SActivityDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.document.mapping.DocumentMappingService;
import org.bonitasoft.engine.core.process.document.mapping.exception.SDocumentMappingException;
import org.bonitasoft.engine.core.process.document.mapping.exception.SPageOutOfRangeException;
import org.bonitasoft.engine.core.process.document.mapping.model.SDocumentMapping;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.core.process.instance.model.SActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SAutomaticTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SCallActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SConnectorInstance;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SGatewayInstance;
import org.bonitasoft.engine.core.process.instance.model.SLoopActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SManualTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SMultiInstanceActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.core.process.instance.model.SReceiveTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SSendTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SSubProcessActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SUserTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAProcessInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.builder.SAAutomaticTaskInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.archive.builder.SACallActivityInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.archive.builder.SAGatewayInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.archive.builder.SALoopActivityInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.archive.builder.SAManualTaskInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.archive.builder.SAMultiInstanceActivityInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.archive.builder.SAProcessInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.archive.builder.SAReceiveTaskInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.archive.builder.SASendTaskInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.archive.builder.SASubProcessActivityInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.archive.builder.SAUserTaskInstanceBuilderFactory;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.data.instance.api.DataInstanceService;
import org.bonitasoft.engine.data.instance.exception.SDataInstanceException;
import org.bonitasoft.engine.data.instance.model.SDataInstance;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.recorder.SRecorderException;

public class ProcessArchiver {
    private static final int BATCH_SIZE = 100;

    public static void archiveProcessInstance(SProcessInstance processInstance, ArchiveService archiveService, ProcessInstanceService processInstanceService, DataInstanceService dataInstanceService, DocumentMappingService documentMappingService, TechnicalLoggerService logger, SCommentService commentService, ProcessDefinitionService processDefinitionService, ConnectorInstanceService connectorInstanceService) throws SArchivingException {
        SAProcessInstance saProcessInstance = BuilderFactory.get(SAProcessInstanceBuilderFactory.class).createNewInstance(processInstance).done();
        long archiveDate = saProcessInstance.getEndDate();
        try {
            dataInstanceService.removeContainer(processInstance.getId(), DataInstanceContainer.PROCESS_INSTANCE.toString());
        }
        catch (SDataInstanceException e) {
            throw new SArchivingException("Unable to delete data mapping.", e);
        }
        SProcessDefinition processDefinition = null;
        try {
            processDefinition = processDefinitionService.getProcessDefinition(processInstance.getProcessDefinitionId());
        }
        catch (SBonitaException e) {
            throw new SArchivingException(e);
        }
        if (!processDefinition.getProcessContainer().getDataDefinitions().isEmpty()) {
            ProcessArchiver.archiveDataInstances(processDefinition, processInstance, dataInstanceService, archiveDate);
        }
        ProcessArchiver.archiveComments(processDefinition, processInstance, archiveService, logger, commentService, archiveDate);
        ProcessArchiver.archiveDocumentMappings(processDefinition, processInstance, documentMappingService, archiveDate);
        if (!processDefinition.getProcessContainer().getConnectors().isEmpty()) {
            ProcessArchiver.archiveConnectors(connectorInstanceService, archiveDate, processInstance.getId(), "process");
        }
        ProcessArchiver.archiveProcessInstance(processDefinition, processInstance, saProcessInstance, archiveDate, archiveService, processInstanceService, logger);
    }

    private static void archiveConnectors(ConnectorInstanceService connectorInstanceService, long archiveDate, long containerId, String containerType) throws SArchivingException {
        try {
            List<SConnectorInstance> connectorInstances;
            int i = 0;
            do {
                connectorInstances = connectorInstanceService.getConnectorInstances(containerId, containerType, i, i + 100, null, null);
                i += 100;
                for (SConnectorInstance sConnectorInstance : connectorInstances) {
                    connectorInstanceService.archiveConnectorInstance(sConnectorInstance, archiveDate);
                }
            } while (connectorInstances.size() == 100);
        }
        catch (SBonitaException e) {
            throw new SArchivingException("Unable to archive the container instance with id " + containerId, e);
        }
    }

    private static void archiveProcessInstance(SProcessDefinition processDefinition, SProcessInstance processInstance, SAProcessInstance saProcessInstance, long archiveDate, ArchiveService archiveService, ProcessInstanceService processInstanceService, TechnicalLoggerService logger) throws SArchivingException {
        block6: {
            try {
                ArchiveInsertRecord insertRecord = new ArchiveInsertRecord(saProcessInstance);
                archiveService.recordInsert(archiveDate, insertRecord);
                if (logger.isLoggable(ProcessArchiver.class, TechnicalLogSeverity.DEBUG)) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("Archiving " + processInstance.getClass().getSimpleName());
                    builder.append("with id = <" + processInstance.getId() + ">");
                    logger.log(ProcessArchiver.class, TechnicalLogSeverity.DEBUG, MessageFormat.format(" and state {2}", processInstance.getStateId()));
                }
                try {
                    processInstanceService.deleteProcessInstance(processInstance.getId());
                }
                catch (SBonitaException e) {
                    throw new SArchivingException("Unable to delete the process instance during the archiving.", e);
                }
            }
            catch (SRecorderException e) {
                ProcessArchiver.setExceptionContext(processDefinition, processInstance, e);
                throw new SArchivingException("Unable to archive the process instance.", e);
            }
            catch (SDefinitiveArchiveNotFound e) {
                ProcessArchiver.setExceptionContext(processDefinition, processInstance, e);
                if (!logger.isLoggable(ProcessArchiver.class, TechnicalLogSeverity.ERROR)) break block6;
                logger.log(ProcessArchiver.class, TechnicalLogSeverity.ERROR, "The process instance was not archived.", e);
            }
        }
    }

    private static void archiveDocumentMappings(SProcessDefinition processDefinition, SProcessInstance processInstance, DocumentMappingService documentMappingService, long archiveDate) throws SArchivingException {
        try {
            List<SDocumentMapping> sDocumentMappings = null;
            do {
                sDocumentMappings = documentMappingService.getDocumentMappingsForProcessInstance(processInstance.getId(), 0, 100, null, null);
                for (SDocumentMapping sDocumentMapping : sDocumentMappings) {
                    documentMappingService.archive(sDocumentMapping, archiveDate);
                }
            } while (sDocumentMappings.size() == 100);
        }
        catch (SPageOutOfRangeException e) {
            ProcessArchiver.setExceptionContext(processDefinition, processInstance, e);
            throw new SArchivingException("Unable to archive the process instance.", e);
        }
        catch (SDocumentMappingException e) {
            ProcessArchiver.setExceptionContext(processDefinition, processInstance, e);
            throw new SArchivingException("Unable to archive the process instance.", e);
        }
    }

    private static void archiveComments(SProcessDefinition processDefinition, SProcessInstance processInstance, ArchiveService archiveService, TechnicalLoggerService logger, SCommentService commentService, long archiveDate) throws SArchivingException {
        List<SComment> sComments = null;
        int startIndex = 0;
        do {
            block5: {
                try {
                    sComments = commentService.getComments(processInstance.getId(), new QueryOptions(startIndex, 100));
                }
                catch (SBonitaReadException e) {
                    ProcessArchiver.setExceptionContext(processDefinition, processInstance, e);
                    if (!logger.isLoggable(ProcessArchiver.class, TechnicalLogSeverity.ERROR)) break block5;
                    logger.log(ProcessArchiver.class, TechnicalLogSeverity.ERROR, "No process comment found for the process instance.", e);
                }
            }
            if (sComments != null) {
                for (SComment sComment : sComments) {
                    ProcessArchiver.archiveComment(processDefinition, processInstance, archiveService, logger, archiveDate, sComment);
                }
            }
            startIndex += 100;
        } while (sComments != null && sComments.size() > 0);
    }

    private static void archiveComment(SProcessDefinition processDefinition, SProcessInstance processInstance, ArchiveService archiveService, TechnicalLoggerService logger, long archiveDate, SComment sComment) throws SArchivingException {
        block4: {
            SAComment saComment = BuilderFactory.get(SACommentBuilderFactory.class).createNewInstance(sComment).done();
            if (saComment != null) {
                ArchiveInsertRecord insertRecord = new ArchiveInsertRecord(saComment);
                try {
                    archiveService.recordInsert(archiveDate, insertRecord);
                }
                catch (SRecorderException e) {
                    ProcessArchiver.setExceptionContext(processDefinition, processInstance, e);
                    throw new SArchivingException("Unable to archive the process instance comments.", e);
                }
                catch (SDefinitiveArchiveNotFound e) {
                    ProcessArchiver.setExceptionContext(processDefinition, processInstance, e);
                    if (!logger.isLoggable(ProcessArchiver.class, TechnicalLogSeverity.ERROR)) break block4;
                    logger.log(ProcessArchiver.class, TechnicalLogSeverity.ERROR, "The process instance was not archived.", e);
                }
            }
        }
    }

    private static void setExceptionContext(SProcessDefinition processDefinition, SProcessInstance processInstance, SBonitaException e) {
        e.setProcessInstanceIdOnContext(processInstance.getId());
        e.setRootProcessInstanceIdOnContext(processInstance.getRootProcessInstanceId());
        e.setProcessDefinitionIdOnContext(processInstance.getProcessDefinitionId());
        e.setProcessDefinitionNameOnContext(processDefinition.getName());
        e.setProcessDefinitionVersionOnContext(processDefinition.getVersion());
    }

    private static void archiveDataInstances(SProcessDefinition processDefinition, SProcessInstance processInstance, DataInstanceService dataInstanceService, long archiveDate) throws SArchivingException {
        try {
            dataInstanceService.archiveLocalDataInstancesFromProcessInstance(processInstance.getId(), archiveDate);
        }
        catch (SDataInstanceException e) {
            ProcessArchiver.setExceptionContext(processDefinition, processInstance, e);
            throw new SArchivingException("Unable to archive the process instance.", e);
        }
    }

    private static void archiveFlowNodeInstance(SFlowNodeInstance flowNodeInstance, ArchiveService archiveService, long archiveDate) throws SArchivingException {
        try {
            SAFlowNodeInstance saFlowNodeInstance = null;
            switch (flowNodeInstance.getType()) {
                case AUTOMATIC_TASK: {
                    saFlowNodeInstance = BuilderFactory.get(SAAutomaticTaskInstanceBuilderFactory.class).createNewAutomaticTaskInstance((SAutomaticTaskInstance)flowNodeInstance).done();
                    break;
                }
                case GATEWAY: {
                    saFlowNodeInstance = BuilderFactory.get(SAGatewayInstanceBuilderFactory.class).createNewGatewayInstance((SGatewayInstance)flowNodeInstance).done();
                    break;
                }
                case MANUAL_TASK: {
                    saFlowNodeInstance = BuilderFactory.get(SAManualTaskInstanceBuilderFactory.class).createNewManualTaskInstance((SManualTaskInstance)flowNodeInstance).done();
                    break;
                }
                case USER_TASK: {
                    saFlowNodeInstance = BuilderFactory.get(SAUserTaskInstanceBuilderFactory.class).createNewUserTaskInstance((SUserTaskInstance)flowNodeInstance).done();
                    break;
                }
                case RECEIVE_TASK: {
                    saFlowNodeInstance = BuilderFactory.get(SAReceiveTaskInstanceBuilderFactory.class).createNewReceiveTaskInstance((SReceiveTaskInstance)flowNodeInstance).done();
                    break;
                }
                case SEND_TASK: {
                    saFlowNodeInstance = BuilderFactory.get(SASendTaskInstanceBuilderFactory.class).createNewSendTaskInstance((SSendTaskInstance)flowNodeInstance).done();
                    break;
                }
                case LOOP_ACTIVITY: {
                    saFlowNodeInstance = BuilderFactory.get(SALoopActivityInstanceBuilderFactory.class).createNewLoopActivityInstance((SLoopActivityInstance)flowNodeInstance).done();
                    break;
                }
                case CALL_ACTIVITY: {
                    saFlowNodeInstance = BuilderFactory.get(SACallActivityInstanceBuilderFactory.class).createNewArchivedCallActivityInstance((SCallActivityInstance)flowNodeInstance).done();
                    break;
                }
                case MULTI_INSTANCE_ACTIVITY: {
                    saFlowNodeInstance = BuilderFactory.get(SAMultiInstanceActivityInstanceBuilderFactory.class).createNewMultiInstanceActivityInstance((SMultiInstanceActivityInstance)flowNodeInstance).done();
                    break;
                }
                case SUB_PROCESS: {
                    saFlowNodeInstance = BuilderFactory.get(SASubProcessActivityInstanceBuilderFactory.class).createNewArchivedSubProcessActivityInstance((SSubProcessActivityInstance)flowNodeInstance).done();
                    break;
                }
                case END_EVENT: {
                    break;
                }
                case START_EVENT: {
                    break;
                }
                case BOUNDARY_EVENT: {
                    break;
                }
                case INTERMEDIATE_CATCH_EVENT: {
                    break;
                }
                case INTERMEDIATE_THROW_EVENT: {
                    break;
                }
            }
            if (saFlowNodeInstance != null) {
                ArchiveInsertRecord insertRecord = new ArchiveInsertRecord(saFlowNodeInstance);
                archiveService.recordInsert(archiveDate, insertRecord);
            }
        }
        catch (SBonitaException e) {
            throw new SArchivingException(e);
        }
    }

    private static void deleteLocalDataInstancesFromActivityInstance(SFlowNodeInstance flowNodeInstance, DataInstanceService dataInstanceService) throws SDataInstanceException {
        List<SDataInstance> dataInstances;
        do {
            dataInstances = dataInstanceService.getLocalDataInstances(flowNodeInstance.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.toString(), 0, 20);
            for (SDataInstance sDataInstance : dataInstances) {
                dataInstanceService.deleteDataInstance(sDataInstance);
            }
        } while (dataInstances != null && dataInstances.size() > 0);
    }

    public static void archiveFlowNodeInstance(SFlowNodeInstance intTxflowNodeInstance, boolean deleteAfterArchive, long processDefinitionId, ProcessInstanceService processInstanceService, ProcessDefinitionService processDefinitionService, ArchiveService archiveService, DataInstanceService dataInstanceService, ActivityInstanceService activityInstanceService, ConnectorInstanceService connectorInstanceService) throws SArchivingException {
        try {
            SProcessDefinition processDefinition = processDefinitionService.getProcessDefinition(processDefinitionId);
            long archiveDate = System.currentTimeMillis();
            if (deleteAfterArchive) {
                if (intTxflowNodeInstance instanceof SActivityInstance) {
                    SActivityDefinition activityDef = (SActivityDefinition)processDefinition.getProcessContainer().getFlowNode(intTxflowNodeInstance.getFlowNodeDefinitionId());
                    if (activityDef != null && !activityDef.getSDataDefinitions().isEmpty()) {
                        ProcessArchiver.deleteLocalDataInstancesFromActivityInstance(intTxflowNodeInstance, dataInstanceService);
                    }
                    if (activityDef != null && !activityDef.getConnectors().isEmpty()) {
                        ProcessArchiver.archiveConnectors(connectorInstanceService, archiveDate, intTxflowNodeInstance.getId(), "flowNode");
                    }
                }
                dataInstanceService.removeContainer(intTxflowNodeInstance.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.toString());
                ProcessArchiver.archiveFlowNodeInstance(intTxflowNodeInstance, archiveService, archiveDate);
                SFlowNodeInstance flowNodeInstance2 = activityInstanceService.getFlowNodeInstance(intTxflowNodeInstance.getId());
                processInstanceService.deleteFlowNodeInstance(flowNodeInstance2, processDefinition);
            } else {
                ProcessArchiver.archiveFlowNodeInstance(intTxflowNodeInstance, archiveService, archiveDate);
            }
        }
        catch (SArchivingException e) {
            throw e;
        }
        catch (SBonitaException e) {
            throw new SArchivingException(e);
        }
    }
}

