/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.work.failurewrapping;

import java.util.Map;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.execution.work.WrappingBonitaWork;
import org.bonitasoft.engine.execution.work.failurewrapping.TxInHandleFailureWrappingWork;
import org.bonitasoft.engine.service.TenantServiceAccessor;

public class ProcessInstanceContextWork
extends TxInHandleFailureWrappingWork {
    private static final long serialVersionUID = 6958842321501639910L;
    private long processInstanceId;
    private long rootProcessInstanceId;

    public ProcessInstanceContextWork(WrappingBonitaWork wrappedWork, long processInstanceId) {
        this(wrappedWork, processInstanceId, -1L);
    }

    public ProcessInstanceContextWork(WrappingBonitaWork wrappedWork, long processInstanceId, long rootProcessInstanceId) {
        super(wrappedWork);
        this.processInstanceId = processInstanceId;
        this.rootProcessInstanceId = rootProcessInstanceId;
    }

    protected void setProcessInstanceId(long id) {
        this.processInstanceId = id;
    }

    protected void setRootProcessInstanceId(long id) {
        this.rootProcessInstanceId = id;
    }

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName() + ": processInstanceId = " + this.processInstanceId;
    }

    @Override
    protected void setExceptionContext(SBonitaException sBonitaException, Map<String, Object> context) throws SBonitaException {
        if (this.rootProcessInstanceId < 0L) {
            TenantServiceAccessor tenantAccessor = this.getTenantAccessor(context);
            ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
            SProcessInstance sProcessInstance = processInstanceService.getProcessInstance(this.processInstanceId);
            this.rootProcessInstanceId = sProcessInstance.getRootProcessInstanceId();
        }
        sBonitaException.setProcessInstanceIdOnContext(this.processInstanceId);
        sBonitaException.setRootProcessInstanceIdOnContext(this.rootProcessInstanceId);
    }
}

