/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.external.permission;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.actor.mapping.ActorMappingService;
import org.bonitasoft.engine.actor.mapping.model.SActor;
import org.bonitasoft.engine.api.impl.transaction.process.GetArchivedProcessInstanceList;
import org.bonitasoft.engine.bpm.process.ArchivedProcessInstance;
import org.bonitasoft.engine.command.SCommandExecutionException;
import org.bonitasoft.engine.command.SCommandParameterizationException;
import org.bonitasoft.engine.command.TenantCommand;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.search.descriptor.SearchEntitiesDescriptor;
import org.bonitasoft.engine.search.impl.SearchOptionsImpl;
import org.bonitasoft.engine.search.process.SearchArchivedProcessInstancesInvolvingUser;
import org.bonitasoft.engine.search.process.SearchOpenProcessInstancesInvolvingUser;
import org.bonitasoft.engine.service.TenantServiceAccessor;

public class IsAllowedToSeeOverviewForm
extends TenantCommand {
    private TenantServiceAccessor tenantAccessor;
    private static final String USER_ID_KEY = "USER_ID_KEY";
    private static final String PROCESSINSTANCE_ID_KEY = "PROCESSINSTANCE_ID_KEY";

    @Override
    public Serializable execute(Map<String, Serializable> parameters, TenantServiceAccessor tenantAccessor) throws SCommandParameterizationException, SCommandExecutionException {
        SearchEntitiesDescriptor searchEntitiesDescriptor;
        ProcessDefinitionService processDefinitionService;
        ProcessInstanceService processInstanceService;
        long processDefinitionId;
        long processInstanceId;
        Long userId;
        boolean isHas;
        block22: {
            this.tenantAccessor = tenantAccessor;
            isHas = false;
            userId = (Long)parameters.get(USER_ID_KEY);
            if (userId == null || userId == 0L) {
                throw new SCommandParameterizationException("Mandatory parameter USER_ID_KEY is missing or not convertible to Long.");
            }
            processInstanceId = (Long)parameters.get(PROCESSINSTANCE_ID_KEY);
            if (processInstanceId == 0L) {
                throw new SCommandParameterizationException("Mandatory parameter PROCESSINSTANCE_ID_KEY is missing or not convertible to Long.");
            }
            processDefinitionId = 0L;
            processInstanceService = tenantAccessor.getProcessInstanceService();
            processDefinitionService = tenantAccessor.getProcessDefinitionService();
            searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
            try {
                SProcessInstance sProcessInstance = processInstanceService.getProcessInstance(processInstanceId);
                if (sProcessInstance != null) {
                    processDefinitionId = sProcessInstance.getProcessDefinitionId();
                }
            }
            catch (SBonitaException e) {
                GetArchivedProcessInstanceList getArchivedProcessInstanceList = new GetArchivedProcessInstanceList(processInstanceService, searchEntitiesDescriptor, processInstanceId, 0, 5);
                try {
                    getArchivedProcessInstanceList.execute();
                }
                catch (SCommandExecutionException e1) {
                    throw e1;
                }
                catch (SBonitaException e1) {
                    e.setProcessInstanceIdOnContext(processInstanceId);
                    throw new SCommandExecutionException("No process instance and archived process instance during executing command isAllowedToSeeOverviewForm.", e);
                }
                Object archivedPInstances = getArchivedProcessInstanceList.getResult();
                if (archivedPInstances.isEmpty()) break block22;
                processDefinitionId = ((ArchivedProcessInstance)archivedPInstances.get(0)).getProcessDefinitionId();
            }
        }
        if (processDefinitionId != 0L) {
            ActorMappingService actorMappingService = this.tenantAccessor.getActorMappingService();
            try {
                List<SActor> ckRes = actorMappingService.getActorsOfUserCanStartProcessDefinition(userId, processDefinitionId);
                if (ckRes != null && ckRes.size() == 1) {
                    isHas = true;
                }
            }
            catch (SBonitaException e) {
                e.setProcessDefinitionIdOnContext(processDefinitionId);
                throw new SCommandExecutionException("No actorInitiator of user who can start the processDefinition.", e);
            }
        }
        if (!isHas) {
            SearchOptionsImpl searchOptions = new SearchOptionsImpl(0, 10);
            searchOptions.addFilter("id", (Serializable)Long.valueOf(processInstanceId));
            SearchOpenProcessInstancesInvolvingUser searchOpenProcessInstances = new SearchOpenProcessInstancesInvolvingUser(processInstanceService, searchEntitiesDescriptor.getSearchProcessInstanceDescriptor(), userId, (SearchOptions)searchOptions, processDefinitionService);
            SearchResult processInstanceRes = null;
            try {
                searchOpenProcessInstances.execute();
                processInstanceRes = searchOpenProcessInstances.getResult();
            }
            catch (SCommandExecutionException e) {
                throw e;
            }
            catch (SBonitaException sbe) {
                throw new SCommandExecutionException("No processInstance that involves user :" + userId + " found durng executing method IsAllowedToSeeOverviewForm.", sbe);
            }
            if (processInstanceRes.getCount() > 0L) {
                isHas = true;
            } else {
                SearchArchivedProcessInstancesInvolvingUser archivedSearcher = new SearchArchivedProcessInstancesInvolvingUser(userId, processInstanceService, searchEntitiesDescriptor.getSearchArchivedProcessInstanceDescriptor(), (SearchOptions)searchOptions);
                try {
                    archivedSearcher.execute();
                }
                catch (SCommandExecutionException e) {
                    throw e;
                }
                catch (SBonitaException e) {
                    throw new SCommandExecutionException("No archived processInstance that involves user :" + userId + " found during execution of method IsAllowedToSeeOverviewForm.", e);
                }
                SearchResult archivedRes = archivedSearcher.getResult();
                if (archivedRes.getCount() > 0L) {
                    isHas = true;
                }
            }
        }
        return Boolean.valueOf(isHas);
    }
}

