/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.identity.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.CollectionUtil;
import org.bonitasoft.engine.commons.LogUtil;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.events.EventActionType;
import org.bonitasoft.engine.events.EventService;
import org.bonitasoft.engine.events.model.SDeleteEvent;
import org.bonitasoft.engine.events.model.SInsertEvent;
import org.bonitasoft.engine.events.model.SUpdateEvent;
import org.bonitasoft.engine.events.model.builders.SEventBuilderFactory;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.SCustomUserInfoDefinitionAlreadyExistsException;
import org.bonitasoft.engine.identity.SCustomUserInfoDefinitionCreationException;
import org.bonitasoft.engine.identity.SCustomUserInfoDefinitionNotFoundException;
import org.bonitasoft.engine.identity.SCustomUserInfoDefinitionReadException;
import org.bonitasoft.engine.identity.SCustomUserInfoValueNotFoundException;
import org.bonitasoft.engine.identity.SCustomUserInfoValueReadException;
import org.bonitasoft.engine.identity.SGroupCreationException;
import org.bonitasoft.engine.identity.SGroupDeletionException;
import org.bonitasoft.engine.identity.SGroupNotFoundException;
import org.bonitasoft.engine.identity.SIdentityException;
import org.bonitasoft.engine.identity.SMembershipDeletionException;
import org.bonitasoft.engine.identity.SRoleDeletionException;
import org.bonitasoft.engine.identity.SRoleNotFoundException;
import org.bonitasoft.engine.identity.SUserCreationException;
import org.bonitasoft.engine.identity.SUserDeletionException;
import org.bonitasoft.engine.identity.SUserMembershipCreationException;
import org.bonitasoft.engine.identity.SUserNotFoundException;
import org.bonitasoft.engine.identity.SUserUpdateException;
import org.bonitasoft.engine.identity.impl.CredentialsEncrypter;
import org.bonitasoft.engine.identity.model.SContactInfo;
import org.bonitasoft.engine.identity.model.SCustomUserInfoDefinition;
import org.bonitasoft.engine.identity.model.SCustomUserInfoValue;
import org.bonitasoft.engine.identity.model.SGroup;
import org.bonitasoft.engine.identity.model.SRole;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.identity.model.SUserMembership;
import org.bonitasoft.engine.identity.model.builder.SContactInfoBuilderFactory;
import org.bonitasoft.engine.identity.model.builder.SContactInfoLogBuilder;
import org.bonitasoft.engine.identity.model.builder.SContactInfoLogBuilderFactory;
import org.bonitasoft.engine.identity.model.builder.SCustomUserInfoDefinitionLogBuilder;
import org.bonitasoft.engine.identity.model.builder.SCustomUserInfoDefinitionLogBuilderFactory;
import org.bonitasoft.engine.identity.model.builder.SGroupLogBuilder;
import org.bonitasoft.engine.identity.model.builder.SGroupLogBuilderFactory;
import org.bonitasoft.engine.identity.model.builder.SRoleLogBuilder;
import org.bonitasoft.engine.identity.model.builder.SRoleLogBuilderFactory;
import org.bonitasoft.engine.identity.model.builder.SUserBuilderFactory;
import org.bonitasoft.engine.identity.model.builder.SUserLogBuilder;
import org.bonitasoft.engine.identity.model.builder.SUserLogBuilderFactory;
import org.bonitasoft.engine.identity.model.builder.SUserMembershipLogBuilder;
import org.bonitasoft.engine.identity.model.builder.SUserMembershipLogBuilderFactory;
import org.bonitasoft.engine.identity.recorder.SelectDescriptorBuilder;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.ReadPersistenceService;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SBonitaSearchException;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLog;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLogSeverity;
import org.bonitasoft.engine.queriablelogger.model.builder.ActionType;
import org.bonitasoft.engine.queriablelogger.model.builder.HasCRUDEAction;
import org.bonitasoft.engine.queriablelogger.model.builder.SLogBuilder;
import org.bonitasoft.engine.queriablelogger.model.builder.SPersistenceLogBuilder;
import org.bonitasoft.engine.recorder.Recorder;
import org.bonitasoft.engine.recorder.SRecorderException;
import org.bonitasoft.engine.recorder.model.DeleteAllRecord;
import org.bonitasoft.engine.recorder.model.DeleteRecord;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.recorder.model.InsertRecord;
import org.bonitasoft.engine.recorder.model.UpdateRecord;
import org.bonitasoft.engine.services.QueriableLoggerService;

public class IdentityServiceImpl
implements IdentityService {
    private final ReadPersistenceService persistenceService;
    private final Recorder recorder;
    private final TechnicalLoggerService logger;
    private final QueriableLoggerService queriableLoggerService;
    private final EventService eventService;
    private final CredentialsEncrypter encrypter;

    public IdentityServiceImpl(ReadPersistenceService persistenceService, Recorder recorder, EventService eventService, TechnicalLoggerService logger, QueriableLoggerService queriableLoggerService, CredentialsEncrypter encrypter) {
        this.persistenceService = persistenceService;
        this.recorder = recorder;
        this.eventService = eventService;
        this.logger = logger;
        this.queriableLoggerService = queriableLoggerService;
        this.encrypter = encrypter;
    }

    @Override
    public void createGroup(SGroup group) throws SGroupCreationException {
        String methodName = "createGroup";
        this.logBeforeMethod("createGroup");
        long objectId = group.getId();
        SGroupLogBuilder logBuilder = this.getGroupLog(ActionType.CREATED, "Adding a new group with name " + group.getName());
        try {
            InsertRecord insertRecord = new InsertRecord(group);
            SInsertEvent insertEvent = this.getInsertEvent(group, "GROUP");
            this.recorder.recordInsert(insertRecord, insertEvent);
            boolean status = true;
            this.initiateLogBuilder(insertRecord.getEntity().getId(), 1, logBuilder, "createGroup");
            this.logAfterMethod("createGroup");
        }
        catch (SRecorderException re) {
            this.logOnExceptionMethod("createGroup", re);
            boolean status = false;
            this.initiateLogBuilder(objectId, 0, logBuilder, "createGroup");
            throw new SGroupCreationException(re);
        }
    }

    private SInsertEvent getInsertEvent(Object object, String type) {
        if (this.eventService.hasHandlers(type, EventActionType.CREATED)) {
            return (SInsertEvent)BuilderFactory.get(SEventBuilderFactory.class).createInsertEvent(type).setObject(object).done();
        }
        return null;
    }

    private SDeleteEvent getDeleteEvent(Object object, String type) {
        if (this.eventService.hasHandlers(type, EventActionType.DELETED)) {
            return (SDeleteEvent)BuilderFactory.get(SEventBuilderFactory.class).createDeleteEvent(type).setObject(object).done();
        }
        return null;
    }

    @Override
    public SCustomUserInfoDefinition createCustomUserInfoDefinition(SCustomUserInfoDefinition customUserInfo) throws SCustomUserInfoDefinitionAlreadyExistsException, SCustomUserInfoDefinitionCreationException {
        String methodName = "createCustomUserInfoDefinition";
        this.logBeforeMethod("createCustomUserInfoDefinition");
        SCustomUserInfoDefinitionLogBuilder logBuilder = this.getSCustomUserInfoDefinitionLog(ActionType.CREATED, "Adding a custom user info with name " + customUserInfo.getName());
        try {
            this.throwExceptionIfAlreadyExists(customUserInfo);
            InsertRecord insertRecord = new InsertRecord(customUserInfo);
            SInsertEvent insertEvent = this.getInsertEvent(customUserInfo, "CUSTOM_USER_INFO_DEFINITION");
            this.recorder.recordInsert(insertRecord, insertEvent);
            this.initiateLogBuilder(customUserInfo.getId(), 1, logBuilder, "createCustomUserInfoDefinition");
            this.logAfterMethod("createCustomUserInfoDefinition");
            return customUserInfo;
        }
        catch (SRecorderException e) {
            throw this.handleCustomUserInfoDefinitionCreationFailure(customUserInfo, "createCustomUserInfoDefinition", logBuilder, e);
        }
        catch (SBonitaReadException e) {
            throw this.handleCustomUserInfoDefinitionCreationFailure(customUserInfo, "createCustomUserInfoDefinition", logBuilder, e);
        }
    }

    private void throwExceptionIfAlreadyExists(SCustomUserInfoDefinition customUserInfo) throws SBonitaReadException, SCustomUserInfoDefinitionAlreadyExistsException {
        SCustomUserInfoDefinition storedDef = this.getCustomUserInfoDefinitionWithoutCheck(customUserInfo.getName());
        if (storedDef != null) {
            throw new SCustomUserInfoDefinitionAlreadyExistsException(customUserInfo.getName());
        }
    }

    private SCustomUserInfoDefinitionCreationException handleCustomUserInfoDefinitionCreationFailure(SCustomUserInfoDefinition customUserInfo, String methodName, SCustomUserInfoDefinitionLogBuilder logBuilder, SBonitaException exception) throws SCustomUserInfoDefinitionCreationException {
        this.logOnExceptionMethod(methodName, exception);
        this.initiateLogBuilder(customUserInfo.getId(), 0, logBuilder, methodName);
        return new SCustomUserInfoDefinitionCreationException(customUserInfo.getName(), exception);
    }

    @Override
    public SCustomUserInfoValue createCustomUserInfoValue(SCustomUserInfoValue customUserInfo) throws SIdentityException {
        String methodName = "createCustomUserInfoValue";
        this.logBeforeMethod("createCustomUserInfoValue");
        try {
            InsertRecord insertRecord = new InsertRecord(customUserInfo);
            SInsertEvent insertEvent = this.getInsertEvent(customUserInfo, "CUSTOM_USER_INFO_VALUE");
            this.recorder.recordInsert(insertRecord, insertEvent);
            this.logAfterMethod("createCustomUserInfoValue");
            return customUserInfo;
        }
        catch (SRecorderException e) {
            this.logOnExceptionMethod("createCustomUserInfoValue", e);
            throw new SIdentityException("Can't add custom user info value " + customUserInfo, e);
        }
    }

    @Override
    public void createRole(SRole role) throws SIdentityException {
        String methodName = "createRole";
        this.logBeforeMethod("createRole");
        SRoleLogBuilder logBuilder = this.getRoleLog(ActionType.CREATED, "Adding a new role with name " + role.getName());
        try {
            InsertRecord insertRecord = new InsertRecord(role);
            SInsertEvent insertEvent = this.getInsertEvent(role, "ROLE");
            this.recorder.recordInsert(insertRecord, insertEvent);
            this.initiateLogBuilder(role.getId(), 1, logBuilder, "createRole");
            this.logAfterMethod("createRole");
        }
        catch (SRecorderException e) {
            this.logOnExceptionMethod("createRole", e);
            this.initiateLogBuilder(role.getId(), 0, logBuilder, "createRole");
            throw new SIdentityException("Can't add role " + role, e);
        }
    }

    @Override
    public SUser createUser(SUser user) throws SUserCreationException {
        String methodName = "createUser";
        this.logBeforeMethod("createUser");
        String message = "Adding a new user with user name " + user.getUserName() + ", first name " + user.getFirstName() + ", last name " + user.getLastName();
        SUserLogBuilder logBuilder = this.getUserLog(ActionType.CREATED, message);
        String hash = this.encrypter.hash(user.getPassword());
        SUser hashedUser = BuilderFactory.get(SUserBuilderFactory.class).createNewInstance(user).setPassword(hash).done();
        try {
            InsertRecord insertRecord = new InsertRecord(hashedUser);
            SInsertEvent insertEvent = this.getInsertEvent(hashedUser, "USER");
            this.recorder.recordInsert(insertRecord, insertEvent);
            this.initiateLogBuilder(hashedUser.getId(), 1, logBuilder, "createUser");
            this.logAfterMethod("createUser");
            return hashedUser;
        }
        catch (SRecorderException re) {
            this.logOnExceptionMethod("createUser", re);
            this.initiateLogBuilder(hashedUser.getId(), 0, logBuilder, "createUser");
            throw new SUserCreationException(re);
        }
    }

    @Override
    public SContactInfo createUserContactInfo(SContactInfo contactInfo) throws SUserCreationException {
        String methodName = "createUserContactInfo";
        this.logBeforeMethod("createUserContactInfo");
        String message = "Adding a new user contact information for user with id " + contactInfo.getUserId();
        SContactInfoLogBuilder logBuilder = this.getUserContactInfoLog(ActionType.CREATED, message, contactInfo);
        try {
            InsertRecord insertRecord = new InsertRecord(contactInfo);
            SInsertEvent insertEvent = this.getInsertEvent(contactInfo, "USER_CONTACT_INFO");
            this.recorder.recordInsert(insertRecord, insertEvent);
            this.initiateLogBuilder(contactInfo.getId(), 1, logBuilder, "createUserContactInfo");
            this.logAfterMethod("createUserContactInfo");
            return contactInfo;
        }
        catch (SRecorderException re) {
            this.logOnExceptionMethod("createUserContactInfo", re);
            this.initiateLogBuilder(contactInfo.getId(), 0, logBuilder, "createUserContactInfo");
            throw new SUserCreationException(re);
        }
    }

    @Override
    public void createUserMembership(SUserMembership userMembership) throws SUserMembershipCreationException {
        String methodName = "createUserMembership";
        this.logBeforeMethod("createUserMembership");
        String message = "Adding a new user membership for user " + userMembership.getUsername() + " with role " + userMembership.getRoleName() + " in group " + userMembership.getGroupName();
        SUserMembershipLogBuilder logBuilder = this.getUserMembershipLog(ActionType.CREATED, message, userMembership);
        try {
            InsertRecord insertRecord = new InsertRecord(userMembership);
            SInsertEvent insertEvent = this.getInsertEvent(userMembership, "USERMEMBERSHIP");
            this.recorder.recordInsert(insertRecord, insertEvent);
            this.initiateLogBuilder(userMembership.getId(), 1, logBuilder, "createUserMembership");
            this.logAfterMethod("createUserMembership");
        }
        catch (SRecorderException re) {
            this.logOnExceptionMethod("createUserMembership", re);
            this.initiateLogBuilder(userMembership.getId(), 0, logBuilder, "createUserMembership");
            throw new SUserMembershipCreationException(re);
        }
    }

    @Override
    public void deleteGroup(long groupId) throws SGroupNotFoundException, SGroupDeletionException {
        SGroup group = this.getGroup(groupId);
        this.deleteGroup(group);
    }

    @Override
    public void deleteGroup(SGroup group) throws SGroupDeletionException {
        String methodName = "deleteGroup";
        this.logBeforeMethod("deleteGroup");
        SGroupLogBuilder logBuilder = this.getGroupLog(ActionType.DELETED, "Deleting group " + group.getName());
        try {
            DeleteRecord deleteRecord = new DeleteRecord(group);
            SDeleteEvent deleteEvent = this.getDeleteEvent(group, "GROUP");
            this.recorder.recordDelete(deleteRecord, deleteEvent);
            this.initiateLogBuilder(group.getId(), 1, logBuilder, "deleteGroup");
            this.logAfterMethod("deleteGroup");
        }
        catch (SRecorderException re) {
            this.logOnExceptionMethod("deleteGroup", re);
            this.initiateLogBuilder(group.getId(), 0, logBuilder, "deleteGroup");
            throw new SGroupDeletionException(re);
        }
    }

    @Override
    public void deleteAllGroups() throws SGroupDeletionException {
        try {
            DeleteAllRecord record = new DeleteAllRecord(SGroup.class, null);
            this.recorder.recordDeleteAll(record);
        }
        catch (SRecorderException e) {
            throw new SGroupDeletionException("Can't delete all groups.", e);
        }
    }

    @Override
    public List<Long> deleteChildrenGroup(long groupId) throws SGroupDeletionException, SGroupNotFoundException {
        String methodName = "deleteChildrenGroup";
        this.logBeforeMethod("deleteChildrenGroup");
        ArrayList<Long> deletedGroups = new ArrayList<Long>();
        try {
            List<SGroup> childrenGroup;
            int nbGroup = 20;
            while (!(childrenGroup = this.getGroupChildren(groupId, 0, 20)).isEmpty()) {
                for (SGroup sGroup : childrenGroup) {
                    deletedGroups.addAll(this.deleteChildrenGroup(sGroup.getId()));
                    deletedGroups.add(sGroup.getId());
                    this.deleteGroup(sGroup);
                }
            }
            this.logAfterMethod("deleteChildrenGroup");
        }
        catch (SGroupNotFoundException e) {
            throw e;
        }
        catch (SIdentityException e) {
            this.logOnExceptionMethod("deleteChildrenGroup", e);
            throw new SGroupDeletionException(e);
        }
        return deletedGroups;
    }

    private <T extends SLogBuilder> void initializeLogBuilder(T logBuilder, String message) {
        logBuilder.actionStatus(0).severity(SQueriableLogSeverity.INTERNAL).rawMessage(message);
    }

    private <T extends HasCRUDEAction> void updateLog(ActionType actionType, T logBuilder) {
        logBuilder.setActionType(actionType);
    }

    private SGroupLogBuilder getGroupLog(ActionType actionType, String message) {
        SGroupLogBuilder logBuilder = BuilderFactory.get(SGroupLogBuilderFactory.class).createNewInstance();
        this.initializeLogBuilder(logBuilder, message);
        this.updateLog(actionType, logBuilder);
        return logBuilder;
    }

    private SRoleLogBuilder getRoleLog(ActionType actionType, String message) {
        SRoleLogBuilder logBuilder = BuilderFactory.get(SRoleLogBuilderFactory.class).createNewInstance();
        this.initializeLogBuilder(logBuilder, message);
        this.updateLog(actionType, logBuilder);
        return logBuilder;
    }

    private SCustomUserInfoDefinitionLogBuilder getSCustomUserInfoDefinitionLog(ActionType actionType, String message) {
        SCustomUserInfoDefinitionLogBuilder logBuilder = BuilderFactory.get(SCustomUserInfoDefinitionLogBuilderFactory.class).createNewInstance();
        this.initializeLogBuilder(logBuilder, message);
        this.updateLog(actionType, logBuilder);
        return logBuilder;
    }

    private SUserLogBuilder getUserLog(ActionType actionType, String message) {
        SUserLogBuilder logBuilder = BuilderFactory.get(SUserLogBuilderFactory.class).createNewInstance();
        this.initializeLogBuilder(logBuilder, message);
        this.updateLog(actionType, logBuilder);
        return logBuilder;
    }

    private SContactInfoLogBuilder getUserContactInfoLog(ActionType actionType, String message, SContactInfo contactInfo) {
        SContactInfoLogBuilder logBuilder = BuilderFactory.get(SContactInfoLogBuilderFactory.class).createNewInstance();
        this.initializeLogBuilder(logBuilder, message);
        this.updateLog(actionType, logBuilder);
        logBuilder.setContactInfoUserId(contactInfo.getUserId());
        return logBuilder;
    }

    private SUserMembershipLogBuilder getUserMembershipLog(ActionType actionType, String message, SUserMembership userMemberShip) {
        SUserMembershipLogBuilder logBuilder = BuilderFactory.get(SUserMembershipLogBuilderFactory.class).createNewInstance();
        this.initializeLogBuilder(logBuilder, message);
        this.updateLog(actionType, logBuilder);
        logBuilder.identityUserId(userMemberShip.getUserId());
        logBuilder.roleID(userMemberShip.getRoleId());
        logBuilder.groupId(userMemberShip.getGroupId());
        return logBuilder;
    }

    @Override
    public void deleteCustomUserInfoDefinition(long customUserInfoDefinitionId) throws SIdentityException {
        this.deleteCustomUserInfoDefinition(this.getCustomUserInfoDefinition(customUserInfoDefinitionId));
    }

    @Override
    public void deleteCustomUserInfoDefinition(SCustomUserInfoDefinition info) throws SIdentityException {
        String methodName = "deleteCustomUserInfoDefinition";
        this.logBeforeMethod("deleteCustomUserInfoDefinition");
        SCustomUserInfoDefinitionLogBuilder logBuilder = this.getSCustomUserInfoDefinitionLog(ActionType.DELETED, "Deleting profile custom user info definition with name " + info.getName());
        try {
            DeleteRecord deleteRecord = new DeleteRecord(info);
            SDeleteEvent deleteEvent = this.getDeleteEvent(info, "CUSTOM_USER_INFO_DEFINITION");
            this.recorder.recordDelete(deleteRecord, deleteEvent);
            this.initiateLogBuilder(info.getId(), 1, logBuilder, "deleteCustomUserInfoDefinition");
            this.logAfterMethod("deleteCustomUserInfoDefinition");
        }
        catch (SRecorderException e) {
            this.logOnExceptionMethod("deleteCustomUserInfoDefinition", e);
            this.initiateLogBuilder(info.getId(), 0, logBuilder, "deleteCustomUserInfoDefinition");
            throw new SIdentityException("Can't delete profile custom user info definition " + info, e);
        }
    }

    @Override
    public void deleteCustomUserInfoValue(long customUserInfoValueId) throws SIdentityException {
        this.deleteCustomUserInfoValue(this.getCustomUserInfoValue(customUserInfoValueId));
    }

    @Override
    public void deleteCustomUserInfoValue(SCustomUserInfoValue customUserInfo) throws SIdentityException {
        String methodName = "deleteCustomUserInfoValue";
        this.logBeforeMethod("deleteCustomUserInfoValue");
        try {
            DeleteRecord deleteRecord = new DeleteRecord(customUserInfo);
            SDeleteEvent deleteEvent = this.getDeleteEvent(customUserInfo, "CUSTOM_USER_INFO_VALUE");
            this.recorder.recordDelete(deleteRecord, deleteEvent);
            this.logAfterMethod("deleteCustomUserInfoValue");
        }
        catch (SRecorderException e) {
            this.logOnExceptionMethod("deleteCustomUserInfoValue", e);
            throw new SIdentityException("Can't delete custom user info value" + customUserInfo, e);
        }
    }

    @Override
    public void deleteRole(long roleId) throws SRoleNotFoundException, SRoleDeletionException {
        SRole role = this.getRole(roleId);
        this.deleteRole(role);
    }

    @Override
    public void deleteRole(SRole role) throws SRoleDeletionException {
        String methodName = "deleteRole";
        this.logBeforeMethod("deleteRole");
        SRoleLogBuilder logBuilder = this.getRoleLog(ActionType.DELETED, "Deleting role with name " + role.getName());
        try {
            DeleteRecord deleteRecord = new DeleteRecord(role);
            SDeleteEvent deleteEvent = this.getDeleteEvent(role, "ROLE");
            this.recorder.recordDelete(deleteRecord, deleteEvent);
            this.initiateLogBuilder(role.getId(), 1, logBuilder, "deleteRole");
            this.logAfterMethod("deleteRole");
        }
        catch (SRecorderException re) {
            this.logOnExceptionMethod("deleteRole", re);
            this.initiateLogBuilder(role.getId(), 0, logBuilder, "deleteRole");
            throw new SRoleDeletionException(re);
        }
    }

    @Override
    public void deleteAllRoles() throws SRoleDeletionException {
        try {
            DeleteAllRecord record = new DeleteAllRecord(SRole.class, null);
            this.recorder.recordDeleteAll(record);
        }
        catch (SRecorderException e) {
            throw new SRoleDeletionException("Can't delete all roles.", e);
        }
    }

    @Override
    public void deleteUser(long userId) throws SUserDeletionException {
        try {
            SUser user = this.getUser(userId);
            this.deleteUser(user);
        }
        catch (SUserNotFoundException e) {
            // empty catch block
        }
    }

    @Override
    public void deleteUser(SUser user) throws SUserDeletionException {
        String methodName = "deleteUser";
        this.logBeforeMethod("deleteUser");
        SUserLogBuilder logBuilder = this.getUserLog(ActionType.DELETED, "Deleting user with username " + user.getUserName());
        try {
            DeleteRecord deleteRecord = new DeleteRecord(user);
            SDeleteEvent deleteEvent = this.getDeleteEvent(user, "USER");
            this.recorder.recordDelete(deleteRecord, deleteEvent);
            this.initiateLogBuilder(user.getId(), 1, logBuilder, "deleteUser");
            this.logAfterMethod("deleteUser");
        }
        catch (SRecorderException re) {
            this.logOnExceptionMethod("deleteUser", re);
            this.initiateLogBuilder(user.getId(), 0, logBuilder, "deleteUser");
            throw new SUserDeletionException(re);
        }
    }

    @Override
    public void deleteAllUsers() throws SUserDeletionException {
        try {
            DeleteAllRecord record = new DeleteAllRecord(SUser.class, null);
            this.recorder.recordDeleteAll(record);
        }
        catch (SRecorderException e) {
            throw new SUserDeletionException("Can't delete all users.", e);
        }
    }

    @Override
    public SUserMembership getLightUserMembership(long userMembershipId) throws SIdentityException {
        String methodName = "getLightUserMembership";
        this.logBeforeMethod("getLightUserMembership");
        try {
            SUserMembership selectOne = this.persistenceService.selectById(SelectDescriptorBuilder.getLightElementById(SUserMembership.class, "SUserMembership", userMembershipId));
            if (selectOne == null) {
                throw new SIdentityException("Can't get the userMembership with id " + userMembershipId, null);
            }
            this.logAfterMethod("getLightUserMembership");
            return selectOne;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getLightUserMembership", e);
            throw new SIdentityException("Can't get the user membership with id " + userMembershipId, e);
        }
    }

    @Override
    public void deleteUserMembership(SUserMembership userMembership) throws SMembershipDeletionException {
        try {
            if (userMembership.getGroupName() != null || userMembership.getUsername() != null || userMembership.getRoleName() != null) {
                userMembership = this.getLightUserMembership(userMembership.getId());
            }
            this.deleteLightUserMembership(userMembership);
        }
        catch (SIdentityException e) {
            throw new SMembershipDeletionException("Can't delete membership " + userMembership, e);
        }
    }

    @Override
    public void deleteUserMembership(long id) throws SMembershipDeletionException {
        try {
            SUserMembership userMembership = this.getLightUserMembership(id);
            this.deleteLightUserMembership(userMembership);
        }
        catch (SIdentityException e) {
            throw new SMembershipDeletionException("Can't delete membership with id " + id, e);
        }
    }

    @Override
    public void deleteLightUserMembership(SUserMembership userMembership) throws SMembershipDeletionException {
        String methodName = "deleteLightUserMembership";
        this.logBeforeMethod("deleteLightUserMembership");
        String message = "Deleting user membership for user " + userMembership.getUsername() + " with role " + userMembership.getRoleName() + " in group " + userMembership.getGroupName();
        SUserMembershipLogBuilder logBuilder = this.getUserMembershipLog(ActionType.DELETED, message, userMembership);
        try {
            DeleteRecord deleteRecord = new DeleteRecord(userMembership);
            SDeleteEvent deleteEvent = this.getDeleteEvent(userMembership, "USERMEMBERSHIP");
            this.recorder.recordDelete(deleteRecord, deleteEvent);
            this.initiateLogBuilder(userMembership.getId(), 1, logBuilder, "deleteLightUserMembership");
            this.logAfterMethod("deleteLightUserMembership");
        }
        catch (SRecorderException e) {
            this.logOnExceptionMethod("deleteLightUserMembership", e);
            this.initiateLogBuilder(userMembership.getId(), 0, logBuilder, "deleteLightUserMembership");
            throw new SMembershipDeletionException("Can't delete membership " + userMembership, e);
        }
    }

    @Override
    public void deleteAllUserMemberships() throws SMembershipDeletionException {
        try {
            DeleteAllRecord record = new DeleteAllRecord(SUserMembership.class, null);
            this.recorder.recordDeleteAll(record);
        }
        catch (SRecorderException e) {
            throw new SMembershipDeletionException("Can't delete all user memberships.", e);
        }
    }

    @Override
    public SGroup getGroup(long groupId) throws SGroupNotFoundException {
        String methodName = "getGroup";
        this.logBeforeMethod("getGroup");
        try {
            SGroup group = this.persistenceService.selectById(SelectDescriptorBuilder.getElementById(SGroup.class, "Group", groupId));
            if (group == null) {
                throw new SGroupNotFoundException("No group exists with id: " + groupId);
            }
            this.logAfterMethod("getGroup");
            return group;
        }
        catch (SBonitaReadException bre) {
            this.logOnExceptionMethod("getGroup", bre);
            throw new SGroupNotFoundException(bre);
        }
    }

    @Override
    public List<SGroup> getGroupChildren(long groupId) throws SIdentityException {
        String methodName = "getGroupChildren";
        this.logBeforeMethod("getGroupChildren");
        try {
            SGroup group = this.getGroup(groupId);
            List<SGroup> listGroups = this.persistenceService.selectList(SelectDescriptorBuilder.getChildrenOfGroup(group));
            this.logAfterMethod("getGroupChildren");
            return listGroups;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getGroupChildren", e);
            throw new SIdentityException("Can't get the children of the group", e);
        }
    }

    @Override
    public List<SGroup> getGroupChildren(long groupId, int fromIndex, int numberOfGroups) throws SIdentityException {
        String methodName = "getGroupChildren";
        this.logBeforeMethod("getGroupChildren");
        try {
            SGroup group = this.getGroup(groupId);
            List<SGroup> listGroups = this.persistenceService.selectList(SelectDescriptorBuilder.getChildrenOfGroup(group, fromIndex, numberOfGroups));
            this.logAfterMethod("getGroupChildren");
            return listGroups;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getGroupChildren", e);
            throw new SIdentityException("Can't get the children of the group", e);
        }
    }

    @Override
    public List<SGroup> getGroupChildren(long groupId, int fromIndex, int numberOfGroups, String field, OrderByType order) throws SIdentityException {
        String methodName = "getGroupChildren";
        this.logBeforeMethod("getGroupChildren");
        try {
            SGroup group = this.getGroup(groupId);
            List<SGroup> listGroups = this.persistenceService.selectList(SelectDescriptorBuilder.getChildrenOfGroup(group, field, order, fromIndex, numberOfGroups));
            this.logAfterMethod("getGroupChildren");
            return listGroups;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getGroupChildren", e);
            throw new SIdentityException("Can't get the children of the group", e);
        }
    }

    @Override
    public List<SGroup> getGroups(int fromIndex, int numberOfGroups) throws SIdentityException {
        String methodName = "getGroups";
        this.logBeforeMethod("getGroups");
        try {
            List<SGroup> listGroups = this.persistenceService.selectList(SelectDescriptorBuilder.getElements(SGroup.class, "Group", fromIndex, numberOfGroups));
            this.logAfterMethod("getGroups");
            return listGroups;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getGroups", e);
            throw new SIdentityException("Can't get the groups", e);
        }
    }

    @Override
    public List<SGroup> getGroups(int fromIndex, int numberOfGroups, String field, OrderByType order) throws SIdentityException {
        String methodName = "getGroups";
        this.logBeforeMethod("getGroups");
        try {
            List<SGroup> listGroups = this.persistenceService.selectList(SelectDescriptorBuilder.getElements(SGroup.class, "Group", field, order, fromIndex, numberOfGroups));
            this.logAfterMethod("getGroups");
            return listGroups;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getGroups", e);
            throw new SIdentityException("Can't get the groups", e);
        }
    }

    @Override
    public List<SGroup> getGroups(List<Long> groupIds) throws SGroupNotFoundException {
        String methodName = "getGroups";
        this.logBeforeMethod("getGroups");
        if (groupIds == null || groupIds.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            List<SGroup> listGroups = this.persistenceService.selectList(SelectDescriptorBuilder.getElementsByIds(SGroup.class, "Group", groupIds));
            this.logAfterMethod("getGroups");
            return listGroups;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getGroups", e);
            throw new SGroupNotFoundException(e);
        }
    }

    @Override
    public Set<SGroup> getGroupsByName(String groupName) throws SGroupNotFoundException {
        String methodName = "getGroupsByName";
        this.logBeforeMethod("getGroupsByName");
        try {
            Set<SGroup> setGroups = CollectionUtil.buildHashSetFromList(SGroup.class, this.persistenceService.selectList(SelectDescriptorBuilder.getGroupsByName(groupName)));
            this.logAfterMethod("getGroupsByName");
            return setGroups;
        }
        catch (SBonitaReadException bre) {
            this.logOnExceptionMethod("getGroupsByName", bre);
            throw new SGroupNotFoundException(bre);
        }
    }

    @Override
    public List<SUserMembership> getUserMemberships(int fromIndex, int numberOfResult, OrderByOption orderByOption) throws SIdentityException {
        String methodName = "getUserMemberships";
        this.logBeforeMethod("getUserMemberships");
        try {
            List<SUserMembership> listSUserMembership = orderByOption.getClazz() == SRole.class ? this.persistenceService.selectList(SelectDescriptorBuilder.getUserMembershipsWithRole(new QueryOptions(fromIndex, numberOfResult, Collections.singletonList(orderByOption)))) : (orderByOption.getClazz() == SGroup.class ? this.persistenceService.selectList(SelectDescriptorBuilder.getUserMembershipsWithGroup(new QueryOptions(fromIndex, numberOfResult, Collections.singletonList(orderByOption)))) : this.persistenceService.selectList(SelectDescriptorBuilder.getElements(SUserMembership.class, "UserMembership", new QueryOptions(fromIndex, numberOfResult, Collections.singletonList(orderByOption)))));
            this.logAfterMethod("getUserMemberships");
            return listSUserMembership;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getUserMemberships", e);
            throw new SIdentityException("Can't get the memberships", e);
        }
    }

    @Override
    public List<SUserMembership> getUserMembershipsOfGroup(long groupId, int startIndex, int maxResults) throws SIdentityException {
        String methodName = "getUserMembershipsOfGroup";
        this.logBeforeMethod("getUserMembershipsOfGroup");
        try {
            List<SUserMembership> selectList = this.persistenceService.selectList(SelectDescriptorBuilder.getUserMembershipsByGroup(groupId, startIndex, maxResults));
            this.logAfterMethod("getUserMembershipsOfGroup");
            return selectList;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getUserMembershipsOfGroup", e);
            throw new SIdentityException("Can't get the users memberships the group " + groupId, e);
        }
    }

    @Override
    public List<SUserMembership> getUserMembershipsOfRole(long roleId, int startIndex, int maxResults) throws SIdentityException {
        String methodName = "getUserMembershipsOfRole";
        this.logBeforeMethod("getUserMembershipsOfRole");
        try {
            List<SUserMembership> memberships = this.persistenceService.selectList(SelectDescriptorBuilder.getUserMembershipsByRole(roleId, startIndex, maxResults));
            this.logAfterMethod("getUserMembershipsOfRole");
            return memberships;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getUserMembershipsOfRole", e);
            throw new SIdentityException("Can't get the memberships having the role " + roleId, e);
        }
    }

    @Override
    public long getNumberOfGroupChildren(long parentGroupId) throws SIdentityException {
        String methodName = "getNumberOfGroupChildren";
        this.logBeforeMethod("getNumberOfGroupChildren");
        try {
            SGroup parentGroup = this.getGroup(parentGroupId);
            long number = this.persistenceService.selectOne(SelectDescriptorBuilder.getNumberOfGroupChildren(parentGroup.getPath()));
            this.logAfterMethod("getNumberOfGroupChildren");
            return number;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getNumberOfGroupChildren", e);
            throw new SIdentityException("Can't get the number children of group", e);
        }
    }

    @Override
    public long getNumberOfGroups() throws SIdentityException {
        String methodName = "getNumberOfGroups";
        this.logBeforeMethod("getNumberOfGroups");
        try {
            long number = this.persistenceService.selectOne(SelectDescriptorBuilder.getNumberOfElement("SGroup", SGroup.class));
            this.logAfterMethod("getNumberOfGroups");
            return number;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getNumberOfGroups", e);
            throw new SIdentityException("Can't get the number of group", e);
        }
    }

    @Override
    public long getNumberOfCustomUserInfoDefinition() throws SIdentityException {
        String methodName = "getNumberOfCustomUserInfoDefinition";
        this.logBeforeMethod("getNumberOfCustomUserInfoDefinition");
        try {
            long number = this.persistenceService.selectOne(SelectDescriptorBuilder.getNumberOfElement("CustomUserInfoDefinition", SCustomUserInfoDefinition.class));
            this.logAfterMethod("getNumberOfCustomUserInfoDefinition");
            return number;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getNumberOfCustomUserInfoDefinition", e);
            throw new SIdentityException("Can't get the number of custom user info", e);
        }
    }

    @Override
    public long getNumberOfCustomUserInfoValue(QueryOptions options) throws SBonitaSearchException {
        String methodName = "getNumberOfCustomUserInfoValue";
        this.logBeforeMethod("getNumberOfCustomUserInfoValue");
        try {
            long number = this.persistenceService.getNumberOfEntities(SCustomUserInfoValue.class, options, null);
            this.logAfterMethod("getNumberOfCustomUserInfoValue");
            return number;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getNumberOfCustomUserInfoValue", e);
            throw new SBonitaSearchException(e);
        }
    }

    @Override
    public long getNumberOfRoles() throws SIdentityException {
        String methodName = "getNumberOfRoles";
        this.logBeforeMethod("getNumberOfRoles");
        try {
            long number = this.persistenceService.selectOne(SelectDescriptorBuilder.getNumberOfElement("SRole", SRole.class));
            this.logAfterMethod("getNumberOfRoles");
            return number;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getNumberOfRoles", e);
            throw new SIdentityException("Can't get the number of role", e);
        }
    }

    @Override
    public long getNumberOfUsers() throws SIdentityException {
        String methodName = "getNumberOfUsers";
        this.logBeforeMethod("getNumberOfUsers");
        try {
            long number = this.persistenceService.selectOne(SelectDescriptorBuilder.getNumberOfElement("SUser", SUser.class));
            this.logAfterMethod("getNumberOfUsers");
            return number;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getNumberOfUsers", e);
            throw new SIdentityException("Can't get the number of user", e);
        }
    }

    @Override
    public long getNumberOfUserMembershipsOfUser(long userId) throws SIdentityException {
        String methodName = "getNumberOfUserMembershipsOfUser";
        this.logBeforeMethod("getNumberOfUserMembershipsOfUser");
        try {
            long number = this.persistenceService.selectOne(SelectDescriptorBuilder.getNumberOfUserMembershipsOfUser(userId));
            this.logAfterMethod("getNumberOfUserMembershipsOfUser");
            return number;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getNumberOfUserMembershipsOfUser", e);
            throw new SIdentityException("Can't get the number of usermemberships having the user " + userId, e);
        }
    }

    @Override
    public long getNumberOfUsersByGroup(long groupId) throws SIdentityException {
        String methodName = "getNumberOfUsersByGroup";
        this.logBeforeMethod("getNumberOfUsersByGroup");
        try {
            long number = this.persistenceService.selectOne(SelectDescriptorBuilder.getNumberOfUsersByGroup(groupId));
            this.logAfterMethod("getNumberOfUsersByGroup");
            return number;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getNumberOfUsersByGroup", e);
            throw new SIdentityException("Can't get the number of users having the group " + groupId, e);
        }
    }

    @Override
    public long getNumberOfUsersByRole(long roleId) throws SIdentityException {
        String methodName = "getNumberOfUsersByRole";
        this.logBeforeMethod("getNumberOfUsersByRole");
        try {
            long number = this.persistenceService.selectOne(SelectDescriptorBuilder.getNumberOfUsersByRole(roleId));
            this.logAfterMethod("getNumberOfUsersByRole");
            return number;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getNumberOfUsersByRole", e);
            throw new SIdentityException("Can't get the number of users having the role " + roleId, e);
        }
    }

    @Override
    public long getNumberOfUsersByMembership(long groupId, long roleId) throws SIdentityException {
        String methodName = "getNumberOfUsersByMembership";
        this.logBeforeMethod("getNumberOfUsersByMembership");
        try {
            long number = this.persistenceService.selectOne(SelectDescriptorBuilder.getNumberOfUsersByMembership(groupId, roleId));
            this.logAfterMethod("getNumberOfUsersByMembership");
            return number;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getNumberOfUsersByMembership", e);
            throw new SIdentityException("Can't get the number of users having the membership with group:" + groupId + " and role:" + roleId, e);
        }
    }

    @Override
    public SCustomUserInfoDefinition getCustomUserInfoDefinitionByName(String name) throws SCustomUserInfoDefinitionNotFoundException, SCustomUserInfoDefinitionReadException {
        String methodName = "getCustomUserInfoDefinitionByName";
        SCustomUserInfoDefinition definition = null;
        try {
            this.logBeforeMethod("getCustomUserInfoDefinitionByName");
            definition = this.getCustomUserInfoDefinitionWithoutCheck(name);
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getCustomUserInfoDefinitionByName", e);
            throw new SCustomUserInfoDefinitionReadException(name, e);
        }
        if (definition == null) {
            SCustomUserInfoDefinitionNotFoundException notFoundException = new SCustomUserInfoDefinitionNotFoundException(name);
            this.logOnExceptionMethod("getCustomUserInfoDefinitionByName", notFoundException);
            throw notFoundException;
        }
        this.logAfterMethod("getCustomUserInfoDefinitionByName");
        return definition;
    }

    @Override
    public boolean hasCustomUserInfoDefinition(String name) throws SCustomUserInfoDefinitionReadException {
        String methodName = "hasCustomUserInfoDefinition";
        SCustomUserInfoDefinition definition = null;
        try {
            this.logBeforeMethod("hasCustomUserInfoDefinition");
            definition = this.getCustomUserInfoDefinitionWithoutCheck(name);
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("hasCustomUserInfoDefinition", e);
            throw new SCustomUserInfoDefinitionReadException(name, e);
        }
        this.logAfterMethod("hasCustomUserInfoDefinition");
        return definition != null;
    }

    private SCustomUserInfoDefinition getCustomUserInfoDefinitionWithoutCheck(String name) throws SBonitaReadException {
        return this.persistenceService.selectOne(SelectDescriptorBuilder.getCustomUserInfoDefinitionByName(name));
    }

    @Override
    public List<SCustomUserInfoDefinition> getCustomUserInfoDefinitions(int fromIndex, int maxResults) throws SIdentityException {
        String methodName = "getCustomUserInfoDefinitions";
        this.logBeforeMethod("getCustomUserInfoDefinitions");
        try {
            List<SCustomUserInfoDefinition> listSCustomUserInfoDefinition = this.persistenceService.selectList(SelectDescriptorBuilder.getElements(SCustomUserInfoDefinition.class, "CustomUserInfoDefinition", fromIndex, maxResults));
            this.logAfterMethod("getCustomUserInfoDefinitions");
            return listSCustomUserInfoDefinition;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getCustomUserInfoDefinitions", e);
            throw new SIdentityException("Can't get the custom user info definitions", e);
        }
    }

    @Override
    public SCustomUserInfoDefinition getCustomUserInfoDefinition(long customUserInfoDefinitionId) throws SIdentityException {
        String methodName = "getCustomUserInfoDefinition";
        this.logBeforeMethod("getCustomUserInfoDefinition");
        try {
            SCustomUserInfoDefinition selectOne = this.persistenceService.selectById(SelectDescriptorBuilder.getElementById(SCustomUserInfoDefinition.class, "CustomUserInfoDefinition", customUserInfoDefinitionId));
            if (selectOne == null) {
                throw new SIdentityException("Can't get the custom user info definition with id " + customUserInfoDefinitionId, null);
            }
            this.logAfterMethod("getCustomUserInfoDefinition");
            return selectOne;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getCustomUserInfoDefinition", e);
            throw new SIdentityException("Can't get the custom user info definition with id " + customUserInfoDefinitionId, e);
        }
    }

    @Override
    public List<SCustomUserInfoDefinition> getCustomUserInfoDefinitions(List<Long> customUserInfoDefinitionIds) throws SIdentityException {
        String methodName = "getCustomUserInfoDefinitions";
        this.logBeforeMethod("getCustomUserInfoDefinitions");
        if (customUserInfoDefinitionIds == null || customUserInfoDefinitionIds.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            List<SCustomUserInfoDefinition> listSCustomUserInfoDefinition = this.persistenceService.selectList(SelectDescriptorBuilder.getElementsByIds(SCustomUserInfoDefinition.class, "SCustomUserInfoDefinition", customUserInfoDefinitionIds));
            this.logAfterMethod("getCustomUserInfoDefinitions");
            return listSCustomUserInfoDefinition;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getCustomUserInfoDefinitions", e);
            throw new SIdentityException("Can't get custom user info definitions with ids " + Arrays.toString(customUserInfoDefinitionIds.toArray()), e);
        }
    }

    @Override
    public SCustomUserInfoValue getCustomUserInfoValue(long customUserInfoValueId) throws SCustomUserInfoValueNotFoundException, SCustomUserInfoValueReadException {
        String methodName = "getCustomUserInfoValue";
        this.logBeforeMethod("getCustomUserInfoValue");
        try {
            SCustomUserInfoValue selectOne = this.persistenceService.selectById(SelectDescriptorBuilder.getElementById(SCustomUserInfoValue.class, "SCustomUserInfoValue", customUserInfoValueId));
            if (selectOne == null) {
                throw new SCustomUserInfoValueNotFoundException(customUserInfoValueId);
            }
            this.logAfterMethod("getCustomUserInfoValue");
            return selectOne;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getCustomUserInfoValue", e);
            throw new SCustomUserInfoValueReadException(e);
        }
    }

    @Override
    public List<SCustomUserInfoValue> getCustomUserInfoValues(List<Long> customUserInfoValueIds) throws SIdentityException {
        String methodName = "getCustomUserInfoValues";
        this.logBeforeMethod("getCustomUserInfoValues");
        if (customUserInfoValueIds == null || customUserInfoValueIds.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            this.logAfterMethod("getCustomUserInfoValues");
            return this.persistenceService.selectList(SelectDescriptorBuilder.getElementsByIds(SCustomUserInfoValue.class, "SCustomUserInfoValue", customUserInfoValueIds));
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getCustomUserInfoValues", e);
            throw new SIdentityException("Can't get custom user info values with ids " + Arrays.toString(customUserInfoValueIds.toArray()), e);
        }
    }

    @Override
    public SRole getRole(long roleId) throws SRoleNotFoundException {
        String methodName = "getRole";
        this.logBeforeMethod("getRole");
        try {
            SRole selectOne = this.persistenceService.selectById(SelectDescriptorBuilder.getElementById(SRole.class, "Role", roleId));
            if (selectOne == null) {
                throw new SRoleNotFoundException("The role with id= " + roleId + " does not exist");
            }
            this.logAfterMethod("getRole");
            return selectOne;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getRole", e);
            throw new SRoleNotFoundException(e);
        }
    }

    @Override
    public SRole getRoleByName(String roleName) throws SRoleNotFoundException {
        String methodName = "getRoleByName";
        this.logBeforeMethod("getRoleByName");
        try {
            SRole role = this.persistenceService.selectOne(SelectDescriptorBuilder.getRoleByName(roleName));
            if (role == null) {
                throw new SRoleNotFoundException("The role named " + roleName + " does not exist");
            }
            this.logAfterMethod("getRoleByName");
            return role;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getRoleByName", e);
            throw new SRoleNotFoundException(e);
        }
    }

    @Override
    public SGroup getGroupByPath(String groupPath) throws SGroupNotFoundException {
        SelectOneDescriptor<SGroup> descriptor;
        String groupName;
        String methodName = "getGroupByPath";
        this.logBeforeMethod("getGroupByPath");
        int lastIndexOf = groupPath.lastIndexOf(47);
        if (lastIndexOf > 0) {
            groupName = groupPath.substring(lastIndexOf + 1);
            String parentPath = groupPath.substring(0, lastIndexOf);
            descriptor = SelectDescriptorBuilder.getGroupByPath(parentPath, groupName);
        } else if (lastIndexOf == 0) {
            groupName = groupPath.substring(lastIndexOf + 1);
            descriptor = SelectDescriptorBuilder.getGroupByName(groupName);
        } else {
            descriptor = SelectDescriptorBuilder.getGroupByName(groupPath);
        }
        try {
            SGroup group = this.persistenceService.selectOne(descriptor);
            if (group == null) {
                throw new SGroupNotFoundException("The group '" + groupPath + "' does not exist");
            }
            this.logAfterMethod("getGroupByPath");
            return group;
        }
        catch (SBonitaReadException bre) {
            this.logOnExceptionMethod("getGroupByPath", bre);
            throw new SGroupNotFoundException(bre);
        }
    }

    @Override
    public List<SRole> getRoles(int fromIndex, int numberOfRoles) throws SIdentityException {
        String methodName = "getRoles";
        this.logBeforeMethod("getRoles");
        try {
            List<SRole> listSRole = this.persistenceService.selectList(SelectDescriptorBuilder.getElements(SRole.class, "Role", fromIndex, numberOfRoles));
            this.logAfterMethod("getRoles");
            return listSRole;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getRoles", e);
            throw new SIdentityException("Can't get the roles", e);
        }
    }

    @Override
    public List<SRole> getRoles(int fromIndex, int numberOfRoles, String field, OrderByType order) throws SIdentityException {
        String methodName = "getRoles";
        this.logBeforeMethod("getRoles");
        try {
            List<SRole> listSRole = this.persistenceService.selectList(SelectDescriptorBuilder.getElements(SRole.class, "Role", field, order, fromIndex, numberOfRoles));
            this.logAfterMethod("getRoles");
            return listSRole;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getRoles", e);
            throw new SIdentityException("Can't get the roles", e);
        }
    }

    @Override
    public List<SRole> getRoles(List<Long> roleIds) throws SRoleNotFoundException {
        String methodName = "getRoles";
        this.logBeforeMethod("getRoles");
        if (roleIds == null || roleIds.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            List<SRole> listSRoles = this.persistenceService.selectList(SelectDescriptorBuilder.getElementsByIds(SRole.class, "Role", roleIds));
            this.logAfterMethod("getRoles");
            return listSRoles;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getRoles", e);
            throw new SRoleNotFoundException(e);
        }
    }

    @Override
    public SUser getUser(long userId) throws SUserNotFoundException {
        String methodName = "getUser";
        this.logBeforeMethod("getUser");
        try {
            SUser user = this.persistenceService.selectById(SelectDescriptorBuilder.getElementById(SUser.class, "User", userId));
            if (user == null) {
                throw new SUserNotFoundException(userId);
            }
            this.logAfterMethod("getUser");
            return user;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getUser", e);
            throw new SUserNotFoundException("Cannot get user with id: " + userId, e);
        }
    }

    @Override
    public SContactInfo getUserContactInfo(long userId, boolean isPersonal) throws SIdentityException {
        String methodName = "getUserContactInfo";
        this.logBeforeMethod("getUserContactInfo");
        try {
            SContactInfo contactInfo = this.persistenceService.selectOne(SelectDescriptorBuilder.getUserContactInfo(userId, isPersonal));
            this.logAfterMethod("getUserContactInfo");
            return contactInfo;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getUserContactInfo", e);
            throw new SUserNotFoundException("Cannot get user contact info for user id: " + userId, e);
        }
    }

    @Override
    public SUser getUserByUserName(String userName) throws SUserNotFoundException {
        String methodName = "getUserByUserName";
        this.logBeforeMethod("getUserByUserName");
        try {
            SUser user = this.persistenceService.selectOne(SelectDescriptorBuilder.getUserByUserName(userName));
            if (user == null) {
                throw new SUserNotFoundException(userName);
            }
            this.logAfterMethod("getUserByUserName");
            return user;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getUserByUserName", e);
            throw new SUserNotFoundException("Cannot get user: " + userName, e);
        }
    }

    @Override
    public SUserMembership getUserMembership(long userMembershipId) throws SIdentityException {
        String methodName = "getUserMembership";
        this.logBeforeMethod("getUserMembership");
        try {
            Map<String, Object> parameters = Collections.singletonMap("id", userMembershipId);
            SelectOneDescriptor desc = new SelectOneDescriptor("getSUserMembershipById", parameters, SUserMembership.class);
            SUserMembership selectOne = (SUserMembership)this.persistenceService.selectOne(desc);
            if (selectOne == null) {
                throw new SIdentityException("Can't get the userMembership with id " + userMembershipId, null);
            }
            this.logAfterMethod("getUserMembership");
            return selectOne;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getUserMembership", e);
            throw new SIdentityException("Can't get the user membership with id " + userMembershipId, e);
        }
    }

    @Override
    public List<SUserMembership> getUserMembershipsOfUser(long userId) throws SIdentityException {
        String methodName = "getUserMembershipsOfUser";
        this.logBeforeMethod("getUserMembershipsOfUser");
        try {
            List<SUserMembership> listSUserMembership = this.persistenceService.selectList(SelectDescriptorBuilder.getUserMembershipsOfUser(userId));
            this.logAfterMethod("getUserMembershipsOfUser");
            return listSUserMembership;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getUserMembershipsOfUser", e);
            throw new SIdentityException("Can't get memberships of user: " + userId, e);
        }
    }

    @Override
    public List<SUserMembership> getUserMemberships(List<Long> userMembershipIds) throws SIdentityException {
        String methodName = "getUserMemberships";
        this.logBeforeMethod("getUserMemberships");
        List<Long> localUserMembershipIds = userMembershipIds;
        if (localUserMembershipIds == null || localUserMembershipIds.isEmpty()) {
            localUserMembershipIds = Collections.emptyList();
        }
        try {
            List<SUserMembership> listSUserMembership = this.persistenceService.selectList(SelectDescriptorBuilder.getElementsByIds(SUserMembership.class, "SUserMembership", localUserMembershipIds));
            this.logAfterMethod("getUserMemberships");
            return listSUserMembership;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getUserMemberships", e);
            throw new SIdentityException("Can't get users memberships with ids " + Arrays.toString(localUserMembershipIds.toArray()), e);
        }
    }

    @Override
    public List<SUser> getUsers(int fromIndex, int numberOfUsers) throws SIdentityException {
        String methodName = "getUsers";
        this.logBeforeMethod("getUsers");
        try {
            List<SUser> listSUsers = this.persistenceService.selectList(SelectDescriptorBuilder.getElements(SUser.class, "User", fromIndex, numberOfUsers));
            this.logAfterMethod("getUsers");
            return listSUsers;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getUsers", e);
            throw new SIdentityException("Can't get the users", e);
        }
    }

    @Override
    public List<SUser> getUsers(int fromIndex, int numberOfUsers, String field, OrderByType order) throws SIdentityException {
        String methodName = "getUsers";
        this.logBeforeMethod("getUsers");
        try {
            List<SUser> listsUsers = this.persistenceService.selectList(SelectDescriptorBuilder.getElements(SUser.class, "User", field, order, fromIndex, numberOfUsers));
            this.logAfterMethod("getUsers");
            return listsUsers;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getUsers", e);
            throw new SIdentityException("Can't get the users", e);
        }
    }

    @Override
    public List<SUser> getUsers(List<Long> userIds) throws SUserNotFoundException {
        String methodName = "getUsers";
        this.logBeforeMethod("getUsers");
        if (userIds == null || userIds.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            List<SUser> listsUsers = this.persistenceService.selectList(SelectDescriptorBuilder.getElementsByIds(SUser.class, "User", userIds));
            this.logAfterMethod("getUsers");
            return listsUsers;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getUsers", e);
            throw new SUserNotFoundException(e);
        }
    }

    @Override
    public List<SUser> getUsersByUsername(List<String> userNames) throws SIdentityException {
        String methodName = "getUsersByUsername";
        this.logBeforeMethod("getUsersByUsername");
        if (userNames == null || userNames.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            Map<String, Object> parameters = Collections.singletonMap("userNames", userNames);
            List<SUser> users = this.persistenceService.selectList(new SelectListDescriptor("getUsersByName", parameters, SUser.class));
            this.logAfterMethod("getUsersByUsername");
            return users;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getUsersByUsername", e);
            throw new SUserNotFoundException(e);
        }
    }

    @Override
    public List<SUser> getUsersByDelegee(long delegateId) throws SIdentityException {
        String methodName = "getUsersByDelegee";
        this.logBeforeMethod("getUsersByDelegee");
        try {
            SUser delegee = this.getUser(delegateId);
            List<SUser> listsUsers = this.persistenceService.selectList(SelectDescriptorBuilder.getUsersByDelegee(delegee.getUserName()));
            this.logAfterMethod("getUsersByDelegee");
            return listsUsers;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getUsersByDelegee", e);
            throw new SIdentityException("Can't get the users having the delegee " + delegateId, e);
        }
    }

    @Override
    public List<SUser> getUsersByGroup(long groupId) throws SIdentityException {
        String methodName = "getUsersByGroup";
        this.logBeforeMethod("getUsersByGroup");
        try {
            List<SUser> listsUsers = this.persistenceService.selectList(SelectDescriptorBuilder.getUsersByGroup(groupId));
            this.logAfterMethod("getUsersByGroup");
            return listsUsers;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getUsersByGroup", e);
            throw new SIdentityException("Can't get the users having the group " + groupId, e);
        }
    }

    @Override
    public List<SUser> getUsersByGroup(long groupId, int fromIndex, int numberOfUsers) throws SIdentityException {
        String methodName = "getUsersByGroup";
        this.logBeforeMethod("getUsersByGroup");
        try {
            List<SUser> listsUsers = this.persistenceService.selectList(SelectDescriptorBuilder.getUsersByGroup(groupId, fromIndex, numberOfUsers));
            this.logAfterMethod("getUsersByGroup");
            return listsUsers;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getUsersByGroup", e);
            throw new SIdentityException("Can't get the users having the group " + groupId, e);
        }
    }

    @Override
    public List<SUser> getUsersByGroup(long groupId, int fromIndex, int numberOfUsers, String field, OrderByType order) throws SIdentityException {
        String methodName = "getUsersByGroup";
        this.logBeforeMethod("getUsersByGroup");
        try {
            List<SUser> listsSUsers = this.persistenceService.selectList(SelectDescriptorBuilder.getUsersByGroup(groupId, field, order, fromIndex, numberOfUsers));
            this.logAfterMethod("getUsersByGroup");
            return listsSUsers;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getUsersByGroup", e);
            throw new SIdentityException("Can't get the users having the group " + groupId, e);
        }
    }

    @Override
    public List<SUser> getUsersByManager(long managerId) throws SIdentityException {
        String methodName = "getUsersByManager";
        this.logBeforeMethod("getUsersByManager");
        try {
            List<SUser> listsSUsers = this.persistenceService.selectList(SelectDescriptorBuilder.getUsersByManager(managerId));
            this.logAfterMethod("getUsersByManager");
            return listsSUsers;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getUsersByManager", e);
            throw new SIdentityException("Can't get the users having the manager " + managerId, e);
        }
    }

    @Override
    public List<SUser> getUsersByRole(long roleId) throws SIdentityException {
        String methodName = "getUsersByRole";
        this.logBeforeMethod("getUsersByRole");
        try {
            List<SUser> listsUsers = this.persistenceService.selectList(SelectDescriptorBuilder.getUsersByRole(roleId));
            this.logAfterMethod("getUsersByRole");
            return listsUsers;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getUsersByRole", e);
            throw new SIdentityException("Can't get the users having the role " + roleId, e);
        }
    }

    @Override
    public List<SUser> getUsersByRole(long roleId, int fromIndex, int numberOfUsers) throws SIdentityException {
        String methodName = "getUsersByRole";
        this.logBeforeMethod("getUsersByRole");
        try {
            List<SUser> listsSUsers = this.persistenceService.selectList(SelectDescriptorBuilder.getUsersByRole(roleId, fromIndex, numberOfUsers));
            this.logAfterMethod("getUsersByRole");
            return listsSUsers;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getUsersByRole", e);
            throw new SIdentityException("Can't get the users having the role " + roleId, e);
        }
    }

    @Override
    public List<SUser> getUsersByRole(long roleId, int fromIndex, int numberOfUsers, String field, OrderByType order) throws SIdentityException {
        String methodName = "getUsersByRole";
        this.logBeforeMethod("getUsersByRole");
        try {
            List<SUser> listsUsers = this.persistenceService.selectList(SelectDescriptorBuilder.getUsersByRole(roleId, field, order, fromIndex, numberOfUsers));
            this.logAfterMethod("getUsersByRole");
            return listsUsers;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getUsersByRole", e);
            throw new SIdentityException("Can't get the users having the role " + roleId, e);
        }
    }

    @Override
    public void updateGroup(SGroup group, EntityUpdateDescriptor descriptor) throws SIdentityException {
        String methodName = "updateGroup";
        this.logBeforeMethod("updateGroup");
        SGroupLogBuilder logBuilder = this.getGroupLog(ActionType.UPDATED, "Updating the group");
        try {
            UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)group, descriptor);
            SUpdateEvent updateEvent = null;
            if (this.eventService.hasHandlers("GROUP", EventActionType.UPDATED)) {
                updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent("GROUP").setObject(group).done();
            }
            this.recorder.recordUpdate(updateRecord, updateEvent);
            this.initiateLogBuilder(group.getId(), 1, logBuilder, "updateGroup");
            this.logAfterMethod("updateGroup");
        }
        catch (SRecorderException e) {
            this.logOnExceptionMethod("updateGroup", e);
            this.initiateLogBuilder(group.getId(), 0, logBuilder, "updateGroup");
            throw new SIdentityException("Can't update group " + group, e);
        }
    }

    @Override
    public void updateCustomUserInfoDefinition(SCustomUserInfoDefinition customUserInfo, EntityUpdateDescriptor descriptor) throws SIdentityException {
        String methodName = "updateCustomUserInfoDefinition";
        this.logBeforeMethod("updateCustomUserInfoDefinition");
        SCustomUserInfoDefinitionLogBuilder logBuilder = this.getSCustomUserInfoDefinitionLog(ActionType.UPDATED, "Updating the custom user info definition with name " + customUserInfo.getName());
        try {
            UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)customUserInfo, descriptor);
            SUpdateEvent updateEvent = null;
            if (this.eventService.hasHandlers("CUSTOM_USER_INFO_DEFINITION", EventActionType.UPDATED)) {
                updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent("CUSTOM_USER_INFO_DEFINITION").setObject(customUserInfo).done();
            }
            this.recorder.recordUpdate(updateRecord, updateEvent);
            this.initiateLogBuilder(customUserInfo.getId(), 1, logBuilder, "updateCustomUserInfoDefinition");
            this.logAfterMethod("updateCustomUserInfoDefinition");
        }
        catch (SRecorderException e) {
            this.logOnExceptionMethod("updateCustomUserInfoDefinition", e);
            this.initiateLogBuilder(customUserInfo.getId(), 0, logBuilder, "updateCustomUserInfoDefinition");
            throw new SIdentityException("Can't update custom user info definition " + customUserInfo, e);
        }
    }

    @Override
    public void updateCustomUserInfoValue(SCustomUserInfoValue customUserInfo, EntityUpdateDescriptor descriptor) throws SIdentityException {
        String methodName = "updateCustomUserInfoValue";
        this.logBeforeMethod("updateCustomUserInfoValue");
        try {
            UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)customUserInfo, descriptor);
            SUpdateEvent updateEvent = null;
            if (this.eventService.hasHandlers("CUSTOM_USER_INFO_VALUE", EventActionType.UPDATED)) {
                updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent("CUSTOM_USER_INFO_VALUE").setObject(customUserInfo).done();
            }
            this.recorder.recordUpdate(updateRecord, updateEvent);
            this.logAfterMethod("updateCustomUserInfoValue");
        }
        catch (SRecorderException e) {
            this.logOnExceptionMethod("updateCustomUserInfoValue", e);
            throw new SIdentityException("Can't update custom user info definition " + customUserInfo, e);
        }
    }

    @Override
    public void updateRole(SRole role, EntityUpdateDescriptor descriptor) throws SIdentityException {
        String methodName = "updateRole";
        this.logBeforeMethod("updateRole");
        SRoleLogBuilder logBuilder = this.getRoleLog(ActionType.UPDATED, "Updating the role with name " + role.getName());
        try {
            UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)role, descriptor);
            SUpdateEvent updateEvent = null;
            if (this.eventService.hasHandlers("ROLE", EventActionType.UPDATED)) {
                updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent("ROLE").setObject(role).done();
            }
            this.recorder.recordUpdate(updateRecord, updateEvent);
            this.logAfterMethod("updateRole");
            this.initiateLogBuilder(role.getId(), 0, logBuilder, "updateRole");
        }
        catch (SRecorderException e) {
            this.logOnExceptionMethod("updateRole", e);
            this.initiateLogBuilder(role.getId(), 0, logBuilder, "updateRole");
            throw new SIdentityException("Can't update role " + role, e);
        }
    }

    @Override
    public void updateUser(SUser user, EntityUpdateDescriptor descriptor) throws SUserUpdateException {
        this.updateUser(user, descriptor, false);
    }

    @Override
    @Deprecated
    public void updateUser(SUser user, EntityUpdateDescriptor descriptor, boolean isPasswordEncrypted) throws SUserUpdateException {
        String password;
        String methodName = "updateUser";
        this.logBeforeMethod("updateUser");
        StringBuilder sb = new StringBuilder();
        sb.append("Updating user with user name ");
        sb.append(user.getUserName());
        sb.append(", first name ");
        sb.append(user.getFirstName());
        sb.append(", last name ");
        sb.append(user.getLastName());
        if (!isPasswordEncrypted && (password = (String)descriptor.getFields().get("password")) != null) {
            String hash = this.encrypter.hash(password);
            descriptor.getFields().put("password", hash);
        }
        SUserLogBuilder logBuilder = this.getUserLog(ActionType.UPDATED, sb.toString());
        try {
            UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)user, descriptor);
            SUpdateEvent updateEvent = null;
            if (this.eventService.hasHandlers("USER", EventActionType.UPDATED)) {
                updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent("USER").setObject(user).done();
                SUser oldUser = BuilderFactory.get(SUserBuilderFactory.class).createNewInstance(user).done();
                updateEvent.setOldObject(oldUser);
            }
            this.recorder.recordUpdate(updateRecord, updateEvent);
            this.initiateLogBuilder(user.getId(), 1, logBuilder, "updateUser");
            this.logAfterMethod("updateUser");
        }
        catch (SRecorderException re) {
            this.logOnExceptionMethod("updateUser", re);
            this.initiateLogBuilder(user.getId(), 0, logBuilder, "updateUser");
            throw new SUserUpdateException(re);
        }
    }

    @Override
    public void updateUserContactInfo(SContactInfo contactInfo, EntityUpdateDescriptor descriptor) throws SIdentityException {
        String methodName = "updateUserContactInfo";
        this.logBeforeMethod("updateUserContactInfo");
        StringBuilder sb = new StringBuilder();
        sb.append("Updating " + (contactInfo.isPersonal() ? "personal" : "professional") + " user contact Info for user with Id ");
        sb.append(contactInfo.getUserId());
        SContactInfoLogBuilder logBuilder = this.getUserContactInfoLog(ActionType.UPDATED, sb.toString(), contactInfo);
        try {
            UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)contactInfo, descriptor);
            SUpdateEvent updateEvent = null;
            if (this.eventService.hasHandlers("USER_CONTACT_INFO", EventActionType.UPDATED)) {
                updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent("USER_CONTACT_INFO").setObject(contactInfo).done();
                SContactInfo oldContactInfo = BuilderFactory.get(SContactInfoBuilderFactory.class).createNewInstance(contactInfo).done();
                updateEvent.setOldObject(oldContactInfo);
            }
            this.recorder.recordUpdate(updateRecord, updateEvent);
            this.initiateLogBuilder(contactInfo.getId(), 1, logBuilder, "updateUserContactInfo");
            this.logAfterMethod("updateUserContactInfo");
        }
        catch (SRecorderException re) {
            this.logOnExceptionMethod("updateUserContactInfo", re);
            this.initiateLogBuilder(contactInfo.getId(), 0, logBuilder, "updateUserContactInfo");
            throw new SUserUpdateException(re);
        }
    }

    @Override
    public void updateUserMembership(SUserMembership userMembership, EntityUpdateDescriptor descriptor) throws SIdentityException {
        String methodName = "updateUserMembership";
        this.logBeforeMethod("updateUserMembership");
        StringBuilder sb = new StringBuilder();
        sb.append("Updating user membership for user ");
        sb.append(userMembership.getUsername());
        sb.append(" with role ");
        sb.append(userMembership.getRoleName());
        sb.append(" in group ");
        sb.append(userMembership.getGroupName());
        SUserMembershipLogBuilder logBuilder = this.getUserMembershipLog(ActionType.UPDATED, sb.toString(), userMembership);
        try {
            UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)userMembership, descriptor);
            SUpdateEvent updateEvent = null;
            if (this.eventService.hasHandlers("USERMEMBERSHIP", EventActionType.UPDATED)) {
                updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent("USERMEMBERSHIP").setObject(userMembership).done();
            }
            this.recorder.recordUpdate(updateRecord, updateEvent);
            this.logAfterMethod("updateUserMembership");
            this.initiateLogBuilder(userMembership.getId(), 1, logBuilder, "updateUserMembership");
        }
        catch (SRecorderException e) {
            this.logOnExceptionMethod("updateUserMembership", e);
            this.initiateLogBuilder(userMembership.getId(), 0, logBuilder, "updateUserMembership");
            throw new SIdentityException("Can't update user membership " + userMembership, e);
        }
    }

    @Override
    public List<SUserMembership> getUserMemberships(int fromIndex, int numberOfUserMemberships) throws SIdentityException {
        String methodName = "getUserMemberships";
        this.logBeforeMethod("getUserMemberships");
        SelectListDescriptor<SUserMembership> descriptor = SelectDescriptorBuilder.getElements(SUserMembership.class, "UserMembership", fromIndex, numberOfUserMemberships);
        try {
            List<SUserMembership> listsUserMemberships = this.persistenceService.selectList(descriptor);
            this.logAfterMethod("getUserMemberships");
            return listsUserMemberships;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getUserMemberships", e);
            throw new SIdentityException("Can't get the user memberships", e);
        }
    }

    @Override
    public List<SUserMembership> getUserMembershipsOfUser(long userId, int fromIndex, int numberOfUsers) throws SIdentityException {
        String methodName = "getUserMembershipsOfUser";
        this.logBeforeMethod("getUserMembershipsOfUser");
        try {
            SelectListDescriptor<SUserMembership> descriptor = SelectDescriptorBuilder.getUserMembershipsOfUser(userId, fromIndex, numberOfUsers);
            List<SUserMembership> listsSUserMemberships = this.persistenceService.selectList(descriptor);
            this.logAfterMethod("getUserMembershipsOfUser");
            return listsSUserMemberships;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getUserMembershipsOfUser", e);
            throw new SIdentityException("Can't get the memberships having the user " + userId, e);
        }
    }

    @Override
    public List<SUserMembership> getUserMembershipsOfUser(long userId, int fromIndex, int numberOfMemberships, String field, OrderByType order) throws SIdentityException {
        String methodName = "getUserMembershipsOfUser";
        this.logBeforeMethod("getUserMembershipsOfUser");
        try {
            SelectListDescriptor<SUserMembership> descriptor = SelectDescriptorBuilder.getUserMembershipsOfUser(userId, field, order, fromIndex, numberOfMemberships);
            List<SUserMembership> listsSUserMemberships = this.persistenceService.selectList(descriptor);
            this.logAfterMethod("getUserMembershipsOfUser");
            return listsSUserMemberships;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getUserMembershipsOfUser", e);
            throw new SIdentityException("Can't get the memberships having the user" + userId, e);
        }
    }

    @Override
    public List<SUserMembership> getUserMembershipsOfUser(long userId, int fromIndex, int numberPerPage, OrderByOption orderByOption) throws SIdentityException {
        String methodName = "getUserMembershipsOfUser";
        this.logBeforeMethod("getUserMembershipsOfUser");
        try {
            SelectListDescriptor<SUserMembership> descriptor = SelectDescriptorBuilder.getUserMembershipsOfUser(userId, new QueryOptions(fromIndex, numberPerPage, Collections.singletonList(orderByOption)));
            List<SUserMembership> listsUserMemberships = this.persistenceService.selectList(descriptor);
            this.logAfterMethod("getUserMembershipsOfUser");
            return listsUserMemberships;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getUserMembershipsOfUser", e);
            throw new SIdentityException("Can't get the memberships having the user" + userId, e);
        }
    }

    @Override
    public SUserMembership getUserMembership(long userId, long groupId, long roleId) throws SIdentityException {
        String methodName = "getUserMembership";
        this.logBeforeMethod("getUserMembership");
        SelectOneDescriptor<SUserMembership> descriptor = SelectDescriptorBuilder.getUserMembership(userId, groupId, roleId);
        try {
            SUserMembership sUserMembership = this.getUserMembership(userId, groupId, roleId, descriptor);
            this.logAfterMethod("getUserMembership");
            return sUserMembership;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getUserMembership", e);
            throw new SIdentityException("Can't get the userMembership with userId = " + userId + ", groupId = " + groupId + ", roleId = " + roleId, e);
        }
    }

    @Override
    public SUserMembership getLightUserMembership(long userId, long groupId, long roleId) throws SIdentityException {
        String methodName = "getLightUserMembership";
        this.logBeforeMethod("getLightUserMembership");
        SelectOneDescriptor<SUserMembership> descriptor = SelectDescriptorBuilder.getLightUserMembership(userId, groupId, roleId);
        try {
            SUserMembership sUserMembership = this.getUserMembership(userId, groupId, roleId, descriptor);
            this.logAfterMethod("getLightUserMembership");
            return sUserMembership;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getLightUserMembership", e);
            throw new SIdentityException("Can't get the userMembership with userId = " + userId + ", groupId = " + groupId + ", roleId = " + roleId, e);
        }
    }

    private SUserMembership getUserMembership(long userId, long groupId, long roleId, SelectOneDescriptor<SUserMembership> descriptor) throws SBonitaReadException, SIdentityException {
        SUserMembership sUserMembership = this.persistenceService.selectOne(descriptor);
        if (sUserMembership == null) {
            throw new SIdentityException("Can't get the userMembership with userId = " + userId + ", groupId = " + groupId + ", roleId = " + roleId);
        }
        return sUserMembership;
    }

    @Override
    public long getNumberOfUserMemberships() throws SIdentityException {
        String methodName = "getNumberOfUserMemberships";
        this.logBeforeMethod("getNumberOfUserMemberships");
        try {
            long number = this.persistenceService.selectOne(SelectDescriptorBuilder.getNumberOfElement("UserMembership", SUserMembership.class));
            this.logAfterMethod("getNumberOfUserMemberships");
            return number;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getNumberOfUserMemberships", e);
            throw new SIdentityException("Can't get the number of user membership", e);
        }
    }

    @Override
    public List<SUserMembership> getLightUserMemberships(int startIndex, int numberOfElements) throws SIdentityException {
        String methodName = "getLightUserMemberships";
        this.logBeforeMethod("getLightUserMemberships");
        SelectListDescriptor<SUserMembership> descriptor = SelectDescriptorBuilder.getElements(SUserMembership.class, "LightUserMembership", startIndex, numberOfElements);
        try {
            List<SUserMembership> listsUserMemberships = this.persistenceService.selectList(descriptor);
            this.logAfterMethod("getLightUserMemberships");
            return listsUserMemberships;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getLightUserMemberships", e);
            throw new SIdentityException("Can't get the user memberships", e);
        }
    }

    @Override
    public long getNumberOfUsers(QueryOptions options) throws SBonitaSearchException {
        String methodName = "getNumberOfUsers";
        this.logBeforeMethod("getNumberOfUsers");
        try {
            long number = this.persistenceService.getNumberOfEntities(SUser.class, options, null);
            this.logAfterMethod("getNumberOfUsers");
            return number;
        }
        catch (SBonitaReadException bre) {
            this.logOnExceptionMethod("getNumberOfUsers", bre);
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public List<SUser> searchUsers(QueryOptions options) throws SBonitaSearchException {
        String methodName = "searchUsers";
        this.logBeforeMethod("searchUsers");
        try {
            List<SUser> listsSUsers = this.persistenceService.searchEntity(SUser.class, options, null);
            this.logAfterMethod("searchUsers");
            return listsSUsers;
        }
        catch (SBonitaReadException bre) {
            this.logOnExceptionMethod("searchUsers", bre);
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public long getNumberOfRoles(QueryOptions options) throws SBonitaSearchException {
        String methodName = "getNumberOfRoles";
        this.logBeforeMethod("getNumberOfRoles");
        try {
            long number = this.persistenceService.getNumberOfEntities(SRole.class, options, null);
            this.logAfterMethod("getNumberOfRoles");
            return number;
        }
        catch (SBonitaReadException bre) {
            this.logOnExceptionMethod("getNumberOfRoles", bre);
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public List<SRole> searchRoles(QueryOptions options) throws SBonitaSearchException {
        String methodName = "searchRoles";
        this.logBeforeMethod("searchRoles");
        try {
            List<SRole> listsRoles = this.persistenceService.searchEntity(SRole.class, options, null);
            this.logAfterMethod("searchRoles");
            return listsRoles;
        }
        catch (SBonitaReadException bre) {
            this.logOnExceptionMethod("searchRoles", bre);
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public long getNumberOfGroups(QueryOptions options) throws SBonitaSearchException {
        String methodName = "getNumberOfGroups";
        this.logBeforeMethod("getNumberOfGroups");
        try {
            long number = this.persistenceService.getNumberOfEntities(SGroup.class, options, null);
            this.logAfterMethod("getNumberOfGroups");
            return number;
        }
        catch (SBonitaReadException bre) {
            this.logOnExceptionMethod("getNumberOfGroups", bre);
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public List<SGroup> searchGroups(QueryOptions options) throws SBonitaSearchException {
        String methodName = "searchGroups";
        this.logBeforeMethod("searchGroups");
        try {
            List<SGroup> listsGroups = this.persistenceService.searchEntity(SGroup.class, options, null);
            this.logAfterMethod("searchGroups");
            return listsGroups;
        }
        catch (SBonitaReadException bre) {
            this.logOnExceptionMethod("searchGroups", bre);
            throw new SBonitaSearchException(bre);
        }
    }

    private void initiateLogBuilder(long objectId, int sQueriableLogStatus, SPersistenceLogBuilder logBuilder, String methodName) {
        logBuilder.actionScope(String.valueOf(objectId));
        logBuilder.actionStatus(sQueriableLogStatus);
        logBuilder.objectId(objectId);
        SQueriableLog log = logBuilder.done();
        if (this.queriableLoggerService.isLoggable(log.getActionType(), log.getSeverity())) {
            this.queriableLoggerService.log(this.getClass().getName(), methodName, log);
        }
    }

    @Override
    public boolean chechCredentials(SUser user, String password) {
        String hashPassword = user.getPassword();
        return this.encrypter.check(password, hashPassword);
    }

    @Override
    @Deprecated
    public SUser createUserWithoutEncryptingPassword(SUser user) throws SUserCreationException {
        String methodName = "createUserWithoutEncryptingPassword";
        this.logBeforeMethod("createUserWithoutEncryptingPassword");
        String message = "Adding a new user with user name " + user.getUserName() + ", first name " + user.getFirstName() + ", last name " + user.getLastName();
        SUserLogBuilder logBuilder = this.getUserLog(ActionType.CREATED, message);
        SUser hashedUser = BuilderFactory.get(SUserBuilderFactory.class).createNewInstance(user).done();
        try {
            InsertRecord insertRecord = new InsertRecord(hashedUser);
            SInsertEvent insertEvent = this.getInsertEvent(hashedUser, "USER");
            this.recorder.recordInsert(insertRecord, insertEvent);
            this.initiateLogBuilder(hashedUser.getId(), 1, logBuilder, "createUserWithoutEncryptingPassword");
            this.logAfterMethod("createUserWithoutEncryptingPassword");
            return hashedUser;
        }
        catch (SRecorderException re) {
            this.logOnExceptionMethod("createUserWithoutEncryptingPassword", re);
            this.initiateLogBuilder(hashedUser.getId(), 0, logBuilder, "createUserWithoutEncryptingPassword");
            throw new SUserCreationException(re);
        }
    }

    private void logBeforeMethod(String methodName) {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), methodName));
        }
    }

    private void logAfterMethod(String methodName) {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), methodName));
        }
    }

    private void logOnExceptionMethod(String methodName, SBonitaException re) {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), methodName, re));
        }
    }

    @Override
    public List<SCustomUserInfoValue> searchCustomUserInfoValue(QueryOptions options) throws SBonitaSearchException {
        String methodName = "searchCustomUserInfoValue";
        this.logBeforeMethod("searchCustomUserInfoValue");
        try {
            List<SCustomUserInfoValue> result = this.persistenceService.searchEntity(SCustomUserInfoValue.class, options, null);
            this.logAfterMethod("searchCustomUserInfoValue");
            return result;
        }
        catch (SBonitaReadException bre) {
            this.logOnExceptionMethod("searchCustomUserInfoValue", bre);
            throw new SBonitaSearchException(bre);
        }
    }
}

