/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.profile.impl;

import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.engine.api.ImportError;
import org.bonitasoft.engine.profile.impl.ExportedProfileEntry;

public class ExportedParentProfileEntry
extends ExportedProfileEntry {
    private List<ExportedProfileEntry> childProfileEntries;

    public List<ExportedProfileEntry> getChildProfileEntries() {
        return this.childProfileEntries;
    }

    public void setChildProfileEntries(List<ExportedProfileEntry> childProfileEntries) {
        this.childProfileEntries = childProfileEntries;
    }

    public ExportedParentProfileEntry(String name) {
        super(name);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!this.compareExportedProfileEntry(obj)) {
            return false;
        }
        ExportedParentProfileEntry other = (ExportedParentProfileEntry)obj;
        return !(this.getChildProfileEntries() == null ? other.getChildProfileEntries() != null : !this.getChildProfileEntries().equals(other.getChildProfileEntries()));
    }

    public List<ImportError> getErrors() {
        List<ExportedProfileEntry> childProfileEntries;
        ArrayList<ImportError> errors = new ArrayList<ImportError>();
        if (this.hasError()) {
            errors.add(this.getError());
        }
        if ((childProfileEntries = this.getChildProfileEntries()) != null) {
            for (ExportedProfileEntry childEntry : childProfileEntries) {
                if (!childEntry.hasError()) continue;
                errors.add(childEntry.getError());
            }
        }
        if (errors.isEmpty()) {
            return null;
        }
        return errors;
    }

    public boolean hasErrors() {
        return this.getErrors() != null;
    }

    @Override
    public ImportError getError() {
        if (this.getName() == null) {
            return new ImportError(this.getName(), ImportError.Type.PAGE);
        }
        return null;
    }
}

