/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.scheduler.impl;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bonitasoft.engine.scheduler.SchedulerExecutor;
import org.bonitasoft.engine.scheduler.exception.SSchedulerException;
import org.bonitasoft.engine.scheduler.impl.AbstractJobListener;
import org.bonitasoft.engine.scheduler.impl.BonitaSchedulerFactory;
import org.bonitasoft.engine.scheduler.impl.ConcurrentQuartzJob;
import org.bonitasoft.engine.scheduler.impl.NonConcurrentQuartzJob;
import org.bonitasoft.engine.scheduler.impl.SchedulerServiceImpl;
import org.bonitasoft.engine.scheduler.trigger.CronTrigger;
import org.bonitasoft.engine.scheduler.trigger.RepeatTrigger;
import org.bonitasoft.engine.scheduler.trigger.Trigger;
import org.bonitasoft.engine.sessionaccessor.ReadSessionAccessor;
import org.bonitasoft.engine.sessionaccessor.STenantIdNotSetException;
import org.bonitasoft.engine.transaction.BonitaTransactionSynchronization;
import org.bonitasoft.engine.transaction.TransactionService;
import org.bonitasoft.engine.transaction.TransactionState;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.ListenerManager;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.core.QuartzScheduler;
import org.quartz.impl.matchers.GroupMatcher;

public class QuartzSchedulerExecutor
implements SchedulerExecutor {
    private Scheduler scheduler;
    private final BonitaSchedulerFactory schedulerFactory;
    private final ReadSessionAccessor sessionAccessor;
    private final TransactionService transactionService;
    private final boolean useOptimization;
    private QuartzScheduler quartzScheduler;
    private final List<AbstractJobListener> jobListeners;

    public QuartzSchedulerExecutor(BonitaSchedulerFactory schedulerFactory, List<AbstractJobListener> jobListeners, ReadSessionAccessor sessionAccessor, TransactionService transactionService, boolean useOptimization) {
        this.sessionAccessor = sessionAccessor;
        this.transactionService = transactionService;
        this.useOptimization = useOptimization;
        this.schedulerFactory = schedulerFactory;
        this.jobListeners = jobListeners;
    }

    @Override
    public void schedule(long jobId, long tenantId, String jobName, Trigger trigger, boolean disallowConcurrentExecution) throws SSchedulerException {
        try {
            this.checkSchedulerState();
            JobDetail jobDetail = this.getJobDetail(jobId, tenantId, jobName, disallowConcurrentExecution);
            JobKey jobKey = jobDetail.getKey();
            org.quartz.Trigger quartzTrigger = this.getQuartzTrigger(trigger, jobKey.getName(), jobKey.getGroup());
            this.scheduler.scheduleJob(jobDetail, quartzTrigger);
            if (this.useOptimization) {
                this.transactionService.registerBonitaSynchronization(new NotifyQuartzOfNewTrigger(trigger.getStartDate().getTime(), this.quartzScheduler));
            }
        }
        catch (Exception e) {
            throw new SSchedulerException(e);
        }
    }

    private JobDetail getJobDetail(long jobId, long tenantId, String jobName, boolean disallowConcurrentExecution) {
        Class clazz = null;
        clazz = disallowConcurrentExecution ? NonConcurrentQuartzJob.class : ConcurrentQuartzJob.class;
        JobDetail jobDetail = JobBuilder.newJob(clazz).withIdentity(jobName, String.valueOf(tenantId)).build();
        jobDetail.getJobDataMap().put("tenantId", String.valueOf(tenantId));
        jobDetail.getJobDataMap().put("jobId", String.valueOf(jobId));
        jobDetail.getJobDataMap().put("jobName", jobName);
        return jobDetail;
    }

    @Override
    public void executeNow(long jobId, long tenantId, String jobName, boolean disallowConcurrentExecution) throws SSchedulerException {
        try {
            this.checkSchedulerState();
            JobDetail jobDetail = this.getJobDetail(jobId, tenantId, jobName, disallowConcurrentExecution);
            this.scheduler.addJob(jobDetail, true);
            this.scheduler.triggerJob(jobDetail.getKey());
        }
        catch (Exception e) {
            throw new SSchedulerException(e);
        }
    }

    @Override
    public void executeAgain(long jobId, long tenantId, String jobName, boolean disallowConcurrentExecution) throws SSchedulerException {
        try {
            JobDetail jobDetail2 = this.scheduler.getJobDetail(new JobKey(jobName, String.valueOf(tenantId)));
            org.quartz.Trigger trigger = TriggerBuilder.newTrigger().withIdentity("OneShotTrigger" + UUID.randomUUID().getLeastSignificantBits(), String.valueOf(tenantId)).forJob(jobName, String.valueOf(tenantId)).startNow().build();
            if (jobDetail2 == null) {
                JobDetail jobDetail = this.getJobDetail(jobId, tenantId, jobName, disallowConcurrentExecution);
                this.scheduler.scheduleJob(jobDetail, trigger);
            } else {
                this.scheduler.scheduleJob(trigger);
            }
            if (this.useOptimization) {
                this.transactionService.registerBonitaSynchronization(new NotifyQuartzOfNewTrigger(System.currentTimeMillis(), this.quartzScheduler));
            }
        }
        catch (Exception e) {
            throw new SSchedulerException(e);
        }
    }

    org.quartz.Trigger getQuartzTrigger(Trigger trigger, String jobName, String tenantId) {
        TriggerBuilder triggerBuilder;
        TriggerBuilder base = TriggerBuilder.newTrigger().forJob(jobName, tenantId).withIdentity(trigger.getName(), tenantId).startNow();
        if (trigger instanceof CronTrigger) {
            CronTrigger cronTrigger = (CronTrigger)trigger;
            CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule((String)cronTrigger.getExpression());
            switch (cronTrigger.getMisfireHandlingPolicy()) {
                case NONE: {
                    cronScheduleBuilder.withMisfireHandlingInstructionDoNothing();
                    break;
                }
                case ALL: {
                    cronScheduleBuilder.withMisfireHandlingInstructionIgnoreMisfires();
                    break;
                }
                case ONE: {
                    cronScheduleBuilder.withMisfireHandlingInstructionFireAndProceed();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            triggerBuilder = base.withSchedule((ScheduleBuilder)cronScheduleBuilder).endAt(cronTrigger.getEndDate());
        } else if (trigger instanceof RepeatTrigger) {
            RepeatTrigger repeatTrigger = (RepeatTrigger)trigger;
            SimpleScheduleBuilder scheduleBuilder = SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(repeatTrigger.getInterval()).withRepeatCount(repeatTrigger.getCount()).withMisfireHandlingInstructionIgnoreMisfires();
            triggerBuilder = base.withSchedule((ScheduleBuilder)scheduleBuilder).startAt(repeatTrigger.getStartDate());
            switch (repeatTrigger.getMisfireHandlingPolicy()) {
                case NONE: {
                    scheduleBuilder.withMisfireHandlingInstructionNextWithRemainingCount();
                    break;
                }
                case ALL: {
                    scheduleBuilder.withMisfireHandlingInstructionIgnoreMisfires();
                    break;
                }
                case ONE: {
                    scheduleBuilder.withMisfireHandlingInstructionNowWithRemainingCount();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        } else {
            triggerBuilder = base.startAt(trigger.getStartDate());
        }
        return triggerBuilder.withPriority(trigger.getPriority()).build();
    }

    @Override
    public boolean isStarted() throws SSchedulerException {
        try {
            return this.scheduler != null && this.scheduler.isStarted() && !this.scheduler.isShutdown();
        }
        catch (SchedulerException e) {
            throw new SSchedulerException(e);
        }
    }

    @Override
    public boolean isShutdown() throws SSchedulerException {
        try {
            return this.scheduler != null && this.scheduler.isShutdown();
        }
        catch (SchedulerException e) {
            throw new SSchedulerException(e);
        }
    }

    @Override
    public void start() throws SSchedulerException {
        try {
            if (!this.isShutdown() && this.isStarted()) {
                throw new SSchedulerException("The scheduler is already started.");
            }
            this.scheduler = this.schedulerFactory.getScheduler();
            ListenerManager listenerManager = this.scheduler.getListenerManager();
            for (AbstractJobListener jobListener : this.jobListeners) {
                listenerManager.addJobListener((JobListener)jobListener);
            }
            this.scheduler.start();
            try {
                if (this.useOptimization) {
                    Field quartzSchedulerField = this.scheduler.getClass().getDeclaredField("sched");
                    quartzSchedulerField.setAccessible(true);
                    this.quartzScheduler = (QuartzScheduler)quartzSchedulerField.get(this.scheduler);
                }
            }
            catch (Exception t) {
                t.printStackTrace();
            }
        }
        catch (SchedulerException e) {
            throw new SSchedulerException(e);
        }
    }

    @Override
    public void shutdown() throws SSchedulerException {
        try {
            this.checkSchedulerState();
            this.scheduler.shutdown(true);
        }
        catch (SchedulerException e) {
            throw new SSchedulerException(e);
        }
    }

    private void checkSchedulerState() throws SSchedulerException {
        if (this.scheduler == null) {
            throw new SSchedulerException("The scheduler is not started");
        }
    }

    @Override
    public void reschedule(String triggerName, Trigger newTrigger) throws SSchedulerException {
        try {
            String tenantId = String.valueOf(this.getTenantIdFromSession());
            if (triggerName == null) {
                throw new SSchedulerException("The trigger name is null");
            }
            if (tenantId == null) {
                throw new SSchedulerException("The trigger group name is null");
            }
            this.checkSchedulerState();
            org.quartz.Trigger quartzTrigger = this.getQuartzTrigger(newTrigger, triggerName, tenantId);
            org.quartz.Trigger trigger = this.scheduler.getTrigger(TriggerKey.triggerKey((String)triggerName, (String)tenantId));
            if (trigger == null) {
                throw new SSchedulerException("No trigger found with name: " + triggerName + " and tenant: " + tenantId);
            }
            this.scheduler.rescheduleJob(trigger.getKey(), quartzTrigger);
        }
        catch (Exception e) {
            throw new SSchedulerException(e);
        }
    }

    @Override
    public boolean delete(String jobName) throws SSchedulerException {
        try {
            this.checkSchedulerState();
            String tenantId = String.valueOf(this.getTenantIdFromSession());
            return this.scheduler.deleteJob(JobKey.jobKey((String)jobName, (String)tenantId));
        }
        catch (SchedulerException e) {
            throw new SSchedulerException(e);
        }
        catch (STenantIdNotSetException e) {
            throw new SSchedulerException(e);
        }
    }

    @Override
    public void deleteJobs() throws SSchedulerException {
        try {
            this.checkSchedulerState();
            String tenantId = String.valueOf(this.getTenantIdFromSession());
            Set jobNames = this.scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)tenantId));
            for (JobKey jobKey : jobNames) {
                this.delete(jobKey.getName());
            }
        }
        catch (SchedulerException e) {
            throw new SSchedulerException(e);
        }
        catch (STenantIdNotSetException e) {
            throw new SSchedulerException(e);
        }
    }

    @Override
    public List<String> getJobs() throws SSchedulerException {
        try {
            this.checkSchedulerState();
            String tenantId = String.valueOf(this.getTenantIdFromSession());
            Set jobKeys = this.scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)tenantId));
            ArrayList<String> jobsNames = new ArrayList<String>(jobKeys.size());
            for (JobKey jobKey : jobKeys) {
                jobsNames.add(jobKey.getName());
            }
            return jobsNames;
        }
        catch (SchedulerException e) {
            throw new SSchedulerException(e);
        }
        catch (STenantIdNotSetException e) {
            throw new SSchedulerException(e);
        }
    }

    @Override
    public List<String> getAllJobs() throws SSchedulerException {
        try {
            this.checkSchedulerState();
            Set jobKeys = this.scheduler.getJobKeys(GroupMatcher.jobGroupStartsWith((String)""));
            ArrayList<String> jobsNames = new ArrayList<String>(jobKeys.size());
            for (JobKey jobKey : jobKeys) {
                jobsNames.add(jobKey.getName());
            }
            return jobsNames;
        }
        catch (SchedulerException e) {
            throw new SSchedulerException(e);
        }
    }

    @Override
    public void setBOSSchedulerService(SchedulerServiceImpl schedulerService) {
        this.schedulerFactory.setBOSSchedulerService(schedulerService);
        for (AbstractJobListener jobListener : this.jobListeners) {
            jobListener.setBOSSchedulerService(schedulerService);
        }
    }

    private long getTenantIdFromSession() throws STenantIdNotSetException {
        return this.sessionAccessor.getTenantId();
    }

    @Override
    public boolean isStillScheduled(long tenantId, String jobName) throws SSchedulerException {
        boolean stillScheduled = false;
        try {
            List triggers = this.scheduler.getTriggersOfJob(new JobKey(jobName, String.valueOf(tenantId)));
            Iterator iterator = triggers.iterator();
            while (!stillScheduled && iterator.hasNext()) {
                org.quartz.Trigger trigger = (org.quartz.Trigger)iterator.next();
                if (trigger.getNextFireTime() == null) continue;
                stillScheduled = true;
            }
            return stillScheduled;
        }
        catch (SchedulerException e) {
            throw new SSchedulerException(e);
        }
    }

    @Override
    public void rescheduleErroneousTriggers() throws SSchedulerException {
        this.checkSchedulerState();
        try {
            List triggerGroupNames = this.scheduler.getTriggerGroupNames();
            for (String triggerGroupName : triggerGroupNames) {
                Set triggerKeys = this.scheduler.getTriggerKeys(GroupMatcher.triggerGroupEquals((String)triggerGroupName));
                for (TriggerKey triggerKey : triggerKeys) {
                    Trigger.TriggerState triggerState = this.scheduler.getTriggerState(triggerKey);
                    if (!Trigger.TriggerState.ERROR.equals((Object)triggerState)) continue;
                    this.scheduler.pauseTrigger(triggerKey);
                    this.scheduler.resumeTrigger(triggerKey);
                }
            }
        }
        catch (SchedulerException e) {
            throw new SSchedulerException(e);
        }
    }

    @Override
    public void pauseJobs(long tenantId) throws SSchedulerException {
        GroupMatcher groupEquals = GroupMatcher.triggerGroupEquals((String)String.valueOf(tenantId));
        try {
            this.scheduler.pauseTriggers(groupEquals);
        }
        catch (SchedulerException e) {
            throw new SSchedulerException("Unable to put jobs of tenant " + tenantId + " in pause", (Exception)((Object)e));
        }
    }

    @Override
    public void resumeJobs(long tenantId) throws SSchedulerException {
        GroupMatcher groupEquals = GroupMatcher.triggerGroupEquals((String)String.valueOf(tenantId));
        try {
            this.scheduler.resumeTriggers(groupEquals);
        }
        catch (SchedulerException e) {
            throw new SSchedulerException("Unable to put jobs of tenant " + tenantId + " in pause", (Exception)((Object)e));
        }
    }

    private final class NotifyQuartzOfNewTrigger
    implements BonitaTransactionSynchronization {
        private final long time;
        private final QuartzScheduler quartzScheduler;

        public NotifyQuartzOfNewTrigger(long time, QuartzScheduler quartzScheduler) {
            this.time = time;
            this.quartzScheduler = quartzScheduler;
        }

        @Override
        public void beforeCommit() {
        }

        @Override
        public void afterCompletion(TransactionState txState) {
            if (TransactionState.COMMITTED.equals((Object)txState) && this.quartzScheduler != null) {
                this.quartzScheduler.getSchedulerSignaler().signalSchedulingChange(this.time);
            }
        }
    }
}

