/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.theme.persistence;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SelectByIdDescriptor;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;
import org.bonitasoft.engine.theme.model.STheme;
import org.bonitasoft.engine.theme.model.SThemeType;

public class SelectDescriptorBuilder {
    private SelectDescriptorBuilder() {
    }

    public static <T extends PersistentObject> SelectByIdDescriptor<T> getElementById(Class<T> clazz, String elementName, long id) {
        return new SelectByIdDescriptor<T>("get" + elementName + "ById", clazz, id);
    }

    public static SelectOneDescriptor<Long> getNumberOfElement(String elementName, Class<? extends PersistentObject> clazz) {
        Map<String, Object> parameters = Collections.emptyMap();
        return new SelectOneDescriptor<Long>("getNumberOf" + elementName, parameters, clazz, Long.class);
    }

    public static <T extends PersistentObject> SelectListDescriptor<T> getElements(Class<T> clazz, String elementName, int fromIndex, int numberOfElements) {
        QueryOptions queryOptions = new QueryOptions(fromIndex, numberOfElements);
        return SelectDescriptorBuilder.getElements(clazz, elementName, queryOptions);
    }

    public static <T extends PersistentObject> SelectListDescriptor<T> getElements(Class<T> clazz, String elementName, String field, OrderByType order, int fromIndex, int numberOfElements) {
        QueryOptions queryOptions = new QueryOptions(fromIndex, numberOfElements, clazz, field, order);
        return SelectDescriptorBuilder.getElements(clazz, elementName, queryOptions);
    }

    public static <T extends PersistentObject> SelectListDescriptor<T> getElements(Class<T> clazz, String elementName, QueryOptions queryOptions) {
        Map<String, Object> parameters = Collections.emptyMap();
        return new SelectListDescriptor("get" + elementName + "s", parameters, clazz, queryOptions);
    }

    public static SelectOneDescriptor<STheme> getTheme(SThemeType type, boolean isDefault) {
        HashMap<String, Object> inputParameters = new HashMap<String, Object>(1);
        inputParameters.put("type", (Object)type);
        inputParameters.put("isDefault", isDefault);
        return new SelectOneDescriptor<STheme>("getTheme", inputParameters, STheme.class);
    }

    public static SelectOneDescriptor<STheme> getLastModifiedTheme(SThemeType type) {
        HashMap<String, Object> inputParameters = new HashMap<String, Object>(1);
        inputParameters.put("type", (Object)type);
        return new SelectOneDescriptor<STheme>("getLastModifiedTheme", inputParameters, STheme.class);
    }
}

