/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl;

import java.util.Date;
import org.bonitasoft.engine.api.ThemeAPI;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.exception.BonitaRuntimeException;
import org.bonitasoft.engine.exception.RetrieveException;
import org.bonitasoft.engine.service.ModelConvertor;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceSingleton;
import org.bonitasoft.engine.service.impl.ServiceAccessorFactory;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;
import org.bonitasoft.engine.theme.Theme;
import org.bonitasoft.engine.theme.ThemeService;
import org.bonitasoft.engine.theme.ThemeType;
import org.bonitasoft.engine.theme.exception.SThemeNotFoundException;
import org.bonitasoft.engine.theme.model.SThemeType;

public class ThemeAPIImpl
implements ThemeAPI {
    public TenantServiceAccessor getTenantAccessor() {
        try {
            SessionAccessor sessionAccessor = ServiceAccessorFactory.getInstance().createSessionAccessor();
            long tenantId = sessionAccessor.getTenantId();
            return TenantServiceSingleton.getInstance(tenantId);
        }
        catch (Exception e) {
            throw new BonitaRuntimeException((Throwable)e);
        }
    }

    public Theme getCurrentTheme(ThemeType type) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ThemeService themeService = tenantAccessor.getThemeService();
        try {
            return ModelConvertor.toTheme(themeService.getLastModifiedTheme(SThemeType.valueOf(type.name())));
        }
        catch (SThemeNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public Theme getDefaultTheme(ThemeType type) {
        return this.getThemeByType(type, true);
    }

    private Theme getThemeByType(ThemeType type, boolean isDefault) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ThemeService themeService = tenantAccessor.getThemeService();
        try {
            return ModelConvertor.toTheme(themeService.getTheme(SThemeType.valueOf(type.name()), isDefault));
        }
        catch (SThemeNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public Date getLastUpdateDate(ThemeType type) {
        return this.getCurrentTheme(type).getLastUpdatedDate();
    }
}

