/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.data;

import java.util.List;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeType;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeReadException;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.core.process.instance.model.builder.SSubProcessActivityInstanceBuilderFactory;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.data.instance.api.DataInstanceService;
import org.bonitasoft.engine.data.instance.exception.SDataInstanceException;
import org.bonitasoft.engine.data.instance.model.SDataInstance;

public class CreateSDataInstances
implements TransactionContent {
    private final List<SDataInstance> sDataInstances;
    private final DataInstanceService dataInstanceService;
    private final SProcessInstance processInstance;
    private final ActivityInstanceService activityInstanceService;
    private final SProcessDefinition processDefinition;

    public CreateSDataInstances(List<SDataInstance> sDataInstances, DataInstanceService dataInstanceService, SProcessInstance processInstance, ActivityInstanceService activityInstanceService, SProcessDefinition processDefinition) {
        this.sDataInstances = sDataInstances;
        this.dataInstanceService = dataInstanceService;
        this.processInstance = processInstance;
        this.activityInstanceService = activityInstanceService;
        this.processDefinition = processDefinition;
    }

    @Override
    public void execute() throws SDataInstanceException, SFlowNodeNotFoundException, SFlowNodeReadException {
        boolean parentHasData;
        if (!this.sDataInstances.isEmpty()) {
            for (SDataInstance sDataInstance : this.sDataInstances) {
                this.dataInstanceService.createDataInstance(sDataInstance);
            }
        }
        boolean bl = parentHasData = !this.processDefinition.getProcessContainer().getDataDefinitions().isEmpty();
        if (!this.sDataInstances.isEmpty() || parentHasData) {
            if (this.processInstance.getCallerId() > 0L) {
                SFlowNodeInstance caller = this.activityInstanceService.getFlowNodeInstance(this.processInstance.getCallerId());
                if (SFlowNodeType.SUB_PROCESS.equals((Object)caller.getType())) {
                    SSubProcessActivityInstanceBuilderFactory keyProvider = BuilderFactory.get(SSubProcessActivityInstanceBuilderFactory.class);
                    this.dataInstanceService.addChildContainer(caller.getLogicalGroup(keyProvider.getParentProcessInstanceIndex()), DataInstanceContainer.PROCESS_INSTANCE.name(), this.processInstance.getId(), DataInstanceContainer.PROCESS_INSTANCE.name());
                } else {
                    this.dataInstanceService.createDataContainer(this.processInstance.getId(), DataInstanceContainer.PROCESS_INSTANCE.name());
                }
            } else {
                this.dataInstanceService.createDataContainer(this.processInstance.getId(), DataInstanceContainer.PROCESS_INSTANCE.name());
            }
        }
    }
}

