/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.identity;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bonitasoft.engine.actor.mapping.ActorMappingService;
import org.bonitasoft.engine.actor.mapping.SActorMemberDeletionException;
import org.bonitasoft.engine.actor.mapping.SActorMemberNotFoundException;
import org.bonitasoft.engine.actor.mapping.model.SActorMember;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.SIdentityException;
import org.bonitasoft.engine.identity.model.SGroup;
import org.bonitasoft.engine.identity.model.SUserMembership;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.profile.ProfileService;
import org.bonitasoft.engine.profile.builder.SProfileMemberBuilderFactory;
import org.bonitasoft.engine.profile.model.SProfileMember;

public class DeleteWithActorMembers {
    protected static final int BATCH_SIZE = 100;
    private final ActorMappingService actorMappingService;
    private final ProfileService profileService;
    private final IdentityService identityService;
    private final Set<Long> removedActorIds = new HashSet<Long>();

    public DeleteWithActorMembers(ActorMappingService actorMappingService, ProfileService profileService, IdentityService identityService) {
        this.actorMappingService = actorMappingService;
        this.profileService = profileService;
        this.identityService = identityService;
    }

    public Set<Long> getRemovedActorIds() {
        return this.removedActorIds;
    }

    protected void setActorIdsOfRemovedElements(SActorMember removedActorMember) {
        this.removedActorIds.add(removedActorMember.getActorId());
    }

    protected void deleteActorMembersOfUser(long userId) throws SActorMemberNotFoundException, SActorMemberDeletionException, SBonitaReadException {
        List<SActorMember> actorMembers = this.actorMappingService.getActorMembersOfUser(userId, 0, 100);
        while (!actorMembers.isEmpty()) {
            for (SActorMember sActorMember : actorMembers) {
                this.setActorIdsOfRemovedElements(this.actorMappingService.deleteActorMember(sActorMember.getId()));
            }
            actorMembers = this.actorMappingService.getActorMembersOfUser(userId, 0, 100);
        }
    }

    protected void deleteProfileMembersOfUser(long id) throws SBonitaException {
        List<SProfileMember> profileMembersOfUser;
        String field = BuilderFactory.get(SProfileMemberBuilderFactory.class).getIdKey();
        do {
            profileMembersOfUser = this.profileService.getProfileMembersOfUser(id, 0, 100, field, OrderByType.ASC);
            for (SProfileMember sProfileMember : profileMembersOfUser) {
                this.profileService.deleteProfileMember(sProfileMember);
            }
        } while (profileMembersOfUser.size() == 100);
    }

    protected void deleteUserMembershipsByUser(long id) throws SIdentityException {
        List<SUserMembership> sUserMemberships = this.identityService.getUserMembershipsOfUser(id, 0, 100);
        while (!sUserMemberships.isEmpty()) {
            for (SUserMembership sUserMembership : sUserMemberships) {
                this.identityService.deleteUserMembership(sUserMembership.getId());
            }
            sUserMemberships = this.identityService.getUserMembershipsOfUser(id, 0, 100);
        }
    }

    protected void deleteActorMembersOfGroup(long groupId) throws SActorMemberNotFoundException, SActorMemberDeletionException, SBonitaReadException, SIdentityException {
        List<SActorMember> actorMembers;
        do {
            actorMembers = this.actorMappingService.getActorMembersOfGroup(groupId, 0, 100);
            for (SActorMember sActorMember : actorMembers) {
                this.setActorIdsOfRemovedElements(this.actorMappingService.deleteActorMember(sActorMember.getId()));
            }
        } while (actorMembers.size() == 100);
        this.deleteActorMembersOfGroupChildren(groupId);
    }

    private void deleteActorMembersOfGroupChildren(long groupId) throws SIdentityException, SActorMemberNotFoundException, SActorMemberDeletionException, SBonitaReadException {
        List<SGroup> childrenGroup;
        int i = 0;
        do {
            childrenGroup = this.identityService.getGroupChildren(groupId, i, 100);
            i += 100;
            for (SGroup sGroup : childrenGroup) {
                this.deleteActorMembersOfGroup(sGroup.getId());
            }
        } while (childrenGroup.size() == 100);
    }

    protected void deleteProfileMembersOfGroup(long groupId) throws SBonitaException {
        List<SProfileMember> profileMembers;
        String field = BuilderFactory.get(SProfileMemberBuilderFactory.class).getIdKey();
        do {
            profileMembers = this.profileService.getProfileMembersOfGroup(groupId, 0, 100, field, OrderByType.ASC);
            for (SProfileMember sProfileMember : profileMembers) {
                this.profileService.deleteProfileMember(sProfileMember);
            }
        } while (profileMembers.size() == 100);
        this.deleteProfileMembersOfGroupChildren(groupId);
    }

    private void deleteProfileMembersOfGroupChildren(long groupId) throws SIdentityException, SBonitaException {
        List<SGroup> childrenGroup;
        int i = 0;
        do {
            childrenGroup = this.identityService.getGroupChildren(groupId, i, 100);
            i += 100;
            for (SGroup sGroup : childrenGroup) {
                this.deleteProfileMembersOfGroup(sGroup.getId());
            }
        } while (childrenGroup.size() == 100);
    }

    protected void deleteMembershipsByGroup(long groupId) throws SBonitaException {
        List<SUserMembership> memberships;
        do {
            memberships = this.identityService.getUserMembershipsOfGroup(groupId, 0, 100);
            for (SUserMembership sUserMembership : memberships) {
                this.identityService.deleteUserMembership(sUserMembership.getId());
            }
        } while (memberships.size() == 100);
    }

    protected void deleteActorMembersOfRole(long roleId) throws SActorMemberNotFoundException, SActorMemberDeletionException, SBonitaReadException {
        List<SActorMember> actorMembers;
        do {
            actorMembers = this.actorMappingService.getActorMembersOfRole(roleId, 0, 100);
            for (SActorMember sActorMember : actorMembers) {
                this.setActorIdsOfRemovedElements(this.actorMappingService.deleteActorMember(sActorMember.getId()));
            }
        } while (actorMembers.size() == 100);
    }

    protected void deleteProfileMembersOfRole(long roleId) throws SBonitaException {
        List<SProfileMember> profileMembers;
        String field = BuilderFactory.get(SProfileMemberBuilderFactory.class).getIdKey();
        do {
            profileMembers = this.profileService.getProfileMembersOfRole(roleId, 0, 100, field, OrderByType.ASC);
            for (SProfileMember sProfileMember : profileMembers) {
                this.profileService.deleteProfileMember(sProfileMember);
            }
        } while (profileMembers.size() == 100);
    }

    protected void deleteMembershipsByRole(long roleId) throws SBonitaException {
        List<SUserMembership> memberships;
        do {
            memberships = this.identityService.getUserMembershipsOfRole(roleId, 0, 100);
            for (SUserMembership sUserMembership : memberships) {
                this.identityService.deleteUserMembership(sUserMembership.getId());
            }
        } while (memberships.size() == 100);
    }

    public ActorMappingService getActorMappingService() {
        return this.actorMappingService;
    }

    public ProfileService getProfileService() {
        return this.profileService;
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }
}

