/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.platform;

import java.util.List;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.dependency.DependencyService;
import org.bonitasoft.engine.dependency.model.ScopeType;
import org.bonitasoft.engine.service.TenantServiceAccessor;

public class RefreshTenantClassLoaders
implements TransactionContent {
    private final TenantServiceAccessor tenantServiceAccessor;
    private final Long tenantId;

    public RefreshTenantClassLoaders(TenantServiceAccessor tenantServiceAccessor, Long tenantId) {
        this.tenantServiceAccessor = tenantServiceAccessor;
        this.tenantId = tenantId;
    }

    @Override
    public void execute() throws SBonitaException {
        List<Long> processDefinitionIds;
        int maxResults = 100;
        DependencyService dependencyService = this.tenantServiceAccessor.getDependencyService();
        dependencyService.refreshClassLoader(ScopeType.TENANT, this.tenantId);
        ProcessDefinitionService processDefinitionService = this.tenantServiceAccessor.getProcessDefinitionService();
        int j = 0;
        do {
            processDefinitionIds = processDefinitionService.getProcessDefinitionIds(j, 100);
            j += 100;
            for (Long id : processDefinitionIds) {
                dependencyService.refreshClassLoader(ScopeType.PROCESS, id);
            }
        } while (processDefinitionIds.size() == 100);
    }
}

