/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.commons.exceptions;

import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import org.bonitasoft.engine.commons.exceptions.SExceptionContext;

public abstract class SBonitaException
extends Exception {
    private static final long serialVersionUID = -500856379312027085L;
    private final String exceptionId;
    private final Object[] arguments;
    private final Map<SExceptionContext, Serializable> context = new TreeMap<SExceptionContext, Serializable>();

    public SBonitaException() {
        this((Object[])null);
    }

    public SBonitaException(Object ... arguments) {
        this.exceptionId = this.getClass().getName();
        this.arguments = arguments;
    }

    public SBonitaException(String message) {
        super(message);
        this.exceptionId = this.getClass().getName();
        this.arguments = null;
    }

    public SBonitaException(String message, Throwable cause) {
        super(message, cause);
        this.exceptionId = this.getClass().getName();
        this.arguments = null;
    }

    public SBonitaException(Throwable cause) {
        this(cause, (Object[])null);
    }

    public SBonitaException(Throwable cause, Object ... arguments) {
        super(cause);
        this.exceptionId = this.getClass().getName();
        this.arguments = arguments;
    }

    public String getExceptionId() {
        return this.exceptionId;
    }

    public Object[] getParameters() {
        return this.arguments;
    }

    public Map<SExceptionContext, Serializable> getContext() {
        return this.context;
    }

    public void setProcessDefinitionIdOnContext(Long id) {
        this.context.put(SExceptionContext.PROCESS_DEFINITION_ID, id);
    }

    public void setProcessDefinitionNameOnContext(String name) {
        this.context.put(SExceptionContext.PROCESS_NAME, (Serializable)((Object)name));
    }

    public void setProcessDefinitionVersionOnContext(String version) {
        this.context.put(SExceptionContext.PROCESS_VERSION, (Serializable)((Object)version));
    }

    public void setProcessInstanceIdOnContext(Long id) {
        this.context.put(SExceptionContext.PROCESS_INSTANCE_ID, id);
    }

    public void setRootProcessInstanceIdOnContext(Long id) {
        this.context.put(SExceptionContext.ROOT_PROCESS_INSTANCE_ID, id);
    }

    public void setConnectorDefinitionIdOnContext(String id) {
        this.context.put(SExceptionContext.CONNECTOR_DEFINITION_ID, (Serializable)((Object)id));
    }

    public void setConnectorDefinitionImplementationClassNameOnContext(String name) {
        this.context.put(SExceptionContext.CONNECTOR_DEFINITION_IMPLEMENTATION_CLASS_NAME, (Serializable)((Object)name));
    }

    public void setConnectorDefinitionVersionOnContext(String version) {
        this.context.put(SExceptionContext.CONNECTOR_DEFINITION_VERSION, (Serializable)((Object)version));
    }

    public void setConnectorActivationEventOnContext(String activationEvent) {
        this.context.put(SExceptionContext.CONNECTOR_ACTIVATION_EVENT, (Serializable)((Object)activationEvent));
    }

    public void setConnectorInstanceIdOnContext(long id) {
        this.context.put(SExceptionContext.CONNECTOR_INSTANCE_ID, Long.valueOf(id));
    }

    public void setFlowNodeDefinitionIdOnContext(long id) {
        this.context.put(SExceptionContext.FLOW_NODE_DEFINITION_ID, Long.valueOf(id));
    }

    public void setFlowNodeInstanceIdOnContext(long id) {
        this.context.put(SExceptionContext.FLOW_NODE_INSTANCE_ID, Long.valueOf(id));
    }

    public void setFlowNodeNameOnContext(String name) {
        this.context.put(SExceptionContext.FLOW_NODE_NAME, (Serializable)((Object)name));
    }

    public void setMessageInstanceNameOnContext(String name) {
        this.context.put(SExceptionContext.MESSAGE_INSTANCE_NAME, (Serializable)((Object)name));
    }

    public void setMessageInstanceTargetProcessOnContext(String name) {
        this.context.put(SExceptionContext.MESSAGE_INSTANCE_TARGET_PROCESS_NAME, (Serializable)((Object)name));
    }

    public void setMessageInstanceTargetFlowNodeOnContext(String name) {
        this.context.put(SExceptionContext.MESSAGE_INSTANCE_TARGET_FLOW_NODE_NAME, (Serializable)((Object)name));
    }

    public void setWaitingMessageEventTypeOnContext(String eventType) {
        this.context.put(SExceptionContext.WAITING_MESSAGE_INSTANCE_TYPE, (Serializable)((Object)eventType));
    }

    public void setDocumentIdOnContext(long id) {
        this.context.put(SExceptionContext.DOCUMENT_ID, Long.valueOf(id));
    }

    public void setUserIdOnContext(Long userId) {
        this.context.put(SExceptionContext.USER_ID, userId);
    }

    public void setGroupIdOnContext(Long groupId) {
        this.context.put(SExceptionContext.GROUP_ID, groupId);
    }

    public void setRoleIdOnContext(Long roleId) {
        this.context.put(SExceptionContext.ROLE_ID, roleId);
    }

    @Override
    public String getMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendContextMessage(stringBuilder);
        this.appendCauseMessage(stringBuilder);
        return stringBuilder.toString();
    }

    private void appendCauseMessage(StringBuilder stringBuilder) {
        String message = super.getMessage();
        if (message != null && message.isEmpty() && this.getCause() != null) {
            message = this.getCause().getMessage();
        }
        if (message != null && !message.trim().equals("")) {
            stringBuilder.append(message);
        }
    }

    private void appendContextMessage(StringBuilder stringBuilder) {
        if (!this.context.isEmpty()) {
            for (Map.Entry<SExceptionContext, Serializable> entry : this.context.entrySet()) {
                stringBuilder.append((Object)((Object)entry.getKey()) + "=" + entry.getValue() + " | ");
            }
        }
    }
}

