/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.commons.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.bonitasoft.engine.commons.ClassDataUtil;
import org.bonitasoft.engine.commons.NullCheckingUtil;
import org.bonitasoft.engine.commons.Pair;
import org.w3c.dom.Document;

public class IOUtil {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int BUFFER_SIZE = 100000;
    public static final String FILE_ENCODING = "UTF-8";

    private IOUtil() {
    }

    public static File createDirectory(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getClassNameList(byte[] jarContent) throws IOException {
        ArrayList<String> classes = new ArrayList<String>(10);
        ZipInputStream stream = null;
        try {
            stream = new JarInputStream(new ByteArrayInputStream(jarContent));
            JarEntry nextJarEntry = null;
            while ((nextJarEntry = ((JarInputStream)stream).getNextJarEntry()) != null) {
                String name = nextJarEntry.getName();
                if (!name.endsWith(".class")) continue;
                classes.add(IOUtil.toQualifiedClassName(name));
            }
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        return classes;
    }

    private static String toQualifiedClassName(String name) {
        return name.replace('/', '.').replaceAll(".class", "");
    }

    public static File createTempFile(String prefix, String suffix, File directory) throws IOException {
        File tmpDir = null;
        int retryNumber = 10;
        int j = 0;
        boolean succeded = false;
        do {
            try {
                int lastIndexOfSeparatorChar = prefix.lastIndexOf(47);
                String fileName = prefix;
                if (lastIndexOfSeparatorChar > -1) {
                    String dirToCreate = prefix.substring(0, lastIndexOfSeparatorChar);
                    new File(directory.getAbsolutePath() + File.separator + dirToCreate).mkdirs();
                    fileName = prefix.substring(lastIndexOfSeparatorChar, prefix.length());
                }
                tmpDir = File.createTempFile(fileName, suffix, directory);
                succeded = true;
            }
            catch (IOException e) {
                if (j == 10) {
                    throw e;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                ++j;
            }
        } while (!succeded);
        return tmpDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File file, byte[] fileContent) throws IOException {
        NullCheckingUtil.checkArgsNotNull(file, fileContent);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        FileOutputStream os = new FileOutputStream(file);
        try {
            ((OutputStream)os).write(fileContent);
            os.flush();
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    public static byte[] generateJar(Class<?> ... classes) throws IOException {
        return IOUtil.generateJar(IOUtil.getResources(classes));
    }

    public static Map<String, byte[]> getResources(Class<?> ... classes) throws IOException {
        if (classes == null || classes.length == 0) {
            String message = "No classes available";
            throw new IOException("No classes available");
        }
        HashMap<String, byte[]> resources = new HashMap<String, byte[]>();
        for (Class<?> clazz : classes) {
            resources.put(clazz.getName().replace(".", "/") + ".class", ClassDataUtil.getClassData(clazz));
            for (Class<?> internalClass : clazz.getDeclaredClasses()) {
                resources.put(internalClass.getName().replace(".", "/") + ".class", ClassDataUtil.getClassData(internalClass));
            }
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] generateJar(Map<String, byte[]> resources) throws IOException {
        if (resources == null || resources.size() == 0) {
            String message = "No resources available";
            throw new IOException("No resources available");
        }
        ByteArrayOutputStream baos = null;
        ZipOutputStream jarOutStream = null;
        try {
            baos = new ByteArrayOutputStream();
            jarOutStream = new JarOutputStream(new BufferedOutputStream(baos));
            for (Map.Entry<String, byte[]> resource : resources.entrySet()) {
                ((JarOutputStream)jarOutStream).putNextEntry(new JarEntry(resource.getKey()));
                jarOutStream.write(resource.getValue());
            }
            jarOutStream.flush();
            baos.flush();
        }
        finally {
            if (jarOutStream != null) {
                jarOutStream.close();
            }
            if (baos != null) {
                baos.close();
            }
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] generateZip(Map<String, byte[]> resources) throws IOException {
        if (resources == null || resources.size() == 0) {
            String message = "No resources available";
            throw new IOException("No resources available");
        }
        ByteArrayOutputStream baos = null;
        ZipOutputStream zipOutStream = null;
        try {
            baos = new ByteArrayOutputStream();
            zipOutStream = new ZipOutputStream(new BufferedOutputStream(baos));
            for (Map.Entry<String, byte[]> resource : resources.entrySet()) {
                zipOutStream.putNextEntry(new ZipEntry(resource.getKey()));
                zipOutStream.write(resource.getValue());
            }
            zipOutStream.flush();
            baos.flush();
        }
        finally {
            if (zipOutStream != null) {
                zipOutStream.close();
            }
            if (baos != null) {
                baos.close();
            }
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getAllContentFrom(InputStream in) throws IOException {
        byte[] resultArray;
        if (in == null) {
            throw new IOException("The InputStream is null!");
        }
        byte[] buffer = new byte[100000];
        BufferedInputStream bis = null;
        ByteArrayOutputStream result = null;
        try {
            int amountRead;
            bis = new BufferedInputStream(in);
            result = new ByteArrayOutputStream();
            while ((amountRead = bis.read(buffer)) > 0) {
                result.write(buffer, 0, amountRead);
            }
            resultArray = result.toByteArray();
            result.flush();
        }
        finally {
            if (bis != null) {
                bis.close();
            }
            if (result != null) {
                result.close();
            }
        }
        return resultArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(InputStream inputStream) {
        Scanner scanner = new Scanner(inputStream, FILE_ENCODING);
        StringBuilder text = new StringBuilder();
        try {
            boolean isFirst = true;
            while (scanner.hasNextLine()) {
                if (isFirst) {
                    text.append(scanner.nextLine());
                } else {
                    text.append(LINE_SEPARATOR + scanner.nextLine());
                }
                isFirst = false;
            }
        }
        finally {
            scanner.close();
        }
        return text.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(File file) throws IOException {
        FileInputStream inputStream = new FileInputStream(file);
        try {
            String string = IOUtil.read(inputStream);
            return string;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getAllContentFrom(File file) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            byte[] byArray = IOUtil.getAllContentFrom(in);
            return byArray;
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getAllContentFrom(URL url) throws IOException {
        InputStream in = url.openStream();
        try {
            byte[] byArray = IOUtil.getAllContentFrom(in);
            return byArray;
        }
        finally {
            in.close();
        }
    }

    public static boolean deleteDir(File dir) throws IOException {
        return IOUtil.deleteDir(dir, 1, 0L);
    }

    public static boolean deleteDir(File dir, int attempts, long sleepTime) throws IOException {
        boolean result = true;
        if (!dir.exists()) {
            return false;
        }
        if (!dir.isDirectory()) {
            throw new IOException("Unable to delete directory: " + dir + ", it is not a directory");
        }
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                IOUtil.deleteDir(files[i], attempts, sleepTime);
                continue;
            }
            result = result && IOUtil.deleteFile(files[i], attempts, sleepTime);
        }
        result = result && IOUtil.deleteFile(dir, attempts, sleepTime);
        return result;
    }

    public static boolean deleteFile(File f, int attempts, long sleepTime) {
        int retries = attempts;
        while (retries > 0 && !f.delete()) {
            --retries;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {}
        }
        return retries > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileContent(File file) {
        StringBuilder sb = new StringBuilder();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            try {
                String line = null;
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                    sb.append(System.getProperty("line.separator"));
                }
            }
            finally {
                reader.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, String fileContent) throws FileNotFoundException, IOException {
        if (file == null) {
            throw new IllegalArgumentException("File should not be null.");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("File does not exist: " + file);
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("Should not be a directory: " + file);
        }
        if (!file.canWrite()) {
            throw new IllegalArgumentException("File cannot be written: " + file);
        }
        BufferedWriter output = new BufferedWriter(new FileWriter(file));
        try {
            output.write(fileContent);
        }
        finally {
            ((Writer)output).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(ZipInputStream inputStream, File target) throws IOException {
        FileOutputStream fos = new FileOutputStream(target);
        int BUFF_SIZE = 1024;
        byte[] buf = new byte[1024];
        try {
            int n;
            while ((n = inputStream.read(buf)) > 0) {
                fos.write(buf, 0, n);
            }
        }
        finally {
            fos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] zip(Map<String, byte[]> files) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(baos);
        try {
            for (Map.Entry<String, byte[]> file : files.entrySet()) {
                zos.putNextEntry(new ZipEntry(file.getKey()));
                zos.write(file.getValue());
                zos.flush();
                zos.closeEntry();
            }
        }
        finally {
            zos.close();
            baos.close();
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] zip(Pair<String, byte[]> ... files) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(baos);
        try {
            for (Pair<String, byte[]> file : files) {
                zos.putNextEntry(new ZipEntry((String)file.getKey()));
                zos.write((byte[])file.getValue());
                zos.flush();
                zos.closeEntry();
            }
        }
        finally {
            zos.close();
            baos.close();
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Map<String, byte[]> unzip(byte[] zipFile) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(zipFile);
        ZipInputStream zipInputstream = new ZipInputStream(bais);
        ZipEntry zipEntry = null;
        HashMap<String, byte[]> files = new HashMap<String, byte[]>();
        try {
            while ((zipEntry = zipInputstream.getNextEntry()) != null) {
                int bytesRead;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] buffer = new byte[100000];
                while ((bytesRead = zipInputstream.read(buffer)) > -1) {
                    byteArrayOutputStream.write(buffer, 0, bytesRead);
                }
                files.put(zipEntry.getName(), byteArrayOutputStream.toByteArray());
            }
        }
        finally {
            zipInputstream.close();
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipToFolder(InputStream inputStream, File outputFolder) throws IOException {
        ZipInputStream zipInputstream = new ZipInputStream(inputStream);
        ZipEntry zipEntry = null;
        try {
            while ((zipEntry = zipInputstream.getNextEntry()) != null) {
                IOUtil.extractZipEntry(zipInputstream, zipEntry, outputFolder);
            }
        }
        finally {
            zipInputstream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractZipEntry(ZipInputStream zipInputstream, ZipEntry zipEntry, File outputFolder) throws FileNotFoundException, IOException {
        try {
            String entryName = zipEntry.getName();
            File outputFile = new File(outputFolder.getAbsolutePath(), entryName);
            if (zipEntry.isDirectory()) {
                IOUtil.mkdirs(outputFile);
                return;
            }
            IOUtil.writeZipInputToFile(zipInputstream, outputFile);
        }
        finally {
            zipInputstream.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeZipInputToFile(ZipInputStream zipInputstream, File outputFile) throws FileNotFoundException, IOException {
        IOUtil.mkdirs(outputFile.getParentFile());
        FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
        try {
            try {
                int bytesRead;
                byte[] buffer = new byte[100000];
                while ((bytesRead = zipInputstream.read(buffer)) > -1) {
                    fileOutputStream.write(buffer, 0, bytesRead);
                }
            }
            finally {
                fileOutputStream.close();
            }
        }
        catch (IOException ioe) {
            outputFile.delete();
            throw ioe;
        }
    }

    private static boolean mkdirs(File file) {
        if (!file.exists()) {
            return file.mkdirs();
        }
        return true;
    }

    public static File createTempDirectory(String fileName) throws IOException {
        File temp = File.createTempFile(fileName, String.valueOf(System.currentTimeMillis()));
        temp.setReadable(true);
        temp.setWritable(true);
        if (!temp.delete()) {
            throw new IOException("Could not delete temporary file : " + temp.getAbsolutePath());
        }
        IOUtil.mkdirs(temp);
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getZipEntryContent(String entryName, InputStream inputStream) throws IOException {
        ZipInputStream zipInputstream = new ZipInputStream(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ZipEntry zipEntry = null;
        try {
            while ((zipEntry = zipInputstream.getNextEntry()) != null) {
                int bytesRead;
                if (!entryName.equals(zipEntry.getName())) continue;
                byte[] buffer = new byte[100000];
                while ((bytesRead = zipInputstream.read(buffer)) > -1) {
                    byteArrayOutputStream.write(buffer, 0, bytesRead);
                }
                byte[] byArray = byteArrayOutputStream.toByteArray();
                return byArray;
            }
        }
        finally {
            zipInputstream.close();
            byteArrayOutputStream.close();
        }
        throw new IOException("Entry " + entryName + " does not exists in the zip file");
    }

    public static byte[] getZipEntryContent(String entryName, byte[] zipFile) throws IOException {
        return IOUtil.getZipEntryContent(entryName, new ByteArrayInputStream(zipFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(Document document) throws IOException, TransformerException {
        if (document == null) {
            throw new IllegalArgumentException("Document should not be null.");
        }
        Transformer tf = TransformerFactory.newInstance().newTransformer();
        tf.setOutputProperty("encoding", FILE_ENCODING);
        tf.setOutputProperty("indent", "yes");
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream();
            tf.transform(new DOMSource(document), new StreamResult(out));
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] addJarEntry(byte[] jarToUpdate, String entryName, byte[] entryContent) throws IOException {
        ByteArrayOutputStream out = null;
        ByteArrayInputStream bais = null;
        ZipOutputStream jos = null;
        JarInputStream jis = null;
        byte[] buffer = new byte[4096];
        try {
            JarEntry inEntry;
            bais = new ByteArrayInputStream(jarToUpdate);
            jis = new JarInputStream(bais);
            out = new ByteArrayOutputStream();
            jos = new JarOutputStream(out);
            while ((inEntry = (JarEntry)jis.getNextEntry()) != null) {
                int len;
                if (!inEntry.getName().equals(entryName)) {
                    ((JarOutputStream)jos).putNextEntry(new JarEntry(inEntry));
                } else {
                    throw new IllegalArgumentException("Jar entry " + entryName + " already exists in jar to update");
                }
                while ((len = jis.read(buffer)) > 0) {
                    jos.write(buffer, 0, len);
                }
                jos.flush();
            }
            JarEntry entry = new JarEntry(entryName);
            ((JarOutputStream)jos).putNextEntry(entry);
            jos.write(entryContent);
            jos.closeEntry();
            jos.finish();
            out.flush();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            if (jos != null) {
                jos.close();
            }
            if (out != null) {
                out.close();
            }
            if (jis != null) {
                jis.close();
            }
        }
    }

    public static byte[] getPropertyAsString(Properties prop) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        prop.store(out, "");
        return out.toByteArray();
    }
}

