/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.definition.model.bindings;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bonitasoft.engine.core.process.definition.model.SActorDefinition;
import org.bonitasoft.engine.core.process.definition.model.SParameterDefinition;
import org.bonitasoft.engine.core.process.definition.model.bindings.SNamedElementBinding;
import org.bonitasoft.engine.core.process.definition.model.bindings.SStringIndex;
import org.bonitasoft.engine.core.process.definition.model.impl.SFlowElementContainerDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.impl.SProcessDefinitionImpl;

public class SProcessDefinitionBinding
extends SNamedElementBinding {
    private String version;
    private final List<SActorDefinition> actors = new ArrayList<SActorDefinition>();
    private SActorDefinition actorInitiator;
    private final Set<SParameterDefinition> parameters = new HashSet<SParameterDefinition>();
    private SFlowElementContainerDefinitionImpl processContainer;
    private final List<SStringIndex> stringIndexes = new ArrayList<SStringIndex>(5);

    @Override
    public void setAttributes(Map<String, String> attributes) {
        super.setAttributes(attributes);
        this.version = attributes.get("version");
    }

    @Override
    public void setChildElement(String name, String value, Map<String, String> attributes) {
    }

    @Override
    public void setChildObject(String name, Object value) {
        if ("actor".equals(name)) {
            this.actors.add((SActorDefinition)value);
        } else if ("actorInitiator".equals(name)) {
            this.actorInitiator = (SActorDefinition)value;
        } else if ("parameter".equals(name)) {
            this.parameters.add((SParameterDefinition)value);
        } else if ("flowElements".equals(name)) {
            this.processContainer = (SFlowElementContainerDefinitionImpl)value;
        } else if ("stringIndex".equals(name)) {
            this.stringIndexes.add((SStringIndex)value);
        }
    }

    @Override
    public SProcessDefinitionImpl getObject() {
        SProcessDefinitionImpl processDefinitionImpl = new SProcessDefinitionImpl(this.name, this.version);
        processDefinitionImpl.setId(this.id);
        processDefinitionImpl.setDescription(this.description);
        for (SStringIndex stringIndex : this.stringIndexes) {
            processDefinitionImpl.setStringIndex(stringIndex.getIndex(), stringIndex.getLabel(), stringIndex.getValue());
        }
        for (SActorDefinition actor : this.actors) {
            processDefinitionImpl.addActor(actor);
        }
        if (this.actorInitiator != null) {
            processDefinitionImpl.setActorInitiator(this.actorInitiator);
        }
        for (SParameterDefinition parameter : this.parameters) {
            processDefinitionImpl.addParameter(parameter);
        }
        if (this.processContainer != null) {
            processDefinitionImpl.setProcessContainer(this.processContainer);
            this.processContainer.setElementContainer(processDefinitionImpl);
        }
        return processDefinitionImpl;
    }

    @Override
    public String getElementTag() {
        return "processDefinition";
    }
}

