/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.instance.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.exceptions.SObjectReadException;
import org.bonitasoft.engine.core.process.definition.model.SFlowElementContainerDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeDefinition;
import org.bonitasoft.engine.core.process.definition.model.SGatewayDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.STransitionDefinition;
import org.bonitasoft.engine.core.process.instance.api.GatewayInstanceService;
import org.bonitasoft.engine.core.process.instance.api.TokenService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SGatewayCreationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SGatewayModificationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SGatewayNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SGatewayReadException;
import org.bonitasoft.engine.core.process.instance.model.SGatewayInstance;
import org.bonitasoft.engine.core.process.instance.model.builder.SGatewayInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.recorder.SelectDescriptorBuilder;
import org.bonitasoft.engine.events.EventActionType;
import org.bonitasoft.engine.events.EventService;
import org.bonitasoft.engine.events.model.SInsertEvent;
import org.bonitasoft.engine.events.model.SUpdateEvent;
import org.bonitasoft.engine.events.model.builders.SEventBuilderFactory;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.ReadPersistenceService;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;
import org.bonitasoft.engine.recorder.Recorder;
import org.bonitasoft.engine.recorder.SRecorderException;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.recorder.model.InsertRecord;
import org.bonitasoft.engine.recorder.model.UpdateRecord;
import org.bonitasoft.engine.services.QueriableLoggerService;

public class GatewayInstanceServiceImpl
implements GatewayInstanceService {
    private final Recorder recorder;
    private final EventService eventService;
    private final ReadPersistenceService persistenceRead;
    private final SGatewayInstanceBuilderFactory sGatewayInstanceBuilderFactory;
    private final TokenService tokenService;
    private final TechnicalLoggerService logger;

    public GatewayInstanceServiceImpl(Recorder recorder, EventService eventService, ReadPersistenceService persistenceRead, QueriableLoggerService queriableLoggerService, TechnicalLoggerService logger, TokenService tokenService) {
        this.recorder = recorder;
        this.eventService = eventService;
        this.persistenceRead = persistenceRead;
        this.logger = logger;
        this.tokenService = tokenService;
        this.sGatewayInstanceBuilderFactory = BuilderFactory.get(SGatewayInstanceBuilderFactory.class);
    }

    @Override
    public void createGatewayInstance(SGatewayInstance gatewayInstance) throws SGatewayCreationException {
        InsertRecord insertRecord = new InsertRecord(gatewayInstance);
        SInsertEvent insertEvent = null;
        if (this.eventService.hasHandlers("GATEWAYINSTANCE", EventActionType.CREATED)) {
            insertEvent = (SInsertEvent)BuilderFactory.get(SEventBuilderFactory.class).createInsertEvent("GATEWAYINSTANCE").setObject(gatewayInstance).done();
        }
        try {
            this.recorder.recordInsert(insertRecord, insertEvent);
        }
        catch (SRecorderException e) {
            throw new SGatewayCreationException(e);
        }
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
            StringBuilder stb = new StringBuilder();
            stb.append("Created gateway instance [name = <" + gatewayInstance.getName());
            stb.append(">, id = <" + gatewayInstance.getId());
            stb.append(">, parent process instance id = <" + gatewayInstance.getParentProcessInstanceId());
            stb.append(">, root process instance id = <" + gatewayInstance.getRootProcessInstanceId());
            stb.append(">, process definition id = <" + gatewayInstance.getRootProcessInstanceId());
            stb.append(">]");
            this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, stb.toString());
        }
    }

    @Override
    public SGatewayInstance getGatewayInstance(long gatewayInstanceId) throws SGatewayNotFoundException, SGatewayReadException {
        SGatewayInstance selectOne;
        try {
            selectOne = this.persistenceRead.selectById(SelectDescriptorBuilder.getElementById(SGatewayInstance.class, "SGatewayInstance", gatewayInstanceId));
        }
        catch (SBonitaReadException e) {
            throw new SGatewayReadException(e);
        }
        if (selectOne == null) {
            throw new SGatewayNotFoundException(gatewayInstanceId);
        }
        return selectOne;
    }

    @Override
    public boolean checkMergingCondition(SProcessDefinition sDefinition, SGatewayInstance gatewayInstance) throws SBonitaException {
        switch (gatewayInstance.getGatewayType()) {
            case EXCLUSIVE: {
                return true;
            }
            case INCLUSIVE: {
                return this.inclusiveBehavior(sDefinition, gatewayInstance);
            }
            case PARALLEL: {
                return this.parallelBehavior(sDefinition, gatewayInstance);
            }
        }
        return false;
    }

    private boolean inclusiveBehavior(SProcessDefinition sDefinition, SGatewayInstance gatewayInstance) throws SObjectReadException {
        SFlowNodeDefinition flowNode = sDefinition.getProcessContainer().getFlowNode(gatewayInstance.getFlowNodeDefinitionId());
        if (flowNode.getIncomingTransitions().size() == 1) {
            return true;
        }
        Long tokenRefId = gatewayInstance.getTokenRefId();
        int size = this.getHitByTransitionList(gatewayInstance).size();
        return this.tokenService.getNumberOfToken(gatewayInstance.getParentContainerId(), tokenRefId) <= size;
    }

    private boolean parallelBehavior(SProcessDefinition sDefinition, SGatewayInstance gatewayInstance) {
        List<String> hitsBy = this.getHitByTransitionList(gatewayInstance);
        List<STransitionDefinition> trans = this.getTransitionDefinitions(gatewayInstance, sDefinition);
        boolean go = true;
        for (int i = 1; go && i <= trans.size(); ++i) {
            go = hitsBy.contains(String.valueOf(i));
        }
        return go;
    }

    private List<String> getHitByTransitionList(SGatewayInstance gatewayInstance) {
        return Arrays.asList(gatewayInstance.getHitBys().split(","));
    }

    protected List<STransitionDefinition> getTransitionDefinitions(SGatewayInstance gatewayInstance, SProcessDefinition processDefinition) {
        SFlowElementContainerDefinition processContainer = processDefinition.getProcessContainer();
        SGatewayDefinition gatewayDefinition = processContainer.getGateway(gatewayInstance.getName());
        return gatewayDefinition.getIncomingTransitions();
    }

    @Override
    public void setState(SGatewayInstance gatewayInstance, int stateId) throws SGatewayModificationException {
        this.updateOneColum(gatewayInstance, this.sGatewayInstanceBuilderFactory.getStateIdKey(), Integer.valueOf(stateId), "GATEWAYINSTANCE_STATE");
    }

    @Override
    public void hitTransition(SGatewayInstance gatewayInstance, long transitionIndex) throws SGatewayModificationException {
        String hitBys = gatewayInstance.getHitBys();
        String columnValue = hitBys == null || hitBys.isEmpty() ? String.valueOf(transitionIndex) : hitBys + "," + String.valueOf(transitionIndex);
        this.updateOneColum(gatewayInstance, this.sGatewayInstanceBuilderFactory.getHitBysKey(), (Serializable)((Object)columnValue), "GATEWAYINSTANCE_HITBYS");
    }

    private void updateOneColum(SGatewayInstance gatewayInstance, String columnName, Serializable columnValue, String event) throws SGatewayModificationException {
        EntityUpdateDescriptor entityUpdateDescriptor = new EntityUpdateDescriptor();
        entityUpdateDescriptor.addField(columnName, columnValue);
        UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)gatewayInstance, entityUpdateDescriptor);
        SUpdateEvent updateEvent = null;
        if (this.eventService.hasHandlers(event, EventActionType.UPDATED)) {
            updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent(event).setObject(gatewayInstance).done();
        }
        try {
            this.recorder.recordUpdate(updateRecord, updateEvent);
        }
        catch (SRecorderException e) {
            throw new SGatewayModificationException(e);
        }
    }

    @Override
    public SGatewayInstance getActiveGatewayInstanceOfTheProcess(long parentProcessInstanceId, String name) throws SGatewayNotFoundException, SGatewayReadException {
        SGatewayInstance selectOne;
        try {
            selectOne = this.persistenceRead.selectOne(SelectDescriptorBuilder.getActiveGatewayInstanceOfProcess(parentProcessInstanceId, name));
        }
        catch (SBonitaReadException e) {
            throw new SGatewayReadException(e);
        }
        if (selectOne == null) {
            throw new SGatewayNotFoundException(parentProcessInstanceId, name);
        }
        return selectOne;
    }

    @Override
    public void setFinish(SGatewayInstance gatewayInstance) throws SGatewayModificationException {
        String columnValue = "FINISH:" + gatewayInstance.getHitBys().split(",").length;
        this.updateOneColum(gatewayInstance, this.sGatewayInstanceBuilderFactory.getHitBysKey(), (Serializable)((Object)columnValue), "GATEWAYINSTANCE_HITBYS");
    }

    @Override
    public SGatewayInstance getGatewayMergingToken(long processInstanceId, Long tokenRefId) throws SGatewayReadException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        hashMap.put("processInstanceId", processInstanceId);
        hashMap.put("tokenRefId", tokenRefId);
        try {
            return (SGatewayInstance)this.persistenceRead.selectOne(new SelectOneDescriptor("getGatewayMergingToken", hashMap, SGatewayInstance.class));
        }
        catch (SBonitaReadException e) {
            throw new SGatewayReadException(e);
        }
    }
}

