/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.bonitasoft.engine.SArchivingException;
import org.bonitasoft.engine.api.impl.transaction.event.CreateEventInstance;
import org.bonitasoft.engine.bpm.connector.ConnectorDefinition;
import org.bonitasoft.engine.bpm.connector.ConnectorDefinitionWithInputValues;
import org.bonitasoft.engine.bpm.connector.ConnectorEvent;
import org.bonitasoft.engine.bpm.connector.InvalidEvaluationConnectorConditionException;
import org.bonitasoft.engine.bpm.model.impl.BPMInstancesCreator;
import org.bonitasoft.engine.bpm.process.ProcessInstanceState;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.exceptions.SObjectCreationException;
import org.bonitasoft.engine.commons.exceptions.SObjectModificationException;
import org.bonitasoft.engine.commons.exceptions.SObjectNotFoundException;
import org.bonitasoft.engine.commons.exceptions.SObjectReadException;
import org.bonitasoft.engine.core.connector.ConnectorInstanceService;
import org.bonitasoft.engine.core.connector.ConnectorResult;
import org.bonitasoft.engine.core.connector.ConnectorService;
import org.bonitasoft.engine.core.connector.exception.SConnectorException;
import org.bonitasoft.engine.core.connector.exception.SConnectorInstanceReadException;
import org.bonitasoft.engine.core.expression.control.api.ExpressionResolverService;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.operation.OperationService;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionNotFoundException;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionReadException;
import org.bonitasoft.engine.core.process.definition.model.SConnectorDefinition;
import org.bonitasoft.engine.core.process.definition.model.SDocumentDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowElementContainerDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeType;
import org.bonitasoft.engine.core.process.definition.model.SGatewayDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.STransitionDefinition;
import org.bonitasoft.engine.core.process.definition.model.TransitionState;
import org.bonitasoft.engine.core.process.definition.model.builder.ServerModelConvertor;
import org.bonitasoft.engine.core.process.definition.model.event.SEndEventDefinition;
import org.bonitasoft.engine.core.process.document.api.ProcessDocumentService;
import org.bonitasoft.engine.core.process.document.api.SProcessDocumentCreationException;
import org.bonitasoft.engine.core.process.document.model.SProcessDocument;
import org.bonitasoft.engine.core.process.document.model.builder.SProcessDocumentBuilder;
import org.bonitasoft.engine.core.process.document.model.builder.SProcessDocumentBuilderFactory;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.GatewayInstanceService;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.core.process.instance.api.TokenService;
import org.bonitasoft.engine.core.process.instance.api.TransitionService;
import org.bonitasoft.engine.core.process.instance.api.event.EventInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityExecutionException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityInstanceNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityReadException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeExecutionException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SGatewayModificationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SGatewayNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceCreationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.STransitionCreationException;
import org.bonitasoft.engine.core.process.instance.api.states.FlowNodeState;
import org.bonitasoft.engine.core.process.instance.model.SActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SConnectorInstance;
import org.bonitasoft.engine.core.process.instance.model.SFlowElementsContainerType;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SGatewayInstance;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.core.process.instance.model.SStateCategory;
import org.bonitasoft.engine.core.process.instance.model.SToken;
import org.bonitasoft.engine.core.process.instance.model.builder.SProcessInstanceBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.SProcessInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.SUserTaskInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.event.SEventInstance;
import org.bonitasoft.engine.core.process.instance.model.event.SThrowEventInstance;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.dependency.model.ScopeType;
import org.bonitasoft.engine.events.EventService;
import org.bonitasoft.engine.events.model.HandlerRegistrationException;
import org.bonitasoft.engine.events.model.SEvent;
import org.bonitasoft.engine.events.model.SHandler;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.BonitaRuntimeException;
import org.bonitasoft.engine.execution.ContainerRegistry;
import org.bonitasoft.engine.execution.Filter;
import org.bonitasoft.engine.execution.FlowNodeExecutor;
import org.bonitasoft.engine.execution.FlowNodeIdFilter;
import org.bonitasoft.engine.execution.FlowNodeSelector;
import org.bonitasoft.engine.execution.ProcessExecutor;
import org.bonitasoft.engine.execution.StartFlowNodeFilter;
import org.bonitasoft.engine.execution.event.EventsHandler;
import org.bonitasoft.engine.execution.flowmerger.FlowMerger;
import org.bonitasoft.engine.execution.flowmerger.FlowNodeCompletionTokenProvider;
import org.bonitasoft.engine.execution.flowmerger.FlowNodeTransitionsWrapper;
import org.bonitasoft.engine.execution.flowmerger.TokenInfo;
import org.bonitasoft.engine.execution.handler.SProcessInstanceHandler;
import org.bonitasoft.engine.execution.state.FlowNodeStateManager;
import org.bonitasoft.engine.execution.work.WorkFactory;
import org.bonitasoft.engine.expression.exception.SExpressionDependencyMissingException;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.exception.SExpressionTypeUnknownException;
import org.bonitasoft.engine.expression.exception.SInvalidExpressionException;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.home.BonitaHomeServer;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.service.ModelConvertor;
import org.bonitasoft.engine.sessionaccessor.ReadSessionAccessor;
import org.bonitasoft.engine.sessionaccessor.STenantIdNotSetException;
import org.bonitasoft.engine.work.SWorkRegisterException;
import org.bonitasoft.engine.work.WorkService;

public class ProcessExecutorImpl
implements ProcessExecutor {
    protected final ActivityInstanceService activityInstanceService;
    private final FlowNodeExecutor flowNodeExecutor;
    private final TechnicalLoggerService logger;
    protected final ProcessInstanceService processInstanceService;
    private final TokenService tokenService;
    private final WorkService workService;
    private final ProcessDefinitionService processDefinitionService;
    private final GatewayInstanceService gatewayInstanceService;
    private final TransitionService transitionService;
    private final EventInstanceService eventInstanceService;
    protected final ClassLoaderService classLoaderService;
    protected final ExpressionResolverService expressionResolverService;
    protected final ConnectorService connectorService;
    private final OperationService operationService;
    private final ProcessDocumentService processDocumentService;
    private final ReadSessionAccessor sessionAccessor;
    protected final BPMInstancesCreator bpmInstancesCreator;
    protected final EventsHandler eventsHandler;
    private final ConnectorInstanceService connectorInstanceService;

    public ProcessExecutorImpl(ActivityInstanceService activityInstanceService, ProcessInstanceService processInstanceService, TechnicalLoggerService logger, FlowNodeExecutor flowNodeExecutor, WorkService workService, ProcessDefinitionService processDefinitionService, GatewayInstanceService gatewayInstanceService, TransitionService transitionService, EventInstanceService eventInstanceService, ConnectorService connectorService, ConnectorInstanceService connectorInstanceService, ClassLoaderService classLoaderService, OperationService operationService, ExpressionResolverService expressionResolverService, EventService eventService, Map<String, SProcessInstanceHandler<SEvent>> handlers, ProcessDocumentService processDocumentService, ReadSessionAccessor sessionAccessor, ContainerRegistry containerRegistry, BPMInstancesCreator bpmInstancesCreator, TokenService tokenService, EventsHandler eventsHandler, FlowNodeStateManager flowNodeStateManager) {
        this.activityInstanceService = activityInstanceService;
        this.processInstanceService = processInstanceService;
        this.connectorInstanceService = connectorInstanceService;
        this.tokenService = tokenService;
        this.logger = logger;
        this.flowNodeExecutor = flowNodeExecutor;
        this.workService = workService;
        this.processDefinitionService = processDefinitionService;
        this.gatewayInstanceService = gatewayInstanceService;
        this.transitionService = transitionService;
        this.eventInstanceService = eventInstanceService;
        this.connectorService = connectorService;
        this.classLoaderService = classLoaderService;
        this.operationService = operationService;
        this.expressionResolverService = expressionResolverService;
        this.processDocumentService = processDocumentService;
        this.sessionAccessor = sessionAccessor;
        this.bpmInstancesCreator = bpmInstancesCreator;
        this.eventsHandler = eventsHandler;
        flowNodeStateManager.setProcessExecutor(this);
        eventsHandler.setProcessExecutor(this);
        for (Map.Entry<String, SProcessInstanceHandler<SEvent>> handler : handlers.entrySet()) {
            try {
                eventService.addHandler(handler.getKey(), (SHandler<SEvent>)handler.getValue());
            }
            catch (HandlerRegistrationException e) {
                if (logger.isLoggable(this.getClass(), TechnicalLogSeverity.WARNING)) {
                    logger.log(this.getClass(), TechnicalLogSeverity.WARNING, e.getMessage());
                }
                if (!logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) continue;
                logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, e);
            }
        }
        containerRegistry.addContainerExecutor(this);
    }

    @Override
    public FlowNodeState executeFlowNode(long flowNodeInstanceId, SExpressionContext contextDependency, List<SOperation> operations, long processInstanceId, Long executerId, Long executerSubstituteId) throws SFlowNodeExecutionException {
        return this.flowNodeExecutor.stepForward(flowNodeInstanceId, contextDependency, operations, processInstanceId, executerId, executerSubstituteId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<STransitionDefinition> evaluateOutgoingTransitions(List<STransitionDefinition> outgoingTransitionDefinitions, SProcessDefinition sDefinition, SFlowNodeInstance flowNodeInstance) throws SBonitaException {
        List<STransitionDefinition> chosenTransitionDefinitions = Collections.emptyList();
        if (!SStateCategory.NORMAL.equals((Object)flowNodeInstance.getStateCategory())) return chosenTransitionDefinitions;
        SExpressionContext sExpressionContext = new SExpressionContext((Long)flowNodeInstance.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.name(), sDefinition.getId());
        if (SFlowNodeType.GATEWAY.equals((Object)flowNodeInstance.getType())) {
            SGatewayInstance gatewayInstance = (SGatewayInstance)flowNodeInstance;
            switch (gatewayInstance.getGatewayType()) {
                case EXCLUSIVE: {
                    return this.evaluateTransitionsExclusively(sDefinition, flowNodeInstance, outgoingTransitionDefinitions, sExpressionContext);
                }
                case INCLUSIVE: {
                    return this.evaluateTransitionsInclusively(sDefinition, flowNodeInstance, outgoingTransitionDefinitions, sExpressionContext);
                }
                case PARALLEL: {
                    return this.evaluateTransitionsParallely(outgoingTransitionDefinitions);
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported gateway type: " + (Object)((Object)gatewayInstance.getGatewayType()));
                }
            }
        }
        if (SFlowNodeType.BOUNDARY_EVENT.equals((Object)flowNodeInstance.getType())) {
            return new ArrayList<STransitionDefinition>(outgoingTransitionDefinitions);
        }
        if (!outgoingTransitionDefinitions.isEmpty()) return this.evaluateTransitionsForImpliciteGateway(sDefinition, flowNodeInstance, outgoingTransitionDefinitions, sExpressionContext);
        STransitionDefinition defaultTransition = null;
        defaultTransition = this.getDefaultTransition(sDefinition, flowNodeInstance);
        if (defaultTransition == null) {
            return new ArrayList<STransitionDefinition>(1);
        }
        ArrayList<STransitionDefinition> transitions = new ArrayList<STransitionDefinition>(1);
        transitions.add(defaultTransition);
        return transitions;
    }

    private int getNumberOfTokenToMerge(SFlowNodeInstance sFlownodeInstance) {
        if (SFlowNodeType.GATEWAY.equals((Object)sFlownodeInstance.getType())) {
            String hitBys = ((SGatewayInstance)sFlownodeInstance).getHitBys();
            String nbOfTokenToMerge = hitBys.substring("FINISH:".length());
            return Integer.parseInt(nbOfTokenToMerge);
        }
        return 1;
    }

    private List<STransitionDefinition> evaluateTransitionsExclusively(SProcessDefinition sDefinition, SFlowNodeInstance flowNodeInstance, List<STransitionDefinition> outgoingTransitionDefinitions, SExpressionContext sExpressionContext) throws SBonitaException {
        ArrayList<STransitionDefinition> chosenTransitions = new ArrayList<STransitionDefinition>(outgoingTransitionDefinitions.size());
        boolean transitionFound = false;
        for (STransitionDefinition sTransitionDefinition : outgoingTransitionDefinitions) {
            Boolean condition = this.evaluateCondition(sDefinition, sTransitionDefinition, sExpressionContext);
            if (condition != null && !condition.booleanValue()) continue;
            transitionFound = true;
            chosenTransitions.add(sTransitionDefinition);
            break;
        }
        if (!transitionFound) {
            STransitionDefinition defaultTransition = this.getDefaultTransitionIfExists(sDefinition, flowNodeInstance);
            chosenTransitions.add(defaultTransition);
            outgoingTransitionDefinitions.add(defaultTransition);
        }
        return chosenTransitions;
    }

    private STransitionDefinition getDefaultTransitionIfExists(SProcessDefinition sDefinition, SFlowNodeInstance flowNodeInstance) throws SActivityExecutionException {
        STransitionDefinition defaultTransition = this.getDefaultTransition(sDefinition, flowNodeInstance);
        if (defaultTransition == null) {
            this.throwSActivityExecutionException(sDefinition, flowNodeInstance);
        }
        return defaultTransition;
    }

    private void throwSActivityExecutionException(SProcessDefinition sDefinition, SFlowNodeInstance flowNodeInstance) throws SActivityExecutionException {
        SActivityExecutionException exception = new SActivityExecutionException("There is no default transition on " + flowNodeInstance.getName() + ", but no outgoing transition had a valid condition.");
        exception.setProcessDefinitionNameOnContext(sDefinition.getName());
        exception.setProcessDefinitionVersionOnContext(sDefinition.getVersion());
        exception.setProcessInstanceIdOnContext(flowNodeInstance.getParentProcessInstanceId());
        throw exception;
    }

    List<STransitionDefinition> evaluateTransitionsInclusively(SProcessDefinition sDefinition, SFlowNodeInstance flowNodeInstance, List<STransitionDefinition> outgoingTransitionDefinitions, SExpressionContext sExpressionContext) throws SBonitaException {
        ArrayList<STransitionDefinition> chosenTransitions = new ArrayList<STransitionDefinition>(outgoingTransitionDefinitions.size());
        for (STransitionDefinition sTransitionDefinition : outgoingTransitionDefinitions) {
            Boolean condition = this.evaluateCondition(sDefinition, sTransitionDefinition, sExpressionContext);
            if (condition != null && !condition.booleanValue()) continue;
            chosenTransitions.add(sTransitionDefinition);
        }
        if (chosenTransitions.isEmpty()) {
            STransitionDefinition defaultTransition = this.getDefaultTransitionIfExists(sDefinition, flowNodeInstance);
            chosenTransitions.add(defaultTransition);
            outgoingTransitionDefinitions.add(defaultTransition);
        }
        return chosenTransitions;
    }

    protected List<STransitionDefinition> evaluateTransitionsForImpliciteGateway(SProcessDefinition sDefinition, SFlowNodeInstance flowNodeInstance, List<STransitionDefinition> outgoingTransitionDefinitions, SExpressionContext sExpressionContext) throws SBonitaException {
        int transitionNumber = outgoingTransitionDefinitions.size();
        ArrayList<STransitionDefinition> conditionalTransitions = new ArrayList<STransitionDefinition>(transitionNumber);
        ArrayList<STransitionDefinition> conditionalFalseTransitions = new ArrayList<STransitionDefinition>(transitionNumber);
        ArrayList<STransitionDefinition> chosenTransitions = new ArrayList<STransitionDefinition>(transitionNumber);
        ArrayList<STransitionDefinition> normalTransitions = new ArrayList<STransitionDefinition>(transitionNumber);
        for (STransitionDefinition sTransitionDefinition : outgoingTransitionDefinitions) {
            Boolean condition = this.evaluateCondition(sDefinition, sTransitionDefinition, sExpressionContext);
            if (condition == null) {
                normalTransitions.add(sTransitionDefinition);
                continue;
            }
            if (condition.booleanValue()) {
                conditionalTransitions.add(sTransitionDefinition);
                continue;
            }
            conditionalFalseTransitions.add(sTransitionDefinition);
        }
        if (!normalTransitions.isEmpty()) {
            chosenTransitions.addAll(normalTransitions);
        }
        if (!conditionalTransitions.isEmpty()) {
            chosenTransitions.addAll(conditionalTransitions);
        } else if (!conditionalFalseTransitions.isEmpty()) {
            STransitionDefinition defaultTransition = this.getDefaultTransitionIfExists(sDefinition, flowNodeInstance);
            chosenTransitions.add(defaultTransition);
        }
        return chosenTransitions;
    }

    private List<STransitionDefinition> evaluateTransitionsParallely(List<STransitionDefinition> outgoingTransitionDefinitions) {
        ArrayList<STransitionDefinition> chosenTransitions = new ArrayList<STransitionDefinition>(outgoingTransitionDefinitions.size());
        for (STransitionDefinition sTransitionDefinition : outgoingTransitionDefinitions) {
            chosenTransitions.add(sTransitionDefinition);
        }
        return chosenTransitions;
    }

    protected STransitionDefinition getDefaultTransition(SProcessDefinition sDefinition, SFlowNodeInstance flowNodeInstance) {
        SFlowElementContainerDefinition processContainer = sDefinition.getProcessContainer();
        SFlowNodeDefinition flowNode = processContainer.getFlowNode(flowNodeInstance.getFlowNodeDefinitionId());
        return flowNode.getDefaultTransition();
    }

    protected Boolean evaluateCondition(SProcessDefinition sDefinition, STransitionDefinition sTransitionDefinition, SExpressionContext contextDependency) throws SExpressionEvaluationException, SExpressionTypeUnknownException, SExpressionDependencyMissingException, SInvalidExpressionException {
        SFlowElementContainerDefinition processContainer = sDefinition.getProcessContainer();
        STransitionDefinition transition = processContainer.getTransition(sTransitionDefinition.getName());
        SExpression expression = transition.getCondition();
        if (expression == null) {
            return null;
        }
        if (!Boolean.class.getName().equals(expression.getReturnType())) {
            throw new SExpressionEvaluationException("Condition expression must return a boolean, on transition: " + sTransitionDefinition.getName(), expression.getName());
        }
        return (Boolean)this.expressionResolverService.evaluate(expression, contextDependency);
    }

    private SConnectorInstance getNextConnectorInstance(SProcessInstance processInstance, ConnectorEvent event) throws SConnectorInstanceReadException {
        List<SConnectorInstance> connectorInstances = this.connectorInstanceService.getConnectorInstances(processInstance.getId(), "process", event, 0, 1, "TO_BE_EXECUTED");
        return connectorInstances.size() == 1 ? connectorInstances.get(0) : null;
    }

    @Override
    public boolean executeConnectors(SProcessDefinition processDefinition, SProcessInstance sProcessInstance, ConnectorEvent activationEvent) throws SBonitaException {
        SConnectorInstance nextConnectorInstance;
        SFlowElementContainerDefinition processContainer = processDefinition.getProcessContainer();
        long processDefinitionId = processDefinition.getId();
        List<SConnectorDefinition> connectors = processContainer.getConnectors(activationEvent);
        if (connectors.size() > 0 && (nextConnectorInstance = this.getNextConnectorInstance(sProcessInstance, activationEvent)) != null) {
            for (SConnectorDefinition sConnectorDefinition : connectors) {
                if (!sConnectorDefinition.getName().equals(nextConnectorInstance.getName())) continue;
                Long connectorInstanceId = nextConnectorInstance.getId();
                String connectorDefinitionName = sConnectorDefinition.getName();
                this.workService.registerWork(WorkFactory.createExecuteConnectorOfProcess(processDefinitionId, sProcessInstance.getId(), sProcessInstance.getRootProcessInstanceId(), connectorInstanceId, connectorDefinitionName, activationEvent));
                return true;
            }
        }
        return false;
    }

    private List<SFlowNodeInstance> initializeFirstExecutableElements(SProcessInstance sProcessInstance, FlowNodeSelector selector) {
        try {
            List<SFlowNodeDefinition> flownNodeDefinitions = selector.getFilteredElements();
            long rootProcessInstanceId = sProcessInstance.getRootProcessInstanceId();
            if (rootProcessInstanceId <= 0L) {
                rootProcessInstanceId = sProcessInstance.getId();
            }
            return this.bpmInstancesCreator.createFlowNodeInstances(selector.getProcessDefinition().getId(), rootProcessInstanceId, sProcessInstance.getId(), flownNodeDefinitions, rootProcessInstanceId, sProcessInstance.getId(), SStateCategory.NORMAL, selector.getProcessDefinition().getId());
        }
        catch (SBonitaException e) {
            this.setExceptionContext(selector.getProcessDefinition(), sProcessInstance, e);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.ERROR)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.ERROR, e);
            }
            throw new BonitaRuntimeException((Throwable)e);
        }
    }

    private SProcessInstance createProcessInstance(SProcessDefinition sDefinition, long starterId, long starterSubstituteId, long callerId, SFlowNodeType callerType, long rootProcessInstanceId) throws SProcessInstanceCreationException {
        SProcessInstanceBuilder processInstanceBuilder = BuilderFactory.get(SProcessInstanceBuilderFactory.class).createNewInstance(sDefinition).setStartedBy(starterId).setStartedBySubstitute(starterSubstituteId).setCallerId(callerId, callerType).setRootProcessInstanceId(rootProcessInstanceId);
        SProcessInstance sProcessInstance = processInstanceBuilder.done();
        this.processInstanceService.createProcessInstance(sProcessInstance);
        return sProcessInstance;
    }

    protected SProcessInstance createProcessInstance(SProcessDefinition processDefinition, long starterId, long starterSubstituteId, long callerId) throws SProcessInstanceCreationException {
        SActivityInstance callerInstance;
        try {
            callerInstance = this.getCaller(callerId);
        }
        catch (SBonitaException e) {
            throw new SProcessInstanceCreationException("Unable to get caller.", e);
        }
        if (callerInstance != null) {
            return this.createProcessInstance(processDefinition, starterId, starterSubstituteId, callerId, callerInstance.getType(), callerInstance.getRootContainerId());
        }
        return this.createProcessInstance(processDefinition, starterId, starterSubstituteId, callerId, null, -1L);
    }

    private SActivityInstance getCaller(long callerId) throws SActivityReadException, SActivityInstanceNotFoundException {
        if (callerId > 0L) {
            return this.activityInstanceService.getActivityInstance(callerId);
        }
        return null;
    }

    private void executeGateway(SProcessDefinition sProcessDefinition, STransitionDefinition sTransitionDefinition, SFlowNodeInstance flowNodeThatTriggeredTheTransition, Long tokenRefId) throws SBonitaException {
        long parentProcessInstanceId = flowNodeThatTriggeredTheTransition.getParentProcessInstanceId();
        long rootProcessInstanceId = flowNodeThatTriggeredTheTransition.getRootProcessInstanceId();
        SFlowNodeDefinition sFlowNodeDefinition = this.processDefinitionService.getNextFlowNode(sProcessDefinition, sTransitionDefinition.getName());
        Long processDefinitionId = sProcessDefinition.getId();
        boolean isGateway = SFlowNodeType.GATEWAY.equals((Object)sFlowNodeDefinition.getType());
        boolean toExecute = false;
        try {
            Long nextFlowNodeInstanceId;
            SProcessInstance parentProcessInstance = this.processInstanceService.getProcessInstance(parentProcessInstanceId);
            SStateCategory stateCategory = parentProcessInstance.getStateCategory();
            if (isGateway) {
                SGatewayInstance gatewayInstance = this.createOrRetreiveGateway(sProcessDefinition, sFlowNodeDefinition, stateCategory, tokenRefId, parentProcessInstanceId, rootProcessInstanceId, sTransitionDefinition);
                this.gatewayInstanceService.hitTransition(gatewayInstance, sFlowNodeDefinition.getTransitionIndex(sTransitionDefinition.getName()));
                nextFlowNodeInstanceId = gatewayInstance.getId();
                if (this.gatewayInstanceService.checkMergingCondition(sProcessDefinition, gatewayInstance)) {
                    this.gatewayInstanceService.setFinish(gatewayInstance);
                    toExecute = true;
                }
            } else {
                SFlowNodeInstance sFlowNodeInstance = this.bpmInstancesCreator.toFlowNodeInstance(processDefinitionId, flowNodeThatTriggeredTheTransition.getRootContainerId(), flowNodeThatTriggeredTheTransition.getParentContainerId(), SFlowElementsContainerType.PROCESS, sFlowNodeDefinition, rootProcessInstanceId, parentProcessInstanceId, true, -1, stateCategory, -1L, tokenRefId);
                new CreateEventInstance((SEventInstance)sFlowNodeInstance, this.eventInstanceService).call();
                nextFlowNodeInstanceId = sFlowNodeInstance.getId();
                toExecute = true;
            }
            if (toExecute) {
                this.workService.registerWork(WorkFactory.createExecuteFlowNodeWork(processDefinitionId, parentProcessInstanceId, nextFlowNodeInstanceId, null, null));
            }
        }
        catch (SBonitaException e) {
            this.setExceptionContext(sProcessDefinition, flowNodeThatTriggeredTheTransition, e);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.ERROR)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.ERROR, e);
            }
            throw e;
        }
    }

    private SGatewayInstance createOrRetreiveGateway(SProcessDefinition sProcessDefinition, SFlowNodeDefinition flowNodeDefinition, SStateCategory stateCategory, Long tokenRefId, long parentProcessInstanceId, long rootProcessInstanceId, STransitionDefinition transitionDefinition) throws SBonitaException {
        SGatewayInstance gatewayInstance = null;
        try {
            gatewayInstance = this.gatewayInstanceService.getActiveGatewayInstanceOfTheProcess(parentProcessInstanceId, flowNodeDefinition.getName());
        }
        catch (SGatewayNotFoundException e) {
            // empty catch block
        }
        if (gatewayInstance != null && gatewayInstance.getHitBys() != null && (gatewayInstance.getHitBys().contains("FINISH:") || Arrays.asList(gatewayInstance.getHitBys().split(",")).contains(flowNodeDefinition.getTransitionIndex(transitionDefinition.getName())))) {
            gatewayInstance = null;
        }
        if (gatewayInstance != null && !tokenRefId.equals(gatewayInstance.getTokenRefId())) {
            StringBuilder builder = new StringBuilder("Error while executing the join on the gateway. ");
            builder.append("This can happen when you try to join branches that are not from the same split level (some branches were split more times than others). ");
            builder.append("Check if your design is valid in the Bonita Studio. ");
            builder.append("Token is <" + tokenRefId + "> expected <" + gatewayInstance.getTokenRefId() + ">");
            SFlowNodeExecutionException exception = new SFlowNodeExecutionException(builder.toString());
            this.setExceptionContext(sProcessDefinition, (SFlowNodeInstance)gatewayInstance, (SBonitaException)exception);
            throw exception;
        }
        if (gatewayInstance != null) {
            return gatewayInstance;
        }
        return this.createGateway(sProcessDefinition.getId(), flowNodeDefinition, stateCategory, parentProcessInstanceId, tokenRefId, rootProcessInstanceId);
    }

    private SGatewayInstance createGateway(Long processDefinitionId, SFlowNodeDefinition flowNodeDefinition, SStateCategory stateCategory, long parentProcessInstanceId, Long tokenRefId, long rootProcessInstanceId) throws SBonitaException {
        return (SGatewayInstance)this.bpmInstancesCreator.createFlowNodeInstance(processDefinitionId, rootProcessInstanceId, parentProcessInstanceId, SFlowElementsContainerType.PROCESS, flowNodeDefinition, rootProcessInstanceId, parentProcessInstanceId, false, 0, stateCategory, -1L, tokenRefId);
    }

    protected void executeOperations(List<SOperation> operations, Map<String, Object> context, SExpressionContext expressionContext, SProcessInstance sProcessInstance) throws SBonitaException {
        if (operations != null && !operations.isEmpty()) {
            expressionContext.setInputValues(context);
            this.operationService.execute(operations, sProcessInstance.getId(), DataInstanceContainer.PROCESS_INSTANCE.name(), expressionContext);
        }
    }

    protected boolean initialize(long userId, SProcessDefinition sProcessDefinition, SProcessInstance sProcessInstance, SExpressionContext expressionContext, List<SOperation> operations, Map<String, Object> context, SFlowElementContainerDefinition processContainer, List<ConnectorDefinitionWithInputValues> connectors) throws BonitaHomeNotSetException, IOException, InvalidEvaluationConnectorConditionException, SBonitaException {
        this.bpmInstancesCreator.createDataInstances(sProcessInstance, processContainer, sProcessDefinition, expressionContext, operations, context);
        this.createDocuments(sProcessDefinition, sProcessInstance, userId);
        if (connectors != null) {
            this.executeConnectors(sProcessDefinition, sProcessInstance, connectors);
        }
        if (expressionContext == null) {
            expressionContext = new SExpressionContext();
        }
        this.executeOperations(operations, context, expressionContext, sProcessInstance);
        this.bpmInstancesCreator.createConnectorInstances(sProcessInstance, processContainer.getConnectors(), "process");
        return this.executeConnectors(sProcessDefinition, sProcessInstance, ConnectorEvent.ON_ENTER);
    }

    protected void createDocuments(SProcessDefinition sDefinition, SProcessInstance sProcessInstance, long authorId) throws SProcessDocumentCreationException, BonitaHomeNotSetException, STenantIdNotSetException, IOException {
        SFlowElementContainerDefinition processContainer = sDefinition.getProcessContainer();
        List<SDocumentDefinition> documentDefinitions = processContainer.getDocumentDefinitions();
        if (!documentDefinitions.isEmpty()) {
            String processesFolder = BonitaHomeServer.getInstance().getProcessFolder(this.sessionAccessor.getTenantId(), sDefinition.getId());
            File documentsFolder = new File(processesFolder, "documents");
            for (SDocumentDefinition document : documentDefinitions) {
                if (document.getFile() != null) {
                    String file = document.getFile();
                    byte[] content = FileUtils.readFileToByteArray((File)new File(documentsFolder, file));
                    this.attachDocument(sProcessInstance.getId(), document.getName(), document.getFileName(), document.getContentMimeType(), content, authorId);
                    continue;
                }
                if (document.getUrl() != null) {
                    this.attachDocument(sProcessInstance.getId(), document.getName(), document.getFileName(), document.getContentMimeType(), document.getUrl(), authorId);
                    continue;
                }
                throw new SProcessDocumentCreationException("Unable to create documents. A document was defined without url or content.");
            }
        }
    }

    protected SProcessDocument attachDocument(long processInstanceId, String documentName, String fileName, String mimeType, String url, long authorId) throws SProcessDocumentCreationException {
        SProcessDocument attachment = this.buildExternalProcessDocumentReference(processInstanceId, documentName, fileName, mimeType, authorId, url);
        return this.processDocumentService.attachDocumentToProcessInstance(attachment);
    }

    protected SProcessDocument attachDocument(long processInstanceId, String documentName, String fileName, String mimeType, byte[] documentContent, long authorId) throws SProcessDocumentCreationException {
        SProcessDocument attachment = this.buildProcessDocument(processInstanceId, documentName, fileName, mimeType, authorId);
        return this.processDocumentService.attachDocumentToProcessInstance(attachment, documentContent);
    }

    private SProcessDocument buildExternalProcessDocumentReference(long processInstanceId, String documentName, String fileName, String mimeType, long authorId, String url) {
        SProcessDocumentBuilder documentBuilder = this.initDocumentBuilder(processInstanceId, documentName, fileName, mimeType, authorId);
        documentBuilder.setURL(url);
        documentBuilder.setHasContent(false);
        return documentBuilder.done();
    }

    private SProcessDocument buildProcessDocument(long processInstanceId, String documentName, String fileName, String mimetype, long authorId) {
        SProcessDocumentBuilder documentBuilder = this.initDocumentBuilder(processInstanceId, documentName, fileName, mimetype, authorId);
        documentBuilder.setHasContent(true);
        return documentBuilder.done();
    }

    private SProcessDocumentBuilder initDocumentBuilder(long processInstanceId, String documentName, String fileName, String mimetype, long authorId) {
        SProcessDocumentBuilder documentBuilder = BuilderFactory.get(SProcessDocumentBuilderFactory.class).createNewInstance();
        documentBuilder.setName(documentName);
        documentBuilder.setFileName(fileName);
        documentBuilder.setContentMimeType(mimetype);
        documentBuilder.setProcessInstanceId(processInstanceId);
        documentBuilder.setAuthor(authorId);
        documentBuilder.setCreationDate(System.currentTimeMillis());
        return documentBuilder;
    }

    @Override
    public void childFinished(long processDefinitionId, long flowNodeInstanceId, long parentId) throws SBonitaException {
        SUserTaskInstanceBuilderFactory flowNodeKeyProvider;
        long processInstanceId;
        SProcessInstance sProcessInstance;
        SFlowNodeInstance sFlowNodeInstanceChild = this.activityInstanceService.getFlowNodeInstance(flowNodeInstanceId);
        SProcessDefinition sProcessDefinition = this.processDefinitionService.getProcessDefinition(processDefinitionId);
        int tokensOfProcess = this.executeValidOutgoingTransitionsAndUpdateTokens(sProcessDefinition, sFlowNodeInstanceChild, sProcessInstance = this.processInstanceService.getProcessInstance(processInstanceId = sFlowNodeInstanceChild.getLogicalGroup((flowNodeKeyProvider = BuilderFactory.get(SUserTaskInstanceBuilderFactory.class)).getParentProcessInstanceIndex())));
        if (tokensOfProcess == 0) {
            boolean hasActionsToExecute = false;
            if (ProcessInstanceState.ABORTING.getId() != sProcessInstance.getStateId()) {
                hasActionsToExecute = this.executePostThrowEventHandlers(sProcessDefinition, sProcessInstance, sFlowNodeInstanceChild);
                if (hasActionsToExecute) {
                    sProcessInstance = this.processInstanceService.getProcessInstance(processInstanceId);
                }
                this.eventsHandler.unregisterEventSubProcess(sProcessDefinition, sProcessInstance);
            }
            this.handleProcessCompletion(sProcessDefinition, sProcessInstance, hasActionsToExecute);
        }
    }

    @Override
    public void handleProcessCompletion(SProcessDefinition sProcessDefinition, SProcessInstance sProcessInstance, boolean hasActionsToExecute) throws SBonitaException {
        ProcessInstanceState processInstanceState;
        switch (sProcessInstance.getStateCategory()) {
            case ABORTING: {
                if (ProcessInstanceState.ABORTING.getId() == sProcessInstance.getStateId()) {
                    processInstanceState = ProcessInstanceState.ABORTED;
                    break;
                }
                if (hasActionsToExecute) {
                    processInstanceState = ProcessInstanceState.ABORTING;
                    break;
                }
                processInstanceState = ProcessInstanceState.ABORTED;
                break;
            }
            case CANCELLING: {
                processInstanceState = ProcessInstanceState.CANCELLED;
                break;
            }
            default: {
                processInstanceState = ProcessInstanceState.COMPLETING.getId() == sProcessInstance.getStateId() ? ProcessInstanceState.COMPLETED : (this.executeConnectors(sProcessDefinition, sProcessInstance, ConnectorEvent.ON_FINISH) ? ProcessInstanceState.COMPLETING : ProcessInstanceState.COMPLETED);
            }
        }
        this.processInstanceService.setState(sProcessInstance, processInstanceState);
        if (this.tokenService.getNumberOfToken(sProcessInstance.getId()) == 0) {
            this.flowNodeExecutor.childReachedState(sProcessInstance, processInstanceState, hasActionsToExecute);
        }
    }

    private boolean executePostThrowEventHandlers(SProcessDefinition sProcessDefinition, SProcessInstance sProcessInstance, SFlowNodeInstance child) throws SBonitaException {
        boolean hasActionsToExecute = false;
        if (sProcessInstance.hasBeenInterruptedByEvent()) {
            SFlowNodeInstance endEventInstance = this.activityInstanceService.getFlowNodeInstance(sProcessInstance.getInterruptingEventId());
            SEndEventDefinition endEventDefinition = (SEndEventDefinition)sProcessDefinition.getProcessContainer().getFlowNode(endEventInstance.getFlowNodeDefinitionId());
            hasActionsToExecute = this.eventsHandler.handlePostThrowEvent(sProcessDefinition, endEventDefinition, (SThrowEventInstance)endEventInstance, child);
            this.flowNodeExecutor.archiveFlowNodeInstance(endEventInstance, true, sProcessDefinition.getId());
        }
        return hasActionsToExecute;
    }

    private int executeValidOutgoingTransitionsAndUpdateTokens(SProcessDefinition sProcessDefinition, SFlowNodeInstance child, SProcessInstance sProcessInstance) throws SBonitaException {
        int numberOfTokenToMerge = this.getNumberOfTokenToMerge(child);
        SFlowNodeDefinition sFlowNodeDefinition = sProcessDefinition.getProcessContainer().getFlowNode(child.getFlowNodeDefinitionId());
        FlowNodeTransitionsWrapper transitionsDescriptor = this.buildTransitionsWrapper(sFlowNodeDefinition, sProcessDefinition, child);
        FlowNodeCompletionTokenProvider tokenProvider = new FlowNodeCompletionTokenProvider(child, sProcessInstance, sFlowNodeDefinition, transitionsDescriptor, this.tokenService);
        FlowMerger merger = new FlowMerger(sFlowNodeDefinition, transitionsDescriptor, tokenProvider);
        this.archiveInvalidTransitions(child, transitionsDescriptor);
        ArrayList<STransitionDefinition> chosenGatewaysTransitions = new ArrayList<STransitionDefinition>(transitionsDescriptor.getValidOutgoingTransitionDefinitions().size());
        ArrayList<SFlowNodeDefinition> chosenFlowNode = new ArrayList<SFlowNodeDefinition>(transitionsDescriptor.getValidOutgoingTransitionDefinitions().size());
        for (STransitionDefinition sTransitionDefinition : transitionsDescriptor.getValidOutgoingTransitionDefinitions()) {
            SFlowNodeDefinition flowNodeDefinition = this.processDefinitionService.getNextFlowNode(sProcessDefinition, sTransitionDefinition.getName());
            this.transitionService.archive(sTransitionDefinition, child, TransitionState.TAKEN);
            if (flowNodeDefinition instanceof SGatewayDefinition) {
                chosenGatewaysTransitions.add(sTransitionDefinition);
                continue;
            }
            chosenFlowNode.add(flowNodeDefinition);
        }
        this.archiveFlowNodeInstance(sProcessDefinition, child, sProcessInstance);
        TokenInfo outputTokenInfo = merger.getOutputTokenInfo();
        this.createAndExecuteActivities(sProcessDefinition.getId(), child, sProcessInstance.getId(), chosenFlowNode, child.getRootProcessInstanceId(), outputTokenInfo.outputTokenRefId);
        for (STransitionDefinition sTransitionDefinition : chosenGatewaysTransitions) {
            this.executeGateway(sProcessDefinition, sTransitionDefinition, child, outputTokenInfo.outputTokenRefId);
        }
        return this.updateTokens(sProcessDefinition, child, sProcessInstance, numberOfTokenToMerge, transitionsDescriptor, merger);
    }

    private void archiveFlowNodeInstance(SProcessDefinition sProcessDefinition, SFlowNodeInstance child, SProcessInstance sProcessInstance) throws SArchivingException {
        if (child.getId() != sProcessInstance.getInterruptingEventId() || SFlowNodeType.SUB_PROCESS.equals((Object)sProcessInstance.getCallerType())) {
            this.flowNodeExecutor.archiveFlowNodeInstance(child, true, sProcessDefinition.getId());
        }
    }

    private int updateTokens(SProcessDefinition sProcessDefinition, SFlowNodeInstance child, SProcessInstance sProcessInstance, int numberOfTokenToMerge, FlowNodeTransitionsWrapper transitionsDescriptor, FlowMerger merger) throws SObjectModificationException, SObjectNotFoundException, SObjectReadException, SObjectCreationException, SGatewayModificationException, SWorkRegisterException, SBonitaException {
        if (merger.mustConsumeInputTokenOnTakingTransition()) {
            this.tokenService.deleteTokens(sProcessInstance.getId(), child.getTokenRefId(), numberOfTokenToMerge);
        }
        if (merger.mustCreateTokenOnFinish()) {
            TokenInfo outputTokenInfo = merger.getOutputTokenInfo();
            this.tokenService.createTokens(sProcessInstance.getId(), outputTokenInfo.outputTokenRefId, outputTokenInfo.outputParentTokenRefId, transitionsDescriptor.getValidOutgoingTransitionDefinitions().size());
        }
        if (merger.isImplicitEnd()) {
            Long tokenRefId = child.getTokenRefId();
            if (tokenRefId == null) {
                throw new SObjectNotFoundException("No token ref id set for " + child);
            }
            this.implicitEnd(sProcessDefinition, sProcessInstance.getId(), numberOfTokenToMerge, tokenRefId);
        }
        return this.tokenService.getNumberOfToken(sProcessInstance.getId());
    }

    private void archiveInvalidTransitions(SFlowNodeInstance child, FlowNodeTransitionsWrapper transitionsDescriptor) throws STransitionCreationException {
        for (STransitionDefinition sTransitionDefinition : transitionsDescriptor.getAllOutgoingTransitionDefinitions()) {
            if (transitionsDescriptor.getValidOutgoingTransitionDefinitions().contains(sTransitionDefinition)) continue;
            this.transitionService.archive(sTransitionDefinition, child, TransitionState.ABORTED);
        }
    }

    private FlowNodeTransitionsWrapper buildTransitionsWrapper(SFlowNodeDefinition flowNode, SProcessDefinition sProcessDefinition, SFlowNodeInstance child) throws SBonitaException {
        FlowNodeTransitionsWrapper transitionsDescriptor = new FlowNodeTransitionsWrapper();
        if (flowNode == null) {
            transitionsDescriptor.setInputTransitionsSize(0);
            transitionsDescriptor.setAllOutgoingTransitionDefinitions(Collections.<STransitionDefinition>emptyList());
        } else {
            transitionsDescriptor.setInputTransitionsSize(flowNode.getIncomingTransitions().size());
            transitionsDescriptor.setAllOutgoingTransitionDefinitions(new ArrayList<STransitionDefinition>(flowNode.getOutgoingTransitions()));
        }
        transitionsDescriptor.setValidOutgoingTransitionDefinitions(this.evaluateOutgoingTransitions(transitionsDescriptor.getAllOutgoingTransitionDefinitions(), sProcessDefinition, child));
        return transitionsDescriptor;
    }

    private void implicitEnd(SProcessDefinition processDefinition, long processInstanceId, int numberOfTokenToMerge, Long tokenRefId) throws SGatewayModificationException, SWorkRegisterException, SBonitaException {
        SGatewayInstance gatewayInstance;
        SToken token = this.tokenService.getToken(processInstanceId, tokenRefId);
        this.tokenService.deleteTokens(processInstanceId, tokenRefId, numberOfTokenToMerge);
        if (processDefinition.getProcessContainer().containsInclusiveGateway() && (gatewayInstance = this.gatewayInstanceService.getGatewayMergingToken(processInstanceId, tokenRefId)) != null && this.gatewayInstanceService.checkMergingCondition(processDefinition, gatewayInstance)) {
            this.gatewayInstanceService.setFinish(gatewayInstance);
            this.workService.registerWork(WorkFactory.createExecuteFlowNodeWork(processDefinition.getId(), processInstanceId, gatewayInstance.getId(), null, null));
        }
        if (token.getParentRefId() != null && this.tokenService.getNumberOfToken(processInstanceId, tokenRefId) == 0) {
            this.implicitEnd(processDefinition, processInstanceId, 1, token.getParentRefId());
        }
    }

    @Override
    public SProcessInstance start(long starterId, long starterSubstituteId, List<SOperation> operations, Map<String, Object> context, List<ConnectorDefinitionWithInputValues> connectorsWithInput, FlowNodeSelector selector) throws SProcessInstanceCreationException {
        return this.start(starterId, starterSubstituteId, null, operations, context, connectorsWithInput, -1L, selector);
    }

    @Override
    public SProcessInstance start(long processDefinitionId, long targetSFlowNodeDefinitionId, long starterId, long starterSubstituteId, SExpressionContext expressionContext, List<SOperation> operations, Map<String, Object> context, List<ConnectorDefinitionWithInputValues> connectorsWithInput, long callerId, long subProcessDefinitionId) throws SProcessInstanceCreationException {
        try {
            SProcessDefinition sProcessDefinition = this.processDefinitionService.getProcessDefinition(processDefinitionId);
            FlowNodeSelector selector = new FlowNodeSelector(sProcessDefinition, this.getFilter(targetSFlowNodeDefinitionId), subProcessDefinitionId);
            return this.start(starterId, starterSubstituteId, expressionContext, operations, context, connectorsWithInput, callerId, selector);
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw new SProcessInstanceCreationException(e);
        }
        catch (SProcessDefinitionReadException e) {
            throw new SProcessInstanceCreationException(e);
        }
    }

    private Filter<SFlowNodeDefinition> getFilter(long targetSFlowNodeDefinitionId) {
        if (targetSFlowNodeDefinitionId == -1L) {
            return new StartFlowNodeFilter();
        }
        return new FlowNodeIdFilter(targetSFlowNodeDefinitionId);
    }

    @Override
    public SProcessInstance start(long starterId, long starterSubstituteId, SExpressionContext expressionContext, List<SOperation> operations, Map<String, Object> context, List<ConnectorDefinitionWithInputValues> connectors, long callerId, FlowNodeSelector selector) throws SProcessInstanceCreationException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            SProcessDefinition sProcessDefinition = selector.getProcessDefinition();
            ClassLoader localClassLoader = this.classLoaderService.getLocalClassLoader(ScopeType.PROCESS.name(), sProcessDefinition.getId());
            Thread.currentThread().setContextClassLoader(localClassLoader);
            try {
                localClassLoader.loadClass(this.getClass().getName());
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            SProcessInstance sProcessInstance = this.createProcessInstance(sProcessDefinition, starterId, starterSubstituteId, callerId);
            SFlowElementContainerDefinition processContainer = selector.getContainer();
            boolean isInitializing = this.initialize(starterId, sProcessDefinition, sProcessInstance, expressionContext, operations != null ? new ArrayList<SOperation>(operations) : operations, context, processContainer, connectors);
            try {
                this.handleEventSubProcess(sProcessDefinition, sProcessInstance, selector.getSubProcessDefinitionId());
            }
            catch (SProcessInstanceCreationException e) {
                throw e;
            }
            catch (SBonitaException e) {
                this.setExceptionContext(sProcessDefinition, sProcessInstance, e);
                throw new SProcessInstanceCreationException("Unable to register events for event sub process in process.", e);
            }
            if (isInitializing) {
                this.processInstanceService.setState(sProcessInstance, ProcessInstanceState.INITIALIZING);
                SProcessInstance sProcessInstance2 = sProcessInstance;
                return sProcessInstance2;
            }
            SProcessInstance sProcessInstance3 = this.startElements(sProcessInstance, selector);
            return sProcessInstance3;
        }
        catch (BonitaException e) {
            throw new SProcessInstanceCreationException(e);
        }
        catch (IOException e) {
            throw new SProcessInstanceCreationException(e);
        }
        catch (SProcessInstanceCreationException e) {
            throw e;
        }
        catch (SBonitaException e) {
            throw new SProcessInstanceCreationException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    protected void executeConnectors(SProcessDefinition processDefinition, SProcessInstance sProcessInstance, List<ConnectorDefinitionWithInputValues> connectorsList) throws InvalidEvaluationConnectorConditionException, SConnectorException {
        SExpressionContext expcontext = new SExpressionContext();
        expcontext.setProcessDefinitionId(processDefinition.getId());
        expcontext.setProcessDefinition(processDefinition);
        expcontext.setContainerId(sProcessInstance.getId());
        expcontext.setContainerType(DataInstanceContainer.PROCESS_INSTANCE.name());
        for (ConnectorDefinitionWithInputValues connectorWithInput : connectorsList) {
            ConnectorDefinition connectorDefinition = connectorWithInput.getConnectorDefinition();
            Map contextInputValues = connectorWithInput.getInputValues();
            String connectorId = connectorDefinition.getConnectorId();
            String version = connectorDefinition.getVersion();
            Map inputs = connectorDefinition.getInputs();
            if (contextInputValues.size() != inputs.size()) {
                throw new InvalidEvaluationConnectorConditionException(contextInputValues.size(), inputs.size());
            }
            Map<String, SExpression> connectorsExps = ModelConvertor.constructExpressions(inputs);
            ConnectorResult result = this.connectorService.executeMutipleEvaluation(processDefinition.getId(), connectorId, version, connectorsExps, contextInputValues, Thread.currentThread().getContextClassLoader(), expcontext);
            List outputs = connectorDefinition.getOutputs();
            this.connectorService.executeOutputOperation(ServerModelConvertor.convertOperations(outputs), expcontext, result);
        }
    }

    protected void handleEventSubProcess(SProcessDefinition sProcessDefinition, SProcessInstance sProcessInstance, long subProcessDefinitionId) throws SBonitaException {
        if (subProcessDefinitionId == -1L) {
            this.eventsHandler.handleEventSubProcess(sProcessDefinition, sProcessInstance);
        }
    }

    @Override
    public SProcessInstance startElements(SProcessInstance sProcessInstance, FlowNodeSelector selector) throws SProcessInstanceCreationException, SFlowNodeExecutionException {
        List<SFlowNodeInstance> flowNodeInstances = this.initializeFirstExecutableElements(sProcessInstance, selector);
        int size = flowNodeInstances.size();
        ProcessInstanceState state = size == 0 ? ProcessInstanceState.COMPLETED : ProcessInstanceState.STARTED;
        try {
            this.tokenService.createTokens(sProcessInstance.getId(), sProcessInstance.getProcessDefinitionId(), null, size);
            this.processInstanceService.setState(sProcessInstance, state);
        }
        catch (SBonitaException e) {
            throw new SProcessInstanceCreationException("Unable to set the state on the process.", e);
        }
        for (SFlowNodeInstance sFlowNodeInstance : flowNodeInstances) {
            try {
                this.workService.registerWork(WorkFactory.createExecuteFlowNodeWork(sProcessInstance.getProcessDefinitionId(), sProcessInstance.getId(), sFlowNodeInstance.getId(), null, null));
            }
            catch (SWorkRegisterException e) {
                this.setExceptionContext(sProcessInstance, sFlowNodeInstance, (SBonitaException)e);
                throw new SFlowNodeExecutionException("Unable to trigger execution of the flow node.", e);
            }
        }
        return sProcessInstance;
    }

    @Override
    public String getHandledType() {
        return SFlowElementsContainerType.PROCESS.name();
    }

    private void createAndExecuteActivities(Long processDefinitionId, SFlowNodeInstance flowNodeInstance, long parentProcessInstanceId, List<SFlowNodeDefinition> choosenActivityDefinitions, long rootProcessInstanceId, Long tokenRefId) throws SBonitaException {
        SProcessInstance parentProcessInstance = this.processInstanceService.getProcessInstance(parentProcessInstanceId);
        SStateCategory stateCategory = parentProcessInstance.getStateCategory();
        List<SFlowNodeInstance> sFlowNodeInstances = this.bpmInstancesCreator.createFlowNodeInstances(processDefinitionId, flowNodeInstance.getRootContainerId(), flowNodeInstance.getParentContainerId(), choosenActivityDefinitions, rootProcessInstanceId, parentProcessInstanceId, stateCategory, tokenRefId);
        for (SFlowNodeInstance sFlowNodeInstance : sFlowNodeInstances) {
            this.workService.registerWork(WorkFactory.createExecuteFlowNodeWork(processDefinitionId, parentProcessInstanceId, sFlowNodeInstance.getId(), null, null));
        }
    }

    private void setExceptionContext(SProcessDefinition sProcessDefinition, SFlowNodeInstance sFlowNodeInstance, SBonitaException e) {
        this.setExceptionContext(sProcessDefinition, e);
        e.setProcessInstanceIdOnContext(sFlowNodeInstance.getParentProcessInstanceId());
        e.setRootProcessInstanceIdOnContext(sFlowNodeInstance.getRootProcessInstanceId());
        this.setExceptionContext(sFlowNodeInstance, e);
    }

    private void setExceptionContext(SProcessDefinition sProcessDefinition, SProcessInstance sProcessInstance, SBonitaException e) {
        this.setExceptionContext(sProcessDefinition, e);
        this.setExceptionContext(sProcessInstance, e);
    }

    private void setExceptionContext(SProcessInstance sProcessInstance, SFlowNodeInstance sFlowNodeInstance, SBonitaException e) {
        e.setProcessDefinitionIdOnContext(sProcessInstance.getProcessDefinitionId());
        e.setProcessDefinitionNameOnContext(sProcessInstance.getName());
        this.setExceptionContext(sProcessInstance, e);
        this.setExceptionContext(sFlowNodeInstance, e);
    }

    private void setExceptionContext(SProcessDefinition sProcessDefinition, SBonitaException e) {
        e.setProcessDefinitionIdOnContext(sProcessDefinition.getId());
        e.setProcessDefinitionNameOnContext(sProcessDefinition.getName());
        e.setProcessDefinitionVersionOnContext(sProcessDefinition.getVersion());
    }

    private void setExceptionContext(SProcessInstance sProcessInstance, SBonitaException e) {
        e.setProcessInstanceIdOnContext(sProcessInstance.getId());
        e.setRootProcessInstanceIdOnContext(sProcessInstance.getRootProcessInstanceId());
    }

    private void setExceptionContext(SFlowNodeInstance sFlowNodeInstance, SBonitaException e) {
        e.setFlowNodeDefinitionIdOnContext(sFlowNodeInstance.getFlowNodeDefinitionId());
        e.setFlowNodeInstanceIdOnContext(sFlowNodeInstance.getId());
        e.setFlowNodeNameOnContext(sFlowNodeInstance.getName());
    }
}

