/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.event;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bonitasoft.engine.bpm.model.impl.BPMInstancesCreator;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.core.expression.control.api.ExpressionResolverService;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.model.SActivityDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeType;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.SReceiveTaskDefinition;
import org.bonitasoft.engine.core.process.definition.model.SSendTaskDefinition;
import org.bonitasoft.engine.core.process.definition.model.SSubProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.builder.event.trigger.SThrowErrorEventTriggerDefinitionBuilderFactory;
import org.bonitasoft.engine.core.process.definition.model.event.SEndEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SStartEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SCatchMessageEventTriggerDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SEventTriggerDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SEventTriggerType;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SThrowErrorEventTriggerDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SThrowMessageEventTriggerDefinition;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.core.process.instance.api.TokenService;
import org.bonitasoft.engine.core.process.instance.api.event.EventInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeExecutionException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeReadException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceCreationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SEventTriggerInstanceCreationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SMessageInstanceCreationException;
import org.bonitasoft.engine.core.process.instance.model.SFlowElementsContainerType;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.core.process.instance.model.SReceiveTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SSendTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SStateCategory;
import org.bonitasoft.engine.core.process.instance.model.event.SCatchEventInstance;
import org.bonitasoft.engine.core.process.instance.model.event.SEventInstance;
import org.bonitasoft.engine.core.process.instance.model.event.SThrowEventInstance;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SBPMEventType;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SWaitingEvent;
import org.bonitasoft.engine.data.instance.api.DataInstanceService;
import org.bonitasoft.engine.data.instance.exception.SDataInstanceException;
import org.bonitasoft.engine.execution.ContainerRegistry;
import org.bonitasoft.engine.execution.ProcessExecutor;
import org.bonitasoft.engine.execution.TransactionContainedProcessInstanceInterruptor;
import org.bonitasoft.engine.execution.TransactionalProcessInstanceInterruptor;
import org.bonitasoft.engine.execution.event.ErrorEventHandlerStrategy;
import org.bonitasoft.engine.execution.event.EventHandlerStrategy;
import org.bonitasoft.engine.execution.event.MessageEventHandlerStrategy;
import org.bonitasoft.engine.execution.event.OperationsWithContext;
import org.bonitasoft.engine.execution.event.SignalEventHandlerStrategy;
import org.bonitasoft.engine.execution.event.TerminateEventHandlerStrategy;
import org.bonitasoft.engine.execution.event.TimerEventHandlerStrategy;
import org.bonitasoft.engine.expression.exception.SExpressionException;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.scheduler.SchedulerService;

public class EventsHandler {
    private final Map<SEventTriggerType, EventHandlerStrategy> handlers;
    private final ContainerRegistry containerRegistry;
    private final ProcessDefinitionService processDefinitionService;
    private final TokenService tokenService;
    private final EventInstanceService eventInstanceService;
    private final BPMInstancesCreator bpmInstancesCreator;
    private final ProcessInstanceService processInstanceService;
    private final TechnicalLoggerService logger;
    private ProcessExecutor processExecutor;

    public EventsHandler(SchedulerService schedulerService, ExpressionResolverService expressionResolverService, EventInstanceService eventInstanceService, BPMInstancesCreator bpmInstancesCreator, DataInstanceService dataInstanceService, ProcessDefinitionService processDefinitionService, ContainerRegistry containerRegistry, ProcessInstanceService processInstanceService, TokenService tokenService, TechnicalLoggerService logger) {
        this.eventInstanceService = eventInstanceService;
        this.processDefinitionService = processDefinitionService;
        this.containerRegistry = containerRegistry;
        this.bpmInstancesCreator = bpmInstancesCreator;
        this.processInstanceService = processInstanceService;
        this.tokenService = tokenService;
        this.logger = logger;
        this.handlers = new HashMap<SEventTriggerType, EventHandlerStrategy>(4);
        this.handlers.put(SEventTriggerType.TIMER, new TimerEventHandlerStrategy(expressionResolverService, schedulerService, logger));
        this.handlers.put(SEventTriggerType.MESSAGE, new MessageEventHandlerStrategy(expressionResolverService, eventInstanceService, bpmInstancesCreator, dataInstanceService, processDefinitionService));
        this.handlers.put(SEventTriggerType.SIGNAL, new SignalEventHandlerStrategy(this, eventInstanceService));
        this.handlers.put(SEventTriggerType.TERMINATE, new TerminateEventHandlerStrategy(processInstanceService, eventInstanceService, containerRegistry, logger));
        this.handlers.put(SEventTriggerType.ERROR, new ErrorEventHandlerStrategy(eventInstanceService, processInstanceService, containerRegistry, processDefinitionService, this, logger));
    }

    public void setProcessExecutor(ProcessExecutor processExecutor) {
        this.processExecutor = processExecutor;
    }

    public void handleCatchEvent(SProcessDefinition processDefinition, SEventDefinition eventDefinition, SEventInstance eventInstance) throws SBonitaException {
        List<SEventTriggerDefinition> eventTriggers = eventDefinition.getEventTriggers();
        for (SEventTriggerDefinition sEventTriggerDefinition : eventTriggers) {
            EventHandlerStrategy eventHandlerStrategy = this.handlers.get((Object)sEventTriggerDefinition.getEventTriggerType());
            eventHandlerStrategy.handleCatchEvent(processDefinition, eventDefinition, (SCatchEventInstance)eventInstance, sEventTriggerDefinition);
        }
    }

    public void handleCatchMessage(SProcessDefinition processDefinition, SReceiveTaskDefinition receiveTaskDefinition, SReceiveTaskInstance receiveTaskInstance) throws SBonitaException {
        SCatchMessageEventTriggerDefinition eventTrigger = receiveTaskDefinition.getTrigger();
        MessageEventHandlerStrategy messageEventHandlerStrategy = (MessageEventHandlerStrategy)this.handlers.get((Object)SEventTriggerType.MESSAGE);
        messageEventHandlerStrategy.handleCatchEvent(processDefinition, receiveTaskInstance, eventTrigger);
    }

    private void handleEventSubProcess(SProcessDefinition processDefinition, SEventDefinition eventDefinition, long subProcessId, SProcessInstance parentProcessInstance) throws SBonitaException {
        List<SEventTriggerDefinition> eventTriggers = eventDefinition.getEventTriggers();
        for (SEventTriggerDefinition sEventTriggerDefinition : eventTriggers) {
            EventHandlerStrategy eventHandlerStrategy = this.handlers.get((Object)sEventTriggerDefinition.getEventTriggerType());
            eventHandlerStrategy.handleEventSubProcess(processDefinition, eventDefinition, sEventTriggerDefinition, subProcessId, parentProcessInstance);
        }
    }

    public void handleEventSubProcess(SProcessDefinition sDefinition, SProcessInstance parentProcessInstance) throws SBonitaException {
        Set<SActivityDefinition> activities = sDefinition.getProcessContainer().getActivities();
        for (SActivityDefinition activity : activities) {
            if (!SFlowNodeType.SUB_PROCESS.equals((Object)activity.getType()) || !((SSubProcessDefinition)activity).isTriggeredByEvent()) continue;
            SSubProcessDefinition eventSubProcess = (SSubProcessDefinition)activity;
            SStartEventDefinition sStartEventDefinition = eventSubProcess.getSubProcessContainer().getStartEvents().get(0);
            this.handleEventSubProcess(sDefinition, sStartEventDefinition, activity.getId(), parentProcessInstance);
        }
    }

    private void unregisterEventSubProcess(SProcessDefinition processDefinition, SEventDefinition eventDefinition, long subProcessId, SProcessInstance parentProcessInstance) throws SBonitaException {
        List<SEventTriggerDefinition> eventTriggers = eventDefinition.getEventTriggers();
        for (SEventTriggerDefinition sEventTriggerDefinition : eventTriggers) {
            EventHandlerStrategy eventHandlerStrategy = this.handlers.get((Object)sEventTriggerDefinition.getEventTriggerType());
            eventHandlerStrategy.unregisterCatchEvent(processDefinition, eventDefinition, sEventTriggerDefinition, subProcessId, parentProcessInstance);
        }
    }

    public void unregisterEventSubProcess(SProcessDefinition sDefinition, SProcessInstance parentProcessInstance) throws SBonitaException {
        Set<SActivityDefinition> activities = sDefinition.getProcessContainer().getActivities();
        for (SActivityDefinition activity : activities) {
            if (!SFlowNodeType.SUB_PROCESS.equals((Object)activity.getType()) || !((SSubProcessDefinition)activity).isTriggeredByEvent()) continue;
            SSubProcessDefinition eventSubProcess = (SSubProcessDefinition)activity;
            SStartEventDefinition sStartEventDefinition = eventSubProcess.getSubProcessContainer().getStartEvents().get(0);
            this.unregisterEventSubProcess(sDefinition, sStartEventDefinition, activity.getId(), parentProcessInstance);
        }
    }

    public void handleThrowEvent(SProcessDefinition processDefinition, SEventDefinition eventDefinition, SEventInstance eventInstance) throws SBonitaException {
        List<SEventTriggerDefinition> eventTriggers = eventDefinition.getEventTriggers();
        for (SEventTriggerDefinition sEventTriggerDefinition : eventTriggers) {
            EventHandlerStrategy eventHandlerStrategy = this.handlers.get((Object)sEventTriggerDefinition.getEventTriggerType());
            if (eventHandlerStrategy == null) continue;
            eventHandlerStrategy.handleThrowEvent(processDefinition, eventDefinition, (SThrowEventInstance)eventInstance, sEventTriggerDefinition);
        }
    }

    public void handleThrowMessage(SProcessDefinition processDefinition, SSendTaskDefinition sendTaskDefinition, SSendTaskInstance sendTaskInstance) throws SEventTriggerInstanceCreationException, SMessageInstanceCreationException, SDataInstanceException, SExpressionException {
        SThrowMessageEventTriggerDefinition eventTrigger = sendTaskDefinition.getMessageTrigger();
        MessageEventHandlerStrategy messageEventHandlerStrategy = (MessageEventHandlerStrategy)this.handlers.get((Object)SEventTriggerType.MESSAGE);
        messageEventHandlerStrategy.handleThrowEvent(processDefinition, sendTaskInstance, eventTrigger);
    }

    public boolean handlePostThrowEvent(SProcessDefinition sProcessDefinition, SEndEventDefinition sEndEventDefinition, SThrowEventInstance sThrowEventInstance, SFlowNodeInstance sFlowNodeInstance) throws SBonitaException {
        boolean hasActionsToExecute = false;
        if (sEndEventDefinition == null) {
            String errorCode = sThrowEventInstance.getName();
            SThrowErrorEventTriggerDefinition errorEventTriggerDefinition = BuilderFactory.get(SThrowErrorEventTriggerDefinitionBuilderFactory.class).createNewInstance(errorCode).done();
            hasActionsToExecute = this.handlers.get((Object)SEventTriggerType.ERROR).handlePostThrowEvent(sProcessDefinition, null, sThrowEventInstance, errorEventTriggerDefinition, sFlowNodeInstance);
        } else {
            List<SEventTriggerDefinition> eventTriggers = sEndEventDefinition.getEventTriggers();
            for (SEventTriggerDefinition sEventTriggerDefinition : eventTriggers) {
                EventHandlerStrategy eventHandlerStrategy = this.handlers.get((Object)sEventTriggerDefinition.getEventTriggerType());
                if (eventHandlerStrategy == null) continue;
                hasActionsToExecute = hasActionsToExecute || eventHandlerStrategy.handlePostThrowEvent(sProcessDefinition, sEndEventDefinition, sThrowEventInstance, sEventTriggerDefinition, sFlowNodeInstance);
            }
        }
        return hasActionsToExecute;
    }

    public void handleThrowEvent(SEventTriggerDefinition sEventTriggerDefinition) throws SBonitaException {
        EventHandlerStrategy eventHandlerStrategy = this.handlers.get((Object)sEventTriggerDefinition.getEventTriggerType());
        if (eventHandlerStrategy != null) {
            eventHandlerStrategy.handleThrowEvent(sEventTriggerDefinition);
        }
    }

    public void triggerCatchEvent(SWaitingEvent waitingEvent, Long triggeringElementID) throws SBonitaException {
        SBPMEventType eventType = waitingEvent.getEventType();
        long processDefinitionId = waitingEvent.getProcessDefinitionId();
        long targetSFlowNodeDefinitionId = waitingEvent.getFlowNodeDefinitionId();
        long flowNodeInstanceId = waitingEvent.getFlowNodeInstanceId();
        OperationsWithContext operations = this.handlers.get((Object)waitingEvent.getEventTriggerType()).getOperations(waitingEvent, triggeringElementID);
        if (SBPMEventType.EVENT_SUB_PROCESS.equals((Object)waitingEvent.getEventType())) {
            SProcessDefinition processDefinition = this.processDefinitionService.getProcessDefinition(processDefinitionId);
            SStartEventDefinition startEvent = (SStartEventDefinition)processDefinition.getProcessContainer().getFlowNode(waitingEvent.getFlowNodeDefinitionId());
            this.triggerCatchStartEventSubProcess(waitingEvent.getEventTriggerType(), processDefinitionId, targetSFlowNodeDefinitionId, operations, waitingEvent.getSubProcessId(), waitingEvent.getParentProcessInstanceId(), waitingEvent.getRootProcessInstanceId(), startEvent.isInterrupting());
        } else {
            this.triggerCatchEvent(eventType, processDefinitionId, targetSFlowNodeDefinitionId, waitingEvent, flowNodeInstanceId, operations);
        }
    }

    private void triggerInTransaction(final SBPMEventType eventType, final Long processDefinitionId, final Long targetSFlowNodeDefinitionId, final SWaitingEvent waitingEvent, final Long flowNodeInstanceId, final OperationsWithContext operations) throws SBonitaException {
        TransactionContent transactionContent = new TransactionContent(){

            @Override
            public void execute() throws SBonitaException {
                EventsHandler.this.triggerCatchEvent(eventType, processDefinitionId, targetSFlowNodeDefinitionId, waitingEvent, flowNodeInstanceId, operations);
            }
        };
        transactionContent.execute();
    }

    private void triggerInTransaction(final SEventTriggerType eventTriggerType, final Long processDefinitionId, final Long targetSFlowNodeDefinitionId, final OperationsWithContext operations, final long subProcessId, final Long parentProcessInstanceId, final Long rootProcessInstanceId, final Boolean isInterrupting) throws SBonitaException {
        TransactionContent transactionContent = new TransactionContent(){

            @Override
            public void execute() throws SBonitaException {
                EventsHandler.this.triggerCatchStartEventSubProcess(eventTriggerType, processDefinitionId, targetSFlowNodeDefinitionId, operations, subProcessId, parentProcessInstanceId, rootProcessInstanceId, isInterrupting);
            }
        };
        transactionContent.execute();
    }

    private void triggerCatchEvent(SBPMEventType eventType, Long processDefinitionId, Long targetSFlowNodeDefinitionId, SWaitingEvent waitingEvent, Long flowNodeInstanceId, OperationsWithContext operations) throws SBonitaException {
        switch (eventType) {
            case START_EVENT: {
                this.instantiateProcess(processDefinitionId, targetSFlowNodeDefinitionId, operations);
                break;
            }
            default: {
                if (waitingEvent != null) {
                    this.eventInstanceService.deleteWaitingEvent(waitingEvent);
                    this.executeFlowNode(flowNodeInstanceId, operations, waitingEvent.getParentProcessInstanceId());
                    break;
                }
                long processInstanceId = this.eventInstanceService.getFlowNodeInstance(flowNodeInstanceId).getParentProcessInstanceId();
                this.executeFlowNode(flowNodeInstanceId, operations, processInstanceId);
            }
        }
    }

    private void triggerCatchStartEventSubProcess(SEventTriggerType triggerType, Long processDefinitionId, Long targetSFlowNodeDefinitionId, OperationsWithContext operations, long subProcessId, long parentProcessInstanceId, Long rootProcessInstanceId, Boolean isInterrupting) throws SBonitaException {
        SProcessDefinition processDefinition = this.processDefinitionService.getProcessDefinition(processDefinitionId);
        SFlowNodeDefinition sFlowNodeDefinition = processDefinition.getProcessContainer().getFlowNode(subProcessId);
        SFlowNodeInstance subProcflowNodeInstance = this.bpmInstancesCreator.createFlowNodeInstance(processDefinitionId, rootProcessInstanceId, parentProcessInstanceId, SFlowElementsContainerType.PROCESS, sFlowNodeDefinition, rootProcessInstanceId, parentProcessInstanceId, false, 0, SStateCategory.NORMAL, -1L, processDefinitionId);
        SProcessInstance parentProcessInstance = this.processInstanceService.getProcessInstance(parentProcessInstanceId);
        this.tokenService.createToken(parentProcessInstanceId, parentProcessInstance.getProcessDefinitionId(), null);
        if (triggerType.equals((Object)SEventTriggerType.ERROR)) {
            TransactionContainedProcessInstanceInterruptor interruptor = new TransactionContainedProcessInstanceInterruptor(this.processInstanceService, this.eventInstanceService, this.containerRegistry, this.logger);
            interruptor.interruptProcessInstance(parentProcessInstanceId, SStateCategory.ABORTING, -1L, subProcflowNodeInstance.getId());
        } else if (isInterrupting.booleanValue()) {
            TransactionalProcessInstanceInterruptor interruptor = new TransactionalProcessInstanceInterruptor(this.processInstanceService, this.eventInstanceService, this.processExecutor, this.logger);
            interruptor.interruptProcessInstance(parentProcessInstanceId, SStateCategory.ABORTING, -1L, subProcflowNodeInstance.getId());
        }
        this.processExecutor.start(processDefinitionId, targetSFlowNodeDefinitionId, 0L, 0L, operations.getContext(), operations.getOperations(), null, null, subProcflowNodeInstance.getId(), subProcessId);
        this.unregisterEventSubProcess(processDefinition, parentProcessInstance);
    }

    public void triggerCatchEvent(String eventType, Long processDefinitionId, Long targetSFlowNodeDefinitionId, Long flowNodeInstanceId, String containerType) throws SBonitaException {
        SBPMEventType type = SBPMEventType.valueOf(eventType);
        this.triggerInTransaction(type, processDefinitionId, targetSFlowNodeDefinitionId, null, flowNodeInstanceId, new OperationsWithContext(null, null, containerType));
    }

    public void triggerCatchEvent(SEventTriggerType eventTriggerType, Long processDefinitionId, Long targetSFlowNodeDefinitionId, String containerType, long subProcessId, Long parentProcessInstanceId, Long rootProcessInstanceId, Boolean isInterrupting) throws SBonitaException {
        this.triggerInTransaction(eventTriggerType, processDefinitionId, targetSFlowNodeDefinitionId, new OperationsWithContext(null, null, containerType), subProcessId, parentProcessInstanceId, rootProcessInstanceId, isInterrupting);
    }

    private void executeFlowNode(long flowNodeInstanceId, OperationsWithContext operations, long processInstanceId) throws SFlowNodeReadException, SFlowNodeExecutionException {
        this.containerRegistry.executeFlowNodeInSameThread(processInstanceId, flowNodeInstanceId, operations.getContext(), operations.getOperations(), operations.getContainerType());
    }

    private void instantiateProcess(long processDefinitionId, long targetSFlowNodeDefinitionId, OperationsWithContext operations) throws SProcessInstanceCreationException {
        this.processExecutor.start(processDefinitionId, targetSFlowNodeDefinitionId, 0L, 0L, operations.getContext(), operations.getOperations(), null, null, -1L, -1L);
    }

    public EventHandlerStrategy getHandler(SEventTriggerType triggerType) {
        return this.handlers.get((Object)triggerType);
    }
}

