/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.work;

import java.util.Iterator;
import java.util.concurrent.Callable;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.execution.work.RestartException;
import org.bonitasoft.engine.execution.work.RestartFlowNodesHandler;
import org.bonitasoft.engine.execution.work.WorkFactory;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.work.SWorkRegisterException;
import org.bonitasoft.engine.work.WorkService;

public class ExecuteFlowNodes
implements Callable<Object> {
    private final WorkService workService;
    private final TechnicalLoggerService logger;
    private final ActivityInstanceService activityInstanceService;
    private final Iterator<Long> iterator;

    public ExecuteFlowNodes(WorkService workService, TechnicalLoggerService logger, ActivityInstanceService activityInstanceService, Iterator<Long> iterator) {
        this.workService = workService;
        this.logger = logger;
        this.activityInstanceService = activityInstanceService;
        this.iterator = iterator;
    }

    @Override
    public Object call() throws Exception {
        try {
            for (int i = 0; i < 20 && this.iterator.hasNext(); ++i) {
                SFlowNodeInstance flowNodeInstance = this.activityInstanceService.getFlowNodeInstance(this.iterator.next());
                if (flowNodeInstance.isTerminal()) {
                    this.createNotifyChildFinishedWork(this.workService, this.logger, flowNodeInstance);
                    continue;
                }
                this.createExecuteFlowNodeWork(this.workService, this.logger, flowNodeInstance);
            }
            return null;
        }
        catch (SWorkRegisterException e) {
            throw new RestartException("Unable to restart flowNodes: can't register work", e);
        }
        catch (SBonitaException e) {
            throw new RestartException("Unable to restart flowNodes: can't read flow nodes", e);
        }
    }

    void createExecuteFlowNodeWork(WorkService workService, TechnicalLoggerService logger, SFlowNodeInstance sFlowNodeInstance) throws SWorkRegisterException {
        this.logInfo(logger, "Restarting flow node (Execute ...) with name = <" + sFlowNodeInstance.getName() + ">, and id = <" + sFlowNodeInstance.getId() + "> in state = <" + sFlowNodeInstance.getStateName() + ">");
        workService.registerWork(WorkFactory.createExecuteFlowNodeWork(sFlowNodeInstance.getProcessDefinitionId(), sFlowNodeInstance.getParentProcessInstanceId(), sFlowNodeInstance.getId(), null, null));
    }

    void createNotifyChildFinishedWork(WorkService workService, TechnicalLoggerService logger, SFlowNodeInstance sFlowNodeInstance) throws SWorkRegisterException {
        this.logInfo(logger, "Restarting flow node (Notify finished...) with name = <" + sFlowNodeInstance.getName() + ">, and id = <" + sFlowNodeInstance.getId() + " in state = <" + sFlowNodeInstance.getStateName() + ">");
        workService.registerWork(WorkFactory.createNotifyChildFinishedWork(sFlowNodeInstance.getProcessDefinitionId(), sFlowNodeInstance.getParentProcessInstanceId(), sFlowNodeInstance.getId(), sFlowNodeInstance.getParentContainerId(), sFlowNodeInstance.getParentContainerType().name()));
    }

    private void logInfo(TechnicalLoggerService logger, String message) {
        boolean isInfo = logger.isLoggable(RestartFlowNodesHandler.class, TechnicalLogSeverity.INFO);
        if (isInfo) {
            logger.log(RestartFlowNodesHandler.class, TechnicalLogSeverity.INFO, message);
        }
    }
}

