/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.external.permission;

import java.io.Serializable;
import java.util.Map;
import org.bonitasoft.engine.actor.mapping.ActorMappingService;
import org.bonitasoft.engine.actor.mapping.SActorNotFoundException;
import org.bonitasoft.engine.actor.mapping.model.SActor;
import org.bonitasoft.engine.api.impl.SessionInfos;
import org.bonitasoft.engine.command.SCommandExecutionException;
import org.bonitasoft.engine.command.SCommandParameterizationException;
import org.bonitasoft.engine.command.system.CommandWithParameters;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityInstanceNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityReadException;
import org.bonitasoft.engine.core.process.instance.model.SHumanTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAHumanTaskInstance;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.session.model.SSession;

public class IsInvolvedInHumanTask
extends CommandWithParameters {
    private static final String USER_ID_KEY = "USER_ID_KEY";
    private static final String HUMAN_TASK_INSTANCE_ID_KEY = "HUMAN_TASK_INSTANCE_ID_KEY";

    @Override
    public Serializable execute(Map<String, Serializable> parameters, TenantServiceAccessor serviceAccessor) throws SCommandParameterizationException, SCommandExecutionException {
        long userId = this.getLongMandadoryParameter(parameters, USER_ID_KEY);
        long humanTaskInstanceId = this.getLongMandadoryParameter(parameters, HUMAN_TASK_INSTANCE_ID_KEY);
        try {
            return this.isInvolvedInHumanTask(userId, humanTaskInstanceId, serviceAccessor);
        }
        catch (SBonitaException e) {
            throw new SCommandExecutionException("Error executing command 'Boolean IsInvolvedInHumanTask(long userId, long humanTaskInstanceId)'", e);
        }
    }

    private Boolean isInvolvedInHumanTask(long userId, long humanTaskInstanceId, TenantServiceAccessor serviceAccessor) throws SActivityInstanceNotFoundException, SActivityReadException, SActorNotFoundException, SBonitaReadException {
        long processDefinitionId;
        ActorMappingService actorMappingService = serviceAccessor.getActorMappingService();
        ActivityInstanceService activityInstanceService = serviceAccessor.getActivityInstanceService();
        long actorId = -1L;
        long assigneeId = -1L;
        try {
            SHumanTaskInstance humanTaskInstance = activityInstanceService.getHumanTaskInstance(humanTaskInstanceId);
            actorId = humanTaskInstance.getActorId();
            assigneeId = humanTaskInstance.getAssigneeId();
            processDefinitionId = humanTaskInstance.getProcessDefinitionId();
        }
        catch (SActivityInstanceNotFoundException e) {
            SAActivityInstance archivedActivityInstance = activityInstanceService.getMostRecentArchivedActivityInstance(humanTaskInstanceId);
            if (archivedActivityInstance instanceof SAHumanTaskInstance) {
                SAHumanTaskInstance saHumanTaskInstance = (SAHumanTaskInstance)archivedActivityInstance;
                actorId = saHumanTaskInstance.getActorId();
                assigneeId = saHumanTaskInstance.getAssigneeId();
                processDefinitionId = saHumanTaskInstance.getProcessDefinitionId();
            }
            throw new SActivityInstanceNotFoundException(humanTaskInstanceId);
        }
        SSession session = SessionInfos.getSession();
        if (session.getUserId() == assigneeId) {
            return true;
        }
        if (userId != -1L && assigneeId != 0L) {
            return true;
        }
        if (assigneeId == 0L) {
            SActor actor = actorMappingService.getActor(actorId);
            return actor.getScopeId() == processDefinitionId;
        }
        return false;
    }
}

