/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.jobs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.instance.api.event.EventInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SEventTriggerInstanceReadException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SMessageInstanceNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SMessageInstanceReadException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SMessageModificationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SWaitingEventModificationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SWaitingEventNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SWaitingEventReadException;
import org.bonitasoft.engine.core.process.instance.model.builder.event.handling.SMessageInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.event.handling.SWaitingMessageEventBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SBPMEventType;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SMessageEventCouple;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SMessageInstance;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SWaitingMessageEvent;
import org.bonitasoft.engine.execution.work.WorkFactory;
import org.bonitasoft.engine.jobs.InternalJob;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.scheduler.exception.SJobConfigurationException;
import org.bonitasoft.engine.scheduler.exception.SJobExecutionException;
import org.bonitasoft.engine.work.SWorkRegisterException;
import org.bonitasoft.engine.work.WorkService;

public class BPMEventHandlingJob
extends InternalJob {
    private static final List<SBPMEventType> START_WAITING_MESSAGE_LIST = Arrays.asList(SBPMEventType.START_EVENT);
    private static final long serialVersionUID = 8929044925208984537L;
    private transient EventInstanceService eventInstanceService;
    private WorkService workService;

    @Override
    public String getName() {
        return "BPMEventHandlingJob";
    }

    @Override
    public String getDescription() {
        return "Handle BPM events";
    }

    @Override
    public void execute() throws SJobExecutionException {
        try {
            List<SMessageEventCouple> uniqueCouples = this.getMessageUniqueCouples();
            this.executeUniqueMessageCouplesWork(uniqueCouples);
        }
        catch (SBonitaException e) {
            throw new SJobExecutionException(e);
        }
    }

    private void executeUniqueMessageCouplesWork(List<SMessageEventCouple> uniqueCouples) throws SWaitingEventNotFoundException, SWaitingEventReadException, SMessageInstanceNotFoundException, SMessageInstanceReadException, SMessageModificationException, SWaitingEventModificationException, SWorkRegisterException {
        for (SMessageEventCouple couple : uniqueCouples) {
            long messageInstanceId = couple.getMessageInstanceId();
            long waitingMessageId = couple.getWaitingMessageId();
            SBPMEventType waitingMessageEventType = couple.getWaitingMessageEventType();
            SWaitingMessageEvent waitingMsg = this.eventInstanceService.getWaitingMessage(waitingMessageId);
            SMessageInstance messageInstance = this.eventInstanceService.getMessageInstance(messageInstanceId);
            this.markMessageAsInProgress(messageInstance);
            if (!START_WAITING_MESSAGE_LIST.contains((Object)waitingMessageEventType)) {
                this.markWaitingMessageAsInProgress(waitingMsg);
            }
            this.workService.registerWork(WorkFactory.createExecuteMessageCoupleWork(messageInstance, waitingMsg));
        }
    }

    protected List<SMessageEventCouple> getMessageUniqueCouples() throws SEventTriggerInstanceReadException {
        ArrayList<Long> takenMessages = new ArrayList<Long>();
        ArrayList<Long> takenWaitings = new ArrayList<Long>();
        ArrayList<SMessageEventCouple> uniqueMessageCouples = new ArrayList<SMessageEventCouple>();
        int index = 0;
        List<SMessageEventCouple> potentialMessageCouples = this.get1000MessageEventCouples(index);
        while (!potentialMessageCouples.isEmpty()) {
            for (SMessageEventCouple couple : potentialMessageCouples) {
                long messageInstanceId = couple.getMessageInstanceId();
                long waitingMessageId = couple.getWaitingMessageId();
                SBPMEventType waitingMessageEventType = couple.getWaitingMessageEventType();
                if (takenMessages.contains(messageInstanceId) || takenWaitings.contains(waitingMessageId)) continue;
                takenMessages.add(messageInstanceId);
                if (!START_WAITING_MESSAGE_LIST.contains((Object)waitingMessageEventType)) {
                    takenWaitings.add(waitingMessageId);
                }
                uniqueMessageCouples.add(couple);
            }
            potentialMessageCouples = this.get1000MessageEventCouples(++index);
        }
        return uniqueMessageCouples;
    }

    List<SMessageEventCouple> get1000MessageEventCouples(int index) throws SEventTriggerInstanceReadException {
        return this.eventInstanceService.getMessageEventCouples(index * 1000, 1000);
    }

    @Override
    public void setAttributes(Map<String, Serializable> attributes) throws SJobConfigurationException {
        this.setEventInstanceService(this.getTenantServiceAccessor().getEventInstanceService());
        this.setWorkService(this.getTenantServiceAccessor().getWorkService());
    }

    void setEventInstanceService(EventInstanceService eventInstanceService) {
        this.eventInstanceService = eventInstanceService;
    }

    void setWorkService(WorkService workService) {
        this.workService = workService;
    }

    private void markMessageAsInProgress(SMessageInstance messageInstance) throws SMessageModificationException {
        EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
        descriptor.addField(BuilderFactory.get(SMessageInstanceBuilderFactory.class).getHandledKey(), true);
        this.eventInstanceService.updateMessageInstance(messageInstance, descriptor);
    }

    private void markWaitingMessageAsInProgress(SWaitingMessageEvent waitingMsg) throws SWaitingEventModificationException {
        EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
        descriptor.addField(BuilderFactory.get(SWaitingMessageEventBuilderFactory.class).getProgressKey(), 1);
        this.eventInstanceService.updateWaitingMessage(waitingMsg, descriptor);
    }
}

