/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.queriablelogger.model.builder.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.engine.persistence.model.impl.BlobValueImpl;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLogParameter;
import org.bonitasoft.engine.queriablelogger.model.builder.SQueriableLogParameterBuilder;
import org.bonitasoft.engine.queriablelogger.model.builder.impl.MissingMandatoryFieldsException;
import org.bonitasoft.engine.queriablelogger.model.impl.SQueriableLogParameterImpl;

public class SQueriableLogParameterBuilderImpl
implements SQueriableLogParameterBuilder {
    private final SQueriableLogParameterImpl entity;

    public SQueriableLogParameterBuilderImpl(SQueriableLogParameterImpl entity) {
        this.entity = entity;
    }

    @Override
    public SQueriableLogParameterBuilder stringValue(String stringValue) {
        this.entity.setStringValue(stringValue);
        return this;
    }

    @Override
    public SQueriableLogParameterBuilder blobValue(Serializable blobValue) {
        BlobValueImpl blob = new BlobValueImpl();
        blob.setValue(blobValue);
        this.entity.setBlobValue(blob);
        return this;
    }

    @Override
    public SQueriableLogParameter done() {
        List<String> problems = this.checkMandatoryFields();
        if (problems.size() > 0) {
            throw new MissingMandatoryFieldsException("Some mandatory fields were not set: " + problems);
        }
        return this.entity;
    }

    private List<String> checkMandatoryFields() {
        ArrayList<String> problems = new ArrayList<String>();
        if (this.entity.getName() == null) {
            problems.add("name");
        }
        if (this.entity.getValueType() == null) {
            problems.add("valueType");
        }
        return problems;
    }
}

