/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.scheduler.impl;

import java.io.Serializable;
import java.util.Map;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.events.EventService;
import org.bonitasoft.engine.events.model.SEvent;
import org.bonitasoft.engine.events.model.SFireEventException;
import org.bonitasoft.engine.events.model.builders.SEventBuilderFactory;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.scheduler.StatelessJob;
import org.bonitasoft.engine.scheduler.exception.SJobConfigurationException;
import org.bonitasoft.engine.scheduler.exception.SJobExecutionException;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;
import org.bonitasoft.engine.transaction.BonitaTransactionSynchronization;
import org.bonitasoft.engine.transaction.STransactionNotFoundException;
import org.bonitasoft.engine.transaction.TransactionService;
import org.bonitasoft.engine.transaction.TransactionState;

public class JobWrapper
implements StatelessJob {
    private static final long serialVersionUID = 7145451610635400449L;
    private final StatelessJob statelessJob;
    private final TechnicalLoggerService logger;
    private final long tenantId;
    private final SEvent jobExecuting;
    private final SEvent jobCompleted;
    private final EventService eventService;
    private final String name;
    private final SessionAccessor sessionAccessor;
    private final TransactionService transactionService;

    public JobWrapper(String name, StatelessJob statelessJob, TechnicalLoggerService logger, long tenantId, EventService eventService, SessionAccessor sessionAccessor, TransactionService transactionService) {
        this.name = name;
        this.sessionAccessor = sessionAccessor;
        this.statelessJob = statelessJob;
        this.logger = logger;
        this.tenantId = tenantId;
        this.eventService = eventService;
        this.transactionService = transactionService;
        this.jobExecuting = BuilderFactory.get(SEventBuilderFactory.class).createNewInstance("JOB_EXECUTING").done();
        this.jobCompleted = BuilderFactory.get(SEventBuilderFactory.class).createNewInstance("JOB_COMPLETED").done();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.statelessJob.getDescription();
    }

    @Override
    public void execute() throws SJobExecutionException, SFireEventException {
        try {
            this.sessionAccessor.setTenantId(this.tenantId);
            if (this.eventService.hasHandlers("JOB_EXECUTING", null)) {
                this.jobExecuting.setObject(this);
                this.eventService.fireEvent(this.jobExecuting);
            }
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, "Start execution of " + this.statelessJob.getName());
            }
            this.statelessJob.execute();
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, "Finished execution of " + this.statelessJob.getName());
            }
        }
        catch (SFireEventException e) {
            this.logFailedJob(e);
            throw e;
        }
        catch (SJobExecutionException e) {
            this.logFailedJob(e);
            throw e;
        }
        finally {
            if (this.eventService.hasHandlers("JOB_COMPLETED", null)) {
                this.jobCompleted.setObject(this);
                this.eventService.fireEvent(this.jobCompleted);
            }
            try {
                this.transactionService.registerBonitaSynchronization(new BonitaTransactionSynchronizationImplementation());
            }
            catch (STransactionNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private void logFailedJob(SBonitaException e) {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.ERROR)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.ERROR, "Error while executing job " + this.name + " : " + e.getMessage(), e);
        }
    }

    @Override
    public void setAttributes(Map<String, Serializable> attributes) throws SJobConfigurationException {
        this.statelessJob.setAttributes(attributes);
    }

    public StatelessJob getStatelessJob() {
        return this.statelessJob;
    }

    private final class BonitaTransactionSynchronizationImplementation
    implements BonitaTransactionSynchronization {
        private BonitaTransactionSynchronizationImplementation() {
        }

        @Override
        public void beforeCommit() {
        }

        @Override
        public void afterCompletion(TransactionState txState) {
            JobWrapper.this.sessionAccessor.deleteTenantId();
        }
    }
}

