/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.actor.xml;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bonitasoft.engine.bpm.bar.xml.XMLProcessDefinition;

public class Actor {
    private final String name;
    private String description;
    private Set<String> users;
    private Set<String> groups;
    private Set<String> roles;
    private final Set<XMLProcessDefinition.BEntry<String, String>> memberships;

    public Actor(String name) {
        this.name = name;
        this.users = new HashSet<String>();
        this.groups = new HashSet<String>();
        this.roles = new HashSet<String>();
        this.memberships = new HashSet<XMLProcessDefinition.BEntry<String, String>>();
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void addGroup(String group) {
        this.groups.add(group);
    }

    public void addGroups(List<String> groups) {
        this.groups = new HashSet<String>(groups);
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public void addRole(String role) {
        this.roles.add(role);
    }

    public void addRoles(List<String> roles) {
        this.roles = new HashSet<String>(roles);
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void addUser(String user) {
        this.users.add(user);
    }

    public void addUsers(List<String> userNames) {
        this.users = new HashSet<String>(userNames);
    }

    public Set<String> getUsers() {
        return this.users;
    }

    public void addMembership(String groupName, String roleName) {
        this.memberships.add((XMLProcessDefinition.BEntry<String, String>)new XMLProcessDefinition.BEntry((Object)groupName, (Object)roleName));
    }

    public Set<XMLProcessDefinition.BEntry<String, String>> getMemberships() {
        return this.memberships;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.groups == null ? 0 : ((Object)this.groups).hashCode());
        result = 31 * result + (this.memberships == null ? 0 : ((Object)this.memberships).hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.roles == null ? 0 : ((Object)this.roles).hashCode());
        result = 31 * result + (this.users == null ? 0 : ((Object)this.users).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Actor other = (Actor)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.groups == null ? other.groups != null : !((Object)this.groups).equals(other.groups)) {
            return false;
        }
        if (this.memberships == null ? other.memberships != null : !((Object)this.memberships).equals(other.memberships)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.roles == null ? other.roles != null : !((Object)this.roles).equals(other.roles)) {
            return false;
        }
        return !(this.users == null ? other.users != null : !((Object)this.users).equals(other.users));
    }
}

