/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.api.impl.CustomUserInfoConverter;
import org.bonitasoft.engine.identity.CustomUserInfo;
import org.bonitasoft.engine.identity.CustomUserInfoDefinition;
import org.bonitasoft.engine.identity.CustomUserInfoValue;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.SIdentityException;
import org.bonitasoft.engine.identity.model.SCustomUserInfoDefinition;
import org.bonitasoft.engine.identity.model.SCustomUserInfoValue;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaSearchException;

public class CustomUserInfoAPIDelegate {
    private IdentityService service;
    private final CustomUserInfoConverter converter = new CustomUserInfoConverter();

    public CustomUserInfoAPIDelegate(IdentityService service) {
        this.service = service;
    }

    public List<CustomUserInfo> list(long userId, int startIndex, int maxResult) throws SIdentityException, SBonitaSearchException {
        List<SCustomUserInfoDefinition> definitions = this.service.getCustomUserInfoDefinitions(startIndex, maxResult);
        if (definitions.size() == 0) {
            return Collections.emptyList();
        }
        Map<Long, CustomUserInfoValue> values = this.transform(this.searchCorrespondingValues(userId, definitions));
        ArrayList<CustomUserInfo> info = new ArrayList<CustomUserInfo>();
        for (SCustomUserInfoDefinition definition : definitions) {
            info.add(new CustomUserInfo(userId, (CustomUserInfoDefinition)this.converter.convert(definition), values.get(definition.getId())));
        }
        return info;
    }

    private Map<Long, CustomUserInfoValue> transform(List<SCustomUserInfoValue> values) {
        HashMap<Long, CustomUserInfoValue> map = new HashMap<Long, CustomUserInfoValue>();
        for (SCustomUserInfoValue value : values) {
            map.put(value.getDefinitionId(), (CustomUserInfoValue)this.converter.convert(value));
        }
        return map;
    }

    private List<SCustomUserInfoValue> searchCorrespondingValues(long userId, List<SCustomUserInfoDefinition> definitions) throws SBonitaSearchException {
        return this.service.searchCustomUserInfoValue(new QueryOptions(0, definitions.size(), Collections.<OrderByOption>emptyList(), Arrays.asList(new FilterOption(SCustomUserInfoValue.class, "userId", userId), new FilterOption(SCustomUserInfoValue.class, "definitionId").in(this.getIds(definitions))), null));
    }

    private List<Long> getIds(List<SCustomUserInfoDefinition> definitions) {
        ArrayList<Long> ids = new ArrayList<Long>(definitions.size());
        for (SCustomUserInfoDefinition definition : definitions) {
            ids.add(definition.getId());
        }
        return ids;
    }
}

