/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.io.IOUtil;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.theme.ThemeService;
import org.bonitasoft.engine.theme.builder.SThemeBuilder;
import org.bonitasoft.engine.theme.builder.SThemeBuilderFactory;
import org.bonitasoft.engine.theme.exception.SThemeCreationException;
import org.bonitasoft.engine.theme.model.STheme;
import org.bonitasoft.engine.theme.model.SThemeType;

public class PlatformAPIImplDelegate {
    private static final String BONITA_PORTAL_THEME_DEFAULT = "bonita-portal-theme";
    private static final String BONITA_MOBILE_THEME_DEFAULT = "bonita-mobile-theme";
    private static final String ZIP = ".zip";
    private final String portalDefaultThemeFilename;
    private final String mobileDefaultThemeFilename;
    private File unzippedCssPortalThemeFolder;

    public PlatformAPIImplDelegate() {
        this(BONITA_PORTAL_THEME_DEFAULT, BONITA_MOBILE_THEME_DEFAULT);
    }

    public PlatformAPIImplDelegate(String portalDefaultThemeFilename, String mobileDefaultThemeFilename) {
        this.portalDefaultThemeFilename = portalDefaultThemeFilename;
        this.mobileDefaultThemeFilename = mobileDefaultThemeFilename;
        try {
            InputStream defaultThemeCssZip = this.getResourceAsStream(portalDefaultThemeFilename + "-css" + ZIP);
            if (defaultThemeCssZip != null) {
                this.unzippedCssPortalThemeFolder = IOUtil.createTempDirectory(portalDefaultThemeFilename + "-css");
                IOUtil.unzipToFolder(defaultThemeCssZip, this.unzippedCssPortalThemeFolder);
            } else {
                this.unzippedCssPortalThemeFolder = null;
            }
        }
        catch (IOException e) {
            this.unzippedCssPortalThemeFolder = null;
        }
    }

    public void cleanUnzippedFolder() throws IOException {
        IOUtil.deleteDir(this.unzippedCssPortalThemeFolder);
    }

    public void createDefaultThemes(TenantServiceAccessor tenantServiceAccessor) throws IOException, SThemeCreationException {
        this.createDefaultMobileTheme(tenantServiceAccessor);
        this.createDefaultPortalTheme(tenantServiceAccessor);
    }

    protected void createDefaultPortalTheme(TenantServiceAccessor tenantServiceAccessor) throws IOException, SThemeCreationException {
        byte[] defaultThemeCss;
        ThemeService themeService = tenantServiceAccessor.getThemeService();
        byte[] defaultThemeZip = this.getFileContent(this.portalDefaultThemeFilename + ZIP);
        if (defaultThemeZip != null && this.unzippedCssPortalThemeFolder != null && defaultThemeZip.length > 0 && (defaultThemeCss = IOUtil.getAllContentFrom(new File(this.unzippedCssPortalThemeFolder, "bonita.css"))) != null) {
            STheme sTheme = this.buildSTheme(defaultThemeZip, defaultThemeCss, SThemeType.PORTAL);
            themeService.createTheme(sTheme);
        }
    }

    protected void createDefaultMobileTheme(TenantServiceAccessor tenantServiceAccessor) throws IOException, SThemeCreationException {
        ThemeService themeService = tenantServiceAccessor.getThemeService();
        byte[] defaultThemeZip = this.getFileContent(this.mobileDefaultThemeFilename + ZIP);
        if (defaultThemeZip != null && defaultThemeZip.length > 0) {
            STheme sTheme = this.buildSTheme(defaultThemeZip, null, SThemeType.MOBILE);
            themeService.createTheme(sTheme);
        }
    }

    STheme buildSTheme(byte[] defaultThemeZip, byte[] defaultThemeCss, SThemeType type) {
        long lastUpdateDate = System.currentTimeMillis();
        SThemeBuilder sThemeBuilder = BuilderFactory.get(SThemeBuilderFactory.class).createNewInstance(defaultThemeZip, true, type, lastUpdateDate);
        if (SThemeType.PORTAL.equals((Object)type)) {
            sThemeBuilder.setCSSContent(defaultThemeCss);
        }
        return sThemeBuilder.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getFileContent(String fileName) throws IOException {
        InputStream inputStream = this.getResourceAsStream(fileName);
        if (inputStream == null) {
            return null;
        }
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
            return byArray;
        }
        finally {
            inputStream.close();
        }
    }

    private InputStream getResourceAsStream(String fileName) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
    }
}

