/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.bonitasoft.engine.actor.mapping.ActorMappingService;
import org.bonitasoft.engine.actor.mapping.SActorNotFoundException;
import org.bonitasoft.engine.actor.mapping.model.SActor;
import org.bonitasoft.engine.actor.mapping.model.SActorMember;
import org.bonitasoft.engine.actor.mapping.model.SActorUpdateBuilder;
import org.bonitasoft.engine.actor.mapping.model.SActorUpdateBuilderFactory;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.api.impl.DeepRegexFileFilter;
import org.bonitasoft.engine.api.impl.OrderAndFields;
import org.bonitasoft.engine.api.impl.ProcessManagementAPIImplDelegate;
import org.bonitasoft.engine.api.impl.ProcessStarter;
import org.bonitasoft.engine.api.impl.SessionInfos;
import org.bonitasoft.engine.api.impl.resolver.ProcessDependencyResolver;
import org.bonitasoft.engine.api.impl.transaction.CustomTransactions;
import org.bonitasoft.engine.api.impl.transaction.activity.GetArchivedActivityInstance;
import org.bonitasoft.engine.api.impl.transaction.activity.GetArchivedActivityInstances;
import org.bonitasoft.engine.api.impl.transaction.activity.GetNumberOfActivityInstance;
import org.bonitasoft.engine.api.impl.transaction.actor.ExportActorMapping;
import org.bonitasoft.engine.api.impl.transaction.actor.GetActor;
import org.bonitasoft.engine.api.impl.transaction.actor.GetActorsByActorIds;
import org.bonitasoft.engine.api.impl.transaction.actor.GetNumberOfActorMembers;
import org.bonitasoft.engine.api.impl.transaction.actor.GetNumberOfActors;
import org.bonitasoft.engine.api.impl.transaction.actor.GetNumberOfGroupsOfActor;
import org.bonitasoft.engine.api.impl.transaction.actor.GetNumberOfMembershipsOfActor;
import org.bonitasoft.engine.api.impl.transaction.actor.GetNumberOfRolesOfActor;
import org.bonitasoft.engine.api.impl.transaction.actor.GetNumberOfUsersOfActor;
import org.bonitasoft.engine.api.impl.transaction.actor.ImportActorMapping;
import org.bonitasoft.engine.api.impl.transaction.actor.RemoveActorMember;
import org.bonitasoft.engine.api.impl.transaction.category.CreateCategory;
import org.bonitasoft.engine.api.impl.transaction.category.DeleteSCategory;
import org.bonitasoft.engine.api.impl.transaction.category.GetCategories;
import org.bonitasoft.engine.api.impl.transaction.category.GetCategory;
import org.bonitasoft.engine.api.impl.transaction.category.GetNumberOfCategories;
import org.bonitasoft.engine.api.impl.transaction.category.GetNumberOfCategoriesOfProcess;
import org.bonitasoft.engine.api.impl.transaction.category.RemoveCategoriesFromProcessDefinition;
import org.bonitasoft.engine.api.impl.transaction.category.RemoveProcessDefinitionsOfCategory;
import org.bonitasoft.engine.api.impl.transaction.category.UpdateCategory;
import org.bonitasoft.engine.api.impl.transaction.comment.AddComment;
import org.bonitasoft.engine.api.impl.transaction.connector.GetConnectorImplementation;
import org.bonitasoft.engine.api.impl.transaction.connector.GetConnectorImplementations;
import org.bonitasoft.engine.api.impl.transaction.connector.GetNumberOfConnectorImplementations;
import org.bonitasoft.engine.api.impl.transaction.document.AttachDocumentVersion;
import org.bonitasoft.engine.api.impl.transaction.document.AttachDocumentVersionAndStoreContent;
import org.bonitasoft.engine.api.impl.transaction.document.GetArchivedDocument;
import org.bonitasoft.engine.api.impl.transaction.document.GetDocument;
import org.bonitasoft.engine.api.impl.transaction.document.GetDocumentByName;
import org.bonitasoft.engine.api.impl.transaction.document.GetDocumentByNameAtActivityCompletion;
import org.bonitasoft.engine.api.impl.transaction.document.GetDocumentByNameAtProcessInstantiation;
import org.bonitasoft.engine.api.impl.transaction.document.GetDocumentContent;
import org.bonitasoft.engine.api.impl.transaction.document.GetDocumentsOfProcessInstance;
import org.bonitasoft.engine.api.impl.transaction.document.GetNumberOfDocumentsOfProcessInstance;
import org.bonitasoft.engine.api.impl.transaction.event.GetEventInstances;
import org.bonitasoft.engine.api.impl.transaction.expression.EvaluateExpressionsDefinitionLevel;
import org.bonitasoft.engine.api.impl.transaction.expression.EvaluateExpressionsInstanceLevel;
import org.bonitasoft.engine.api.impl.transaction.expression.EvaluateExpressionsInstanceLevelAndArchived;
import org.bonitasoft.engine.api.impl.transaction.flownode.GetFlowNodeInstance;
import org.bonitasoft.engine.api.impl.transaction.flownode.HideTasks;
import org.bonitasoft.engine.api.impl.transaction.flownode.IsTaskHidden;
import org.bonitasoft.engine.api.impl.transaction.flownode.SetExpectedEndDate;
import org.bonitasoft.engine.api.impl.transaction.flownode.UnhideTasks;
import org.bonitasoft.engine.api.impl.transaction.identity.GetSUser;
import org.bonitasoft.engine.api.impl.transaction.process.AddProcessDefinitionToCategory;
import org.bonitasoft.engine.api.impl.transaction.process.DeleteArchivedProcessInstances;
import org.bonitasoft.engine.api.impl.transaction.process.EnableProcess;
import org.bonitasoft.engine.api.impl.transaction.process.GetArchivedProcessInstanceList;
import org.bonitasoft.engine.api.impl.transaction.process.GetLastArchivedProcessInstance;
import org.bonitasoft.engine.api.impl.transaction.process.GetLatestProcessDefinitionId;
import org.bonitasoft.engine.api.impl.transaction.process.GetNumberOfArchivedProcessInstance;
import org.bonitasoft.engine.api.impl.transaction.process.GetNumberOfProcessDeploymentInfos;
import org.bonitasoft.engine.api.impl.transaction.process.GetNumberOfProcessDeploymentInfosUnrelatedToCategory;
import org.bonitasoft.engine.api.impl.transaction.process.GetNumberOfProcessInstance;
import org.bonitasoft.engine.api.impl.transaction.process.GetProcessDefinition;
import org.bonitasoft.engine.api.impl.transaction.process.GetProcessDefinitionDeployInfo;
import org.bonitasoft.engine.api.impl.transaction.process.GetProcessDefinitionDeployInfos;
import org.bonitasoft.engine.api.impl.transaction.process.GetProcessDefinitionDeployInfosWithActorOnlyForGroup;
import org.bonitasoft.engine.api.impl.transaction.process.GetProcessDefinitionDeployInfosWithActorOnlyForGroups;
import org.bonitasoft.engine.api.impl.transaction.process.GetProcessDefinitionDeployInfosWithActorOnlyForRole;
import org.bonitasoft.engine.api.impl.transaction.process.GetProcessDefinitionDeployInfosWithActorOnlyForRoles;
import org.bonitasoft.engine.api.impl.transaction.process.GetProcessDefinitionDeployInfosWithActorOnlyForUser;
import org.bonitasoft.engine.api.impl.transaction.process.GetProcessDefinitionDeployInfosWithActorOnlyForUsers;
import org.bonitasoft.engine.api.impl.transaction.process.GetProcessDefinitionIDByNameAndVersion;
import org.bonitasoft.engine.api.impl.transaction.process.SetProcessInstanceState;
import org.bonitasoft.engine.api.impl.transaction.process.UpdateProcessDeploymentInfo;
import org.bonitasoft.engine.api.impl.transaction.task.AssignOrUnassignUserTask;
import org.bonitasoft.engine.api.impl.transaction.task.GetAssignedTasks;
import org.bonitasoft.engine.api.impl.transaction.task.GetHumanTaskInstance;
import org.bonitasoft.engine.api.impl.transaction.task.GetNumberOfAssignedUserTaskInstances;
import org.bonitasoft.engine.api.impl.transaction.task.GetNumberOfOpenTasksForUsers;
import org.bonitasoft.engine.api.impl.transaction.task.SetTaskPriority;
import org.bonitasoft.engine.archive.ArchiveService;
import org.bonitasoft.engine.bpm.actor.ActorCriterion;
import org.bonitasoft.engine.bpm.actor.ActorInstance;
import org.bonitasoft.engine.bpm.actor.ActorMappingExportException;
import org.bonitasoft.engine.bpm.actor.ActorMappingImportException;
import org.bonitasoft.engine.bpm.actor.ActorMember;
import org.bonitasoft.engine.bpm.actor.ActorNotFoundException;
import org.bonitasoft.engine.bpm.actor.ActorUpdater;
import org.bonitasoft.engine.bpm.bar.BusinessArchive;
import org.bonitasoft.engine.bpm.bar.BusinessArchiveBuilder;
import org.bonitasoft.engine.bpm.bar.BusinessArchiveFactory;
import org.bonitasoft.engine.bpm.bar.InvalidBusinessArchiveFormatException;
import org.bonitasoft.engine.bpm.bar.ProcessDefinitionBARContribution;
import org.bonitasoft.engine.bpm.category.Category;
import org.bonitasoft.engine.bpm.category.CategoryCriterion;
import org.bonitasoft.engine.bpm.category.CategoryNotFoundException;
import org.bonitasoft.engine.bpm.category.CategoryUpdater;
import org.bonitasoft.engine.bpm.comment.ArchivedComment;
import org.bonitasoft.engine.bpm.comment.Comment;
import org.bonitasoft.engine.bpm.connector.ArchivedConnectorInstance;
import org.bonitasoft.engine.bpm.connector.ConnectorCriterion;
import org.bonitasoft.engine.bpm.connector.ConnectorExecutionException;
import org.bonitasoft.engine.bpm.connector.ConnectorImplementationDescriptor;
import org.bonitasoft.engine.bpm.connector.ConnectorInstance;
import org.bonitasoft.engine.bpm.connector.ConnectorNotFoundException;
import org.bonitasoft.engine.bpm.data.ArchivedDataInstance;
import org.bonitasoft.engine.bpm.data.ArchivedDataNotFoundException;
import org.bonitasoft.engine.bpm.data.DataDefinition;
import org.bonitasoft.engine.bpm.data.DataInstance;
import org.bonitasoft.engine.bpm.data.DataNotFoundException;
import org.bonitasoft.engine.bpm.document.ArchivedDocument;
import org.bonitasoft.engine.bpm.document.ArchivedDocumentNotFoundException;
import org.bonitasoft.engine.bpm.document.Document;
import org.bonitasoft.engine.bpm.document.DocumentAttachmentException;
import org.bonitasoft.engine.bpm.document.DocumentCriterion;
import org.bonitasoft.engine.bpm.document.DocumentException;
import org.bonitasoft.engine.bpm.document.DocumentNotFoundException;
import org.bonitasoft.engine.bpm.flownode.ActivityDefinitionNotFoundException;
import org.bonitasoft.engine.bpm.flownode.ActivityExecutionException;
import org.bonitasoft.engine.bpm.flownode.ActivityInstance;
import org.bonitasoft.engine.bpm.flownode.ActivityInstanceCriterion;
import org.bonitasoft.engine.bpm.flownode.ActivityInstanceNotFoundException;
import org.bonitasoft.engine.bpm.flownode.ArchivedActivityInstance;
import org.bonitasoft.engine.bpm.flownode.ArchivedFlowNodeInstance;
import org.bonitasoft.engine.bpm.flownode.ArchivedFlowNodeInstanceNotFoundException;
import org.bonitasoft.engine.bpm.flownode.ArchivedHumanTaskInstance;
import org.bonitasoft.engine.bpm.flownode.EventCriterion;
import org.bonitasoft.engine.bpm.flownode.EventInstance;
import org.bonitasoft.engine.bpm.flownode.FlowNodeExecutionException;
import org.bonitasoft.engine.bpm.flownode.FlowNodeInstance;
import org.bonitasoft.engine.bpm.flownode.FlowNodeInstanceNotFoundException;
import org.bonitasoft.engine.bpm.flownode.FlowNodeType;
import org.bonitasoft.engine.bpm.flownode.HumanTaskInstance;
import org.bonitasoft.engine.bpm.flownode.SendEventException;
import org.bonitasoft.engine.bpm.flownode.TaskPriority;
import org.bonitasoft.engine.bpm.process.ActivationState;
import org.bonitasoft.engine.bpm.process.ArchivedProcessInstance;
import org.bonitasoft.engine.bpm.process.ArchivedProcessInstanceNotFoundException;
import org.bonitasoft.engine.bpm.process.DesignProcessDefinition;
import org.bonitasoft.engine.bpm.process.InvalidProcessDefinitionException;
import org.bonitasoft.engine.bpm.process.Problem;
import org.bonitasoft.engine.bpm.process.ProcessActivationException;
import org.bonitasoft.engine.bpm.process.ProcessDefinition;
import org.bonitasoft.engine.bpm.process.ProcessDefinitionNotFoundException;
import org.bonitasoft.engine.bpm.process.ProcessDeployException;
import org.bonitasoft.engine.bpm.process.ProcessDeploymentInfo;
import org.bonitasoft.engine.bpm.process.ProcessDeploymentInfoCriterion;
import org.bonitasoft.engine.bpm.process.ProcessDeploymentInfoUpdater;
import org.bonitasoft.engine.bpm.process.ProcessEnablementException;
import org.bonitasoft.engine.bpm.process.ProcessExecutionException;
import org.bonitasoft.engine.bpm.process.ProcessExportException;
import org.bonitasoft.engine.bpm.process.ProcessInstance;
import org.bonitasoft.engine.bpm.process.ProcessInstanceCriterion;
import org.bonitasoft.engine.bpm.process.ProcessInstanceNotFoundException;
import org.bonitasoft.engine.bpm.process.ProcessInstanceState;
import org.bonitasoft.engine.bpm.supervisor.ProcessSupervisor;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.classloader.SClassLoaderException;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.exceptions.SBonitaRuntimeException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.commons.transaction.TransactionExecutor;
import org.bonitasoft.engine.core.category.CategoryService;
import org.bonitasoft.engine.core.category.exception.SCategoryAlreadyExistsException;
import org.bonitasoft.engine.core.category.exception.SCategoryInProcessAlreadyExistsException;
import org.bonitasoft.engine.core.category.exception.SCategoryNotFoundException;
import org.bonitasoft.engine.core.category.model.SCategory;
import org.bonitasoft.engine.core.category.model.SProcessCategoryMapping;
import org.bonitasoft.engine.core.category.model.builder.SCategoryBuilderFactory;
import org.bonitasoft.engine.core.category.model.builder.SCategoryUpdateBuilder;
import org.bonitasoft.engine.core.category.model.builder.SCategoryUpdateBuilderFactory;
import org.bonitasoft.engine.core.category.model.builder.SProcessCategoryMappingBuilderFactory;
import org.bonitasoft.engine.core.connector.ConnectorInstanceService;
import org.bonitasoft.engine.core.connector.ConnectorResult;
import org.bonitasoft.engine.core.connector.ConnectorService;
import org.bonitasoft.engine.core.connector.exception.SConnectorException;
import org.bonitasoft.engine.core.connector.parser.SConnectorImplementationDescriptor;
import org.bonitasoft.engine.core.data.instance.TransientDataService;
import org.bonitasoft.engine.core.expression.control.api.ExpressionResolverService;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.filter.FilterResult;
import org.bonitasoft.engine.core.filter.UserFilterService;
import org.bonitasoft.engine.core.filter.exception.SUserFilterExecutionException;
import org.bonitasoft.engine.core.operation.OperationService;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.core.process.comment.api.SCommentNotFoundException;
import org.bonitasoft.engine.core.process.comment.api.SCommentService;
import org.bonitasoft.engine.core.process.comment.model.SComment;
import org.bonitasoft.engine.core.process.comment.model.archive.SAComment;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionNotFoundException;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionReadException;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDeletionException;
import org.bonitasoft.engine.core.process.definition.model.SActivityDefinition;
import org.bonitasoft.engine.core.process.definition.model.SActorDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowElementContainerDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeDefinition;
import org.bonitasoft.engine.core.process.definition.model.SHumanTaskDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinitionDeployInfo;
import org.bonitasoft.engine.core.process.definition.model.SUserFilterDefinition;
import org.bonitasoft.engine.core.process.definition.model.builder.SProcessDefinitionBuilderFactory;
import org.bonitasoft.engine.core.process.definition.model.builder.SProcessDefinitionDeployInfoBuilderFactory;
import org.bonitasoft.engine.core.process.definition.model.builder.ServerModelConvertor;
import org.bonitasoft.engine.core.process.definition.model.builder.event.trigger.SThrowMessageEventTriggerDefinitionBuilder;
import org.bonitasoft.engine.core.process.definition.model.builder.event.trigger.SThrowMessageEventTriggerDefinitionBuilderFactory;
import org.bonitasoft.engine.core.process.definition.model.builder.event.trigger.SThrowSignalEventTriggerDefinitionBuilderFactory;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SThrowMessageEventTriggerDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SThrowSignalEventTriggerDefinition;
import org.bonitasoft.engine.core.process.document.api.ProcessDocumentService;
import org.bonitasoft.engine.core.process.document.model.SAProcessDocument;
import org.bonitasoft.engine.core.process.document.model.SProcessDocument;
import org.bonitasoft.engine.core.process.document.model.builder.SProcessDocumentBuilder;
import org.bonitasoft.engine.core.process.document.model.builder.SProcessDocumentBuilderFactory;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.core.process.instance.api.event.EventInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SAProcessInstanceNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityInstanceNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityModificationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityReadException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeReadException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceHierarchicalDeletionException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceReadException;
import org.bonitasoft.engine.core.process.instance.api.states.FlowNodeState;
import org.bonitasoft.engine.core.process.instance.model.SActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SFlowElementsContainerType;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SHumanTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SPendingActivityMapping;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.core.process.instance.model.SStateCategory;
import org.bonitasoft.engine.core.process.instance.model.STaskPriority;
import org.bonitasoft.engine.core.process.instance.model.archive.SAActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAProcessInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.builder.SAProcessInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.SAutomaticTaskInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.SPendingActivityMappingBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.SProcessInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.event.SEventInstance;
import org.bonitasoft.engine.data.definition.model.SDataDefinition;
import org.bonitasoft.engine.data.definition.model.builder.SDataDefinitionBuilder;
import org.bonitasoft.engine.data.definition.model.builder.SDataDefinitionBuilderFactory;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.data.instance.api.DataInstanceService;
import org.bonitasoft.engine.data.instance.exception.SDataInstanceException;
import org.bonitasoft.engine.data.instance.exception.SDataInstanceReadException;
import org.bonitasoft.engine.data.instance.model.SDataInstance;
import org.bonitasoft.engine.data.instance.model.archive.SADataInstance;
import org.bonitasoft.engine.dependency.DependencyService;
import org.bonitasoft.engine.dependency.model.ScopeType;
import org.bonitasoft.engine.document.SDocumentNotFoundException;
import org.bonitasoft.engine.exception.AlreadyExistsException;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.BonitaRuntimeException;
import org.bonitasoft.engine.exception.CreationException;
import org.bonitasoft.engine.exception.DeletionException;
import org.bonitasoft.engine.exception.ExecutionException;
import org.bonitasoft.engine.exception.NotFoundException;
import org.bonitasoft.engine.exception.NotSerializableException;
import org.bonitasoft.engine.exception.ProcessInstanceHierarchicalDeletionException;
import org.bonitasoft.engine.exception.RetrieveException;
import org.bonitasoft.engine.exception.SearchException;
import org.bonitasoft.engine.exception.UpdateException;
import org.bonitasoft.engine.execution.FlowNodeExecutor;
import org.bonitasoft.engine.execution.ProcessExecutor;
import org.bonitasoft.engine.execution.SUnreleasableTaskException;
import org.bonitasoft.engine.execution.TransactionalProcessInstanceInterruptor;
import org.bonitasoft.engine.execution.event.EventsHandler;
import org.bonitasoft.engine.execution.state.FlowNodeStateManager;
import org.bonitasoft.engine.expression.ContainerState;
import org.bonitasoft.engine.expression.Expression;
import org.bonitasoft.engine.expression.ExpressionBuilder;
import org.bonitasoft.engine.expression.ExpressionEvaluationException;
import org.bonitasoft.engine.expression.ExpressionType;
import org.bonitasoft.engine.expression.InvalidExpressionException;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.exception.SInvalidExpressionException;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.home.BonitaHomeServer;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.SUserNotFoundException;
import org.bonitasoft.engine.identity.User;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.io.IOUtil;
import org.bonitasoft.engine.job.FailedJob;
import org.bonitasoft.engine.lock.BonitaLock;
import org.bonitasoft.engine.lock.LockService;
import org.bonitasoft.engine.lock.SLockException;
import org.bonitasoft.engine.log.LogMessageBuilder;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.operation.LeftOperand;
import org.bonitasoft.engine.operation.Operation;
import org.bonitasoft.engine.operation.OperationBuilder;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.OrderAndField;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.ReadPersistenceService;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SBonitaSearchException;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.scheduler.JobService;
import org.bonitasoft.engine.scheduler.SchedulerService;
import org.bonitasoft.engine.scheduler.builder.SJobParameterBuilderFactory;
import org.bonitasoft.engine.scheduler.exception.SSchedulerException;
import org.bonitasoft.engine.scheduler.model.SFailedJob;
import org.bonitasoft.engine.scheduler.model.SJobParameter;
import org.bonitasoft.engine.search.Order;
import org.bonitasoft.engine.search.SSearchException;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.SearchOptionsBuilder;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.search.activity.SearchActivityInstances;
import org.bonitasoft.engine.search.activity.SearchArchivedActivityInstances;
import org.bonitasoft.engine.search.comment.SearchArchivedComments;
import org.bonitasoft.engine.search.comment.SearchComments;
import org.bonitasoft.engine.search.comment.SearchCommentsInvolvingUser;
import org.bonitasoft.engine.search.comment.SearchCommentsManagedBy;
import org.bonitasoft.engine.search.connector.SearchArchivedConnectorInstance;
import org.bonitasoft.engine.search.connector.SearchConnectorInstances;
import org.bonitasoft.engine.search.descriptor.SearchEntitiesDescriptor;
import org.bonitasoft.engine.search.descriptor.SearchHumanTaskInstanceDescriptor;
import org.bonitasoft.engine.search.descriptor.SearchProcessDefinitionsDescriptor;
import org.bonitasoft.engine.search.descriptor.SearchProcessSupervisorDescriptor;
import org.bonitasoft.engine.search.descriptor.SearchUserDescriptor;
import org.bonitasoft.engine.search.document.SearchArchivedDocuments;
import org.bonitasoft.engine.search.document.SearchArchivedDocumentsSupervisedBy;
import org.bonitasoft.engine.search.document.SearchDocuments;
import org.bonitasoft.engine.search.document.SearchDocumentsSupervisedBy;
import org.bonitasoft.engine.search.flownode.SearchArchivedFlowNodeInstances;
import org.bonitasoft.engine.search.flownode.SearchFlowNodeInstances;
import org.bonitasoft.engine.search.identity.SearchUsersWhoCanExecutePendingHumanTaskDeploymentInfo;
import org.bonitasoft.engine.search.identity.SearchUsersWhoCanStartProcessDeploymentInfo;
import org.bonitasoft.engine.search.impl.SearchResultImpl;
import org.bonitasoft.engine.search.process.SearchArchivedProcessInstances;
import org.bonitasoft.engine.search.process.SearchArchivedProcessInstancesInvolvingUser;
import org.bonitasoft.engine.search.process.SearchArchivedProcessInstancesSupervisedBy;
import org.bonitasoft.engine.search.process.SearchArchivedProcessInstancesWithoutSubProcess;
import org.bonitasoft.engine.search.process.SearchOpenProcessInstancesInvolvingUser;
import org.bonitasoft.engine.search.process.SearchOpenProcessInstancesInvolvingUsersManagedBy;
import org.bonitasoft.engine.search.process.SearchOpenProcessInstancesSupervisedBy;
import org.bonitasoft.engine.search.process.SearchProcessDeploymentInfos;
import org.bonitasoft.engine.search.process.SearchProcessDeploymentInfosCanBeStartedBy;
import org.bonitasoft.engine.search.process.SearchProcessDeploymentInfosCanBeStartedByUsersManagedBy;
import org.bonitasoft.engine.search.process.SearchProcessDeploymentInfosStartedBy;
import org.bonitasoft.engine.search.process.SearchProcessDeploymentInfosWithAssignedOrPendingHumanTasks;
import org.bonitasoft.engine.search.process.SearchProcessDeploymentInfosWithAssignedOrPendingHumanTasksFor;
import org.bonitasoft.engine.search.process.SearchProcessDeploymentInfosWithAssignedOrPendingHumanTasksSupervisedBy;
import org.bonitasoft.engine.search.process.SearchProcessInstances;
import org.bonitasoft.engine.search.process.SearchUncategorizedProcessDeploymentInfos;
import org.bonitasoft.engine.search.process.SearchUncategorizedProcessDeploymentInfosCanBeStartedBy;
import org.bonitasoft.engine.search.process.SearchUncategorizedProcessDeploymentInfosSupervisedBy;
import org.bonitasoft.engine.search.supervisor.SearchArchivedHumanTasksSupervisedBy;
import org.bonitasoft.engine.search.supervisor.SearchAssignedTasksSupervisedBy;
import org.bonitasoft.engine.search.supervisor.SearchProcessDeploymentInfosSupervised;
import org.bonitasoft.engine.search.supervisor.SearchSupervisors;
import org.bonitasoft.engine.search.task.SearchArchivedTasks;
import org.bonitasoft.engine.search.task.SearchArchivedTasksManagedBy;
import org.bonitasoft.engine.search.task.SearchAssignedAndPendingHumanTasks;
import org.bonitasoft.engine.search.task.SearchAssignedAndPendingHumanTasksFor;
import org.bonitasoft.engine.search.task.SearchAssignedTaskManagedBy;
import org.bonitasoft.engine.search.task.SearchHumanTaskInstances;
import org.bonitasoft.engine.search.task.SearchPendingHiddenTasks;
import org.bonitasoft.engine.search.task.SearchPendingTasksForUser;
import org.bonitasoft.engine.search.task.SearchPendingTasksManagedBy;
import org.bonitasoft.engine.search.task.SearchPendingTasksSupervisedBy;
import org.bonitasoft.engine.service.ModelConvertor;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceSingleton;
import org.bonitasoft.engine.service.impl.ServiceAccessorFactory;
import org.bonitasoft.engine.session.model.SSession;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;
import org.bonitasoft.engine.supervisor.mapping.SSupervisorDeletionException;
import org.bonitasoft.engine.supervisor.mapping.SSupervisorNotFoundException;
import org.bonitasoft.engine.supervisor.mapping.SupervisorMappingService;
import org.bonitasoft.engine.supervisor.mapping.model.SProcessSupervisor;
import org.bonitasoft.engine.supervisor.mapping.model.SProcessSupervisorBuilder;
import org.bonitasoft.engine.supervisor.mapping.model.SProcessSupervisorBuilderFactory;
import org.bonitasoft.engine.transaction.UserTransactionService;
import org.bonitasoft.engine.xml.Parser;
import org.bonitasoft.engine.xml.XMLWriter;

public class ProcessAPIImpl
implements ProcessAPI {
    private static final int BATCH_SIZE = 100;
    private static final String CONTAINER_TYPE_PROCESS_INSTANCE = "PROCESS_INSTANCE";
    private static final String CONTAINER_TYPE_ACTIVITY_INSTANCE = "ACTIVITY_INSTANCE";
    private final ProcessManagementAPIImplDelegate processManagementAPIImplDelegate = this.instantiateProcessManagementAPIDelegate();

    protected ProcessManagementAPIImplDelegate instantiateProcessManagementAPIDelegate() {
        return new ProcessManagementAPIImplDelegate();
    }

    protected TenantServiceAccessor getTenantAccessor() {
        try {
            SessionAccessor sessionAccessor = ServiceAccessorFactory.getInstance().createSessionAccessor();
            long tenantId = sessionAccessor.getTenantId();
            return TenantServiceSingleton.getInstance(tenantId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public SearchResult<HumanTaskInstance> searchHumanTaskInstances(SearchOptions searchOptions) throws SearchException {
        try {
            return this.searchHumanTasksTransaction(searchOptions);
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
    }

    private SearchResult<HumanTaskInstance> searchHumanTasksTransaction(SearchOptions searchOptions) throws SBonitaException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        SearchHumanTaskInstances searchHumanTasksTransaction = new SearchHumanTaskInstances(activityInstanceService, flowNodeStateManager, searchEntitiesDescriptor.getSearchHumanTaskInstanceDescriptor(), searchOptions);
        searchHumanTasksTransaction.execute();
        return searchHumanTasksTransaction.getResult();
    }

    public void deleteProcessDefinition(long processDefinitionId) throws DeletionException {
        SearchOptionsBuilder builder = new SearchOptionsBuilder(0, 1);
        builder.filter("processDefinitionId", (Serializable)Long.valueOf(processDefinitionId));
        SearchOptions searchOptions = builder.done();
        try {
            boolean hasArchivedProcessInstances;
            boolean hasOpenProcessInstances;
            boolean bl = hasOpenProcessInstances = this.searchProcessInstances(this.getTenantAccessor(), searchOptions).getCount() > 0L;
            if (hasOpenProcessInstances) {
                throw new DeletionException("Some active process instances are still found, process #" + processDefinitionId + " can't be deleted.");
            }
            boolean bl2 = hasArchivedProcessInstances = this.searchArchivedProcessInstances(searchOptions).getCount() > 0L;
            if (hasArchivedProcessInstances) {
                throw new DeletionException("Some archived process instances are still found, process #" + processDefinitionId + " can't be deleted.");
            }
            this.processManagementAPIImplDelegate.deleteProcessDefinition(processDefinitionId);
        }
        catch (Exception e) {
            throw new DeletionException((Throwable)e);
        }
    }

    public void deleteProcessDefinitions(List<Long> processDefinitionIds) throws DeletionException {
        for (Long processDefinitionId : processDefinitionIds) {
            this.deleteProcessDefinition(processDefinitionId);
        }
    }

    @CustomTransactions
    @Deprecated
    public void deleteProcess(final long processDefinitionId) throws DeletionException {
        final TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        UserTransactionService userTransactionService = tenantAccessor.getUserTransactionService();
        try {
            userTransactionService.executeInTransaction(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ProcessAPIImpl.this.deleteProcessInstancesFromProcessDefinition(processDefinitionId, tenantAccessor);
                    try {
                        ProcessAPIImpl.this.processManagementAPIImplDelegate.deleteProcessDefinition(processDefinitionId);
                    }
                    catch (BonitaHomeNotSetException e) {
                        throw new SProcessDeletionException((Throwable)e, processDefinitionId);
                    }
                    catch (IOException e) {
                        throw new SProcessDeletionException((Throwable)e, processDefinitionId);
                    }
                    return null;
                }
            });
        }
        catch (SProcessInstanceHierarchicalDeletionException e) {
            throw new ProcessInstanceHierarchicalDeletionException(e.getMessage(), e.getProcessInstanceId());
        }
        catch (Exception e) {
            throw new DeletionException((Throwable)e);
        }
    }

    private void deleteProcessInstancesFromProcessDefinition(long processDefinitionId, TenantServiceAccessor tenantAccessor) throws SBonitaException, SProcessInstanceHierarchicalDeletionException {
        List<ProcessInstance> processInstances;
        int maxResults = 1000;
        do {
            if ((processInstances = this.searchProcessInstancesFromProcessDefinition(tenantAccessor, processDefinitionId, 0, 1000)).size() <= 0) continue;
            this.deleteProcessInstancesInsideLocks(tenantAccessor, true, processInstances, tenantAccessor.getTenantId());
        } while (!processInstances.isEmpty());
    }

    private void deleteProcessInstancesInsideLocks(TenantServiceAccessor tenantAccessor, boolean ignoreProcessInstanceNotFound, List<ProcessInstance> processInstances, long tenantId) throws SBonitaException, SProcessInstanceHierarchicalDeletionException {
        ArrayList<Long> processInstanceIds = new ArrayList<Long>(processInstances.size());
        for (ProcessInstance processInstance : processInstances) {
            processInstanceIds.add(processInstance.getId());
        }
        this.deleteProcessInstancesInsideLocksFromIds(tenantAccessor, ignoreProcessInstanceNotFound, processInstanceIds, tenantId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteProcessInstancesInsideLocksFromIds(TenantServiceAccessor tenantAccessor, boolean ignoreProcessInstanceNotFound, List<Long> processInstanceIds, long tenantId) throws SBonitaException, SProcessInstanceHierarchicalDeletionException {
        LockService lockService = tenantAccessor.getLockService();
        String objectType = SFlowElementsContainerType.PROCESS.name();
        ArrayList<Long> lockedProcesses = new ArrayList<Long>();
        ArrayList<BonitaLock> locks = null;
        try {
            locks = this.createLocks(lockService, objectType, lockedProcesses, processInstanceIds, tenantId);
            this.deleteProcessInstancesInTransaction(tenantAccessor, ignoreProcessInstanceNotFound, processInstanceIds);
        }
        finally {
            this.releaseLocks(tenantAccessor, lockService, locks, tenantId);
        }
    }

    private void releaseLocks(TenantServiceAccessor tenantAccessor, LockService lockService, List<BonitaLock> locks, long tenantId) {
        if (locks == null) {
            return;
        }
        for (BonitaLock lock : locks) {
            try {
                lockService.unlock(lock, tenantId);
            }
            catch (SLockException e) {
                this.log(tenantAccessor, e);
            }
        }
    }

    private ArrayList<BonitaLock> createLocks(LockService lockService, String objectType, List<Long> lockedProcesses, List<Long> processInstanceIds, long tenantId) throws SLockException {
        ArrayList<BonitaLock> locks = new ArrayList<BonitaLock>(processInstanceIds.size());
        for (Long processInstanceId : processInstanceIds) {
            BonitaLock lock = lockService.lock(processInstanceId, objectType, tenantId);
            locks.add(lock);
            lockedProcesses.add(processInstanceId);
        }
        return locks;
    }

    private void deleteProcessInstancesInTransaction(TenantServiceAccessor tenantAccessor, boolean ignoreProcessInstanceNotFound, List<Long> processInstanceIds) throws SBonitaException, SProcessInstanceHierarchicalDeletionException {
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        TechnicalLoggerService logger = tenantAccessor.getTechnicalLoggerService();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        this.deleteProcessInstances(processInstanceService, logger, ignoreProcessInstanceNotFound, activityInstanceService, processInstanceIds);
    }

    private void deleteProcessInstances(ProcessInstanceService processInstanceService, TechnicalLoggerService logger, boolean ignoreProcessInstanceNotFound, ActivityInstanceService activityInstanceService, List<Long> processInstanceIds) throws SBonitaException, SProcessInstanceHierarchicalDeletionException {
        for (Long processInstanceId : processInstanceIds) {
            try {
                this.deleteProcessInstance(processInstanceService, processInstanceId, activityInstanceService);
            }
            catch (SProcessInstanceNotFoundException e) {
                if (ignoreProcessInstanceNotFound) {
                    if (!logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) continue;
                    logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, e.getMessage() + ". It has probably completed.");
                    continue;
                }
                throw e;
            }
        }
    }

    private void deleteProcessInstance(ProcessInstanceService processInstanceService, Long processInstanceId, ActivityInstanceService activityInstanceService) throws SBonitaException, SProcessInstanceHierarchicalDeletionException {
        SProcessInstance processInstance = processInstanceService.getProcessInstance(processInstanceId);
        long callerId = processInstance.getCallerId();
        if (callerId > 0L) {
            try {
                SFlowNodeInstance flowNodeInstance = activityInstanceService.getFlowNodeInstance(callerId);
                long rootProcessInstanceId = flowNodeInstance.getRootProcessInstanceId();
                SProcessInstanceHierarchicalDeletionException exception = new SProcessInstanceHierarchicalDeletionException("Unable to delete the process instance, because the parent is still active.", rootProcessInstanceId);
                exception.setProcessInstanceIdOnContext(processInstanceId);
                exception.setRootProcessInstanceIdOnContext(rootProcessInstanceId);
                exception.setFlowNodeDefinitionIdOnContext(flowNodeInstance.getFlowNodeDefinitionId());
                exception.setFlowNodeInstanceIdOnContext(flowNodeInstance.getId());
                exception.setFlowNodeNameOnContext(flowNodeInstance.getName());
                exception.setProcessDefinitionIdOnContext(flowNodeInstance.getProcessDefinitionId());
                throw exception;
            }
            catch (SFlowNodeNotFoundException e) {
                // empty catch block
            }
        }
        processInstanceService.deleteArchivedProcessInstanceElements(processInstanceId, processInstance.getProcessDefinitionId());
        processInstanceService.deleteArchivedProcessInstancesOfProcessInstance(processInstanceId);
        processInstanceService.deleteProcessInstance(processInstance);
    }

    private List<ProcessInstance> searchProcessInstancesFromProcessDefinition(TenantServiceAccessor tenantAccessor, long processDefinitionId, int startIndex, int maxResults) throws SSearchException {
        SearchOptionsBuilder searchOptionsBuilder = new SearchOptionsBuilder(startIndex, maxResults);
        searchOptionsBuilder.filter("processDefinitionId", (Serializable)Long.valueOf(processDefinitionId));
        searchOptionsBuilder.sort("callerId", Order.ASC);
        return this.searchProcessInstances(tenantAccessor, searchOptionsBuilder.done()).getResult();
    }

    @CustomTransactions
    @Deprecated
    public void deleteProcesses(List<Long> processDefinitionIds) throws DeletionException {
        for (Long processDefinitionId : processDefinitionIds) {
            this.deleteProcess(processDefinitionId);
        }
    }

    public ProcessDefinition deployAndEnableProcess(DesignProcessDefinition designProcessDefinition) throws ProcessDeployException, ProcessEnablementException, AlreadyExistsException, InvalidProcessDefinitionException {
        BusinessArchive businessArchive;
        try {
            businessArchive = new BusinessArchiveBuilder().createNewBusinessArchive().setProcessDefinition(designProcessDefinition).done();
        }
        catch (InvalidBusinessArchiveFormatException ibafe) {
            throw new InvalidProcessDefinitionException(ibafe.getMessage());
        }
        return this.deployAndEnableProcess(businessArchive);
    }

    public ProcessDefinition deployAndEnableProcess(BusinessArchive businessArchive) throws ProcessDeployException, ProcessEnablementException, AlreadyExistsException {
        ProcessDefinition processDefinition = this.deploy(businessArchive);
        try {
            this.enableProcess(processDefinition.getId());
        }
        catch (ProcessDefinitionNotFoundException pdnfe) {
            throw new ProcessEnablementException(pdnfe.getMessage());
        }
        return processDefinition;
    }

    public ProcessDefinition deploy(DesignProcessDefinition designProcessDefinition) throws AlreadyExistsException, ProcessDeployException {
        try {
            BusinessArchive businessArchive = new BusinessArchiveBuilder().createNewBusinessArchive().setProcessDefinition(designProcessDefinition).done();
            return this.deploy(businessArchive);
        }
        catch (InvalidBusinessArchiveFormatException ibafe) {
            throw new ProcessDeployException((Throwable)ibafe);
        }
    }

    public ProcessDefinition deploy(BusinessArchive businessArchive) throws ProcessDeployException, AlreadyExistsException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        DependencyService dependencyService = tenantAccessor.getDependencyService();
        DesignProcessDefinition designProcessDefinition = businessArchive.getProcessDefinition();
        SProcessDefinition sProcessDefinition = BuilderFactory.get(SProcessDefinitionBuilderFactory.class).createNewInstance(designProcessDefinition).done();
        try {
            try {
                processDefinitionService.getProcessDefinitionId(designProcessDefinition.getName(), designProcessDefinition.getVersion());
                throw new AlreadyExistsException("The process " + designProcessDefinition.getName() + " in version " + designProcessDefinition.getVersion() + " already exists.");
            }
            catch (SProcessDefinitionReadException e) {
                processDefinitionService.store(sProcessDefinition, designProcessDefinition.getDisplayName(), designProcessDefinition.getDisplayDescription());
                this.unzipBar(businessArchive, sProcessDefinition, tenantAccessor.getTenantId());
                boolean isResolved = tenantAccessor.getDependencyResolver().resolveDependencies(businessArchive, tenantAccessor, sProcessDefinition);
                if (isResolved) {
                    tenantAccessor.getDependencyResolver().resolveAndCreateDependencies(businessArchive, processDefinitionService, dependencyService, sProcessDefinition);
                }
            }
        }
        catch (BonitaHomeNotSetException e) {
            throw new ProcessDeployException((Throwable)e);
        }
        catch (IOException e) {
            throw new ProcessDeployException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new ProcessDeployException((Throwable)e);
        }
        ProcessDefinition processDefinition = ModelConvertor.toProcessDefinition(sProcessDefinition);
        TechnicalLoggerService logger = tenantAccessor.getTechnicalLoggerService();
        if (logger.isLoggable(this.getClass(), TechnicalLogSeverity.INFO)) {
            logger.log(this.getClass(), TechnicalLogSeverity.INFO, "The user <" + SessionInfos.getUserNameFromSession() + "> has installed process <" + sProcessDefinition.getName() + "> in version <" + sProcessDefinition.getVersion() + "> with id <" + sProcessDefinition.getId() + ">");
        }
        return processDefinition;
    }

    public void importActorMapping(long pDefinitionId, byte[] actorMappingXML) throws ActorMappingImportException {
        if (actorMappingXML != null) {
            String actorMapping = new String(actorMappingXML, Charset.forName("UTF-8"));
            this.importActorMapping(pDefinitionId, actorMapping);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] exportBarProcessContentUnderHome(long processDefinitionId) throws ProcessExportException {
        byte[] byArray;
        String processesFolder;
        try {
            long tenantId = this.getTenantAccessor().getTenantId();
            processesFolder = BonitaHomeServer.getInstance().getProcessesFolder(tenantId);
        }
        catch (BonitaHomeNotSetException e) {
            throw new BonitaRuntimeException((Throwable)e);
        }
        File file = new File(processesFolder);
        if (!file.exists()) {
            file.mkdirs();
        }
        File processFolder = new File(file, String.valueOf(processDefinitionId));
        File actormappF = new File(processFolder.getPath(), "actorMapping.xml");
        if (!actormappF.exists()) {
            actormappF.createNewFile();
        }
        String xmlcontent = "";
        try {
            xmlcontent = this.exportActorMapping(processDefinitionId);
        }
        catch (ActorMappingExportException e) {
            throw new ProcessExportException((Throwable)e);
        }
        IOUtil.writeContentToFile((String)xmlcontent, (File)actormappF);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(baos);
        try {
            IOUtil.zipDir((String)processFolder.getPath(), (ZipOutputStream)zos, (String)processFolder.getPath());
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                zos.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ProcessExportException((Throwable)e);
            }
        }
        zos.close();
        return byArray;
    }

    protected void unzipBar(BusinessArchive businessArchive, SProcessDefinition sProcessDefinition, long tenantId) throws BonitaHomeNotSetException, IOException {
        File processFolder = this.getProcessFolder(sProcessDefinition.getId(), tenantId);
        BusinessArchiveFactory.writeBusinessArchiveToFolder((BusinessArchive)businessArchive, (File)processFolder);
    }

    private File getProcessFolder(long processDefinitionId, long tenantId) throws BonitaHomeNotSetException {
        String processesFolder = BonitaHomeServer.getInstance().getProcessesFolder(tenantId);
        File file = new File(processesFolder);
        if (!file.exists()) {
            file.mkdirs();
        }
        return new File(file, String.valueOf(processDefinitionId));
    }

    @CustomTransactions
    @Deprecated
    public void disableAndDelete(final long processDefinitionId) throws ProcessDefinitionNotFoundException, ProcessActivationException, DeletionException {
        TransactionExecutor transactionExecutor = this.getTenantAccessor().getTransactionExecutor();
        try {
            transactionExecutor.execute(new TransactionContent(){

                @Override
                public void execute() throws SBonitaException {
                    ProcessAPIImpl.this.processManagementAPIImplDelegate.disableProcess(processDefinitionId);
                }
            });
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new ProcessActivationException((Exception)e);
        }
        this.deleteProcess(processDefinitionId);
    }

    public void disableAndDeleteProcessDefinition(long processDefinitionId) throws ProcessDefinitionNotFoundException, ProcessActivationException, DeletionException {
        this.disableProcess(processDefinitionId);
        this.deleteProcessDefinition(processDefinitionId);
    }

    public void disableProcess(long processDefinitionId) throws ProcessDefinitionNotFoundException, ProcessActivationException {
        try {
            this.processManagementAPIImplDelegate.disableProcess(processDefinitionId);
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new ProcessActivationException((Exception)e);
        }
    }

    public void enableProcess(long processDefinitionId) throws ProcessDefinitionNotFoundException, ProcessEnablementException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        EventsHandler eventsHandler = tenantAccessor.getEventsHandler();
        try {
            EnableProcess enableProcess = new EnableProcess(processDefinitionService, processDefinitionId, eventsHandler, tenantAccessor.getTechnicalLoggerService(), SessionInfos.getUserNameFromSession());
            enableProcess.execute();
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        catch (SBonitaException sbe) {
            throw new ProcessEnablementException((Throwable)sbe);
        }
        catch (Exception e) {
            throw new ProcessEnablementException((Throwable)e);
        }
    }

    @CustomTransactions
    public void executeFlowNode(long flownodeInstanceId) throws FlowNodeExecutionException {
        try {
            this.executeFlowNode(0L, flownodeInstanceId, true);
        }
        catch (SBonitaException e) {
            throw new FlowNodeExecutionException((Throwable)e);
        }
    }

    @CustomTransactions
    public void executeFlowNode(long userId, long flownodeInstanceId) throws FlowNodeExecutionException {
        try {
            this.executeFlowNode(userId, flownodeInstanceId, true);
        }
        catch (SBonitaException e) {
            throw new FlowNodeExecutionException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeFlowNode(final long userId, final long flownodeInstanceId, boolean wrapInTransaction) throws SBonitaException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        final ProcessExecutor processExecutor = tenantAccessor.getProcessExecutor();
        final ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        LockService lockService = tenantAccessor.getLockService();
        final TechnicalLoggerService logger = tenantAccessor.getTechnicalLoggerService();
        TransactionContent transactionContent = new TransactionContent(){

            @Override
            public void execute() throws SBonitaException {
                SSession session = SessionInfos.getSession();
                if (session != null) {
                    long executerSubstituteUserId = session.getUserId();
                    long executerUserId = userId == 0L ? executerSubstituteUserId : userId;
                    SFlowNodeInstance flowNodeInstance = activityInstanceService.getFlowNodeInstance(flownodeInstanceId);
                    boolean isFirstState = flowNodeInstance.getStateId() == 0;
                    processExecutor.executeFlowNode(flownodeInstanceId, null, null, flowNodeInstance.getParentProcessInstanceId(), executerUserId, executerSubstituteUserId);
                    if (logger.isLoggable(this.getClass(), TechnicalLogSeverity.INFO) && !isFirstState) {
                        String message = LogMessageBuilder.buildExecuteTaskContextMessage(flowNodeInstance, session.getUserName(), executerUserId, executerSubstituteUserId);
                        logger.log(this.getClass(), TechnicalLogSeverity.INFO, message);
                    }
                    ProcessAPIImpl.this.addSystemCommentOnProcessInstanceWhenExecutingTaskFor(flowNodeInstance, executerUserId, executerSubstituteUserId);
                }
            }
        };
        GetFlowNodeInstance getFlowNodeInstance = new GetFlowNodeInstance(activityInstanceService, flownodeInstanceId);
        this.executeTransactionContent(tenantAccessor, getFlowNodeInstance, wrapInTransaction);
        BonitaLock lock = lockService.lock(getFlowNodeInstance.getResult().getParentProcessInstanceId(), SFlowElementsContainerType.PROCESS.name(), tenantAccessor.getTenantId());
        try {
            this.executeTransactionContent(tenantAccessor, transactionContent, wrapInTransaction);
        }
        finally {
            lockService.unlock(lock, tenantAccessor.getTenantId());
        }
    }

    protected void addSystemCommentOnProcessInstanceWhenExecutingTaskFor(SFlowNodeInstance flowNodeInstance, long executerUserId, long executerSubstituteUserId) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        TechnicalLoggerService logger = tenantAccessor.getTechnicalLoggerService();
        SCommentService commentService = tenantAccessor.getCommentService();
        SSession session = SessionInfos.getSession();
        if (executerUserId != executerSubstituteUserId) {
            IdentityService identityService = tenantAccessor.getIdentityService();
            try {
                SUser executerUser = identityService.getUser(executerUserId);
                StringBuilder stb = new StringBuilder();
                stb.append("The user " + session.getUserName() + " ");
                stb.append("acting as delegate of the user " + executerUser.getUserName() + " ");
                stb.append("has done the task \"" + flowNodeInstance.getDisplayName() + "\".");
                commentService.addSystemComment(flowNodeInstance.getParentProcessInstanceId(), stb.toString());
            }
            catch (SBonitaException e) {
                logger.log(this.getClass(), TechnicalLogSeverity.ERROR, "Error when adding a comment on the process instance.", e);
            }
        }
    }

    private void executeTransactionContent(TenantServiceAccessor tenantAccessor, TransactionContent transactionContent, boolean wrapInTransaction) throws SBonitaException {
        if (wrapInTransaction) {
            TransactionExecutor transactionExecutor = tenantAccessor.getTransactionExecutor();
            transactionExecutor.execute(transactionContent);
        } else {
            transactionContent.execute();
        }
    }

    public List<ActivityInstance> getActivities(long processInstanceId, int startIndex, int maxResults) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        try {
            return ModelConvertor.toActivityInstances(activityInstanceService.getActivityInstances(processInstanceId, startIndex, maxResults), flowNodeStateManager);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public long getNumberOfProcessDeploymentInfos() {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        GetNumberOfProcessDeploymentInfos transactionContentWithResult = new GetNumberOfProcessDeploymentInfos(processDefinitionService);
        try {
            transactionContentWithResult.execute();
            return (Long)transactionContentWithResult.getResult();
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public ProcessDefinition getProcessDefinition(long processDefinitionId) throws ProcessDefinitionNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        try {
            SProcessDefinition sProcessDefinition = processDefinitionService.getProcessDefinition(processDefinitionId);
            return ModelConvertor.toProcessDefinition(sProcessDefinition);
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        catch (SProcessDefinitionReadException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public DesignProcessDefinition getDesignProcessDefinition(long processDefinitionId) throws ProcessDefinitionNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        try {
            File processFolder = this.getProcessFolder(processDefinitionId, tenantAccessor.getTenantId());
            File processDesignFile = new File(processFolder, "process-design.xml");
            ProcessDefinitionBARContribution processDefinitionBARContribution = new ProcessDefinitionBARContribution();
            return processDefinitionBARContribution.deserializeProcessDefinition(processDesignFile);
        }
        catch (BonitaHomeNotSetException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        catch (InvalidBusinessArchiveFormatException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        catch (IOException e) {
            throw new ProcessDefinitionNotFoundException(processDefinitionId, (Throwable)e);
        }
    }

    public ProcessDeploymentInfo getProcessDeploymentInfo(long processDefinitionId) throws ProcessDefinitionNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        try {
            GetProcessDefinitionDeployInfo transactionContentWithResult = new GetProcessDefinitionDeployInfo(processDefinitionId, processDefinitionService);
            transactionContentWithResult.execute();
            return ModelConvertor.toProcessDeploymentInfo((SProcessDefinitionDeployInfo)transactionContentWithResult.getResult());
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    private void log(TenantServiceAccessor tenantAccessor, Exception e) {
        TechnicalLoggerService logger = tenantAccessor.getTechnicalLoggerService();
        if (logger.isLoggable(this.getClass(), TechnicalLogSeverity.ERROR)) {
            logger.log(this.getClass(), TechnicalLogSeverity.ERROR, e);
        }
    }

    public ProcessInstance getProcessInstance(long processInstanceId) throws ProcessInstanceNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        try {
            SProcessInstance sProcessInstance = this.getSProcessInstance(processInstanceId);
            return ModelConvertor.toProcessInstances(Collections.singletonList(sProcessInstance), processDefinitionService).get(0);
        }
        catch (SProcessInstanceNotFoundException notFound) {
            throw new ProcessInstanceNotFoundException((Throwable)notFound);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    protected SProcessInstance getSProcessInstance(long processInstanceId) throws SProcessInstanceNotFoundException, SProcessInstanceReadException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        return processInstanceService.getProcessInstance(processInstanceId);
    }

    public List<ArchivedProcessInstance> getArchivedProcessInstances(long processInstanceId, int startIndex, int maxResults) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        GetArchivedProcessInstanceList getProcessInstanceList = new GetArchivedProcessInstanceList(processInstanceService, searchEntitiesDescriptor, processInstanceId, startIndex, maxResults);
        try {
            getProcessInstanceList.execute();
        }
        catch (SBonitaException e) {
            this.log(tenantAccessor, e);
            throw new RetrieveException((Throwable)e);
        }
        return getProcessInstanceList.getResult();
    }

    public ArchivedProcessInstance getArchivedProcessInstance(long id) throws ArchivedProcessInstanceNotFoundException, RetrieveException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        try {
            SAProcessInstance archivedProcessInstance = processInstanceService.getArchivedProcessInstance(id);
            return ModelConvertor.toArchivedProcessInstance(archivedProcessInstance);
        }
        catch (SProcessInstanceNotFoundException e) {
            throw new ArchivedProcessInstanceNotFoundException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public ArchivedProcessInstance getFinalArchivedProcessInstance(long processInstanceId) throws ArchivedProcessInstanceNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        GetLastArchivedProcessInstance getProcessInstance = new GetLastArchivedProcessInstance(processInstanceService, processInstanceId, tenantAccessor.getSearchEntitiesDescriptor());
        try {
            getProcessInstance.execute();
        }
        catch (SProcessInstanceNotFoundException e) {
            this.log(tenantAccessor, e);
            throw new ArchivedProcessInstanceNotFoundException((Throwable)e);
        }
        catch (SBonitaException e) {
            this.log(tenantAccessor, e);
            throw new RetrieveException((Throwable)e);
        }
        return getProcessInstance.getResult();
    }

    public ProcessInstance startProcess(long processDefinitionId) throws ProcessActivationException, ProcessExecutionException {
        try {
            return this.startProcess(this.getUserId(), processDefinitionId);
        }
        catch (ProcessDefinitionNotFoundException e) {
            throw new ProcessExecutionException((Throwable)e);
        }
    }

    public ProcessInstance startProcess(long userId, long processDefinitionId) throws ProcessDefinitionNotFoundException, ProcessExecutionException, ProcessActivationException {
        return this.startProcess(userId, processDefinitionId, null, null);
    }

    public int getNumberOfActors(long processDefinitionId) throws ProcessDefinitionNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        GetNumberOfActors getNumberofActors = new GetNumberOfActors(processDefinitionService, processDefinitionId);
        try {
            getNumberofActors.execute();
        }
        catch (SBonitaException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        return getNumberofActors.getResult();
    }

    public List<ActorInstance> getActors(long processDefinitionId, int startIndex, int maxResults, ActorCriterion sort) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        try {
            OrderByType order;
            if (sort == null) {
                order = OrderByType.ASC;
            } else {
                switch (sort) {
                    case NAME_ASC: {
                        order = OrderByType.ASC;
                        break;
                    }
                    default: {
                        order = OrderByType.DESC;
                    }
                }
            }
            QueryOptions queryOptions = new QueryOptions(startIndex, maxResults, SActor.class, "name", order);
            List<SActor> actors = actorMappingService.getActors(processDefinitionId, queryOptions);
            return ModelConvertor.toActors(actors);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public List<ActorMember> getActorMembers(long actorId, int startIndex, int maxResults) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        try {
            List<SActorMember> actorMembers = actorMappingService.getActorMembers(actorId, startIndex, maxResults);
            return ModelConvertor.toActorMembers(actorMembers);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public long getNumberOfActorMembers(long actorId) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        GetNumberOfActorMembers numberOfActorMembers = new GetNumberOfActorMembers(actorMappingService, actorId);
        try {
            numberOfActorMembers.execute();
            return numberOfActorMembers.getResult();
        }
        catch (SBonitaException sbe) {
            return 0L;
        }
    }

    public long getNumberOfUsersOfActor(long actorId) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        GetNumberOfUsersOfActor numberOfUsersOfActor = new GetNumberOfUsersOfActor(actorMappingService, actorId);
        numberOfUsersOfActor.execute();
        return numberOfUsersOfActor.getResult();
    }

    public long getNumberOfRolesOfActor(long actorId) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        GetNumberOfRolesOfActor numberOfRolesOfActor = new GetNumberOfRolesOfActor(actorMappingService, actorId);
        numberOfRolesOfActor.execute();
        return numberOfRolesOfActor.getResult();
    }

    public long getNumberOfGroupsOfActor(long actorId) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        GetNumberOfGroupsOfActor numberOfGroupsOfActor = new GetNumberOfGroupsOfActor(actorMappingService, actorId);
        numberOfGroupsOfActor.execute();
        return numberOfGroupsOfActor.getResult();
    }

    public long getNumberOfMembershipsOfActor(long actorId) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        GetNumberOfMembershipsOfActor getNumber = new GetNumberOfMembershipsOfActor(actorMappingService, actorId);
        getNumber.execute();
        return getNumber.getResult();
    }

    public ActorInstance updateActor(long actorId, ActorUpdater descriptor) throws ActorNotFoundException, UpdateException {
        if (descriptor == null || descriptor.getFields().isEmpty()) {
            throw new UpdateException("The update descriptor does not contain field updates");
        }
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        SActorUpdateBuilder actorUpdateBuilder = BuilderFactory.get(SActorUpdateBuilderFactory.class).createNewInstance();
        Map fields = descriptor.getFields();
        for (Map.Entry field : fields.entrySet()) {
            switch ((ActorUpdater.ActorField)field.getKey()) {
                case DISPLAY_NAME: {
                    actorUpdateBuilder.updateDisplayName((String)field.getValue());
                    break;
                }
                case DESCRIPTION: {
                    actorUpdateBuilder.updateDescription((String)field.getValue());
                    break;
                }
            }
        }
        EntityUpdateDescriptor updateDescriptor = actorUpdateBuilder.done();
        try {
            SActor updateActor = actorMappingService.updateActor(actorId, updateDescriptor);
            return ModelConvertor.toActorInstance(updateActor);
        }
        catch (SActorNotFoundException e) {
            throw new ActorNotFoundException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new UpdateException((Throwable)e);
        }
    }

    public ActorMember addUserToActor(long actorId, long userId) throws CreationException, AlreadyExistsException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        try {
            this.checkIfActorMappingForUserAlreadyExists(actorId, userId);
            SActorMember actorMember = actorMappingService.addUserToActor(actorId, userId);
            long processDefinitionId = actorMappingService.getActor(actorId).getScopeId();
            ActorMember clientActorMember = ModelConvertor.toActorMember(actorMember);
            tenantAccessor.getDependencyResolver().resolveDependencies(processDefinitionId, tenantAccessor);
            return clientActorMember;
        }
        catch (SBonitaException sbe) {
            throw new CreationException((Throwable)sbe);
        }
    }

    private void checkIfActorMappingForUserAlreadyExists(long actorId, long userId) throws AlreadyExistsException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        try {
            SActorMember sActorMember = actorMappingService.getActorMember(actorId, userId, -1L, -1L);
            if (sActorMember != null) {
                throw new AlreadyExistsException("The mapping already exists for the actor id = <" + actorId + ">, the user id = <" + userId + ">");
            }
        }
        catch (SBonitaReadException e) {
            // empty catch block
        }
    }

    public ActorMember addUserToActor(String actorName, ProcessDefinition processDefinition, long userId) throws CreationException, AlreadyExistsException, ActorNotFoundException {
        List<ActorInstance> actors = this.getActors(processDefinition.getId(), 0, Integer.MAX_VALUE, ActorCriterion.NAME_ASC);
        for (ActorInstance ai : actors) {
            if (!actorName.equals(ai.getName())) continue;
            return this.addUserToActor(ai.getId(), userId);
        }
        throw new ActorNotFoundException("Actor " + actorName + " not found in process definition " + processDefinition.getName());
    }

    public ActorMember addGroupToActor(long actorId, long groupId) throws CreationException, AlreadyExistsException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        try {
            this.checkIfActorMappingForGroupAlreadyExists(actorId, groupId);
            SActorMember actorMember = actorMappingService.addGroupToActor(actorId, groupId);
            long processDefinitionId = actorMappingService.getActor(actorId).getScopeId();
            ActorMember clientActorMember = ModelConvertor.toActorMember(actorMember);
            tenantAccessor.getDependencyResolver().resolveDependencies(processDefinitionId, tenantAccessor);
            return clientActorMember;
        }
        catch (SBonitaException e) {
            throw new CreationException((Throwable)e);
        }
    }

    private void checkIfActorMappingForGroupAlreadyExists(long actorId, long groupId) throws AlreadyExistsException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        try {
            SActorMember sActorMember = actorMappingService.getActorMember(actorId, -1L, groupId, -1L);
            if (sActorMember != null) {
                throw new AlreadyExistsException("The mapping already exists for the actor id = <" + actorId + ">, the group id = <" + groupId + ">");
            }
        }
        catch (SBonitaReadException e) {
            // empty catch block
        }
    }

    public ActorMember addGroupToActor(String actorName, long groupId, ProcessDefinition processDefinition) throws CreationException, AlreadyExistsException, ActorNotFoundException {
        List<ActorInstance> actors = this.getActors(processDefinition.getId(), 0, Integer.MAX_VALUE, ActorCriterion.NAME_ASC);
        for (ActorInstance actorInstance : actors) {
            if (!actorName.equals(actorInstance.getName())) continue;
            return this.addGroupToActor(actorInstance.getId(), groupId);
        }
        throw new ActorNotFoundException("Actor " + actorName + " not found in process definition " + processDefinition.getName());
    }

    public ActorMember addRoleToActor(long actorId, long roleId) throws CreationException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        try {
            this.checkIfActorMappingForRoleAlreadyExists(actorId, roleId);
            SActorMember actorMember = actorMappingService.addRoleToActor(actorId, roleId);
            long processDefinitionId = actorMappingService.getActor(actorId).getScopeId();
            ActorMember clientActorMember = ModelConvertor.toActorMember(actorMember);
            tenantAccessor.getDependencyResolver().resolveDependencies(processDefinitionId, tenantAccessor);
            return clientActorMember;
        }
        catch (SBonitaException sbe) {
            throw new CreationException((Throwable)sbe);
        }
    }

    private void checkIfActorMappingForRoleAlreadyExists(long actorId, long roleId) throws AlreadyExistsException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        try {
            SActorMember sActorMember = actorMappingService.getActorMember(actorId, -1L, -1L, roleId);
            if (sActorMember != null) {
                throw new AlreadyExistsException("The mapping already exists for the actor id = <" + actorId + ">, the role id = <" + roleId + ">");
            }
        }
        catch (SBonitaReadException e) {
            // empty catch block
        }
    }

    public ActorMember addRoleToActor(String actorName, ProcessDefinition processDefinition, long roleId) throws ActorNotFoundException, CreationException {
        List<ActorInstance> actors = this.getActors(processDefinition.getId(), 0, Integer.MAX_VALUE, ActorCriterion.NAME_ASC);
        for (ActorInstance ai : actors) {
            if (!actorName.equals(ai.getName())) continue;
            return this.addRoleToActor(ai.getId(), roleId);
        }
        throw new ActorNotFoundException("Actor " + actorName + " not found in process definition " + processDefinition.getName());
    }

    public ActorMember addRoleAndGroupToActor(String actorName, ProcessDefinition processDefinition, long roleId, long groupId) throws ActorNotFoundException, CreationException {
        List<ActorInstance> actors = this.getActors(processDefinition.getId(), 0, Integer.MAX_VALUE, ActorCriterion.NAME_ASC);
        for (ActorInstance ai : actors) {
            if (!actorName.equals(ai.getName())) continue;
            return this.addRoleAndGroupToActor(ai.getId(), roleId, groupId);
        }
        throw new ActorNotFoundException("Actor " + actorName + " not found in process definition " + processDefinition.getName());
    }

    public ActorMember addRoleAndGroupToActor(long actorId, long roleId, long groupId) throws CreationException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        try {
            this.checkIfActorMappingForMembershipAlreadyExists(actorId, roleId, groupId);
            SActorMember actorMember = actorMappingService.addRoleAndGroupToActor(actorId, roleId, groupId);
            long processDefinitionId = actorMappingService.getActor(actorId).getScopeId();
            ActorMember clientActorMember = ModelConvertor.toActorMember(actorMember);
            tenantAccessor.getDependencyResolver().resolveDependencies(processDefinitionId, tenantAccessor);
            return clientActorMember;
        }
        catch (SBonitaException sbe) {
            throw new CreationException((Throwable)sbe);
        }
    }

    private void checkIfActorMappingForMembershipAlreadyExists(long actorId, long roleId, long groupId) throws AlreadyExistsException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        try {
            SActorMember sActorMember = actorMappingService.getActorMember(actorId, -1L, groupId, roleId);
            if (sActorMember != null) {
                throw new AlreadyExistsException("The mapping already exists for the actor id = <" + actorId + ">, the role id = <" + roleId + ">, the group id = <" + groupId + ">");
            }
        }
        catch (SBonitaReadException e) {
            // empty catch block
        }
    }

    public void removeActorMember(long actorMemberId) throws DeletionException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        RemoveActorMember removeActorMember = new RemoveActorMember(actorMappingService, actorMemberId);
        try {
            removeActorMember.execute();
            SActorMember actorMember = removeActorMember.getResult();
            long processDefinitionId = this.getActor(actorMember.getActorId()).getProcessDefinitionId();
            tenantAccessor.getDependencyResolver().resolveDependencies(processDefinitionId, tenantAccessor);
        }
        catch (SBonitaException sbe) {
            throw new DeletionException((Throwable)sbe);
        }
        catch (ActorNotFoundException e) {
            throw new DeletionException((Throwable)e);
        }
    }

    public ActorInstance getActor(long actorId) throws ActorNotFoundException {
        try {
            TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
            ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
            GetActor getActor = new GetActor(actorMappingService, actorId);
            getActor.execute();
            return ModelConvertor.toActorInstance(getActor.getResult());
        }
        catch (SBonitaException e) {
            throw new ActorNotFoundException((Throwable)e);
        }
    }

    public ActivityInstance getActivityInstance(long activityInstanceId) throws ActivityInstanceNotFoundException {
        SActivityInstance sActivityInstance;
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        try {
            sActivityInstance = this.getSActivityInstance(activityInstanceId);
        }
        catch (SActivityInstanceNotFoundException e) {
            throw new ActivityInstanceNotFoundException(activityInstanceId);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
        return ModelConvertor.toActivityInstance(sActivityInstance, flowNodeStateManager);
    }

    protected SActivityInstance getSActivityInstance(long activityInstanceId) throws SActivityInstanceNotFoundException, SActivityReadException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        return activityInstanceService.getActivityInstance(activityInstanceId);
    }

    public FlowNodeInstance getFlowNodeInstance(long flowNodeInstanceId) throws FlowNodeInstanceNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        try {
            SFlowNodeInstance flowNodeInstance = activityInstanceService.getFlowNodeInstance(flowNodeInstanceId);
            return ModelConvertor.toFlowNodeInstance(flowNodeInstance, flowNodeStateManager);
        }
        catch (SFlowNodeNotFoundException e) {
            throw new FlowNodeInstanceNotFoundException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public List<HumanTaskInstance> getAssignedHumanTaskInstances(long userId, int startIndex, int maxResults, ActivityInstanceCriterion pagingCriterion) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        OrderAndField orderAndField = OrderAndFields.getOrderAndFieldForActivityInstance(pagingCriterion);
        ActivityInstanceService instanceService = tenantAccessor.getActivityInstanceService();
        try {
            GetAssignedTasks getAssignedTasks = new GetAssignedTasks(instanceService, userId, startIndex, maxResults, orderAndField.getField(), orderAndField.getOrder());
            getAssignedTasks.execute();
            Object assignedTasks = getAssignedTasks.getResult();
            return ModelConvertor.toHumanTaskInstances((List<? extends SHumanTaskInstance>)assignedTasks, flowNodeStateManager);
        }
        catch (SUserNotFoundException e) {
            return Collections.emptyList();
        }
        catch (SBonitaException e) {
            return Collections.emptyList();
        }
    }

    public List<HumanTaskInstance> getPendingHumanTaskInstances(long userId, int startIndex, int maxResults, ActivityInstanceCriterion pagingCriterion) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        OrderAndField orderAndField = OrderAndFields.getOrderAndFieldForActivityInstance(pagingCriterion);
        ProcessDefinitionService definitionService = tenantAccessor.getProcessDefinitionService();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        try {
            Set<Long> actorIds = this.getActorsForUser(userId, actorMappingService, definitionService);
            List<SHumanTaskInstance> pendingTasks = activityInstanceService.getPendingTasks(userId, actorIds, startIndex, maxResults, orderAndField.getField(), orderAndField.getOrder());
            return ModelConvertor.toHumanTaskInstances(pendingTasks, flowNodeStateManager);
        }
        catch (SBonitaException e) {
            return Collections.emptyList();
        }
    }

    private Set<Long> getActorsForUser(long userId, ActorMappingService actorMappingService, ProcessDefinitionService definitionService) throws SBonitaReadException, SProcessDefinitionReadException {
        List<Long> processDefIds = definitionService.getProcessDefinitionIds(ActivationState.ENABLED, 0, Integer.MAX_VALUE);
        HashSet<Long> processDefinitionIds = new HashSet<Long>(processDefIds);
        if (processDefinitionIds.isEmpty()) {
            return Collections.emptySet();
        }
        List<SActor> actors = actorMappingService.getActors(processDefinitionIds, userId);
        if (actors.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Long> actorIds = new HashSet<Long>();
        for (SActor sActor : actors) {
            actorIds.add(sActor.getId());
        }
        return actorIds;
    }

    public ArchivedActivityInstance getArchivedActivityInstance(long activityInstanceId) throws ActivityInstanceNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        GetArchivedActivityInstance getActivityInstance = new GetArchivedActivityInstance(activityInstanceService, activityInstanceId);
        try {
            getActivityInstance.execute();
        }
        catch (SActivityInstanceNotFoundException e) {
            throw new ActivityInstanceNotFoundException(activityInstanceId, (Exception)e);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
        return ModelConvertor.toArchivedActivityInstance(getActivityInstance.getResult(), flowNodeStateManager);
    }

    public ArchivedFlowNodeInstance getArchivedFlowNodeInstance(long archivedFlowNodeInstanceId) throws ArchivedFlowNodeInstanceNotFoundException, RetrieveException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        try {
            SAFlowNodeInstance archivedFlowNodeInstance = activityInstanceService.getArchivedFlowNodeInstance(archivedFlowNodeInstanceId);
            return ModelConvertor.toArchivedFlowNodeInstance(archivedFlowNodeInstance, flowNodeStateManager);
        }
        catch (SFlowNodeNotFoundException e) {
            throw new ArchivedFlowNodeInstanceNotFoundException(archivedFlowNodeInstanceId);
        }
        catch (SFlowNodeReadException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public List<ProcessInstance> getProcessInstances(int startIndex, int maxResults, ProcessInstanceCriterion criterion) {
        List result;
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        OrderAndField orderAndField = OrderAndFields.getOrderAndFieldForProcessInstance(criterion);
        SearchOptionsBuilder searchOptionsBuilder = new SearchOptionsBuilder(startIndex, maxResults);
        searchOptionsBuilder.sort(orderAndField.getField(), Order.valueOf((String)orderAndField.getOrder().name()));
        try {
            result = this.searchProcessInstances(tenantAccessor, searchOptionsBuilder.done()).getResult();
        }
        catch (SSearchException e) {
            result = Collections.emptyList();
        }
        return result;
    }

    public long getNumberOfProcessInstances() {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        try {
            GetNumberOfProcessInstance transactionContent = new GetNumberOfProcessInstance(processInstanceService, processDefinitionService, searchEntitiesDescriptor);
            transactionContent.execute();
            return (Long)transactionContent.getResult();
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    protected SearchResult<ProcessInstance> searchProcessInstances(TenantServiceAccessor tenantAccessor, SearchOptions searchOptions) throws SSearchException {
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        try {
            SearchProcessInstances searchProcessInstances = new SearchProcessInstances(processInstanceService, searchEntitiesDescriptor.getSearchProcessInstanceDescriptor(), searchOptions, processDefinitionService);
            searchProcessInstances.execute();
            return searchProcessInstances.getResult();
        }
        catch (SBonitaException sbe) {
            throw new SSearchException(sbe);
        }
    }

    public List<ArchivedProcessInstance> getArchivedProcessInstances(int startIndex, int maxResults, ProcessInstanceCriterion criterion) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        OrderAndField orderAndField = OrderAndFields.getOrderAndFieldForProcessInstance(criterion);
        SearchOptionsBuilder searchOptionsBuilder = new SearchOptionsBuilder(startIndex, maxResults);
        searchOptionsBuilder.sort(orderAndField.getField(), Order.valueOf((String)orderAndField.getOrder().name()));
        searchOptionsBuilder.filter("stateId", (Serializable)Integer.valueOf(ProcessInstanceState.COMPLETED.getId()));
        searchOptionsBuilder.filter("callerId", (Serializable)Integer.valueOf(-1));
        SearchArchivedProcessInstances searchArchivedProcessInstances = this.searchArchivedProcessInstances(tenantAccessor, searchOptionsBuilder.done());
        try {
            searchArchivedProcessInstances.execute();
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
        return searchArchivedProcessInstances.getResult().getResult();
    }

    private SearchArchivedProcessInstances searchArchivedProcessInstances(TenantServiceAccessor tenantAccessor, SearchOptions searchOptions) throws RetrieveException {
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        return new SearchArchivedProcessInstances(processInstanceService, searchEntitiesDescriptor.getSearchArchivedProcessInstanceDescriptor(), searchOptions);
    }

    public long getNumberOfArchivedProcessInstances() {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        try {
            GetNumberOfArchivedProcessInstance transactionContent = new GetNumberOfArchivedProcessInstance(processInstanceService, searchEntitiesDescriptor);
            transactionContent.execute();
            return (Long)transactionContent.getResult();
        }
        catch (SBonitaException e) {
            this.log(tenantAccessor, e);
            throw new RetrieveException((Throwable)e);
        }
    }

    public SearchResult<ArchivedProcessInstance> searchArchivedProcessInstances(SearchOptions searchOptions) throws RetrieveException, SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        SearchArchivedProcessInstancesWithoutSubProcess searchArchivedProcessInstances = new SearchArchivedProcessInstancesWithoutSubProcess(processInstanceService, searchEntitiesDescriptor.getSearchArchivedProcessInstanceDescriptor(), searchOptions);
        try {
            searchArchivedProcessInstances.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return searchArchivedProcessInstances.getResult();
    }

    public SearchResult<ArchivedProcessInstance> searchArchivedProcessInstancesInAllStates(SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        SearchArchivedProcessInstances searchArchivedProcessInstances = new SearchArchivedProcessInstances(processInstanceService, searchEntitiesDescriptor.getSearchArchivedProcessInstanceDescriptor(), searchOptions);
        try {
            searchArchivedProcessInstances.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return searchArchivedProcessInstances.getResult();
    }

    public List<ActivityInstance> getOpenActivityInstances(long processInstanceId, int startIndex, int maxResults, ActivityInstanceCriterion criterion) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        try {
            int totalNumber = activityInstanceService.getNumberOfOpenActivityInstances(processInstanceId);
            if (totalNumber == 0) {
                return Collections.emptyList();
            }
            OrderAndField orderAndField = OrderAndFields.getOrderAndFieldForActivityInstance(criterion);
            return ModelConvertor.toActivityInstances(activityInstanceService.getOpenActivityInstances(processInstanceId, startIndex, maxResults, orderAndField.getField(), orderAndField.getOrder()), flowNodeStateManager);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public List<ArchivedActivityInstance> getArchivedActivityInstances(long processInstanceId, int startIndex, int maxResults, ActivityInstanceCriterion criterion) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        List<ArchivedActivityInstance> archivedActivityInstances = this.getArchivedActivityInstances(processInstanceId, startIndex, maxResults, criterion, tenantAccessor);
        return archivedActivityInstances;
    }

    private List<ArchivedActivityInstance> getArchivedActivityInstances(long processInstanceId, int pageIndex, int numberPerPage, ActivityInstanceCriterion pagingCriterion, TenantServiceAccessor tenantAccessor) throws RetrieveException {
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        OrderAndField orderAndField = OrderAndFields.getOrderAndFieldForActivityInstance(pagingCriterion);
        GetArchivedActivityInstances getActivityInstances = new GetArchivedActivityInstances(activityInstanceService, processInstanceId, pageIndex, numberPerPage, orderAndField.getField(), orderAndField.getOrder());
        try {
            getActivityInstances.execute();
        }
        catch (SBonitaException e) {
            this.log(tenantAccessor, e);
            throw new RetrieveException((Throwable)e);
        }
        return ModelConvertor.toArchivedActivityInstances((List<SAActivityInstance>)getActivityInstances.getResult(), flowNodeStateManager);
    }

    public int getNumberOfOpenedActivityInstances(long processInstanceId) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        GetNumberOfActivityInstance transactionContentWithResult = new GetNumberOfActivityInstance(processInstanceId, activityInstanceService);
        try {
            transactionContentWithResult.execute();
            return (Integer)transactionContentWithResult.getResult();
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public Category createCategory(String name, String description) throws AlreadyExistsException, CreationException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        CategoryService categoryService = tenantAccessor.getCategoryService();
        try {
            CreateCategory createCategory = new CreateCategory(name, description, categoryService);
            createCategory.execute();
            return ModelConvertor.toCategory(createCategory.getResult());
        }
        catch (SCategoryAlreadyExistsException scaee) {
            throw new AlreadyExistsException((Throwable)scaee);
        }
        catch (SBonitaException e) {
            throw new CreationException("Category create exception!", (Throwable)e);
        }
    }

    public Category getCategory(long categoryId) throws CategoryNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        CategoryService categoryService = tenantAccessor.getCategoryService();
        try {
            GetCategory getCategory = new GetCategory(categoryService, categoryId);
            getCategory.execute();
            SCategory sCategory = getCategory.getResult();
            return ModelConvertor.toCategory(sCategory);
        }
        catch (SBonitaException sbe) {
            throw new CategoryNotFoundException((Throwable)sbe);
        }
    }

    public long getNumberOfCategories() {
        CategoryService categoryService = this.getTenantAccessor().getCategoryService();
        try {
            GetNumberOfCategories getNumberOfCategories = new GetNumberOfCategories(categoryService);
            getNumberOfCategories.execute();
            return getNumberOfCategories.getResult();
        }
        catch (SBonitaException e) {
            return 0L;
        }
    }

    public List<Category> getCategories(int startIndex, int maxResults, CategoryCriterion sortCriterion) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        SCategoryBuilderFactory fact = BuilderFactory.get(SCategoryBuilderFactory.class);
        CategoryService categoryService = tenantAccessor.getCategoryService();
        String field = null;
        OrderByType order = null;
        switch (sortCriterion) {
            case NAME_ASC: {
                field = fact.getNameKey();
                order = OrderByType.ASC;
                break;
            }
            case NAME_DESC: {
                field = fact.getNameKey();
                order = OrderByType.DESC;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        try {
            GetCategories getCategories = new GetCategories(startIndex, maxResults, field, categoryService, order);
            getCategories.execute();
            return ModelConvertor.toCategories((List<SCategory>)getCategories.getResult());
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public void addCategoriesToProcess(long processDefinitionId, List<Long> categoryIds) throws AlreadyExistsException, CreationException {
        try {
            CategoryService categoryService = this.getTenantAccessor().getCategoryService();
            ProcessDefinitionService processDefinitionService = this.getTenantAccessor().getProcessDefinitionService();
            for (Long categoryId : categoryIds) {
                new AddProcessDefinitionToCategory(categoryId, processDefinitionId, categoryService, processDefinitionService).execute();
            }
        }
        catch (SCategoryInProcessAlreadyExistsException scipaee) {
            throw new AlreadyExistsException((Throwable)scipaee);
        }
        catch (SBonitaException sbe) {
            throw new CreationException((Throwable)sbe);
        }
    }

    public void removeCategoriesFromProcess(long processDefinitionId, List<Long> categoryIds) throws DeletionException {
        try {
            CategoryService categoryService = this.getTenantAccessor().getCategoryService();
            RemoveCategoriesFromProcessDefinition transactionContent = new RemoveCategoriesFromProcessDefinition(processDefinitionId, categoryIds, categoryService);
            transactionContent.execute();
        }
        catch (SBonitaException sbe) {
            throw new DeletionException((Throwable)sbe);
        }
    }

    public void addProcessDefinitionToCategory(long categoryId, long processDefinitionId) throws AlreadyExistsException, CreationException {
        try {
            CategoryService categoryService = this.getTenantAccessor().getCategoryService();
            ProcessDefinitionService processDefinitionService = this.getTenantAccessor().getProcessDefinitionService();
            AddProcessDefinitionToCategory transactionContent = new AddProcessDefinitionToCategory(categoryId, processDefinitionId, categoryService, processDefinitionService);
            transactionContent.execute();
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw new CreationException((Throwable)e);
        }
        catch (SCategoryNotFoundException scnfe) {
            throw new CreationException((Throwable)scnfe);
        }
        catch (SCategoryInProcessAlreadyExistsException cipaee) {
            throw new AlreadyExistsException((Throwable)cipaee);
        }
        catch (SBonitaException sbe) {
            throw new CreationException((Throwable)sbe);
        }
    }

    public void addProcessDefinitionsToCategory(long categoryId, List<Long> processDefinitionIds) throws AlreadyExistsException, CreationException {
        try {
            CategoryService categoryService = this.getTenantAccessor().getCategoryService();
            ProcessDefinitionService processDefinitionService = this.getTenantAccessor().getProcessDefinitionService();
            for (Long processDefinitionId : processDefinitionIds) {
                new AddProcessDefinitionToCategory(categoryId, processDefinitionId, categoryService, processDefinitionService).execute();
            }
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw new CreationException((Throwable)e);
        }
        catch (SCategoryNotFoundException scnfe) {
            throw new CreationException((Throwable)scnfe);
        }
        catch (SCategoryInProcessAlreadyExistsException cipaee) {
            throw new AlreadyExistsException((Throwable)cipaee);
        }
        catch (SBonitaException sbe) {
            throw new CreationException((Throwable)sbe);
        }
    }

    public long getNumberOfCategories(long processDefinitionId) {
        try {
            TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
            CategoryService categoryService = tenantAccessor.getCategoryService();
            GetNumberOfCategoriesOfProcess getNumberOfCategoriesOfProcess = new GetNumberOfCategoriesOfProcess(categoryService, processDefinitionId);
            getNumberOfCategoriesOfProcess.execute();
            return getNumberOfCategoriesOfProcess.getResult();
        }
        catch (SBonitaException sbe) {
            throw new RetrieveException((Throwable)sbe);
        }
    }

    public long getNumberOfProcessDefinitionsOfCategory(long categoryId) {
        try {
            CategoryService categoryService = this.getTenantAccessor().getCategoryService();
            return categoryService.getNumberOfProcessDeploymentInfosOfCategory(categoryId);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public List<ProcessDeploymentInfo> getProcessDeploymentInfosOfCategory(long categoryId, int startIndex, int maxResults, ProcessDeploymentInfoCriterion sortCriterion) {
        if (sortCriterion == null) {
            throw new IllegalArgumentException("You must to have a criterion to sort your result.");
        }
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        OrderByType order = this.buildOrderByType(sortCriterion.getOrder());
        String field = sortCriterion.getField();
        try {
            QueryOptions queryOptions = new QueryOptions(startIndex, maxResults, SProcessDefinitionDeployInfo.class, field, order);
            List<SProcessDefinitionDeployInfo> sProcessDefinitionDeployInfos = processDefinitionService.searchProcessDeploymentInfosOfCategory(categoryId, queryOptions);
            return ModelConvertor.toProcessDeploymentInfo(sProcessDefinitionDeployInfos);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public List<Category> getCategoriesOfProcessDefinition(long processDefinitionId, int startIndex, int maxResults, CategoryCriterion sortingCriterion) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        CategoryService categoryService = tenantAccessor.getCategoryService();
        try {
            OrderByType order = this.buildOrderByType(sortingCriterion.getOrder());
            return ModelConvertor.toCategories(categoryService.getCategoriesOfProcessDefinition(processDefinitionId, startIndex, maxResults, order));
        }
        catch (SBonitaException sbe) {
            throw new RetrieveException((Throwable)sbe);
        }
    }

    private OrderByType buildOrderByType(Order order) {
        return OrderByType.valueOf(order.name());
    }

    public List<Category> getCategoriesUnrelatedToProcessDefinition(long processDefinitionId, int startIndex, int maxResults, CategoryCriterion sortingCriterion) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        CategoryService categoryService = tenantAccessor.getCategoryService();
        try {
            OrderByType order = this.buildOrderByType(sortingCriterion.getOrder());
            return ModelConvertor.toCategories(categoryService.getCategoriesUnrelatedToProcessDefinition(processDefinitionId, startIndex, maxResults, order));
        }
        catch (SBonitaException sbe) {
            throw new RetrieveException((Throwable)sbe);
        }
    }

    public void updateCategory(long categoryId, CategoryUpdater updater) throws CategoryNotFoundException, UpdateException {
        if (updater == null || updater.getFields().isEmpty()) {
            throw new UpdateException("The update descriptor does not contain field updates");
        }
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        CategoryService categoryService = tenantAccessor.getCategoryService();
        try {
            SCategoryUpdateBuilderFactory fact = BuilderFactory.get(SCategoryUpdateBuilderFactory.class);
            EntityUpdateDescriptor updateDescriptor = this.getCategoryUpdateDescriptor(fact.createNewInstance(), updater);
            UpdateCategory updateCategory = new UpdateCategory(categoryService, categoryId, updateDescriptor);
            updateCategory.execute();
        }
        catch (SCategoryNotFoundException scnfe) {
            throw new CategoryNotFoundException((Throwable)scnfe);
        }
        catch (SBonitaException sbe) {
            throw new UpdateException((Throwable)sbe);
        }
    }

    private EntityUpdateDescriptor getCategoryUpdateDescriptor(SCategoryUpdateBuilder descriptorBuilder, CategoryUpdater updater) {
        String description;
        Map fields = updater.getFields();
        String name = (String)fields.get(CategoryUpdater.CategoryField.NAME);
        if (name != null) {
            descriptorBuilder.updateName(name);
        }
        if ((description = (String)fields.get(CategoryUpdater.CategoryField.DESCRIPTION)) != null) {
            descriptorBuilder.updateDescription(description);
        }
        return descriptorBuilder.done();
    }

    public void deleteCategory(long categoryId) throws DeletionException {
        if (categoryId <= 0L) {
            throw new DeletionException("Category id can not be less than 0!");
        }
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        CategoryService categoryService = tenantAccessor.getCategoryService();
        DeleteSCategory deleteSCategory = new DeleteSCategory(categoryService, categoryId);
        try {
            deleteSCategory.execute();
        }
        catch (SBonitaException sbe) {
            throw new DeletionException((Throwable)sbe);
        }
    }

    public long getNumberOfUncategorizedProcessDefinitions() {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        CategoryService categoryService = tenantAccessor.getCategoryService();
        try {
            List<Long> processDefinitionIds = processDefinitionService.getProcessDefinitionIds(0, Integer.MAX_VALUE);
            long number = processDefinitionIds.isEmpty() ? 0L : (long)processDefinitionIds.size() - categoryService.getNumberOfCategorizedProcessIds(processDefinitionIds);
            return number;
        }
        catch (SBonitaException e) {
            throw new BonitaRuntimeException((Throwable)e);
        }
    }

    public List<ProcessDeploymentInfo> getUncategorizedProcessDeploymentInfos(int startIndex, int maxResults, ProcessDeploymentInfoCriterion sortCriterion) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        try {
            QueryOptions queryOptions = new QueryOptions(startIndex, maxResults, SProcessDefinitionDeployInfo.class, sortCriterion.getField(), this.buildOrderByType(sortCriterion.getOrder()));
            List<SProcessDefinitionDeployInfo> processDefinitionDeployInfos = processDefinitionService.searchUncategorizedProcessDeploymentInfos(queryOptions);
            return ModelConvertor.toProcessDeploymentInfo(processDefinitionDeployInfos);
        }
        catch (SBonitaException sbe) {
            throw new RetrieveException((Throwable)sbe);
        }
    }

    public long getNumberOfProcessDeploymentInfosUnrelatedToCategory(long categoryId) {
        try {
            TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
            ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
            GetNumberOfProcessDeploymentInfosUnrelatedToCategory transactionContentWithResult = new GetNumberOfProcessDeploymentInfosUnrelatedToCategory(categoryId, processDefinitionService);
            transactionContentWithResult.execute();
            return transactionContentWithResult.getResult();
        }
        catch (SBonitaException sbe) {
            throw new RetrieveException((Throwable)sbe);
        }
    }

    public List<ProcessDeploymentInfo> getProcessDeploymentInfosUnrelatedToCategory(long categoryId, int startIndex, int maxResults, ProcessDeploymentInfoCriterion sortingCriterion) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        try {
            return ModelConvertor.toProcessDeploymentInfo(processDefinitionService.getProcessDeploymentInfosUnrelatedToCategory(categoryId, startIndex, maxResults, sortingCriterion));
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    @Deprecated
    public void removeAllCategoriesFromProcessDefinition(long processDefinitionId) throws DeletionException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        CategoryService categoryService = tenantAccessor.getCategoryService();
        RemoveProcessDefinitionsOfCategory transactionContent = new RemoveProcessDefinitionsOfCategory(processDefinitionId, categoryService);
        try {
            transactionContent.execute();
        }
        catch (SBonitaException sbe) {
            throw new DeletionException((Throwable)sbe);
        }
    }

    @Deprecated
    public void removeAllProcessDefinitionsFromCategory(long categoryId) throws DeletionException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        CategoryService categoryService = tenantAccessor.getCategoryService();
        RemoveProcessDefinitionsOfCategory remove = new RemoveProcessDefinitionsOfCategory(categoryService, categoryId);
        try {
            remove.execute();
        }
        catch (SBonitaException sbe) {
            throw new DeletionException((Throwable)sbe);
        }
    }

    public long removeCategoriesFromProcessDefinition(long processDefinitionId, int startIndex, int maxResults) throws DeletionException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        CategoryService categoryService = tenantAccessor.getCategoryService();
        SProcessCategoryMappingBuilderFactory fact = BuilderFactory.get(SProcessCategoryMappingBuilderFactory.class);
        try {
            FilterOption filterOption = new FilterOption(SProcessCategoryMapping.class, fact.getProcessIdKey(), processDefinitionId);
            OrderByOption order = new OrderByOption(SProcessCategoryMapping.class, fact.getIdKey(), OrderByType.ASC);
            QueryOptions queryOptions = new QueryOptions(startIndex, maxResults, Collections.singletonList(order), Collections.singletonList(filterOption), null);
            List<SProcessCategoryMapping> processCategoryMappings = categoryService.searchProcessCategoryMappings(queryOptions);
            return categoryService.deleteProcessCategoryMappings(processCategoryMappings);
        }
        catch (SBonitaException e) {
            throw new DeletionException((Throwable)e);
        }
    }

    public long removeProcessDefinitionsFromCategory(long categoryId, int startIndex, int maxResults) throws DeletionException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        CategoryService categoryService = tenantAccessor.getCategoryService();
        SProcessCategoryMappingBuilderFactory fact = BuilderFactory.get(SProcessCategoryMappingBuilderFactory.class);
        try {
            FilterOption filterOption = new FilterOption(SProcessCategoryMapping.class, fact.getCategoryIdKey(), categoryId);
            OrderByOption order = new OrderByOption(SProcessCategoryMapping.class, fact.getIdKey(), OrderByType.ASC);
            QueryOptions queryOptions = new QueryOptions(startIndex, maxResults, Collections.singletonList(order), Collections.singletonList(filterOption), null);
            List<SProcessCategoryMapping> processCategoryMappings = categoryService.searchProcessCategoryMappings(queryOptions);
            return categoryService.deleteProcessCategoryMappings(processCategoryMappings);
        }
        catch (SBonitaException e) {
            throw new DeletionException((Throwable)e);
        }
    }

    public List<EventInstance> getEventInstances(long rootContainerId, int startIndex, int maxResults, EventCriterion criterion) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        EventInstanceService eventInstanceService = tenantAccessor.getEventInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        OrderAndField orderAndField = OrderAndFields.getOrderAndFieldForEvent(criterion);
        GetEventInstances getEventInstances = new GetEventInstances(eventInstanceService, rootContainerId, startIndex, maxResults, orderAndField.getField(), orderAndField.getOrder());
        try {
            getEventInstances.execute();
            Object result = getEventInstances.getResult();
            return ModelConvertor.toEventInstances((Collection<SEventInstance>)result, flowNodeStateManager);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public void assignUserTask(long userTaskId, long userId) throws UpdateException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        SCommentService scommentService = tenantAccessor.getCommentService();
        IdentityService identityService = tenantAccessor.getIdentityService();
        try {
            AssignOrUnassignUserTask assignUserTask = new AssignOrUnassignUserTask(userId, userTaskId, activityInstanceService, scommentService, identityService);
            assignUserTask.execute();
        }
        catch (SUserNotFoundException sunfe) {
            throw new UpdateException((Throwable)sunfe);
        }
        catch (SActivityInstanceNotFoundException sainfe) {
            throw new UpdateException((Throwable)sainfe);
        }
        catch (SBonitaException sbe) {
            throw new UpdateException((Throwable)sbe);
        }
    }

    public void updateActorsOfUserTask(long userTaskId) throws UpdateException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        try {
            TechnicalLoggerService technicalLoggerService;
            SUserFilterDefinition sUserFilterDefinition;
            SHumanTaskInstance humanTaskInstance = this.getSHumanTaskInstance(userTaskId);
            long processDefinitionId = humanTaskInstance.getLogicalGroup(0);
            SProcessDefinition processDefinition = tenantAccessor.getProcessDefinitionService().getProcessDefinition(processDefinitionId);
            SHumanTaskDefinition humanTaskDefinition = (SHumanTaskDefinition)processDefinition.getProcessContainer().getFlowNode(humanTaskInstance.getFlowNodeDefinitionId());
            long humanTaskInstanceId = humanTaskInstance.getId();
            if (humanTaskDefinition != null && (sUserFilterDefinition = humanTaskDefinition.getSUserFilterDefinition()) != null) {
                this.cleanPendingMappingsAndUnassignHumanTask(userTaskId, humanTaskInstance);
                FilterResult result = this.executeFilter(processDefinitionId, humanTaskInstanceId, humanTaskDefinition.getActorName(), sUserFilterDefinition);
                List<Long> userIds = result.getResult();
                if (userIds == null || userIds.isEmpty() || userIds.contains(0L) || userIds.contains(-1L)) {
                    throw new UpdateException("no user id returned by the user filter " + sUserFilterDefinition + " on activity " + humanTaskDefinition.getName());
                }
                this.createPendingMappingsAndAssignHumanTask(humanTaskInstanceId, result);
            }
            if ((technicalLoggerService = tenantAccessor.getTechnicalLoggerService()).isLoggable(ProcessAPIImpl.class, TechnicalLogSeverity.INFO)) {
                StringBuilder builder = new StringBuilder("User '");
                builder.append(SessionInfos.getUserNameFromSession()).append("' has re-executed assignation on activity ").append(humanTaskInstanceId);
                builder.append(" of process instance ").append(humanTaskInstance.getLogicalGroup(1)).append(" of process named '").append(processDefinition.getName()).append("' in version ").append(processDefinition.getVersion());
                technicalLoggerService.log(ProcessAPIImpl.class, TechnicalLogSeverity.INFO, builder.toString());
            }
        }
        catch (SBonitaException sbe) {
            throw new UpdateException((Throwable)sbe);
        }
    }

    private void createPendingMappingsAndAssignHumanTask(long humanTaskInstanceId, FilterResult result) throws SBonitaException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        List<Long> userIds = result.getResult();
        for (Long userId : userIds) {
            this.createPendingMappingForUser(humanTaskInstanceId, userId);
        }
        if (userIds.size() == 1 && result.shouldAutoAssignTaskIfSingleResult()) {
            tenantAccessor.getActivityInstanceService().assignHumanTask(humanTaskInstanceId, userIds.get(0));
        }
    }

    private FilterResult executeFilter(long processDefinitionId, long humanTaskInstanceId, String actorName, SUserFilterDefinition sUserFilterDefinition) throws SUserFilterExecutionException, SClassLoaderException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ClassLoaderService classLoaderService = tenantAccessor.getClassLoaderService();
        UserFilterService userFilterService = tenantAccessor.getUserFilterService();
        ClassLoader processClassloader = classLoaderService.getLocalClassLoader(ScopeType.PROCESS.name(), processDefinitionId);
        SExpressionContext expressionContext = new SExpressionContext((Long)humanTaskInstanceId, DataInstanceContainer.ACTIVITY_INSTANCE.name(), processDefinitionId);
        return userFilterService.executeFilter(processDefinitionId, sUserFilterDefinition, sUserFilterDefinition.getInputs(), processClassloader, expressionContext, actorName);
    }

    private void cleanPendingMappingsAndUnassignHumanTask(long userTaskId, SHumanTaskInstance humanTaskInstance) throws SFlowNodeNotFoundException, SFlowNodeReadException, SActivityModificationException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        if (humanTaskInstance.getAssigneeId() > 0L) {
            activityInstanceService.assignHumanTask(userTaskId, 0L);
        }
        activityInstanceService.deletePendingMappings(humanTaskInstance.getId());
    }

    private SHumanTaskInstance getSHumanTaskInstance(long userTaskId) throws SFlowNodeNotFoundException, SFlowNodeReadException, UpdateException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        SFlowNodeInstance flowNodeInstance = tenantAccessor.getActivityInstanceService().getFlowNodeInstance(userTaskId);
        if (!(flowNodeInstance instanceof SHumanTaskInstance)) {
            throw new UpdateException("The identifier does not refer to a human task");
        }
        return (SHumanTaskInstance)flowNodeInstance;
    }

    private void createPendingMappingForUser(long humanTaskInstanceId, Long userId) throws SBonitaException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        SPendingActivityMappingBuilderFactory sPendingActivityMappingBuilderFactory = BuilderFactory.get(SPendingActivityMappingBuilderFactory.class);
        SPendingActivityMapping mapping = sPendingActivityMappingBuilderFactory.createNewInstanceForUser(humanTaskInstanceId, userId).done();
        activityInstanceService.addPendingActivityMappings(mapping);
    }

    public List<DataDefinition> getActivityDataDefinitions(long processDefinitionId, String activityName, int startIndex, int maxResults) throws ActivityDefinitionNotFoundException, ProcessDefinitionNotFoundException {
        List<DataDefinition> subDataDefinitionList = Collections.emptyList();
        List<SDataDefinition> sdataDefinitionList = Collections.emptyList();
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        GetProcessDefinition getProcessDefinition = new GetProcessDefinition(processDefinitionId, processDefinitionService);
        try {
            getProcessDefinition.execute();
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
        SProcessDefinition sProcessDefinition = getProcessDefinition.getResult();
        if (sProcessDefinition != null) {
            boolean activityFound = false;
            SFlowElementContainerDefinition processContainer = sProcessDefinition.getProcessContainer();
            Set<SActivityDefinition> activityDefList = processContainer.getActivities();
            for (SActivityDefinition sActivityDefinition : activityDefList) {
                if (!activityName.equals(sActivityDefinition.getName())) continue;
                sdataDefinitionList = sActivityDefinition.getSDataDefinitions();
                activityFound = true;
                break;
            }
            if (!activityFound) {
                throw new ActivityDefinitionNotFoundException(activityName);
            }
            List<DataDefinition> dataDefinitionList = ModelConvertor.toDataDefinitions(sdataDefinitionList);
            if (startIndex >= dataDefinitionList.size()) {
                return Collections.emptyList();
            }
            int toIndex = Math.min(dataDefinitionList.size(), startIndex + maxResults);
            subDataDefinitionList = new ArrayList<DataDefinition>(dataDefinitionList.subList(startIndex, toIndex));
        }
        return subDataDefinitionList;
    }

    public List<DataDefinition> getProcessDataDefinitions(long processDefinitionId, int startIndex, int maxResults) throws ProcessDefinitionNotFoundException {
        List<DataDefinition> subDataDefinitionList = Collections.emptyList();
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        GetProcessDefinition getProcessDefinition = new GetProcessDefinition(processDefinitionId, processDefinitionService);
        try {
            getProcessDefinition.execute();
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
        SProcessDefinition sProcessDefinition = getProcessDefinition.getResult();
        if (sProcessDefinition != null) {
            SFlowElementContainerDefinition processContainer = sProcessDefinition.getProcessContainer();
            List<SDataDefinition> sdataDefinitionList = processContainer.getDataDefinitions();
            List<DataDefinition> dataDefinitionList = ModelConvertor.toDataDefinitions(sdataDefinitionList);
            if (startIndex >= dataDefinitionList.size()) {
                return Collections.emptyList();
            }
            int toIndex = Math.min(dataDefinitionList.size(), startIndex + maxResults);
            subDataDefinitionList = new ArrayList<DataDefinition>(dataDefinitionList.subList(startIndex, toIndex));
        }
        return subDataDefinitionList;
    }

    public HumanTaskInstance getHumanTaskInstance(long activityInstanceId) throws ActivityInstanceNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        GetHumanTaskInstance getHumanTaskInstance = new GetHumanTaskInstance(activityInstanceService, activityInstanceId);
        try {
            getHumanTaskInstance.execute();
        }
        catch (SActivityInstanceNotFoundException e) {
            throw new ActivityInstanceNotFoundException(activityInstanceId, (Exception)e);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
        return ModelConvertor.toHumanTaskInstance(getHumanTaskInstance.getResult(), flowNodeStateManager);
    }

    public long getNumberOfAssignedHumanTaskInstances(long userId) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        try {
            GetNumberOfAssignedUserTaskInstances transactionContent = new GetNumberOfAssignedUserTaskInstances(userId, activityInstanceService);
            transactionContent.execute();
            return (Long)transactionContent.getResult();
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public Map<Long, Long> getNumberOfOpenTasks(List<Long> userIds) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        try {
            GetNumberOfOpenTasksForUsers transactionContent = new GetNumberOfOpenTasksForUsers(userIds, activityInstanceService);
            transactionContent.execute();
            return transactionContent.getResult();
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public long getNumberOfPendingHumanTaskInstances(long userId) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        ProcessDefinitionService processDefService = tenantAccessor.getProcessDefinitionService();
        try {
            Set<Long> actorIds = this.getActorsForUser(userId, actorMappingService, processDefService);
            if (actorIds.isEmpty()) {
                return 0L;
            }
            return activityInstanceService.getNumberOfPendingTasksForUser(userId, QueryOptions.countQueryOptions());
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public Map<String, byte[]> getProcessResources(long processDefinitionId, String filenamesPattern) throws RetrieveException {
        String processesFolder;
        try {
            TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
            processesFolder = BonitaHomeServer.getInstance().getProcessesFolder(tenantAccessor.getTenantId());
        }
        catch (BonitaHomeNotSetException e) {
            throw new RetrieveException("Problem accessing basic Bonita Home server resources", (Throwable)e);
        }
        processesFolder = processesFolder.replaceAll("\\\\", "/");
        if (!processesFolder.endsWith("/")) {
            processesFolder = processesFolder + "/";
        }
        processesFolder = processesFolder + processDefinitionId + "/";
        Collection files = FileUtils.listFiles((File)new File(processesFolder), (IOFileFilter)new DeepRegexFileFilter(processesFolder + filenamesPattern), (IOFileFilter)DirectoryFileFilter.DIRECTORY);
        HashMap<String, byte[]> res = new HashMap<String, byte[]>(files.size());
        try {
            for (File f : files) {
                res.put(f.getAbsolutePath().replaceAll("\\\\", "/").replaceFirst(processesFolder, ""), IOUtil.getAllContentFrom((File)f));
            }
        }
        catch (IOException e) {
            throw new RetrieveException("Problem accessing resources " + filenamesPattern + " for processDefinitionId: " + processDefinitionId, (Throwable)e);
        }
        return res;
    }

    public long getLatestProcessDefinitionId(String processName) throws ProcessDefinitionNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        GetLatestProcessDefinitionId transactionContent = new GetLatestProcessDefinitionId(processDefinitionService, processName);
        try {
            transactionContent.execute();
        }
        catch (SBonitaException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        return (Long)transactionContent.getResult();
    }

    public List<DataInstance> getProcessDataInstances(long processInstanceId, int startIndex, int maxResults) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        DataInstanceService dataInstanceService = tenantAccessor.getDataInstanceService();
        ClassLoaderService classLoaderService = tenantAccessor.getClassLoaderService();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            long processDefinitionId = processInstanceService.getProcessInstance(processInstanceId).getProcessDefinitionId();
            ClassLoader processClassLoader = classLoaderService.getLocalClassLoader(ScopeType.PROCESS.name(), processDefinitionId);
            Thread.currentThread().setContextClassLoader(processClassLoader);
            List<SDataInstance> dataInstances = dataInstanceService.getDataInstances(processInstanceId, DataInstanceContainer.PROCESS_INSTANCE.name(), startIndex, maxResults);
            List<DataInstance> list = this.convertModelToDataInstances(dataInstances);
            return list;
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public DataInstance getProcessDataInstance(String dataName, long processInstanceId) throws DataNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        DataInstanceService dataInstanceService = tenantAccessor.getDataInstanceService();
        ClassLoaderService classLoaderService = tenantAccessor.getClassLoaderService();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            long processDefinitionId = processInstanceService.getProcessInstance(processInstanceId).getProcessDefinitionId();
            ClassLoader processClassLoader = classLoaderService.getLocalClassLoader(ScopeType.PROCESS.name(), processDefinitionId);
            Thread.currentThread().setContextClassLoader(processClassLoader);
            SDataInstance sDataInstance = dataInstanceService.getDataInstance(dataName, processInstanceId, DataInstanceContainer.PROCESS_INSTANCE.toString());
            DataInstance dataInstance = this.convertModeltoDataInstance(sDataInstance);
            return dataInstance;
        }
        catch (SBonitaException e) {
            throw new DataNotFoundException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public void updateProcessDataInstance(String dataName, long processInstanceId, Serializable dataValue) throws UpdateException {
        this.updateProcessDataInstances(processInstanceId, Collections.singletonMap(dataName, dataValue));
    }

    public void updateProcessDataInstances(long processInstanceId, Map<String, Serializable> dataNameValues) throws UpdateException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        DataInstanceService dataInstanceService = tenantAccessor.getDataInstanceService();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader processClassLoader = this.getProcessInstanceClassloader(tenantAccessor, processInstanceId);
            Thread.currentThread().setContextClassLoader(processClassLoader);
            List<SDataInstance> sDataInstances = dataInstanceService.getDataInstances(new ArrayList<String>(dataNameValues.keySet()), processInstanceId, DataInstanceContainer.PROCESS_INSTANCE.toString());
            for (SDataInstance sDataInstance : sDataInstances) {
                EntityUpdateDescriptor entityUpdateDescriptor = new EntityUpdateDescriptor();
                entityUpdateDescriptor.addField("value", dataNameValues.get(sDataInstance.getName()));
                dataInstanceService.updateDataInstance(sDataInstance, entityUpdateDescriptor);
            }
        }
        catch (SBonitaException e) {
            throw new UpdateException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    protected ClassLoader getProcessInstanceClassloader(TenantServiceAccessor tenantAccessor, long processInstanceId) throws SProcessInstanceNotFoundException, SProcessInstanceReadException, SClassLoaderException {
        ClassLoaderService classLoaderService = tenantAccessor.getClassLoaderService();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        long processDefinitionId = processInstanceService.getProcessInstance(processInstanceId).getProcessDefinitionId();
        return classLoaderService.getLocalClassLoader(ScopeType.PROCESS.name(), processDefinitionId);
    }

    public List<DataInstance> getActivityDataInstances(long activityInstanceId, int startIndex, int maxResults) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        DataInstanceService dataInstanceService = tenantAccessor.getDataInstanceService();
        ClassLoaderService classLoaderService = tenantAccessor.getClassLoaderService();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        int processDefinitionIndex = BuilderFactory.get(SAutomaticTaskInstanceBuilderFactory.class).getProcessDefinitionIndex();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            long parentProcessInstanceId = activityInstanceService.getFlowNodeInstance(activityInstanceId).getLogicalGroup(processDefinitionIndex);
            ClassLoader processClassLoader = classLoaderService.getLocalClassLoader(ScopeType.PROCESS.name(), parentProcessInstanceId);
            Thread.currentThread().setContextClassLoader(processClassLoader);
            List<SDataInstance> dataInstances = dataInstanceService.getDataInstances(activityInstanceId, DataInstanceContainer.ACTIVITY_INSTANCE.name(), startIndex, maxResults);
            List<DataInstance> list = this.convertModelToDataInstances(dataInstances);
            return list;
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public DataInstance getActivityDataInstance(String dataName, long activityInstanceId) throws DataNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        DataInstanceService dataInstanceService = tenantAccessor.getDataInstanceService();
        ClassLoaderService classLoaderService = tenantAccessor.getClassLoaderService();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        int processDefinitionIndex = BuilderFactory.get(SAutomaticTaskInstanceBuilderFactory.class).getProcessDefinitionIndex();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            SFlowNodeInstance flowNodeInstance = activityInstanceService.getFlowNodeInstance(activityInstanceId);
            long parentProcessInstanceId = flowNodeInstance.getLogicalGroup(processDefinitionIndex);
            ClassLoader processClassLoader = classLoaderService.getLocalClassLoader(ScopeType.PROCESS.name(), parentProcessInstanceId);
            Thread.currentThread().setContextClassLoader(processClassLoader);
            SDataInstance data = dataInstanceService.getDataInstance(dataName, activityInstanceId, DataInstanceContainer.ACTIVITY_INSTANCE.toString());
            DataInstance dataInstance = this.convertModeltoDataInstance(data);
            return dataInstance;
        }
        catch (SBonitaException e) {
            throw new DataNotFoundException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public void updateActivityDataInstance(String dataName, long activityInstanceId, Serializable dataValue) throws UpdateException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        DataInstanceService dataInstanceService = tenantAccessor.getDataInstanceService();
        ClassLoaderService classLoaderService = tenantAccessor.getClassLoaderService();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        int processDefinitionIndex = BuilderFactory.get(SAutomaticTaskInstanceBuilderFactory.class).getProcessDefinitionIndex();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            SFlowNodeInstance flowNodeInstance = activityInstanceService.getFlowNodeInstance(activityInstanceId);
            long parentProcessInstanceId = flowNodeInstance.getLogicalGroup(processDefinitionIndex);
            ClassLoader processClassLoader = classLoaderService.getLocalClassLoader(ScopeType.PROCESS.name(), parentProcessInstanceId);
            Thread.currentThread().setContextClassLoader(processClassLoader);
            this.updateData(dataName, activityInstanceId, dataValue, dataInstanceService);
        }
        catch (SBonitaException e) {
            throw new UpdateException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private void updateData(String dataName, long activityInstanceId, Serializable dataValue, DataInstanceService dataInstanceService) throws SDataInstanceException {
        SDataInstance sDataInstance = dataInstanceService.getDataInstance(dataName, activityInstanceId, DataInstanceContainer.ACTIVITY_INSTANCE.toString());
        EntityUpdateDescriptor entityUpdateDescriptor = new EntityUpdateDescriptor();
        entityUpdateDescriptor.addField("value", dataValue);
        dataInstanceService.updateDataInstance(sDataInstance, entityUpdateDescriptor);
    }

    public DataInstance getActivityTransientDataInstance(String dataName, long activityInstanceId) throws DataNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        TransientDataService transientDataService = tenantAccessor.getTransientDataService();
        ClassLoaderService classLoaderService = tenantAccessor.getClassLoaderService();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        int processDefinitionIndex = BuilderFactory.get(SAutomaticTaskInstanceBuilderFactory.class).getProcessDefinitionIndex();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            SFlowNodeInstance flowNodeInstance = activityInstanceService.getFlowNodeInstance(activityInstanceId);
            long parentProcessInstanceId = flowNodeInstance.getLogicalGroup(processDefinitionIndex);
            ClassLoader processClassLoader = classLoaderService.getLocalClassLoader(ScopeType.PROCESS.name(), parentProcessInstanceId);
            Thread.currentThread().setContextClassLoader(processClassLoader);
            SDataInstance data = transientDataService.getDataInstance(dataName, activityInstanceId, DataInstanceContainer.ACTIVITY_INSTANCE.toString());
            DataInstance dataInstance = this.convertModeltoDataInstance(data);
            return dataInstance;
        }
        catch (SBonitaException e) {
            throw new DataNotFoundException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    protected DataInstance convertModeltoDataInstance(SDataInstance data) {
        return ModelConvertor.toDataInstance(data);
    }

    public List<DataInstance> getActivityTransientDataInstances(long activityInstanceId, int startIndex, int maxResults) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        TransientDataService transientDataService = tenantAccessor.getTransientDataService();
        ClassLoaderService classLoaderService = tenantAccessor.getClassLoaderService();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        int processDefinitionIndex = BuilderFactory.get(SAutomaticTaskInstanceBuilderFactory.class).getProcessDefinitionIndex();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            long parentProcessInstanceId = activityInstanceService.getFlowNodeInstance(activityInstanceId).getLogicalGroup(processDefinitionIndex);
            ClassLoader processClassLoader = classLoaderService.getLocalClassLoader(ScopeType.PROCESS.name(), parentProcessInstanceId);
            Thread.currentThread().setContextClassLoader(processClassLoader);
            List<SDataInstance> dataInstances = transientDataService.getDataInstances(activityInstanceId, DataInstanceContainer.ACTIVITY_INSTANCE.name(), startIndex, maxResults);
            List<DataInstance> list = this.convertModelToDataInstances(dataInstances);
            return list;
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    protected List<DataInstance> convertModelToDataInstances(List<SDataInstance> dataInstances) {
        return ModelConvertor.toDataInstances(dataInstances);
    }

    public void updateActivityTransientDataInstance(String dataName, long activityInstanceId, Serializable dataValue) throws UpdateException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        TransientDataService transientDataService = tenantAccessor.getTransientDataService();
        ClassLoaderService classLoaderService = tenantAccessor.getClassLoaderService();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        int processDefinitionIndex = BuilderFactory.get(SAutomaticTaskInstanceBuilderFactory.class).getProcessDefinitionIndex();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            SFlowNodeInstance flowNodeInstance = activityInstanceService.getFlowNodeInstance(activityInstanceId);
            long parentProcessInstanceId = flowNodeInstance.getLogicalGroup(processDefinitionIndex);
            ClassLoader processClassLoader = classLoaderService.getLocalClassLoader(ScopeType.PROCESS.name(), parentProcessInstanceId);
            Thread.currentThread().setContextClassLoader(processClassLoader);
            this.updateTransientData(dataName, activityInstanceId, dataValue, transientDataService);
        }
        catch (SBonitaException e) {
            throw new UpdateException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    protected void updateTransientData(String dataName, long activityInstanceId, Serializable dataValue, TransientDataService transientDataInstanceService) throws SDataInstanceException {
        SDataInstance sDataInstance = transientDataInstanceService.getDataInstance(dataName, activityInstanceId, DataInstanceContainer.ACTIVITY_INSTANCE.toString());
        EntityUpdateDescriptor entityUpdateDescriptor = new EntityUpdateDescriptor();
        entityUpdateDescriptor.addField("value", dataValue);
        transientDataInstanceService.updateDataInstance(sDataInstance, entityUpdateDescriptor);
    }

    public void importActorMapping(long processDefinitionId, String xmlContent) throws ActorMappingImportException {
        if (xmlContent != null) {
            TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
            ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
            IdentityService identityService = tenantAccessor.getIdentityService();
            Parser parser = tenantAccessor.getActorMappingParser();
            try {
                new ImportActorMapping(actorMappingService, identityService, parser, processDefinitionId, xmlContent).execute();
                tenantAccessor.getDependencyResolver().resolveDependencies(processDefinitionId, tenantAccessor);
            }
            catch (SBonitaException sbe) {
                throw new ActorMappingImportException((Throwable)sbe);
            }
        }
    }

    public String exportActorMapping(long processDefinitionId) throws ActorMappingExportException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        IdentityService identityService = tenantAccessor.getIdentityService();
        XMLWriter writer = tenantAccessor.getXMLWriter();
        try {
            ExportActorMapping exportActorMapping = new ExportActorMapping(actorMappingService, identityService, writer, processDefinitionId);
            exportActorMapping.execute();
            return exportActorMapping.getResult();
        }
        catch (SBonitaException sbe) {
            throw new ActorMappingExportException((Throwable)sbe);
        }
    }

    public boolean isInvolvedInProcessInstance(long userId, long processInstanceId) throws ProcessInstanceNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        try {
            List<OrderByOption> orderByOptions = Arrays.asList(new OrderByOption(SHumanTaskInstance.class, "id", OrderByType.ASC));
            List<FilterOption> filterOptions = Arrays.asList(new FilterOption(SHumanTaskInstance.class, "logicalGroup4", processInstanceId));
            QueryOptions queryOptions = new QueryOptions(0, 100, orderByOptions, filterOptions, null);
            List<SHumanTaskInstance> sHumanTaskInstances = activityInstanceService.searchHumanTasks(queryOptions);
            while (!sHumanTaskInstances.isEmpty()) {
                for (SHumanTaskInstance sHumanTaskInstance : sHumanTaskInstances) {
                    if (userId == sHumanTaskInstance.getAssigneeId()) {
                        return true;
                    }
                    boolean isActorMemberOrManagerOfActorMember = this.checkIfUserIsActorMemberOrManagerOfActorMember(userId, sHumanTaskInstance.getActorId());
                    if (!isActorMemberOrManagerOfActorMember) continue;
                    return true;
                }
                queryOptions = QueryOptions.getNextPage(queryOptions);
                sHumanTaskInstances = activityInstanceService.searchHumanTasks(queryOptions);
            }
            this.checkIfProcessInstanceExistsWhenNoHumanTask(processInstanceId);
            return false;
        }
        catch (SBonitaException e) {
            throw new BonitaRuntimeException((Throwable)e);
        }
    }

    private void checkIfProcessInstanceExistsWhenNoHumanTask(long processInstanceId) throws SBonitaSearchException, SProcessInstanceReadException, ProcessInstanceNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        List<FilterOption> filterOptions = Arrays.asList(new FilterOption(SHumanTaskInstance.class, "logicalGroup4", processInstanceId));
        QueryOptions queryOptions = new QueryOptions(filterOptions, null);
        if (activityInstanceService.getNumberOfHumanTasks(queryOptions) == 0L) {
            try {
                tenantAccessor.getProcessInstanceService().getProcessInstance(processInstanceId);
            }
            catch (SProcessInstanceNotFoundException e) {
                throw new ProcessInstanceNotFoundException(processInstanceId);
            }
        }
    }

    private boolean checkIfUserIsActorMemberOrManagerOfActorMember(long userId, long actorId) throws SBonitaReadException, SUserNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        return actorMappingService.isUserInActorMemberOrManagerOfAUserInActorMember(userId, actorId);
    }

    public long getProcessInstanceIdFromActivityInstanceId(long activityInstanceId) throws ProcessInstanceNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        try {
            SActivityInstance sActivityInstance = this.getSActivityInstance(activityInstanceId);
            return sActivityInstance.getRootContainerId();
        }
        catch (SBonitaException e) {
            this.log(tenantAccessor, e);
            throw new ProcessInstanceNotFoundException(e.getMessage());
        }
    }

    public long getProcessDefinitionIdFromActivityInstanceId(long activityInstanceId) throws ProcessDefinitionNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        try {
            SActivityInstance sActivityInstance = this.getSActivityInstance(activityInstanceId);
            return processInstanceService.getProcessInstance(sActivityInstance.getParentProcessInstanceId()).getProcessDefinitionId();
        }
        catch (SBonitaException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
    }

    public long getProcessDefinitionIdFromProcessInstanceId(long processInstanceId) throws ProcessDefinitionNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        try {
            SProcessInstance sProcessInstance = this.getSProcessInstance(processInstanceId);
            ProcessInstance processInstance = ModelConvertor.toProcessInstances(Collections.singletonList(sProcessInstance), processDefinitionService).get(0);
            return processInstance.getProcessDefinitionId();
        }
        catch (SBonitaException e) {
            this.log(tenantAccessor, e);
            throw new ProcessDefinitionNotFoundException(e.getMessage());
        }
    }

    public Date getActivityReachedStateDate(long activityInstanceId, String stateName) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        int stateId = ModelConvertor.getServerActivityStateId(stateName);
        GetArchivedActivityInstance getArchivedActivityInstance = new GetArchivedActivityInstance(activityInstanceId, stateId, activityInstanceService);
        try {
            getArchivedActivityInstance.execute();
            long reachedDate = getArchivedActivityInstance.getResult().getReachedStateDate();
            return new Date(reachedDate);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public Set<String> getSupportedStates(FlowNodeType nodeType) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        return flowNodeStateManager.getSupportedState(nodeType);
    }

    public void updateActivityInstanceVariables(long activityInstanceId, Map<String, Serializable> variables) throws UpdateException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        DataInstanceService dataInstanceService = tenantAccessor.getDataInstanceService();
        ClassLoaderService classLoaderService = tenantAccessor.getClassLoaderService();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        int processDefinitionIndex = BuilderFactory.get(SAutomaticTaskInstanceBuilderFactory.class).getProcessDefinitionIndex();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            long parentProcessInstanceId = activityInstanceService.getFlowNodeInstance(activityInstanceId).getLogicalGroup(processDefinitionIndex);
            ClassLoader processClassLoader = classLoaderService.getLocalClassLoader(ScopeType.PROCESS.name(), parentProcessInstanceId);
            Thread.currentThread().setContextClassLoader(processClassLoader);
            for (Map.Entry<String, Serializable> variable : variables.entrySet()) {
                SDataInstance sDataInstance = dataInstanceService.getDataInstance(variable.getKey(), activityInstanceId, DataInstanceContainer.ACTIVITY_INSTANCE.toString());
                EntityUpdateDescriptor entityUpdateDescriptor = new EntityUpdateDescriptor();
                entityUpdateDescriptor.addField("value", variable.getValue());
                dataInstanceService.updateDataInstance(sDataInstance, entityUpdateDescriptor);
            }
        }
        catch (SBonitaException e) {
            throw new UpdateException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public void updateActivityInstanceVariables(List<Operation> operations, long activityInstanceId, Map<String, Serializable> expressionContexts) throws UpdateException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        OperationService operationService = tenantAccessor.getOperationService();
        DataInstanceService dataInstanceService = tenantAccessor.getDataInstanceService();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        int processDefinitionIndex = BuilderFactory.get(SAutomaticTaskInstanceBuilderFactory.class).getProcessDefinitionIndex();
        ArrayList<String> dataNames = new ArrayList<String>(operations.size());
        for (Operation operation : operations) {
            dataNames.add(operation.getLeftOperand().getName());
        }
        try {
            SActivityInstance activityInstance = activityInstanceService.getActivityInstance(activityInstanceId);
            SProcessDefinition processDefinition = processDefinitionService.getProcessDefinition(activityInstance.getProcessDefinitionId());
            SActivityDefinition activityDefinition = (SActivityDefinition)processDefinition.getProcessContainer().getFlowNode(activityInstance.getFlowNodeDefinitionId());
            List<SDataDefinition> sDataDefinitions = activityDefinition.getSDataDefinitions();
            ArrayList<String> transientDataNames = new ArrayList<String>();
            for (SDataDefinition sDataDefinition : sDataDefinitions) {
                if (!sDataDefinition.isTransientData().booleanValue() || !dataNames.contains(sDataDefinition.getName())) continue;
                transientDataNames.add(sDataDefinition.getName());
                dataNames.remove(sDataDefinition.getName());
            }
            List<SDataInstance> dataInstances = dataInstanceService.getDataInstances(dataNames, activityInstanceId, DataInstanceContainer.ACTIVITY_INSTANCE.toString());
            for (Operation operation : operations) {
                String name = operation.getLeftOperand().getName();
                if (transientDataNames.contains(name)) {
                    SOperation sOperation = ServerModelConvertor.convertOperation(operation);
                    SExpressionContext sExpressionContext = new SExpressionContext((Long)activityInstanceId, DataInstanceContainer.ACTIVITY_INSTANCE.toString(), activityInstance.getLogicalGroup(processDefinitionIndex));
                    sExpressionContext.setSerializableInputValues(expressionContexts);
                    operationService.execute(sOperation, activityInstanceId, DataInstanceContainer.ACTIVITY_INSTANCE.toString(), sExpressionContext);
                    continue;
                }
                SDataInstance dataInstance = dataInstances.get(dataNames.indexOf(name));
                SOperation sOperation = ServerModelConvertor.convertOperation(operation);
                SExpressionContext sExpressionContext = new SExpressionContext((Long)activityInstanceId, DataInstanceContainer.ACTIVITY_INSTANCE.toString(), activityInstance.getLogicalGroup(processDefinitionIndex));
                sExpressionContext.setSerializableInputValues(expressionContexts);
                operationService.execute(sOperation, dataInstance.getContainerId(), dataInstance.getContainerType(), sExpressionContext);
            }
        }
        catch (SDataInstanceReadException e) {
            throw new UpdateException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new UpdateException((Throwable)e);
        }
    }

    public long getOneAssignedUserTaskInstanceOfProcessInstance(long processInstanceId, long userId) throws RetrieveException {
        int assignedUserTaskInstanceNumber = (int)this.getNumberOfAssignedHumanTaskInstances(userId);
        List<HumanTaskInstance> userTaskInstances = this.getAssignedHumanTaskInstances(userId, 0, assignedUserTaskInstanceNumber, ActivityInstanceCriterion.DEFAULT);
        for (HumanTaskInstance userTaskInstance : userTaskInstances) {
            String stateName = userTaskInstance.getState();
            long userTaskInstanceId = userTaskInstance.getId();
            if (!stateName.equals("ready") || userTaskInstance.getParentContainerId() != processInstanceId) continue;
            return userTaskInstanceId;
        }
        return -1L;
    }

    public long getOneAssignedUserTaskInstanceOfProcessDefinition(long processDefinitionId, long userId) {
        int assignedUserTaskInstanceNumber = (int)this.getNumberOfAssignedHumanTaskInstances(userId);
        List<HumanTaskInstance> userTaskInstances = this.getAssignedHumanTaskInstances(userId, 0, assignedUserTaskInstanceNumber, ActivityInstanceCriterion.DEFAULT);
        if (userTaskInstances.size() != 0) {
            for (HumanTaskInstance userTaskInstance : userTaskInstances) {
                String stateName = userTaskInstance.getState();
                try {
                    SProcessInstance sProcessInstance = this.getSProcessInstance(userTaskInstance.getRootContainerId());
                    if (!stateName.equals("ready") || sProcessInstance.getProcessDefinitionId() != processDefinitionId) continue;
                    return userTaskInstance.getId();
                }
                catch (SBonitaException e) {
                    throw new RetrieveException((Throwable)e);
                }
            }
        }
        return -1L;
    }

    public String getActivityInstanceState(long activityInstanceId) throws ActivityInstanceNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        try {
            SActivityInstance sActivityInstance = this.getSActivityInstance(activityInstanceId);
            ActivityInstance activityInstance = ModelConvertor.toActivityInstance(sActivityInstance, flowNodeStateManager);
            return activityInstance.getState();
        }
        catch (SBonitaException e) {
            this.log(tenantAccessor, e);
            throw new ActivityInstanceNotFoundException(activityInstanceId);
        }
    }

    public boolean canExecuteTask(long activityInstanceId, long userId) throws ActivityInstanceNotFoundException, RetrieveException {
        HumanTaskInstance userTaskInstance = this.getHumanTaskInstance(activityInstanceId);
        return userTaskInstance.getState().equalsIgnoreCase("ready") && userTaskInstance.getAssigneeId() == userId;
    }

    public long getProcessDefinitionId(String name, String version) throws ProcessDefinitionNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        GetProcessDefinitionIDByNameAndVersion transactionContent = new GetProcessDefinitionIDByNameAndVersion(processDefinitionService, name, version);
        try {
            transactionContent.execute();
        }
        catch (SBonitaException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        return (Long)transactionContent.getResult();
    }

    public void releaseUserTask(long userTaskId) throws ActivityInstanceNotFoundException, UpdateException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        try {
            AssignOrUnassignUserTask assignUserTask = new AssignOrUnassignUserTask(0L, userTaskId, activityInstanceService, null, null);
            assignUserTask.execute();
        }
        catch (SUnreleasableTaskException e) {
            throw new UpdateException((Throwable)e);
        }
        catch (SActivityInstanceNotFoundException e) {
            throw new ActivityInstanceNotFoundException((Throwable)e);
        }
        catch (SBonitaException e) {
            this.log(tenantAccessor, e);
            throw new UpdateException((Throwable)e);
        }
    }

    public void updateProcessDeploymentInfo(long processDefinitionId, ProcessDeploymentInfoUpdater processDeploymentInfoUpdater) throws ProcessDefinitionNotFoundException, UpdateException {
        if (processDeploymentInfoUpdater == null || processDeploymentInfoUpdater.getFields().isEmpty()) {
            throw new UpdateException("The update descriptor does not contain field updates");
        }
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        UpdateProcessDeploymentInfo updateProcessDeploymentInfo = new UpdateProcessDeploymentInfo(processDefinitionService, processDefinitionId, processDeploymentInfoUpdater);
        try {
            updateProcessDeploymentInfo.execute();
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        catch (SBonitaException sbe) {
            throw new UpdateException((Throwable)sbe);
        }
    }

    public List<ProcessDeploymentInfo> getStartableProcessDeploymentInfosForActors(Set<Long> actorIds, int startIndex, int maxResults, ProcessDeploymentInfoCriterion sortingCriterion) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SProcessDefinitionDeployInfoBuilderFactory builder = BuilderFactory.get(SProcessDefinitionDeployInfoBuilderFactory.class);
        try {
            List<SActor> actors = actorMappingService.getActors(new ArrayList<Long>(actorIds));
            HashSet<Long> processDefIds = new HashSet<Long>(actors.size());
            for (SActor sActor : actors) {
                if (!sActor.isInitiator()) continue;
                processDefIds.add(sActor.getScopeId());
            }
            String field = null;
            OrderByType order = null;
            switch (sortingCriterion) {
                case DEFAULT: {
                    break;
                }
                case LABEL_ASC: {
                    break;
                }
                case LABEL_DESC: {
                    break;
                }
                case NAME_ASC: {
                    field = builder.getNameKey();
                    order = OrderByType.ASC;
                    break;
                }
                case NAME_DESC: {
                    field = builder.getNameKey();
                    order = OrderByType.DESC;
                    break;
                }
                case ACTIVATION_STATE_ASC: {
                    field = builder.getActivationStateKey();
                    order = OrderByType.ASC;
                    break;
                }
                case ACTIVATION_STATE_DESC: {
                    field = builder.getActivationStateKey();
                    order = OrderByType.DESC;
                    break;
                }
                case CONFIGURATION_STATE_ASC: {
                    field = builder.getConfigurationStateKey();
                    order = OrderByType.ASC;
                    break;
                }
                case CONFIGURATION_STATE_DESC: {
                    field = builder.getConfigurationStateKey();
                    order = OrderByType.DESC;
                    break;
                }
                case VERSION_ASC: {
                    field = builder.getVersionKey();
                    order = OrderByType.ASC;
                    break;
                }
                case VERSION_DESC: {
                    field = builder.getVersionKey();
                    order = OrderByType.DESC;
                    break;
                }
            }
            List<SProcessDefinitionDeployInfo> processDefinitionDeployInfos = processDefinitionService.getProcessDeploymentInfos(new ArrayList<Long>(processDefIds), startIndex, maxResults, field, order);
            return ModelConvertor.toProcessDeploymentInfo(processDefinitionDeployInfos);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public boolean isAllowedToStartProcess(long processDefinitionId, Set<Long> actorIds) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        GetActorsByActorIds getActorsByActorIds = new GetActorsByActorIds(actorMappingService, new ArrayList<Long>(actorIds));
        try {
            getActorsByActorIds.execute();
            Object actors = getActorsByActorIds.getResult();
            boolean isAllowedToStartProcess = true;
            Iterator iterator = actors.iterator();
            while (isAllowedToStartProcess && iterator.hasNext()) {
                SActor actor = (SActor)iterator.next();
                if (actor.getScopeId() == processDefinitionId && actor.isInitiator()) continue;
                isAllowedToStartProcess = false;
            }
            return isAllowedToStartProcess;
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public ActorInstance getActorInitiator(long processDefinitionId) throws ActorNotFoundException, ProcessDefinitionNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        ActorInstance actorInstance = null;
        try {
            SProcessDefinition definition = processDefinitionService.getProcessDefinition(processDefinitionId);
            SActorDefinition sActorDefinition = definition.getActorInitiator();
            if (sActorDefinition == null) {
                throw new ActorNotFoundException("No actor initiator defined on the process");
            }
            String name = sActorDefinition.getName();
            SActor sActor = actorMappingService.getActor(name, processDefinitionId);
            actorInstance = ModelConvertor.toActorInstance(sActor);
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
        return actorInstance;
    }

    public int getNumberOfActivityDataDefinitions(long processDefinitionId, String activityName) throws ProcessDefinitionNotFoundException, ActivityDefinitionNotFoundException {
        List<Object> sdataDefinitionList = Collections.emptyList();
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        GetProcessDefinition getProcessDefinition = new GetProcessDefinition(processDefinitionId, processDefinitionService);
        try {
            getProcessDefinition.execute();
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
        SProcessDefinition sProcessDefinition = getProcessDefinition.getResult();
        if (sProcessDefinition != null) {
            boolean found = false;
            SFlowElementContainerDefinition processContainer = sProcessDefinition.getProcessContainer();
            Set<SActivityDefinition> activityDefList = processContainer.getActivities();
            for (SActivityDefinition sActivityDefinition : activityDefList) {
                if (!activityName.equals(sActivityDefinition.getName())) continue;
                sdataDefinitionList = sActivityDefinition.getSDataDefinitions();
                found = true;
                break;
            }
            if (!found) {
                throw new ActivityDefinitionNotFoundException(activityName);
            }
            return sdataDefinitionList.size();
        }
        return 0;
    }

    public int getNumberOfProcessDataDefinitions(long processDefinitionId) throws ProcessDefinitionNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        GetProcessDefinition getProcessDefinition = new GetProcessDefinition(processDefinitionId, processDefinitionService);
        try {
            getProcessDefinition.execute();
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
        SProcessDefinition sProcessDefinition = getProcessDefinition.getResult();
        SFlowElementContainerDefinition processContainer = sProcessDefinition.getProcessContainer();
        return processContainer.getDataDefinitions().size();
    }

    public ProcessInstance startProcess(long processDefinitionId, Map<String, Serializable> initialVariables) throws ProcessDefinitionNotFoundException, ProcessActivationException, ProcessExecutionException {
        List<Operation> operations = this.createSetDataOperation(processDefinitionId, initialVariables);
        return this.startProcess(processDefinitionId, operations, initialVariables);
    }

    public ProcessInstance startProcess(long userId, long processDefinitionId, Map<String, Serializable> initialVariables) throws ProcessDefinitionNotFoundException, ProcessActivationException, ProcessExecutionException {
        List<Operation> operations = this.createSetDataOperation(processDefinitionId, initialVariables);
        return this.startProcess(userId, processDefinitionId, operations, initialVariables);
    }

    protected List<Operation> createSetDataOperation(long processDefinitionId, Map<String, Serializable> initialVariables) throws ProcessExecutionException {
        ClassLoaderService classLoaderService = this.getTenantAccessor().getClassLoaderService();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        ArrayList<Operation> operations = new ArrayList<Operation>();
        try {
            ClassLoader localClassLoader = classLoaderService.getLocalClassLoader(ScopeType.PROCESS.name(), processDefinitionId);
            Thread.currentThread().setContextClassLoader(localClassLoader);
            if (initialVariables != null) {
                for (Map.Entry<String, Serializable> initialVariable : initialVariables.entrySet()) {
                    String name = initialVariable.getKey();
                    Serializable value = initialVariable.getValue();
                    Expression expression = new ExpressionBuilder().createExpression(name, name, value.getClass().getName(), ExpressionType.TYPE_INPUT);
                    Operation operation = new OperationBuilder().createSetDataOperation(name, expression);
                    operations.add(operation);
                }
            }
        }
        catch (SClassLoaderException cle) {
            throw new ProcessExecutionException((Throwable)cle);
        }
        catch (InvalidExpressionException iee) {
            throw new ProcessExecutionException((Throwable)iee);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        return operations;
    }

    public ProcessInstance startProcess(long processDefinitionId, List<Operation> operations, Map<String, Serializable> context) throws ProcessExecutionException, ProcessDefinitionNotFoundException, ProcessActivationException {
        try {
            return this.startProcess(0L, processDefinitionId, operations, context);
        }
        catch (RetrieveException e) {
            throw new ProcessExecutionException((Throwable)e);
        }
    }

    public ProcessInstance startProcess(long userId, long processDefinitionId, List<Operation> operations, Map<String, Serializable> context) throws ProcessDefinitionNotFoundException, ProcessActivationException, ProcessExecutionException {
        ProcessStarter starter = new ProcessStarter(userId, processDefinitionId, operations, context);
        return starter.start();
    }

    public long getNumberOfActivityDataInstances(long activityInstanceId) throws ActivityInstanceNotFoundException {
        try {
            return this.getNumberOfDataInstancesOfContainer(activityInstanceId, DataInstanceContainer.ACTIVITY_INSTANCE);
        }
        catch (SBonitaException e) {
            throw new ActivityInstanceNotFoundException(activityInstanceId);
        }
    }

    private long getNumberOfDataInstancesOfContainer(long instanceId, DataInstanceContainer containerType) throws SBonitaException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        DataInstanceService dataInstanceService = tenantAccessor.getDataInstanceService();
        return dataInstanceService.getNumberOfDataInstances(instanceId, containerType);
    }

    public long getNumberOfProcessDataInstances(long processInstanceId) throws ProcessInstanceNotFoundException {
        try {
            return this.getNumberOfDataInstancesOfContainer(processInstanceId, DataInstanceContainer.PROCESS_INSTANCE);
        }
        catch (SBonitaException e) {
            throw new ProcessInstanceNotFoundException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Serializable> executeOperations(ConnectorResult connectorResult, List<Operation> operations, Map<String, Serializable> operationInputValues, SExpressionContext expressionContext, ClassLoader classLoader, TenantServiceAccessor tenantAccessor) throws SBonitaException {
        ConnectorService connectorService = tenantAccessor.getConnectorService();
        OperationService operationService = tenantAccessor.getOperationService();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            HashMap<String, Serializable> externalDataValue = new HashMap<String, Serializable>(operations.size());
            for (Operation operation : operations) {
                SOperation sOperation = ServerModelConvertor.convertOperation(operation);
                HashMap<String, Object> inputValues = new HashMap<String, Object>(operationInputValues);
                inputValues.putAll(connectorResult.getResult());
                expressionContext.setInputValues(inputValues);
                Long containerId = expressionContext.getContainerId();
                operationService.execute(sOperation, containerId == null ? -1L : containerId, expressionContext.getContainerType(), expressionContext);
                LeftOperand leftOperand = operation.getLeftOperand();
                if (!"EXTERNAL_DATA".equals(leftOperand.getType())) continue;
                externalDataValue.put(leftOperand.getName(), (Serializable)expressionContext.getInputValues().get(leftOperand.getName()));
            }
            connectorService.disconnect(connectorResult);
            HashMap<String, Serializable> hashMap = externalDataValue;
            return hashMap;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private Map<String, Serializable> toSerializableMap(Map<String, Object> map, String connectorDefinitionId, String connectorDefinitionVersion) throws NotSerializableException {
        HashMap<String, Serializable> resMap = new HashMap<String, Serializable>(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            try {
                resMap.put(entry.getKey(), (Serializable)entry.getValue());
            }
            catch (ClassCastException e) {
                throw new NotSerializableException(connectorDefinitionId, connectorDefinitionVersion, entry.getKey(), entry.getValue());
            }
        }
        return resMap;
    }

    public Map<String, Serializable> executeConnectorOnProcessDefinition(String connectorDefinitionId, String connectorDefinitionVersion, Map<String, Expression> connectorInputParameters, Map<String, Map<String, Serializable>> inputValues, long processDefinitionId) throws ConnectorExecutionException {
        return this.executeConnectorOnProcessDefinitionWithOrWithoutOperations(connectorDefinitionId, connectorDefinitionVersion, connectorInputParameters, inputValues, null, null, processDefinitionId);
    }

    public Map<String, Serializable> executeConnectorOnProcessDefinition(String connectorDefinitionId, String connectorDefinitionVersion, Map<String, Expression> connectorInputParameters, Map<String, Map<String, Serializable>> inputValues, List<Operation> operations, Map<String, Serializable> operationInputValues, long processDefinitionId) throws ConnectorExecutionException {
        return this.executeConnectorOnProcessDefinitionWithOrWithoutOperations(connectorDefinitionId, connectorDefinitionVersion, connectorInputParameters, inputValues, operations, operationInputValues, processDefinitionId);
    }

    private Map<String, Serializable> executeConnectorOnProcessDefinitionWithOrWithoutOperations(String connectorDefinitionId, String connectorDefinitionVersion, Map<String, Expression> connectorInputParameters, Map<String, Map<String, Serializable>> inputValues, List<Operation> operations, Map<String, Serializable> operationInputValues, long processDefinitionId) throws ConnectorExecutionException {
        this.checkConnectorParameters(connectorInputParameters, inputValues);
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        ConnectorService connectorService = tenantAccessor.getConnectorService();
        ClassLoaderService classLoaderService = tenantAccessor.getClassLoaderService();
        try {
            ClassLoader classLoader = classLoaderService.getLocalClassLoader(ScopeType.PROCESS.name(), processDefinitionId);
            Map<String, SExpression> connectorsExps = ModelConvertor.constructExpressions(connectorInputParameters);
            SExpressionContext expcontext = new SExpressionContext();
            expcontext.setProcessDefinitionId(processDefinitionId);
            expcontext.setContainerState(ContainerState.ACTIVE);
            SProcessDefinition processDef = processDefinitionService.getProcessDefinition(processDefinitionId);
            if (processDef != null) {
                expcontext.setProcessDefinition(processDef);
            }
            ConnectorResult connectorResult = connectorService.executeMutipleEvaluation(processDefinitionId, connectorDefinitionId, connectorDefinitionVersion, connectorsExps, inputValues, classLoader, expcontext);
            if (operations != null) {
                return this.executeOperations(connectorResult, operations, operationInputValues, expcontext, classLoader, tenantAccessor);
            }
            return this.getSerializableResultOfConnector(connectorDefinitionVersion, connectorResult, connectorService);
        }
        catch (SBonitaException e) {
            throw new ConnectorExecutionException((Throwable)e);
        }
        catch (NotSerializableException e) {
            throw new ConnectorExecutionException((Throwable)e);
        }
    }

    protected Map<String, Serializable> getSerializableResultOfConnector(String connectorDefinitionVersion, ConnectorResult connectorResult, ConnectorService connectorService) throws NotSerializableException, SConnectorException {
        connectorService.disconnect(connectorResult);
        return this.toSerializableMap(connectorResult.getResult(), connectorDefinitionVersion, connectorDefinitionVersion);
    }

    protected void checkConnectorParameters(Map<String, Expression> connectorInputParameters, Map<String, Map<String, Serializable>> inputValues) throws ConnectorExecutionException {
        if (connectorInputParameters.size() != inputValues.size()) {
            throw new ConnectorExecutionException("The number of input parameters is not consistent with the number of input values. Input parameters: " + connectorInputParameters.size() + ", number of input values: " + inputValues.size());
        }
    }

    public void setActivityStateByName(long activityInstanceId, String state) throws UpdateException {
        this.setActivityStateById(activityInstanceId, ModelConvertor.getServerActivityStateId(state));
    }

    public void setActivityStateById(long activityInstanceId, int stateId) throws UpdateException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        FlowNodeExecutor flowNodeExecutor = tenantAccessor.getFlowNodeExecutor();
        try {
            SActivityInstance sActivityInstance = this.getSActivityInstance(activityInstanceId);
            flowNodeExecutor.setStateByStateId(sActivityInstance.getLogicalGroup(0), sActivityInstance.getId(), stateId);
        }
        catch (SBonitaException e) {
            throw new UpdateException((Throwable)e);
        }
    }

    public void setTaskPriority(long humanTaskInstanceId, TaskPriority priority) throws UpdateException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        try {
            SetTaskPriority transactionContent = new SetTaskPriority(activityInstanceService, humanTaskInstanceId, STaskPriority.valueOf(priority.name()));
            transactionContent.execute();
        }
        catch (SBonitaException e) {
            throw new UpdateException((Throwable)e);
        }
    }

    @Deprecated
    public void deleteProcessInstances(long processDefinitionId) throws DeletionException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        try {
            this.deleteProcessInstancesFromProcessDefinition(processDefinitionId, tenantAccessor);
            new DeleteArchivedProcessInstances(tenantAccessor, processDefinitionId).execute();
        }
        catch (SProcessInstanceHierarchicalDeletionException e) {
            throw new ProcessInstanceHierarchicalDeletionException(e.getMessage(), e.getProcessInstanceId());
        }
        catch (SBonitaException e) {
            throw new DeletionException((Throwable)e);
        }
    }

    private void deleteProcessInstanceInTransaction(TenantServiceAccessor tenantAccessor, final long processInstanceId) throws SBonitaException {
        UserTransactionService userTransactionService = tenantAccessor.getUserTransactionService();
        final ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        try {
            userTransactionService.executeInTransaction(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    processInstanceService.deleteParentProcessInstanceAndElements(processInstanceId);
                    return null;
                }
            });
        }
        catch (SBonitaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SBonitaRuntimeException("Error while deleting the parent process instance and elements.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CustomTransactions
    public long deleteProcessInstances(final long processDefinitionId, final int startIndex, final int maxResults) throws DeletionException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        final ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        UserTransactionService userTxService = tenantAccessor.getUserTransactionService();
        final List<SProcessInstance> sProcessInstances = userTxService.executeInTransaction(new Callable<List<SProcessInstance>>(){

            @Override
            public List<SProcessInstance> call() throws SBonitaSearchException {
                return ProcessAPIImpl.this.searchProcessInstancesFromProcessDefinition(processInstanceService, processDefinitionId, startIndex, maxResults);
            }
        });
        if (sProcessInstances.isEmpty()) {
            return 0L;
        }
        LockService lockService = tenantAccessor.getLockService();
        String objectType = SFlowElementsContainerType.PROCESS.name();
        List<BonitaLock> locks = null;
        try {
            locks = this.createLockProcessInstances(lockService, objectType, sProcessInstances, tenantAccessor.getTenantId());
            long l = userTxService.executeInTransaction(new Callable<Long>(){

                @Override
                public Long call() throws Exception {
                    return processInstanceService.deleteParentProcessInstanceAndElements(sProcessInstances);
                }
            });
            this.releaseLocks(tenantAccessor, lockService, locks, tenantAccessor.getTenantId());
            return l;
        }
        catch (Throwable throwable) {
            try {
                this.releaseLocks(tenantAccessor, lockService, locks, tenantAccessor.getTenantId());
                throw throwable;
            }
            catch (SProcessInstanceHierarchicalDeletionException e) {
                throw new ProcessInstanceHierarchicalDeletionException(e.getMessage(), e.getProcessInstanceId());
            }
            catch (Exception e) {
                throw new DeletionException((Throwable)e);
            }
        }
    }

    private List<SProcessInstance> searchProcessInstancesFromProcessDefinition(ProcessInstanceService processInstanceService, long processDefinitionId, int startIndex, int maxResults) throws SBonitaSearchException {
        SProcessInstanceBuilderFactory keyProvider = BuilderFactory.get(SProcessInstanceBuilderFactory.class);
        FilterOption filterOption = new FilterOption(SProcessInstance.class, keyProvider.getProcessDefinitionIdKey(), processDefinitionId);
        OrderByOption order2 = new OrderByOption(SProcessInstance.class, keyProvider.getIdKey(), OrderByType.ASC);
        OrderByOption order = new OrderByOption(SProcessInstance.class, keyProvider.getCallerIdKey(), OrderByType.ASC);
        ArrayList<OrderByOption> orders = new ArrayList<OrderByOption>();
        orders.add(order);
        orders.add(order2);
        QueryOptions queryOptions = new QueryOptions(startIndex, maxResults, orders, Collections.singletonList(filterOption), null);
        return processInstanceService.searchProcessInstances(queryOptions);
    }

    public long deleteArchivedProcessInstances(long processDefinitionId, int startIndex, int maxResults) throws DeletionException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        try {
            List<SAProcessInstance> saProcessInstances = this.searchArchivedProcessInstancesFromProcessDefinition(processInstanceService, processDefinitionId, startIndex, maxResults);
            if (!saProcessInstances.isEmpty()) {
                return processInstanceService.deleteParentArchivedProcessInstancesAndElements(saProcessInstances);
            }
            return 0L;
        }
        catch (SBonitaException e) {
            throw new DeletionException((Throwable)e);
        }
    }

    private List<SAProcessInstance> searchArchivedProcessInstancesFromProcessDefinition(ProcessInstanceService processInstanceService, long processDefinitionId, int startIndex, int maxResults) throws SBonitaSearchException {
        SAProcessInstanceBuilderFactory keyProvider = BuilderFactory.get(SAProcessInstanceBuilderFactory.class);
        FilterOption filterOption = new FilterOption(SAProcessInstance.class, keyProvider.getProcessDefinitionIdKey(), processDefinitionId);
        OrderByOption order = new OrderByOption(SAProcessInstance.class, keyProvider.getIdKey(), OrderByType.ASC);
        OrderByOption order2 = new OrderByOption(SAProcessInstance.class, keyProvider.getCallerIdKey(), OrderByType.ASC);
        ArrayList<OrderByOption> orders = new ArrayList<OrderByOption>();
        orders.add(order);
        orders.add(order2);
        QueryOptions queryOptions = new QueryOptions(startIndex, maxResults, orders, Collections.singletonList(filterOption), null);
        return processInstanceService.searchArchivedProcessInstances(queryOptions);
    }

    private List<BonitaLock> createLockProcessInstances(LockService lockService, String objectType, List<SProcessInstance> sProcessInstances, long tenantId) throws SLockException {
        ArrayList<BonitaLock> locks = new ArrayList<BonitaLock>();
        for (SProcessInstance sProcessInstance : sProcessInstances) {
            BonitaLock bonitaLock = lockService.lock(sProcessInstance.getId(), objectType, tenantId);
            locks.add(bonitaLock);
        }
        return locks;
    }

    @CustomTransactions
    public void deleteProcessInstance(long processInstanceId) throws DeletionException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        LockService lockService = tenantAccessor.getLockService();
        String objectType = SFlowElementsContainerType.PROCESS.name();
        try {
            BonitaLock lock = lockService.lock(processInstanceId, objectType, tenantAccessor.getTenantId());
            this.deleteProcessInstanceInTransaction(tenantAccessor, processInstanceId);
            lockService.unlock(lock, tenantAccessor.getTenantId());
        }
        catch (SLockException e) {
            throw new DeletionException("Lock was not released. Object type: " + objectType + ", id: " + processInstanceId);
        }
        catch (SProcessInstanceHierarchicalDeletionException e) {
            throw new ProcessInstanceHierarchicalDeletionException(e.getMessage(), e.getProcessInstanceId());
        }
        catch (SProcessInstanceNotFoundException e) {
            throw new DeletionException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new DeletionException((Throwable)e);
        }
    }

    public SearchResult<ProcessInstance> searchOpenProcessInstances(SearchOptions searchOptions) throws SearchException {
        SearchOptionsBuilder searchOptionsBuilder = new SearchOptionsBuilder(searchOptions);
        searchOptionsBuilder.differentFrom("stateId", (Serializable)Integer.valueOf(ProcessInstanceState.COMPLETED.getId()));
        searchOptionsBuilder.filter("callerId", (Serializable)Integer.valueOf(-1));
        try {
            return this.searchProcessInstances(this.getTenantAccessor(), searchOptionsBuilder.done());
        }
        catch (SSearchException e) {
            throw new SearchException((Throwable)e);
        }
    }

    public SearchResult<ProcessInstance> searchProcessInstances(SearchOptions searchOptions) throws SearchException {
        try {
            return this.searchProcessInstances(this.getTenantAccessor(), searchOptions);
        }
        catch (SSearchException e) {
            throw new SearchException((Throwable)e);
        }
    }

    public SearchResult<ProcessInstance> searchOpenProcessInstancesSupervisedBy(long userId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        GetSUser getUser = new GetSUser(identityService, userId);
        try {
            getUser.execute();
        }
        catch (SBonitaException e) {
            return new SearchResultImpl(0L, Collections.emptyList());
        }
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchOpenProcessInstancesSupervisedBy searchOpenProcessInstances = new SearchOpenProcessInstancesSupervisedBy(processInstanceService, searchEntitiesDescriptor.getSearchProcessInstanceDescriptor(), userId, searchOptions, processDefinitionService);
        try {
            searchOpenProcessInstances.execute();
            return searchOpenProcessInstances.getResult();
        }
        catch (SBonitaException sbe) {
            throw new SearchException((Throwable)sbe);
        }
    }

    public SearchResult<ProcessDeploymentInfo> searchProcessDeploymentInfosStartedBy(long userId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchProcessDefinitionsDescriptor searchDescriptor = searchEntitiesDescriptor.getSearchProcessDefinitionsDescriptor();
        SearchProcessDeploymentInfosStartedBy searcher = new SearchProcessDeploymentInfosStartedBy(processDefinitionService, searchDescriptor, userId, searchOptions);
        try {
            searcher.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException("Can't get ProcessDeploymentInfo startedBy userid " + userId, (Throwable)e);
        }
        return searcher.getResult();
    }

    public SearchResult<ProcessDeploymentInfo> searchProcessDeploymentInfos(SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchProcessDefinitionsDescriptor searchDescriptor = searchEntitiesDescriptor.getSearchProcessDefinitionsDescriptor();
        SearchProcessDeploymentInfos transactionSearch = new SearchProcessDeploymentInfos(processDefinitionService, searchDescriptor, searchOptions);
        try {
            transactionSearch.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException("Can't get processDefinition's executing searchProcessDefinitions()", (Throwable)e);
        }
        return transactionSearch.getResult();
    }

    public SearchResult<ProcessDeploymentInfo> searchProcessDeploymentInfosCanBeStartedBy(long userId, SearchOptions searchOptions) throws RetrieveException, SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchProcessDefinitionsDescriptor searchDescriptor = searchEntitiesDescriptor.getSearchProcessDefinitionsDescriptor();
        SearchProcessDeploymentInfosCanBeStartedBy transactionSearch = new SearchProcessDeploymentInfosCanBeStartedBy(processDefinitionService, searchDescriptor, searchOptions, userId);
        try {
            transactionSearch.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException("Error while retrieving process definitions: " + e.getMessage(), (Throwable)e);
        }
        return transactionSearch.getResult();
    }

    @Deprecated
    public SearchResult<ProcessDeploymentInfo> searchProcessDeploymentInfos(long userId, SearchOptions searchOptions) throws RetrieveException, SearchException {
        return this.searchProcessDeploymentInfosCanBeStartedBy(userId, searchOptions);
    }

    public SearchResult<ProcessDeploymentInfo> searchProcessDeploymentInfosCanBeStartedByUsersManagedBy(long managerUserId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor serviceAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = serviceAccessor.getProcessDefinitionService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = serviceAccessor.getSearchEntitiesDescriptor();
        SearchProcessDefinitionsDescriptor searchDescriptor = searchEntitiesDescriptor.getSearchProcessDefinitionsDescriptor();
        SearchProcessDeploymentInfosCanBeStartedByUsersManagedBy transactionSearch = new SearchProcessDeploymentInfosCanBeStartedByUsersManagedBy(processDefinitionService, searchDescriptor, searchOptions, managerUserId);
        try {
            transactionSearch.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return transactionSearch.getResult();
    }

    @Deprecated
    public SearchResult<ProcessDeploymentInfo> searchProcessDeploymentInfosUsersManagedByCanStart(long managerUserId, SearchOptions searchOptions) throws SearchException {
        return this.searchProcessDeploymentInfosCanBeStartedByUsersManagedBy(managerUserId, searchOptions);
    }

    public SearchResult<ProcessDeploymentInfo> searchProcessDeploymentInfosWithAssignedOrPendingHumanTasksFor(long userId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor serviceAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = serviceAccessor.getProcessDefinitionService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = serviceAccessor.getSearchEntitiesDescriptor();
        SearchProcessDefinitionsDescriptor searchDescriptor = searchEntitiesDescriptor.getSearchProcessDefinitionsDescriptor();
        SearchProcessDeploymentInfosWithAssignedOrPendingHumanTasksFor searcher = new SearchProcessDeploymentInfosWithAssignedOrPendingHumanTasksFor(processDefinitionService, searchDescriptor, searchOptions, userId);
        try {
            searcher.execute();
        }
        catch (SBonitaException sbe) {
            throw new SearchException((Throwable)sbe);
        }
        return searcher.getResult();
    }

    public SearchResult<ProcessDeploymentInfo> searchProcessDeploymentInfosWithAssignedOrPendingHumanTasksSupervisedBy(long supervisorId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor serviceAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = serviceAccessor.getProcessDefinitionService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = serviceAccessor.getSearchEntitiesDescriptor();
        SearchProcessDefinitionsDescriptor searchDescriptor = searchEntitiesDescriptor.getSearchProcessDefinitionsDescriptor();
        SearchProcessDeploymentInfosWithAssignedOrPendingHumanTasksSupervisedBy searcher = new SearchProcessDeploymentInfosWithAssignedOrPendingHumanTasksSupervisedBy(processDefinitionService, searchDescriptor, searchOptions, supervisorId);
        try {
            searcher.execute();
        }
        catch (SBonitaException sbe) {
            throw new SearchException((Throwable)sbe);
        }
        return searcher.getResult();
    }

    public SearchResult<ProcessDeploymentInfo> searchProcessDeploymentInfosWithAssignedOrPendingHumanTasks(SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor serviceAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = serviceAccessor.getProcessDefinitionService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = serviceAccessor.getSearchEntitiesDescriptor();
        SearchProcessDefinitionsDescriptor searchDescriptor = searchEntitiesDescriptor.getSearchProcessDefinitionsDescriptor();
        SearchProcessDeploymentInfosWithAssignedOrPendingHumanTasks searcher = new SearchProcessDeploymentInfosWithAssignedOrPendingHumanTasks(processDefinitionService, searchDescriptor, searchOptions);
        try {
            searcher.execute();
        }
        catch (SBonitaException sbe) {
            throw new SearchException((Throwable)sbe);
        }
        return searcher.getResult();
    }

    public SearchResult<ProcessDeploymentInfo> searchProcessDeploymentInfosSupervisedBy(long userId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor serviceAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = serviceAccessor.getProcessDefinitionService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = serviceAccessor.getSearchEntitiesDescriptor();
        SearchProcessDefinitionsDescriptor searchDescriptor = searchEntitiesDescriptor.getSearchProcessDefinitionsDescriptor();
        SearchProcessDeploymentInfosSupervised searcher = new SearchProcessDeploymentInfosSupervised(processDefinitionService, searchDescriptor, searchOptions, userId);
        try {
            searcher.execute();
        }
        catch (SBonitaException sbe) {
            throw new SearchException((Throwable)sbe);
        }
        return searcher.getResult();
    }

    public SearchResult<HumanTaskInstance> searchAssignedTasksSupervisedBy(long supervisorId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor serviceAccessor = this.getTenantAccessor();
        FlowNodeStateManager flowNodeStateManager = serviceAccessor.getFlowNodeStateManager();
        ActivityInstanceService activityInstanceService = serviceAccessor.getActivityInstanceService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = serviceAccessor.getSearchEntitiesDescriptor();
        SearchAssignedTasksSupervisedBy searchedTasksTransaction = new SearchAssignedTasksSupervisedBy(supervisorId, activityInstanceService, flowNodeStateManager, searchEntitiesDescriptor.getSearchHumanTaskInstanceDescriptor(), searchOptions);
        try {
            searchedTasksTransaction.execute();
        }
        catch (SBonitaException sbe) {
            throw new SearchException((Throwable)sbe);
        }
        return searchedTasksTransaction.getResult();
    }

    public SearchResult<ArchivedHumanTaskInstance> searchArchivedHumanTasksSupervisedBy(long supervisorId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor serviceAccessor = this.getTenantAccessor();
        FlowNodeStateManager flowNodeStateManager = serviceAccessor.getFlowNodeStateManager();
        ActivityInstanceService activityInstanceService = serviceAccessor.getActivityInstanceService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = serviceAccessor.getSearchEntitiesDescriptor();
        SearchArchivedHumanTasksSupervisedBy searchedTasksTransaction = new SearchArchivedHumanTasksSupervisedBy(supervisorId, activityInstanceService, flowNodeStateManager, searchEntitiesDescriptor.getSearchArchivedHumanTaskInstanceDescriptor(), searchOptions);
        try {
            searchedTasksTransaction.execute();
        }
        catch (SBonitaException sbe) {
            throw new SearchException((Throwable)sbe);
        }
        return searchedTasksTransaction.getResult();
    }

    public SearchResult<ProcessSupervisor> searchProcessSupervisors(SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor serviceAccessor = this.getTenantAccessor();
        SupervisorMappingService supervisorService = serviceAccessor.getSupervisorService();
        SearchProcessSupervisorDescriptor searchDescriptor = new SearchProcessSupervisorDescriptor();
        SearchSupervisors searchSupervisorsTransaction = new SearchSupervisors(supervisorService, searchDescriptor, searchOptions);
        try {
            searchSupervisorsTransaction.execute();
            return searchSupervisorsTransaction.getResult();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
    }

    public boolean isUserProcessSupervisor(long processDefinitionId, long userId) {
        TenantServiceAccessor serviceAccessor = this.getTenantAccessor();
        SupervisorMappingService supervisorService = serviceAccessor.getSupervisorService();
        try {
            return supervisorService.isProcessSupervisor(processDefinitionId, userId);
        }
        catch (SBonitaReadException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public void deleteSupervisor(long supervisorId) throws DeletionException {
        TenantServiceAccessor serviceAccessor = this.getTenantAccessor();
        SupervisorMappingService supervisorService = serviceAccessor.getSupervisorService();
        TechnicalLoggerService technicalLoggerService = serviceAccessor.getTechnicalLoggerService();
        try {
            supervisorService.deleteProcessSupervisor(supervisorId);
            if (technicalLoggerService.isLoggable(this.getClass(), TechnicalLogSeverity.INFO)) {
                technicalLoggerService.log(this.getClass(), TechnicalLogSeverity.INFO, "The process manager has been deleted with id = <" + supervisorId + ">.");
            }
        }
        catch (SSupervisorNotFoundException e) {
            throw new DeletionException("The process manager was not found with id = <" + supervisorId + ">");
        }
        catch (SSupervisorDeletionException e) {
            throw new DeletionException((Throwable)e);
        }
    }

    public void deleteSupervisor(Long processDefinitionId, Long userId, Long roleId, Long groupId) throws DeletionException {
        block4: {
            TenantServiceAccessor serviceAccessor = this.getTenantAccessor();
            SupervisorMappingService supervisorService = serviceAccessor.getSupervisorService();
            TechnicalLoggerService technicalLoggerService = serviceAccessor.getTechnicalLoggerService();
            try {
                List<SProcessSupervisor> sProcessSupervisors = this.searchSProcessSupervisors(processDefinitionId, userId, groupId, roleId);
                if (!sProcessSupervisors.isEmpty()) {
                    supervisorService.deleteProcessSupervisor(sProcessSupervisors.get(0));
                    if (technicalLoggerService.isLoggable(this.getClass(), TechnicalLogSeverity.INFO)) {
                        technicalLoggerService.log(this.getClass(), TechnicalLogSeverity.INFO, "The process manager has been deleted with process definition id = <" + processDefinitionId + ">, user id = <" + userId + ">, group id = <" + groupId + ">, and role id = <" + roleId + ">.");
                    }
                    break block4;
                }
                throw new SSupervisorNotFoundException(userId, roleId, groupId, processDefinitionId);
            }
            catch (SBonitaException e) {
                throw new DeletionException((Throwable)e);
            }
        }
    }

    public ProcessSupervisor createProcessSupervisorForUser(long processDefinitionId, long userId) throws CreationException, AlreadyExistsException {
        SProcessSupervisorBuilder supervisorBuilder = this.buildSProcessSupervisor(processDefinitionId);
        supervisorBuilder.setUserId(userId);
        return this.createSupervisor(supervisorBuilder.done());
    }

    public ProcessSupervisor createProcessSupervisorForRole(long processDefinitionId, long roleId) throws CreationException, AlreadyExistsException {
        SProcessSupervisorBuilder supervisorBuilder = this.buildSProcessSupervisor(processDefinitionId);
        supervisorBuilder.setRoleId(roleId);
        return this.createSupervisor(supervisorBuilder.done());
    }

    public ProcessSupervisor createProcessSupervisorForGroup(long processDefinitionId, long groupId) throws CreationException, AlreadyExistsException {
        SProcessSupervisorBuilder supervisorBuilder = this.buildSProcessSupervisor(processDefinitionId);
        supervisorBuilder.setGroupId(groupId);
        return this.createSupervisor(supervisorBuilder.done());
    }

    public ProcessSupervisor createProcessSupervisorForMembership(long processDefinitionId, long groupId, long roleId) throws CreationException, AlreadyExistsException {
        SProcessSupervisorBuilder supervisorBuilder = this.buildSProcessSupervisor(processDefinitionId);
        supervisorBuilder.setGroupId(groupId);
        supervisorBuilder.setRoleId(roleId);
        return this.createSupervisor(supervisorBuilder.done());
    }

    private SProcessSupervisorBuilder buildSProcessSupervisor(long processDefinitionId) {
        SProcessSupervisorBuilderFactory sProcessSupervisorBuilderFactory = BuilderFactory.get(SProcessSupervisorBuilderFactory.class);
        return sProcessSupervisorBuilderFactory.createNewInstance(processDefinitionId);
    }

    private ProcessSupervisor createSupervisor(SProcessSupervisor sProcessSupervisor) throws CreationException, AlreadyExistsException {
        TenantServiceAccessor tenantServiceAccessor = this.getTenantAccessor();
        SupervisorMappingService supervisorService = tenantServiceAccessor.getSupervisorService();
        TechnicalLoggerService technicalLoggerService = tenantServiceAccessor.getTechnicalLoggerService();
        try {
            this.checkIfProcessSupervisorAlreadyExists(sProcessSupervisor.getProcessDefId(), sProcessSupervisor.getUserId(), sProcessSupervisor.getGroupId(), sProcessSupervisor.getRoleId());
            SProcessSupervisor supervisor = supervisorService.createProcessSupervisor(sProcessSupervisor);
            if (technicalLoggerService.isLoggable(this.getClass(), TechnicalLogSeverity.INFO)) {
                technicalLoggerService.log(this.getClass(), TechnicalLogSeverity.INFO, "The process manager has been created with process definition id = <" + sProcessSupervisor.getProcessDefId() + ">, user id = <" + sProcessSupervisor.getUserId() + ">, group id = <" + sProcessSupervisor.getGroupId() + ">, and role id = <" + sProcessSupervisor.getRoleId() + ">");
            }
            return ModelConvertor.toProcessSupervisor(supervisor);
        }
        catch (SBonitaException e) {
            throw new CreationException((Throwable)e);
        }
    }

    private void checkIfProcessSupervisorAlreadyExists(long processDefinitionId, Long userId, Long groupId, Long roleId) throws AlreadyExistsException {
        try {
            List<SProcessSupervisor> processSupervisors = this.searchSProcessSupervisors(processDefinitionId, userId, groupId, roleId);
            if (!processSupervisors.isEmpty()) {
                throw new AlreadyExistsException("This supervisor already exists for process definition id = <" + processDefinitionId + ">, user id = <" + userId + ">, group id = <" + groupId + ">, role id = <" + roleId + ">");
            }
        }
        catch (SBonitaSearchException e1) {
            // empty catch block
        }
    }

    protected List<SProcessSupervisor> searchSProcessSupervisors(Long processDefinitionId, Long userId, Long groupId, Long roleId) throws SBonitaSearchException {
        TenantServiceAccessor serviceAccessor = this.getTenantAccessor();
        SupervisorMappingService supervisorService = serviceAccessor.getSupervisorService();
        SProcessSupervisorBuilderFactory sProcessSupervisorBuilderFactory = BuilderFactory.get(SProcessSupervisorBuilderFactory.class);
        List<OrderByOption> oderByOptions = Collections.singletonList(new OrderByOption(SProcessSupervisor.class, sProcessSupervisorBuilderFactory.getUserIdKey(), OrderByType.DESC));
        ArrayList<FilterOption> filterOptions = new ArrayList<FilterOption>();
        filterOptions.add(new FilterOption(SProcessSupervisor.class, sProcessSupervisorBuilderFactory.getProcessDefIdKey(), processDefinitionId == null ? -1L : processDefinitionId));
        filterOptions.add(new FilterOption(SProcessSupervisor.class, sProcessSupervisorBuilderFactory.getUserIdKey(), userId == null ? -1L : userId));
        filterOptions.add(new FilterOption(SProcessSupervisor.class, sProcessSupervisorBuilderFactory.getGroupIdKey(), groupId == null ? -1L : groupId));
        filterOptions.add(new FilterOption(SProcessSupervisor.class, sProcessSupervisorBuilderFactory.getRoleIdKey(), roleId == null ? -1L : roleId));
        return supervisorService.searchProcessSupervisors(new QueryOptions(0, 1, oderByOptions, filterOptions, null));
    }

    @Deprecated
    public SearchResult<ProcessDeploymentInfo> searchUncategorizedProcessDeploymentInfosUserCanStart(long userId, SearchOptions searchOptions) throws SearchException {
        return this.searchUncategorizedProcessDeploymentInfosCanBeStartedBy(userId, searchOptions);
    }

    public SearchResult<ProcessDeploymentInfo> searchUncategorizedProcessDeploymentInfosCanBeStartedBy(long userId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchProcessDefinitionsDescriptor searchDescriptor = searchEntitiesDescriptor.getSearchProcessDefinitionsDescriptor();
        SearchUncategorizedProcessDeploymentInfosCanBeStartedBy transactionSearch = new SearchUncategorizedProcessDeploymentInfosCanBeStartedBy(processDefinitionService, searchDescriptor, searchOptions, userId);
        try {
            transactionSearch.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException("Error while retrieving process definitions", (Throwable)e);
        }
        return transactionSearch.getResult();
    }

    public SearchResult<ArchivedHumanTaskInstance> searchArchivedHumanTasksManagedBy(long managerUserId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        SearchArchivedTasksManagedBy searchTransaction = new SearchArchivedTasksManagedBy(managerUserId, searchOptions, activityInstanceService, flowNodeStateManager, searchEntitiesDescriptor.getSearchArchivedHumanTaskInstanceDescriptor());
        try {
            searchTransaction.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return searchTransaction.getResult();
    }

    public SearchResult<ProcessInstance> searchOpenProcessInstancesInvolvingUser(long userId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchOpenProcessInstancesInvolvingUser searchOpenProcessInstances = new SearchOpenProcessInstancesInvolvingUser(processInstanceService, searchEntitiesDescriptor.getSearchProcessInstanceDescriptor(), userId, searchOptions, processDefinitionService);
        try {
            searchOpenProcessInstances.execute();
            return searchOpenProcessInstances.getResult();
        }
        catch (SBonitaException sbe) {
            throw new SearchException((Throwable)sbe);
        }
    }

    public SearchResult<ProcessInstance> searchOpenProcessInstancesInvolvingUsersManagedBy(long managerUserId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchOpenProcessInstancesInvolvingUsersManagedBy searchOpenProcessInstances = new SearchOpenProcessInstancesInvolvingUsersManagedBy(processInstanceService, searchEntitiesDescriptor.getSearchProcessInstanceDescriptor(), managerUserId, searchOptions, processDefinitionService);
        try {
            searchOpenProcessInstances.execute();
            return searchOpenProcessInstances.getResult();
        }
        catch (SBonitaException sbe) {
            throw new SearchException((Throwable)sbe);
        }
    }

    public SearchResult<ArchivedHumanTaskInstance> searchArchivedHumanTasks(SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        SearchArchivedTasks searchArchivedTasks = new SearchArchivedTasks(activityInstanceService, flowNodeStateManager, searchEntitiesDescriptor.getSearchArchivedHumanTaskInstanceDescriptor(), searchOptions);
        try {
            searchArchivedTasks.execute();
        }
        catch (SBonitaException sbe) {
            throw new SearchException((Throwable)sbe);
        }
        return searchArchivedTasks.getResult();
    }

    public SearchResult<HumanTaskInstance> searchAssignedTasksManagedBy(long managerUserId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        SearchAssignedTaskManagedBy searchAssignedTaskManagedBy = new SearchAssignedTaskManagedBy(activityInstanceService, flowNodeStateManager, searchEntitiesDescriptor.getSearchHumanTaskInstanceDescriptor(), managerUserId, searchOptions);
        try {
            searchAssignedTaskManagedBy.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return searchAssignedTaskManagedBy.getResult();
    }

    public SearchResult<ArchivedProcessInstance> searchArchivedProcessInstancesSupervisedBy(long userId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        SearchArchivedProcessInstancesSupervisedBy searchArchivedProcessInstances = new SearchArchivedProcessInstancesSupervisedBy(userId, processInstanceService, searchEntitiesDescriptor.getSearchArchivedProcessInstanceDescriptor(), searchOptions);
        try {
            searchArchivedProcessInstances.execute();
            return searchArchivedProcessInstances.getResult();
        }
        catch (SBonitaException sbe) {
            throw new SearchException((Throwable)sbe);
        }
    }

    public SearchResult<ArchivedProcessInstance> searchArchivedProcessInstancesInvolvingUser(long userId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        SearchArchivedProcessInstancesInvolvingUser searchArchivedProcessInstances = new SearchArchivedProcessInstancesInvolvingUser(userId, processInstanceService, searchEntitiesDescriptor.getSearchArchivedProcessInstanceDescriptor(), searchOptions);
        try {
            searchArchivedProcessInstances.execute();
            return searchArchivedProcessInstances.getResult();
        }
        catch (SBonitaException sbe) {
            throw new SearchException((Throwable)sbe);
        }
    }

    public SearchResult<HumanTaskInstance> searchPendingTasksForUser(long userId, SearchOptions searchOptions) throws SearchException {
        return this.searchTasksForUser(userId, searchOptions, false);
    }

    private SearchResult<HumanTaskInstance> searchTasksForUser(long userId, SearchOptions searchOptions, boolean orAssignedToUser) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        SearchPendingTasksForUser searchPendingTasksForUser = new SearchPendingTasksForUser(activityInstanceService, flowNodeStateManager, searchEntitiesDescriptor.getSearchHumanTaskInstanceDescriptor(), userId, searchOptions, orAssignedToUser);
        try {
            searchPendingTasksForUser.execute();
            return searchPendingTasksForUser.getResult();
        }
        catch (SBonitaException sbe) {
            throw new SearchException((Throwable)sbe);
        }
    }

    public SearchResult<HumanTaskInstance> searchMyAvailableHumanTasks(long userId, SearchOptions searchOptions) throws SearchException {
        return this.searchTasksForUser(userId, searchOptions, true);
    }

    public SearchResult<HumanTaskInstance> searchPendingTasksSupervisedBy(long userId, SearchOptions searchOptions) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        SearchPendingTasksSupervisedBy searchPendingTasksSupervisedBy = new SearchPendingTasksSupervisedBy(activityInstanceService, flowNodeStateManager, searchEntitiesDescriptor.getSearchHumanTaskInstanceDescriptor(), userId, searchOptions);
        try {
            searchPendingTasksSupervisedBy.execute();
            return searchPendingTasksSupervisedBy.getResult();
        }
        catch (SBonitaException sbe) {
            throw new BonitaRuntimeException((Throwable)sbe);
        }
    }

    public SearchResult<Comment> searchComments(SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        SCommentService commentService = tenantAccessor.getCommentService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        SearchComments searchComments = new SearchComments(searchEntitiesDescriptor.getSearchCommentDescriptor(), searchOptions, commentService);
        try {
            searchComments.execute();
            return searchComments.getResult();
        }
        catch (SBonitaException sbe) {
            throw new SearchException((Throwable)sbe);
        }
    }

    public Comment addProcessComment(long processInstanceId, String comment) throws CreationException {
        try {
            return this.addComment(processInstanceId, comment);
        }
        catch (RetrieveException e) {
            throw new CreationException("Cannot add a comment on a finished or inexistant process instance", e.getCause());
        }
    }

    @Deprecated
    public Comment addComment(long processInstanceId, String comment) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        try {
            tenantAccessor.getProcessInstanceService().getProcessInstance(processInstanceId);
        }
        catch (SProcessInstanceReadException e) {
            throw new RetrieveException("Cannot add a comment on a finished or inexistant process instance", (Throwable)e);
        }
        catch (SProcessInstanceNotFoundException e) {
            throw new RetrieveException("Cannot add a comment on a finished or inexistant process instance", (Throwable)e);
        }
        SCommentService commentService = tenantAccessor.getCommentService();
        AddComment addComment = new AddComment(commentService, processInstanceId, comment);
        try {
            addComment.execute();
            SComment sComment = addComment.getResult();
            return ModelConvertor.toComment(sComment);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    @Deprecated
    public List<Comment> getComments(long processInstanceId) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        SCommentService commentService = tenantAccessor.getCommentService();
        try {
            List<SComment> sComments = commentService.getComments(processInstanceId);
            return ModelConvertor.toComments(sComments);
        }
        catch (SBonitaReadException sbe) {
            throw new RetrieveException((Throwable)sbe);
        }
    }

    public Document attachDocument(long processInstanceId, String documentName, String fileName, String mimeType, String url) throws DocumentAttachmentException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDocumentService processDocumentService = tenantAccessor.getProcessDocumentService();
        long author = this.getUserId();
        try {
            SProcessDocument document = this.attachDocument(processInstanceId, documentName, fileName, mimeType, url, processDocumentService, author);
            return ModelConvertor.toDocument(document);
        }
        catch (SBonitaException sbe) {
            throw new DocumentAttachmentException((Throwable)sbe);
        }
    }

    protected SProcessDocument attachDocument(long processInstanceId, String documentName, String fileName, String mimeType, String url, ProcessDocumentService processDocumentService, long authorId) throws SBonitaException {
        SProcessDocument attachment = this.buildExternalProcessDocumentReference(processInstanceId, documentName, fileName, mimeType, authorId, url);
        return processDocumentService.attachDocumentToProcessInstance(attachment);
    }

    private SProcessDocument buildExternalProcessDocumentReference(long processInstanceId, String documentName, String fileName, String mimeType, long authorId, String url) {
        SProcessDocumentBuilder documentBuilder = this.initDocumentBuilder(processInstanceId, documentName, fileName, mimeType, authorId);
        documentBuilder.setURL(url);
        documentBuilder.setHasContent(false);
        return documentBuilder.done();
    }

    private SProcessDocument buildProcessDocument(long processInstanceId, String documentName, String fileName, String mimetype, long authorId) {
        SProcessDocumentBuilder documentBuilder = this.initDocumentBuilder(processInstanceId, documentName, fileName, mimetype, authorId);
        documentBuilder.setHasContent(true);
        return documentBuilder.done();
    }

    private SProcessDocumentBuilder initDocumentBuilder(long processInstanceId, String documentName, String fileName, String mimetype, long authorId) {
        SProcessDocumentBuilder documentBuilder = BuilderFactory.get(SProcessDocumentBuilderFactory.class).createNewInstance();
        documentBuilder.setName(documentName);
        documentBuilder.setFileName(fileName);
        documentBuilder.setContentMimeType(mimetype);
        documentBuilder.setProcessInstanceId(processInstanceId);
        documentBuilder.setAuthor(authorId);
        documentBuilder.setCreationDate(System.currentTimeMillis());
        return documentBuilder;
    }

    public Document attachDocument(long processInstanceId, String documentName, String fileName, String mimeType, byte[] documentContent) throws DocumentAttachmentException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDocumentService processDocumentService = tenantAccessor.getProcessDocumentService();
        long authorId = this.getUserId();
        try {
            SProcessDocument document = this.attachDocument(processInstanceId, documentName, fileName, mimeType, documentContent, processDocumentService, authorId);
            return ModelConvertor.toDocument(document);
        }
        catch (SBonitaException sbe) {
            throw new DocumentAttachmentException((Throwable)sbe);
        }
    }

    protected SProcessDocument attachDocument(long processInstanceId, String documentName, String fileName, String mimeType, byte[] documentContent, ProcessDocumentService processDocumentService, long authorId) throws SBonitaException {
        SProcessDocument attachment = this.buildProcessDocument(processInstanceId, documentName, fileName, mimeType, authorId);
        return processDocumentService.attachDocumentToProcessInstance(attachment, documentContent);
    }

    public Document attachNewDocumentVersion(long processInstanceId, String documentName, String fileName, String mimeType, String url) throws DocumentAttachmentException {
        this.getTenantAccessor();
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDocumentService processDocumentService = tenantAccessor.getProcessDocumentService();
        long authorId = this.getUserId();
        try {
            SProcessDocument attachment = this.buildExternalProcessDocumentReference(processInstanceId, documentName, fileName, mimeType, authorId, url);
            AttachDocumentVersion attachDocumentTransationContent = new AttachDocumentVersion(processDocumentService, attachment);
            attachDocumentTransationContent.execute();
            return ModelConvertor.toDocument(attachDocumentTransationContent.getResult());
        }
        catch (SBonitaException sbe) {
            throw new DocumentAttachmentException((Throwable)sbe);
        }
    }

    public Document attachNewDocumentVersion(long processInstanceId, String documentName, String contentFileName, String contentMimeType, byte[] documentContent) throws DocumentAttachmentException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDocumentService processDocumentService = tenantAccessor.getProcessDocumentService();
        long authorId = this.getUserId();
        try {
            SProcessDocument attachment = this.buildProcessDocument(processInstanceId, documentName, contentFileName, contentMimeType, authorId);
            AttachDocumentVersionAndStoreContent attachDocumentTransationContent = new AttachDocumentVersionAndStoreContent(processDocumentService, attachment, documentContent);
            attachDocumentTransationContent.execute();
            return ModelConvertor.toDocument(attachDocumentTransationContent.getResult());
        }
        catch (SBonitaException sbe) {
            throw new DocumentAttachmentException((Throwable)sbe);
        }
    }

    public Document getDocument(long documentId) throws DocumentNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDocumentService processDocumentService = tenantAccessor.getProcessDocumentService();
        try {
            GetDocument attachDocumentTransationContent = new GetDocument(processDocumentService, documentId);
            attachDocumentTransationContent.execute();
            return ModelConvertor.toDocument(attachDocumentTransationContent.getResult());
        }
        catch (SBonitaException sbe) {
            throw new DocumentNotFoundException((Throwable)sbe);
        }
    }

    public List<Document> getLastVersionOfDocuments(long processInstanceId, int pageIndex, int numberPerPage, DocumentCriterion pagingCriterion) throws DocumentException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDocumentService processDocumentService = tenantAccessor.getProcessDocumentService();
        OrderAndField orderAndField = OrderAndFields.getOrderAndFieldForDocument(pagingCriterion);
        try {
            GetDocumentsOfProcessInstance transationContent = new GetDocumentsOfProcessInstance(processDocumentService, processInstanceId, pageIndex, numberPerPage, orderAndField.getField(), orderAndField.getOrder());
            transationContent.execute();
            Object attachments = transationContent.getResult();
            if (attachments != null && !attachments.isEmpty()) {
                ArrayList<Document> result = new ArrayList<Document>(attachments.size());
                Iterator i$ = attachments.iterator();
                while (i$.hasNext()) {
                    SProcessDocument attachment = (SProcessDocument)i$.next();
                    result.add(ModelConvertor.toDocument(attachment));
                }
                return result;
            }
            return Collections.emptyList();
        }
        catch (SBonitaException sbe) {
            throw new DocumentException((Throwable)sbe);
        }
    }

    public byte[] getDocumentContent(String documentStorageId) throws DocumentNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDocumentService processDocumentService = tenantAccessor.getProcessDocumentService();
        try {
            GetDocumentContent transationContent = new GetDocumentContent(processDocumentService, documentStorageId);
            transationContent.execute();
            return transationContent.getResult();
        }
        catch (SBonitaException sbe) {
            throw new DocumentNotFoundException((Throwable)sbe);
        }
    }

    public Document getLastDocument(long processInstaneId, String documentName) throws DocumentNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDocumentService processDocumentService = tenantAccessor.getProcessDocumentService();
        try {
            GetDocumentByName transationContent = new GetDocumentByName(processDocumentService, processInstaneId, documentName);
            transationContent.execute();
            SProcessDocument attachment = transationContent.getResult();
            return ModelConvertor.toDocument(attachment);
        }
        catch (SBonitaException sbe) {
            throw new DocumentNotFoundException((Throwable)sbe);
        }
    }

    public long getNumberOfDocuments(long processInstanceId) throws DocumentException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDocumentService processDocumentService = tenantAccessor.getProcessDocumentService();
        try {
            GetNumberOfDocumentsOfProcessInstance transationContent = new GetNumberOfDocumentsOfProcessInstance(processDocumentService, processInstanceId);
            transationContent.execute();
            return transationContent.getResult();
        }
        catch (SBonitaException sbe) {
            throw new DocumentException((Throwable)sbe);
        }
    }

    public Document getDocumentAtProcessInstantiation(long processInstanceId, String documentName) throws DocumentNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDocumentService processDocumentService = tenantAccessor.getProcessDocumentService();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        try {
            GetDocumentByNameAtProcessInstantiation transationContent = new GetDocumentByNameAtProcessInstantiation(processDocumentService, processInstanceService, searchEntitiesDescriptor, processInstanceId, documentName);
            transationContent.execute();
            SProcessDocument attachment = transationContent.getResult();
            return ModelConvertor.toDocument(attachment);
        }
        catch (SBonitaException sbe) {
            throw new DocumentNotFoundException((Throwable)sbe);
        }
    }

    public Document getDocumentAtActivityInstanceCompletion(long activityInstanceId, String documentName) throws DocumentNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDocumentService processDocumentService = tenantAccessor.getProcessDocumentService();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        try {
            GetDocumentByNameAtActivityCompletion transationContent = new GetDocumentByNameAtActivityCompletion(processDocumentService, activityInstanceId, documentName, activityInstanceService);
            transationContent.execute();
            SProcessDocument attachment = transationContent.getResult();
            return ModelConvertor.toDocument(attachment);
        }
        catch (SBonitaException sbe) {
            throw new DocumentNotFoundException((Throwable)sbe);
        }
    }

    public SearchResult<HumanTaskInstance> searchPendingTasksManagedBy(long managerUserId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        SearchPendingTasksManagedBy searchPendingTasksManagedBy = new SearchPendingTasksManagedBy(activityInstanceService, flowNodeStateManager, searchEntitiesDescriptor.getSearchHumanTaskInstanceDescriptor(), managerUserId, searchOptions);
        try {
            searchPendingTasksManagedBy.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return searchPendingTasksManagedBy.getResult();
    }

    public Map<Long, Long> getNumberOfOverdueOpenTasks(List<Long> userIds) throws RetrieveException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        try {
            return activityInstanceService.getNumberOfOverdueOpenTasksForUsers(userIds);
        }
        catch (SBonitaException e) {
            this.log(tenantAccessor, e);
            throw new RetrieveException(e.getMessage());
        }
    }

    public SearchResult<ProcessDeploymentInfo> searchUncategorizedProcessDeploymentInfos(SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchProcessDefinitionsDescriptor searchDescriptor = searchEntitiesDescriptor.getSearchProcessDefinitionsDescriptor();
        SearchUncategorizedProcessDeploymentInfos transactionSearch = new SearchUncategorizedProcessDeploymentInfos(processDefinitionService, searchDescriptor, searchOptions);
        try {
            transactionSearch.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException("Problem encountered while searching for Uncategorized Process Definitions", (Throwable)e);
        }
        return transactionSearch.getResult();
    }

    public SearchResult<Comment> searchCommentsManagedBy(long managerUserId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        SCommentService commentService = tenantAccessor.getCommentService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        SearchCommentsManagedBy searchComments = new SearchCommentsManagedBy(searchEntitiesDescriptor.getSearchCommentDescriptor(), searchOptions, commentService, managerUserId);
        try {
            searchComments.execute();
            return searchComments.getResult();
        }
        catch (SBonitaException sbe) {
            throw new SearchException((Throwable)sbe);
        }
    }

    public SearchResult<Comment> searchCommentsInvolvingUser(long userId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        SCommentService commentService = tenantAccessor.getCommentService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        SearchCommentsInvolvingUser searchComments = new SearchCommentsInvolvingUser(searchEntitiesDescriptor.getSearchCommentDescriptor(), searchOptions, commentService, userId);
        try {
            searchComments.execute();
            return searchComments.getResult();
        }
        catch (SBonitaException sbe) {
            throw new SearchException((Throwable)sbe);
        }
    }

    public List<Long> getChildrenInstanceIdsOfProcessInstance(long processInstanceId, int startIndex, int maxResults, ProcessInstanceCriterion criterion) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        try {
            long totalNumber = processInstanceService.getNumberOfChildInstancesOfProcessInstance(processInstanceId);
            if (totalNumber == 0L) {
                return Collections.emptyList();
            }
            OrderAndField orderAndField = OrderAndFields.getOrderAndFieldForProcessInstance(criterion);
            return processInstanceService.getChildInstanceIdsOfProcessInstance(processInstanceId, startIndex, maxResults, orderAndField.getField(), orderAndField.getOrder());
        }
        catch (SProcessInstanceReadException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public SearchResult<ProcessDeploymentInfo> searchUncategorizedProcessDeploymentInfosSupervisedBy(long userId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchProcessDefinitionsDescriptor searchDescriptor = searchEntitiesDescriptor.getSearchProcessDefinitionsDescriptor();
        SearchUncategorizedProcessDeploymentInfosSupervisedBy transactionSearch = new SearchUncategorizedProcessDeploymentInfosSupervisedBy(processDefinitionService, searchDescriptor, searchOptions, userId);
        try {
            transactionSearch.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException("Problem encountered while searching for Uncategorized Process Definitions for a supervisor", (Throwable)e);
        }
        return transactionSearch.getResult();
    }

    public Map<Long, ProcessDeploymentInfo> getProcessDeploymentInfosFromIds(List<Long> processDefinitionIds) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        try {
            List<SProcessDefinitionDeployInfo> processDefinitionDeployInfos = processDefinitionService.getProcessDeploymentInfos(processDefinitionIds);
            List<ProcessDeploymentInfo> processDeploymentInfos = ModelConvertor.toProcessDeploymentInfo(processDefinitionDeployInfos);
            HashMap<Long, ProcessDeploymentInfo> mProcessDefinitions = new HashMap<Long, ProcessDeploymentInfo>();
            for (ProcessDeploymentInfo p : processDeploymentInfos) {
                mProcessDefinitions.put(p.getProcessId(), p);
            }
            return mProcessDefinitions;
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public List<ConnectorImplementationDescriptor> getConnectorImplementations(long processDefinitionId, int startIndex, int maxsResults, ConnectorCriterion sortingCriterion) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ConnectorService connectorService = tenantAccessor.getConnectorService();
        OrderAndField orderAndField = OrderAndFields.getOrderAndFieldForConnectorImplementation(sortingCriterion);
        GetConnectorImplementations transactionContent = new GetConnectorImplementations(connectorService, processDefinitionId, tenantAccessor.getTenantId(), startIndex, maxsResults, orderAndField.getField(), orderAndField.getOrder());
        try {
            transactionContent.execute();
            Object sConnectorImplementationDescriptors = transactionContent.getResult();
            return ModelConvertor.toConnectorImplementationDescriptors((List<SConnectorImplementationDescriptor>)sConnectorImplementationDescriptors);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public long getNumberOfConnectorImplementations(long processDefinitionId) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ConnectorService connectorService = tenantAccessor.getConnectorService();
        GetNumberOfConnectorImplementations transactionContent = new GetNumberOfConnectorImplementations(connectorService, processDefinitionId, tenantAccessor.getTenantId());
        try {
            transactionContent.execute();
            return transactionContent.getResult();
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public SearchResult<ActivityInstance> searchActivities(SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        SearchActivityInstances searchActivityInstancesTransaction = new SearchActivityInstances(activityInstanceService, flowNodeStateManager, searchEntitiesDescriptor.getSearchActivityInstanceDescriptor(), searchOptions);
        try {
            searchActivityInstancesTransaction.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return searchActivityInstancesTransaction.getResult();
    }

    public SearchResult<ArchivedFlowNodeInstance> searchArchivedFlowNodeInstances(SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        SearchArchivedFlowNodeInstances searchTransaction = new SearchArchivedFlowNodeInstances(activityInstanceService, flowNodeStateManager, searchEntitiesDescriptor.getSearchArchivedFlowNodeInstanceDescriptor(), searchOptions);
        try {
            searchTransaction.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return searchTransaction.getResult();
    }

    public SearchResult<FlowNodeInstance> searchFlowNodeInstances(SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        SearchFlowNodeInstances searchFlowNodeInstancesTransaction = new SearchFlowNodeInstances(activityInstanceService, flowNodeStateManager, searchEntitiesDescriptor.getSearchFlowNodeInstanceDescriptor(), searchOptions);
        try {
            searchFlowNodeInstancesTransaction.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return searchFlowNodeInstancesTransaction.getResult();
    }

    public SearchResult<ArchivedActivityInstance> searchArchivedActivities(SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        SearchArchivedActivityInstances searchActivityInstancesTransaction = new SearchArchivedActivityInstances(activityInstanceService, flowNodeStateManager, searchEntitiesDescriptor.getSearchArchivedActivityInstanceDescriptor(), searchOptions);
        try {
            searchActivityInstancesTransaction.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return searchActivityInstancesTransaction.getResult();
    }

    public ConnectorImplementationDescriptor getConnectorImplementation(long processDefinitionId, String connectorId, String connectorVersion) throws ConnectorNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ConnectorService connectorService = tenantAccessor.getConnectorService();
        GetConnectorImplementation transactionContent = new GetConnectorImplementation(connectorService, processDefinitionId, connectorId, connectorVersion, tenantAccessor.getTenantId());
        try {
            transactionContent.execute();
            SConnectorImplementationDescriptor sConnectorImplementationDescriptor = transactionContent.getResult();
            return ModelConvertor.toConnectorImplementationDescriptor(sConnectorImplementationDescriptor);
        }
        catch (SBonitaException e) {
            throw new ConnectorNotFoundException((Throwable)e);
        }
    }

    public void cancelProcessInstance(long processInstanceId) throws ProcessInstanceNotFoundException, UpdateException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        LockService lockService = tenantAccessor.getLockService();
        TransactionalProcessInstanceInterruptor processInstanceInterruptor = this.buildProcessInstanceInterruptor(tenantAccessor);
        String objectType = SFlowElementsContainerType.PROCESS.name();
        BonitaLock lock = null;
        try {
            lock = lockService.lock(processInstanceId, objectType, tenantAccessor.getTenantId());
            processInstanceInterruptor.interruptProcessInstance(processInstanceId, SStateCategory.CANCELLING, this.getUserId());
        }
        catch (SProcessInstanceNotFoundException spinfe) {
            throw new ProcessInstanceNotFoundException(processInstanceId);
        }
        catch (SBonitaException e) {
            throw new UpdateException((Throwable)e);
        }
        finally {
            try {
                lockService.unlock(lock, tenantAccessor.getTenantId());
            }
            catch (SLockException e) {}
        }
    }

    protected long getUserId() {
        return SessionInfos.getUserIdFromSession();
    }

    protected TransactionalProcessInstanceInterruptor buildProcessInstanceInterruptor(TenantServiceAccessor tenantAccessor) {
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        ProcessExecutor processExecutor = tenantAccessor.getProcessExecutor();
        return new TransactionalProcessInstanceInterruptor(processInstanceService, activityInstanceService, processExecutor, tenantAccessor.getTechnicalLoggerService());
    }

    public void setProcessInstanceState(ProcessInstance processInstance, String state) throws UpdateException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        try {
            ProcessInstanceState processInstanceState = ModelConvertor.getProcessInstanceState(state);
            SetProcessInstanceState transactionContent = new SetProcessInstanceState(processInstanceService, processInstance.getId(), processInstanceState);
            transactionContent.execute();
        }
        catch (IllegalArgumentException e) {
            throw new UpdateException(e.getMessage());
        }
        catch (SBonitaException e) {
            throw new UpdateException(e.getMessage());
        }
    }

    public Map<Long, ProcessDeploymentInfo> getProcessDeploymentInfosFromProcessInstanceIds(List<Long> processInstanceIds) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        try {
            Map<Long, SProcessDefinitionDeployInfo> sProcessDeploymentInfos = processDefinitionService.getProcessDeploymentInfosFromProcessInstanceIds(processInstanceIds);
            return ModelConvertor.toProcessDeploymentInfos(sProcessDeploymentInfos);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public Map<Long, ProcessDeploymentInfo> getProcessDeploymentInfosFromArchivedProcessInstanceIds(List<Long> archivedProcessInstantsIds) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        try {
            Map<Long, SProcessDefinitionDeployInfo> sProcessDeploymentInfos = processDefinitionService.getProcessDeploymentInfosFromArchivedProcessInstanceIds(archivedProcessInstantsIds);
            return ModelConvertor.toProcessDeploymentInfos(sProcessDeploymentInfos);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public SearchResult<Document> searchDocuments(SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ProcessDocumentService processDocumentService = tenantAccessor.getProcessDocumentService();
        SearchDocuments searchDocuments = new SearchDocuments(processDocumentService, searchEntitiesDescriptor.getSearchDocumentDescriptor(), searchOptions);
        try {
            searchDocuments.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return searchDocuments.getResult();
    }

    public SearchResult<Document> searchDocumentsSupervisedBy(long userId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ProcessDocumentService processDocumentService = tenantAccessor.getProcessDocumentService();
        SearchDocumentsSupervisedBy searchDocuments = new SearchDocumentsSupervisedBy(processDocumentService, searchEntitiesDescriptor.getSearchDocumentDescriptor(), searchOptions, userId);
        try {
            searchDocuments.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return searchDocuments.getResult();
    }

    public SearchResult<ArchivedDocument> searchArchivedDocuments(SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ProcessDocumentService processDocumentService = tenantAccessor.getProcessDocumentService();
        SearchArchivedDocuments searchDocuments = new SearchArchivedDocuments(processDocumentService, searchEntitiesDescriptor.getSearchArchivedDocumentDescriptor(), searchOptions);
        try {
            searchDocuments.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return searchDocuments.getResult();
    }

    public SearchResult<ArchivedDocument> searchArchivedDocumentsSupervisedBy(long userId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ProcessDocumentService processDocumentService = tenantAccessor.getProcessDocumentService();
        SearchArchivedDocumentsSupervisedBy searchDocuments = new SearchArchivedDocumentsSupervisedBy(userId, processDocumentService, searchEntitiesDescriptor.getSearchArchivedDocumentDescriptor(), searchOptions);
        try {
            searchDocuments.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return searchDocuments.getResult();
    }

    public void retryTask(long activityInstanceId) throws ActivityExecutionException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        FlowNodeExecutor flowNodeExecutor = tenantAccessor.getFlowNodeExecutor();
        ProcessExecutor processExecutor = tenantAccessor.getProcessExecutor();
        SAutomaticTaskInstanceBuilderFactory keyProvider = BuilderFactory.get(SAutomaticTaskInstanceBuilderFactory.class);
        try {
            SFlowNodeInstance activity = activityInstanceService.getFlowNodeInstance(activityInstanceId);
            long processDefinitionId = activity.getLogicalGroup(keyProvider.getProcessDefinitionIndex());
            FlowNodeState flowNodeState = flowNodeStateManager.getState(activity.getStateId());
            int stateId = activity.getPreviousStateId();
            FlowNodeState state = flowNodeStateManager.getState(stateId);
            if (!"failed".equals(flowNodeState.getName())) {
                throw new ActivityExecutionException("Unable to retry a task that is not failed - task name=" + activity.getName() + " id=" + activityInstanceId + " that was in state " + flowNodeState);
            }
            flowNodeExecutor.setStateByStateId(processDefinitionId, activity.getId(), stateId);
            if (!state.isTerminal()) {
                long userIdFromSession = this.getUserId();
                processExecutor.executeFlowNode(activityInstanceId, null, null, activity.getParentProcessInstanceId(), userIdFromSession, userIdFromSession);
            }
        }
        catch (SBonitaException e) {
            throw new ActivityExecutionException((Throwable)e);
        }
    }

    public ArchivedDocument getArchivedVersionOfProcessDocument(long sourceObjectId) throws ArchivedDocumentNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDocumentService processDocumentService = tenantAccessor.getProcessDocumentService();
        GetArchivedDocument getArchivedDocument = new GetArchivedDocument(processDocumentService, sourceObjectId);
        try {
            getArchivedDocument.execute();
        }
        catch (SBonitaException e) {
            throw new ArchivedDocumentNotFoundException((Throwable)e);
        }
        return ModelConvertor.toArchivedDocument(getArchivedDocument.getResult());
    }

    public ArchivedDocument getArchivedProcessDocument(long archivedProcessDocumentId) throws ArchivedDocumentNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDocumentService processDocumentService = tenantAccessor.getProcessDocumentService();
        try {
            SAProcessDocument archivedDocument = processDocumentService.getArchivedDocument(archivedProcessDocumentId);
            return ModelConvertor.toArchivedDocument(archivedDocument);
        }
        catch (SDocumentNotFoundException e) {
            throw new ArchivedDocumentNotFoundException((Throwable)e);
        }
    }

    public SearchResult<ArchivedComment> searchArchivedComments(SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        SCommentService sCommentService = tenantAccessor.getCommentService();
        SearchArchivedComments searchArchivedComments = new SearchArchivedComments(sCommentService, searchEntitiesDescriptor.getSearchArchivedCommentsDescriptor(), searchOptions);
        try {
            searchArchivedComments.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return searchArchivedComments.getResult();
    }

    public ArchivedComment getArchivedComment(long archivedCommentId) throws RetrieveException, NotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        SCommentService sCommentService = tenantAccessor.getCommentService();
        try {
            SAComment archivedComment = sCommentService.getArchivedComment(archivedCommentId);
            return ModelConvertor.toArchivedComment(archivedComment);
        }
        catch (SCommentNotFoundException e) {
            throw new NotFoundException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public Map<Long, ActorInstance> getActorsFromActorIds(List<Long> actorIds) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        HashMap<Long, ActorInstance> res = new HashMap<Long, ActorInstance>();
        ActorMappingService actormappingService = tenantAccessor.getActorMappingService();
        GetActorsByActorIds getActorsByActorIds = new GetActorsByActorIds(actormappingService, actorIds);
        try {
            getActorsByActorIds.execute();
        }
        catch (SBonitaException e1) {
            throw new RetrieveException((Throwable)e1);
        }
        Object actors = getActorsByActorIds.getResult();
        Iterator i$ = actors.iterator();
        while (i$.hasNext()) {
            SActor actor = (SActor)i$.next();
            res.put(actor.getId(), ModelConvertor.toActorInstance(actor));
        }
        return res;
    }

    public SearchResult<HumanTaskInstance> searchPendingHiddenTasks(long userId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        SearchPendingHiddenTasks searchHiddenTasksTx = new SearchPendingHiddenTasks(activityInstanceService, flowNodeStateManager, searchEntitiesDescriptor.getSearchHumanTaskInstanceDescriptor(), userId, searchOptions);
        try {
            searchHiddenTasksTx.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return searchHiddenTasksTx.getResult();
    }

    public void hideTasks(long userId, Long ... activityInstanceId) throws UpdateException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        HideTasks hideTasksTx = new HideTasks(tenantAccessor.getActivityInstanceService(), userId, activityInstanceId);
        try {
            hideTasksTx.execute();
        }
        catch (SBonitaException e) {
            throw new UpdateException("Error while trying to hide tasks: " + Arrays.toString((Object[])activityInstanceId) + " from user with ID " + userId, (Throwable)e);
        }
    }

    public void unhideTasks(long userId, Long ... activityInstanceId) throws UpdateException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        UnhideTasks unhideTasksTx = new UnhideTasks(tenantAccessor.getActivityInstanceService(), userId, activityInstanceId);
        try {
            unhideTasksTx.execute();
        }
        catch (SBonitaException e) {
            throw new UpdateException("Error while trying to un-hide tasks: " + Arrays.toString((Object[])activityInstanceId) + " from user with ID " + userId, (Throwable)e);
        }
    }

    public Serializable evaluateExpressionOnProcessDefinition(Expression expression, Map<String, Serializable> context, long processDefinitionId) throws ExpressionEvaluationException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ExpressionResolverService expressionResolverService = tenantAccessor.getExpressionResolverService();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SExpression sExpression = ServerModelConvertor.convertExpression(expression);
        SExpressionContext expcontext = new SExpressionContext();
        expcontext.setProcessDefinitionId(processDefinitionId);
        try {
            SProcessDefinition processDef = processDefinitionService.getProcessDefinition(processDefinitionId);
            if (processDef != null) {
                expcontext.setProcessDefinition(processDef);
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>(context);
            expcontext.setInputValues(hashMap);
            return (Serializable)expressionResolverService.evaluate(sExpression, expcontext);
        }
        catch (SExpressionEvaluationException e) {
            throw new ExpressionEvaluationException((Throwable)e, e.getExpressionName());
        }
        catch (SInvalidExpressionException e) {
            throw new ExpressionEvaluationException((Throwable)e, e.getExpressionName());
        }
        catch (SBonitaException e) {
            throw new ExpressionEvaluationException((Throwable)e, null);
        }
    }

    public void updateDueDateOfTask(long userTaskId, Date dueDate) throws UpdateException {
        if (dueDate == null) {
            throw new UpdateException("Unable to update a due date to null");
        }
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        try {
            SetExpectedEndDate updateProcessInstance = new SetExpectedEndDate(activityInstanceService, userTaskId, dueDate);
            updateProcessInstance.execute();
        }
        catch (SFlowNodeNotFoundException e) {
            throw new UpdateException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new UpdateException((Throwable)e);
        }
    }

    public boolean isTaskHidden(long userTaskId, long userId) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IsTaskHidden hideTasksTx = new IsTaskHidden(tenantAccessor.getActivityInstanceService(), userId, userTaskId);
        try {
            hideTasksTx.execute();
            return hideTasksTx.getResult();
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public long countComments(SearchOptions searchOptions) throws SearchException {
        SearchOptionsBuilder searchOptionsBuilder = new SearchOptionsBuilder(0, 0).setFilters(searchOptions.getFilters()).searchTerm(searchOptions.getSearchTerm());
        SearchResult<Comment> searchResult = this.searchComments(searchOptionsBuilder.done());
        return searchResult.getCount();
    }

    public long countAttachments(SearchOptions searchOptions) throws SearchException {
        SearchOptionsBuilder searchOptionsBuilder = new SearchOptionsBuilder(0, 0).setFilters(searchOptions.getFilters()).searchTerm(searchOptions.getSearchTerm());
        SearchResult<Document> searchResult = this.searchDocuments(searchOptionsBuilder.done());
        return searchResult.getCount();
    }

    public void sendSignal(String signalName) throws SendEventException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        EventsHandler eventsHandler = tenantAccessor.getEventsHandler();
        SThrowSignalEventTriggerDefinition signalEventTriggerDefinition = BuilderFactory.get(SThrowSignalEventTriggerDefinitionBuilderFactory.class).createNewInstance(signalName).done();
        try {
            eventsHandler.handleThrowEvent(signalEventTriggerDefinition);
        }
        catch (SBonitaException e) {
            throw new SendEventException((Throwable)e);
        }
    }

    public void sendMessage(String messageName, Expression targetProcess, Expression targetFlowNode, Map<Expression, Expression> messageContent) throws SendEventException {
        this.sendMessage(messageName, targetProcess, targetFlowNode, messageContent, null);
    }

    public void sendMessage(String messageName, Expression targetProcess, Expression targetFlowNode, Map<Expression, Expression> messageContent, Map<Expression, Expression> correlations) throws SendEventException {
        if (correlations != null && correlations.size() > 5) {
            throw new SendEventException("Too many correlations: a message can not have more than 5 correlations.");
        }
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        EventsHandler eventsHandler = tenantAccessor.getEventsHandler();
        ExpressionResolverService expressionResolverService = tenantAccessor.getExpressionResolverService();
        SExpression targetProcessNameExp = ServerModelConvertor.convertExpression(targetProcess);
        SExpression targetFlowNodeNameExp = null;
        if (targetFlowNode != null) {
            targetFlowNodeNameExp = ServerModelConvertor.convertExpression(targetFlowNode);
        }
        SThrowMessageEventTriggerDefinitionBuilder builder = BuilderFactory.get(SThrowMessageEventTriggerDefinitionBuilderFactory.class).createNewInstance(messageName, targetProcessNameExp, targetFlowNodeNameExp);
        if (correlations != null && !correlations.isEmpty()) {
            this.addMessageCorrelations(builder, correlations);
        }
        try {
            if (messageContent != null && !messageContent.isEmpty()) {
                this.addMessageContent(builder, expressionResolverService, messageContent);
            }
            SThrowMessageEventTriggerDefinition messageEventTriggerDefinition = builder.done();
            eventsHandler.handleThrowEvent(messageEventTriggerDefinition);
        }
        catch (SBonitaException e) {
            throw new SendEventException((Throwable)e);
        }
    }

    private void addMessageContent(SThrowMessageEventTriggerDefinitionBuilder messageEventTriggerDefinitionBuilder, ExpressionResolverService expressionResolverService, Map<Expression, Expression> messageContent) throws SBonitaException {
        for (Map.Entry<Expression, Expression> entry : messageContent.entrySet()) {
            expressionResolverService.evaluate(ServerModelConvertor.convertExpression(entry.getKey()));
            SDataDefinitionBuilder dataDefinitionBuilder = BuilderFactory.get(SDataDefinitionBuilderFactory.class).createNewInstance(entry.getKey().getContent(), entry.getValue().getReturnType());
            dataDefinitionBuilder.setDefaultValue(ServerModelConvertor.convertExpression(entry.getValue()));
            messageEventTriggerDefinitionBuilder.addData(dataDefinitionBuilder.done());
        }
    }

    private void addMessageCorrelations(SThrowMessageEventTriggerDefinitionBuilder messageEventTriggerDefinitionBuilder, Map<Expression, Expression> messageCorrelations) {
        for (Map.Entry<Expression, Expression> entry : messageCorrelations.entrySet()) {
            messageEventTriggerDefinitionBuilder.addCorrelation(ServerModelConvertor.convertExpression(entry.getKey()), ServerModelConvertor.convertExpression(entry.getValue()));
        }
    }

    public List<Problem> getProcessResolutionProblems(long processDefinitionId) throws ProcessDefinitionNotFoundException {
        SProcessDefinition processDefinition;
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        List<ProcessDependencyResolver> resolvers = tenantAccessor.getDependencyResolver().getResolvers();
        try {
            processDefinition = processDefinitionService.getProcessDefinition(processDefinitionId);
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        catch (SProcessDefinitionReadException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        ArrayList<Problem> problems = new ArrayList<Problem>();
        for (ProcessDependencyResolver resolver : resolvers) {
            List<Problem> problem = resolver.checkResolution(tenantAccessor, processDefinition);
            if (problem == null) continue;
            problems.addAll(problem);
        }
        return problems;
    }

    public List<ProcessDeploymentInfo> getProcessDeploymentInfos(int startIndex, int maxResults, ProcessDeploymentInfoCriterion pagingCriterion) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchProcessDefinitionsDescriptor processDefinitionsDescriptor = tenantAccessor.getSearchEntitiesDescriptor().getSearchProcessDefinitionsDescriptor();
        GetProcessDefinitionDeployInfos transactionContentWithResult = new GetProcessDefinitionDeployInfos(processDefinitionService, processDefinitionsDescriptor, startIndex, maxResults, pagingCriterion);
        try {
            transactionContentWithResult.execute();
            return transactionContentWithResult.getResult();
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public List<ProcessDeploymentInfo> getProcessDeploymentInfosWithActorOnlyForGroup(long groupId, int startIndex, int maxResults, ProcessDeploymentInfoCriterion sortingCriterion) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchProcessDefinitionsDescriptor processDefinitionsDescriptor = tenantAccessor.getSearchEntitiesDescriptor().getSearchProcessDefinitionsDescriptor();
        GetProcessDefinitionDeployInfosWithActorOnlyForGroup transactionContentWithResult = new GetProcessDefinitionDeployInfosWithActorOnlyForGroup(processDefinitionService, processDefinitionsDescriptor, startIndex, maxResults, sortingCriterion, groupId);
        try {
            transactionContentWithResult.execute();
            return transactionContentWithResult.getResult();
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public List<ProcessDeploymentInfo> getProcessDeploymentInfosWithActorOnlyForGroups(List<Long> groupIds, int startIndex, int maxResults, ProcessDeploymentInfoCriterion sortingCriterion) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchProcessDefinitionsDescriptor processDefinitionsDescriptor = tenantAccessor.getSearchEntitiesDescriptor().getSearchProcessDefinitionsDescriptor();
        GetProcessDefinitionDeployInfosWithActorOnlyForGroups transactionContentWithResult = new GetProcessDefinitionDeployInfosWithActorOnlyForGroups(processDefinitionService, processDefinitionsDescriptor, startIndex, maxResults, sortingCriterion, groupIds);
        try {
            transactionContentWithResult.execute();
            return transactionContentWithResult.getResult();
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public List<ProcessDeploymentInfo> getProcessDeploymentInfosWithActorOnlyForRole(long roleId, int startIndex, int maxResults, ProcessDeploymentInfoCriterion sortingCriterion) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchProcessDefinitionsDescriptor processDefinitionsDescriptor = tenantAccessor.getSearchEntitiesDescriptor().getSearchProcessDefinitionsDescriptor();
        GetProcessDefinitionDeployInfosWithActorOnlyForRole transactionContentWithResult = new GetProcessDefinitionDeployInfosWithActorOnlyForRole(processDefinitionService, processDefinitionsDescriptor, startIndex, maxResults, sortingCriterion, roleId);
        try {
            transactionContentWithResult.execute();
            return transactionContentWithResult.getResult();
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public List<ProcessDeploymentInfo> getProcessDeploymentInfosWithActorOnlyForRoles(List<Long> roleIds, int startIndex, int maxResults, ProcessDeploymentInfoCriterion sortingCriterion) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchProcessDefinitionsDescriptor processDefinitionsDescriptor = tenantAccessor.getSearchEntitiesDescriptor().getSearchProcessDefinitionsDescriptor();
        GetProcessDefinitionDeployInfosWithActorOnlyForRoles transactionContentWithResult = new GetProcessDefinitionDeployInfosWithActorOnlyForRoles(processDefinitionService, processDefinitionsDescriptor, startIndex, maxResults, sortingCriterion, roleIds);
        try {
            transactionContentWithResult.execute();
            return transactionContentWithResult.getResult();
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public List<ProcessDeploymentInfo> getProcessDeploymentInfosWithActorOnlyForUser(long userId, int startIndex, int maxResults, ProcessDeploymentInfoCriterion sortingCriterion) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchProcessDefinitionsDescriptor processDefinitionsDescriptor = tenantAccessor.getSearchEntitiesDescriptor().getSearchProcessDefinitionsDescriptor();
        GetProcessDefinitionDeployInfosWithActorOnlyForUser transactionContentWithResult = new GetProcessDefinitionDeployInfosWithActorOnlyForUser(processDefinitionService, processDefinitionsDescriptor, startIndex, maxResults, sortingCriterion, userId);
        try {
            transactionContentWithResult.execute();
            return transactionContentWithResult.getResult();
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public List<ProcessDeploymentInfo> getProcessDeploymentInfosWithActorOnlyForUsers(List<Long> userIds, int startIndex, int maxResults, ProcessDeploymentInfoCriterion sortingCriterion) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchProcessDefinitionsDescriptor processDefinitionsDescriptor = tenantAccessor.getSearchEntitiesDescriptor().getSearchProcessDefinitionsDescriptor();
        GetProcessDefinitionDeployInfosWithActorOnlyForUsers transactionContentWithResult = new GetProcessDefinitionDeployInfosWithActorOnlyForUsers(processDefinitionService, processDefinitionsDescriptor, startIndex, maxResults, sortingCriterion, userIds);
        try {
            transactionContentWithResult.execute();
            return transactionContentWithResult.getResult();
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public SearchResult<ConnectorInstance> searchConnectorInstances(SearchOptions searchOptions) throws RetrieveException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ConnectorInstanceService connectorInstanceService = tenantAccessor.getConnectorInstanceService();
        SearchConnectorInstances searchConnector = new SearchConnectorInstances(connectorInstanceService, searchEntitiesDescriptor.getSearchConnectorInstanceDescriptor(), searchOptions);
        try {
            searchConnector.execute();
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
        return searchConnector.getResult();
    }

    public SearchResult<ArchivedConnectorInstance> searchArchivedConnectorInstances(SearchOptions searchOptions) throws RetrieveException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ConnectorInstanceService connectorInstanceService = tenantAccessor.getConnectorInstanceService();
        ArchiveService archiveService = tenantAccessor.getArchiveService();
        ReadPersistenceService persistenceService = archiveService.getDefinitiveArchiveReadPersistenceService();
        SearchArchivedConnectorInstance searchArchivedConnectorInstance = new SearchArchivedConnectorInstance(connectorInstanceService, searchEntitiesDescriptor.getSearchArchivedConnectorInstanceDescriptor(), searchOptions, persistenceService);
        try {
            searchArchivedConnectorInstance.execute();
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
        return searchArchivedConnectorInstance.getResult();
    }

    public List<HumanTaskInstance> getHumanTaskInstances(long processInstanceId, String taskName, int startIndex, int maxResults) {
        try {
            List<HumanTaskInstance> humanTaskInstances = this.getHumanTaskInstances(processInstanceId, taskName, startIndex, maxResults, "processInstanceId", Order.ASC);
            if (humanTaskInstances == null) {
                return Collections.emptyList();
            }
            return humanTaskInstances;
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public HumanTaskInstance getLastStateHumanTaskInstance(long processInstanceId, String taskName) throws NotFoundException {
        try {
            List<HumanTaskInstance> humanTaskInstances = this.getHumanTaskInstances(processInstanceId, taskName, 0, 1, "reachedStateDate", Order.DESC);
            if (humanTaskInstances == null || humanTaskInstances.isEmpty()) {
                throw new NotFoundException("Task '" + taskName + "' not found");
            }
            return humanTaskInstances.get(0);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    private List<HumanTaskInstance> getHumanTaskInstances(long processInstanceId, String taskName, int startIndex, int maxResults, String field, Order order) throws SBonitaException {
        SearchOptionsBuilder builder = new SearchOptionsBuilder(startIndex, maxResults);
        builder.filter("processInstanceId", (Serializable)Long.valueOf(processInstanceId)).filter("name", (Serializable)((Object)taskName));
        builder.sort(field, order);
        SearchResult<HumanTaskInstance> searchHumanTasks = this.searchHumanTasksTransaction(builder.done());
        return searchHumanTasks.getResult();
    }

    public SearchResult<User> searchUsersWhoCanStartProcessDefinition(long processDefinitionId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        SearchUserDescriptor searchDescriptor = searchEntitiesDescriptor.getSearchUserDescriptor();
        SearchUsersWhoCanStartProcessDeploymentInfo transactionSearch = new SearchUsersWhoCanStartProcessDeploymentInfo(processDefinitionService, searchDescriptor, processDefinitionId, searchOptions);
        try {
            transactionSearch.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return transactionSearch.getResult();
    }

    public Map<String, Serializable> evaluateExpressionsAtProcessInstanciation(long processInstanceId, Map<Expression, Map<String, Serializable>> expressions) throws ExpressionEvaluationException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        try {
            try {
                SProcessInstance processInstance = processInstanceService.getProcessInstance(processInstanceId);
                int stateId = processInstance.getStateId();
                if (stateId == 0 || stateId == 1) {
                    long evaluationDate = stateId == 0 ? System.currentTimeMillis() : processInstance.getStartDate();
                    return this.evaluateExpressionsInstanceLevelAndArchived(expressions, processInstanceId, CONTAINER_TYPE_PROCESS_INSTANCE, processInstance.getProcessDefinitionId(), evaluationDate);
                }
            }
            catch (SProcessInstanceNotFoundException spinfe) {
                // empty catch block
            }
            ArchivedProcessInstance archiveProcessInstance = this.getStartedArchivedProcessInstance(processInstanceId);
            Map<String, Serializable> evaluateExpressionInArchiveProcessInstance = this.evaluateExpressionsInstanceLevelAndArchived(expressions, processInstanceId, CONTAINER_TYPE_PROCESS_INSTANCE, archiveProcessInstance.getProcessDefinitionId(), archiveProcessInstance.getStartDate().getTime());
            return evaluateExpressionInArchiveProcessInstance;
        }
        catch (SExpressionEvaluationException e) {
            throw new ExpressionEvaluationException((Throwable)e, e.getExpressionName());
        }
        catch (SInvalidExpressionException e) {
            throw new ExpressionEvaluationException((Throwable)e, e.getExpressionName());
        }
        catch (SBonitaException e) {
            throw new ExpressionEvaluationException((Throwable)e, null);
        }
    }

    public Map<String, Serializable> evaluateExpressionOnCompletedProcessInstance(long processInstanceId, Map<Expression, Map<String, Serializable>> expressions) throws ExpressionEvaluationException {
        try {
            ArchivedProcessInstance lastArchivedProcessInstance = this.getLastArchivedProcessInstance(processInstanceId);
            return this.evaluateExpressionsInstanceLevelAndArchived(expressions, processInstanceId, CONTAINER_TYPE_PROCESS_INSTANCE, lastArchivedProcessInstance.getProcessDefinitionId(), lastArchivedProcessInstance.getArchiveDate().getTime());
        }
        catch (SExpressionEvaluationException e) {
            throw new ExpressionEvaluationException((Throwable)e, e.getExpressionName());
        }
        catch (SInvalidExpressionException e) {
            throw new ExpressionEvaluationException((Throwable)e, e.getExpressionName());
        }
        catch (SBonitaException e) {
            throw new ExpressionEvaluationException((Throwable)e, null);
        }
    }

    public Map<String, Serializable> evaluateExpressionsOnProcessInstance(long processInstanceId, Map<Expression, Map<String, Serializable>> expressions) throws ExpressionEvaluationException {
        try {
            SProcessInstance sProcessInstance = this.getSProcessInstance(processInstanceId);
            return this.evaluateExpressionsInstanceLevel(expressions, processInstanceId, CONTAINER_TYPE_PROCESS_INSTANCE, sProcessInstance.getProcessDefinitionId());
        }
        catch (SExpressionEvaluationException e) {
            throw new ExpressionEvaluationException((Throwable)e, e.getExpressionName());
        }
        catch (SInvalidExpressionException e) {
            throw new ExpressionEvaluationException((Throwable)e, e.getExpressionName());
        }
        catch (SBonitaException e) {
            throw new ExpressionEvaluationException((Throwable)e, null);
        }
    }

    public Map<String, Serializable> evaluateExpressionsOnProcessDefinition(long processDefinitionId, Map<Expression, Map<String, Serializable>> expressions) throws ExpressionEvaluationException {
        try {
            return this.evaluateExpressionsDefinitionLevel(expressions, processDefinitionId);
        }
        catch (SExpressionEvaluationException e) {
            throw new ExpressionEvaluationException((Throwable)e, e.getExpressionName());
        }
        catch (SInvalidExpressionException e) {
            throw new ExpressionEvaluationException((Throwable)e, e.getExpressionName());
        }
        catch (SBonitaException e) {
            throw new ExpressionEvaluationException((Throwable)e, null);
        }
    }

    public Map<String, Serializable> evaluateExpressionsOnActivityInstance(long activityInstanceId, Map<Expression, Map<String, Serializable>> expressions) throws ExpressionEvaluationException {
        try {
            SActivityInstance sActivityInstance = this.getSActivityInstance(activityInstanceId);
            SProcessInstance sProcessInstance = this.getSProcessInstance(sActivityInstance.getParentProcessInstanceId());
            return this.evaluateExpressionsInstanceLevel(expressions, activityInstanceId, CONTAINER_TYPE_ACTIVITY_INSTANCE, sProcessInstance.getProcessDefinitionId());
        }
        catch (SExpressionEvaluationException e) {
            throw new ExpressionEvaluationException((Throwable)e, e.getExpressionName());
        }
        catch (SInvalidExpressionException e) {
            throw new ExpressionEvaluationException((Throwable)e, e.getExpressionName());
        }
        catch (SBonitaException e) {
            throw new ExpressionEvaluationException((Throwable)e, null);
        }
    }

    public Map<String, Serializable> evaluateExpressionsOnCompletedActivityInstance(long activityInstanceId, Map<Expression, Map<String, Serializable>> expressions) throws ExpressionEvaluationException {
        try {
            ArchivedActivityInstance activityInstance = this.getArchivedActivityInstance(activityInstanceId);
            ArchivedProcessInstance lastArchivedProcessInstance = this.getLastArchivedProcessInstance(activityInstance.getParentContainerId());
            return this.evaluateExpressionsInstanceLevelAndArchived(expressions, activityInstanceId, CONTAINER_TYPE_ACTIVITY_INSTANCE, lastArchivedProcessInstance.getProcessDefinitionId(), activityInstance.getArchiveDate().getTime());
        }
        catch (ActivityInstanceNotFoundException e) {
            throw new ExpressionEvaluationException((Throwable)e, null);
        }
        catch (SExpressionEvaluationException e) {
            throw new ExpressionEvaluationException((Throwable)e, e.getExpressionName());
        }
        catch (SInvalidExpressionException e) {
            throw new ExpressionEvaluationException((Throwable)e, e.getExpressionName());
        }
        catch (SBonitaException e) {
            throw new ExpressionEvaluationException((Throwable)e, null);
        }
    }

    private Map<String, Serializable> evaluateExpressionsDefinitionLevel(Map<Expression, Map<String, Serializable>> expressionsAndTheirPartialContext, long processDefinitionId) throws SBonitaException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ExpressionResolverService expressionResolverService = tenantAccessor.getExpressionResolverService();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        EvaluateExpressionsDefinitionLevel evaluations = new EvaluateExpressionsDefinitionLevel(expressionsAndTheirPartialContext, processDefinitionId, expressionResolverService, processDefinitionService);
        evaluations.execute();
        return evaluations.getResult();
    }

    private Map<String, Serializable> evaluateExpressionsInstanceLevel(Map<Expression, Map<String, Serializable>> expressions, long containerId, String containerType, long processDefinitionId) throws SBonitaException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ExpressionResolverService expressionService = tenantAccessor.getExpressionResolverService();
        EvaluateExpressionsInstanceLevel evaluations = new EvaluateExpressionsInstanceLevel(expressions, containerId, containerType, processDefinitionId, expressionService);
        evaluations.execute();
        return evaluations.getResult();
    }

    private Map<String, Serializable> evaluateExpressionsInstanceLevelAndArchived(Map<Expression, Map<String, Serializable>> expressions, long containerId, String containerType, long processDefinitionId, long time) throws SBonitaException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ExpressionResolverService expressionService = tenantAccessor.getExpressionResolverService();
        EvaluateExpressionsInstanceLevelAndArchived evaluations = new EvaluateExpressionsInstanceLevelAndArchived(expressions, containerId, containerType, processDefinitionId, time, expressionService);
        evaluations.execute();
        return evaluations.getResult();
    }

    private ArchivedProcessInstance getStartedArchivedProcessInstance(long processInstanceId) throws SBonitaException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        SearchOptionsBuilder searchOptionsBuilder = new SearchOptionsBuilder(0, 2);
        searchOptionsBuilder.sort("archiveDate", Order.ASC);
        searchOptionsBuilder.filter("sourceObjectId", (Serializable)Long.valueOf(processInstanceId));
        searchOptionsBuilder.filter("stateId", (Serializable)Integer.valueOf(ProcessInstanceState.STARTED.getId()));
        SearchArchivedProcessInstances searchArchivedProcessInstances = new SearchArchivedProcessInstances(processInstanceService, searchEntitiesDescriptor.getSearchArchivedProcessInstanceDescriptor(), searchOptionsBuilder.done());
        searchArchivedProcessInstances.execute();
        try {
            return (ArchivedProcessInstance)searchArchivedProcessInstances.getResult().getResult().get(0);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SAProcessInstanceNotFoundException(processInstanceId, ProcessInstanceState.STARTED.name());
        }
    }

    private ArchivedProcessInstance getLastArchivedProcessInstance(long processInstanceId) throws SBonitaException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        GetLastArchivedProcessInstance searchArchivedProcessInstances = new GetLastArchivedProcessInstance(processInstanceService, processInstanceId, searchEntitiesDescriptor);
        searchArchivedProcessInstances.execute();
        return searchArchivedProcessInstances.getResult();
    }

    public List<FailedJob> getFailedJobs(int startIndex, int maxResults) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        JobService jobService = tenantAccessor.getJobService();
        try {
            List<SFailedJob> failedJobs = jobService.getFailedJobs(startIndex, maxResults);
            return ModelConvertor.toFailedJobs(failedJobs);
        }
        catch (SSchedulerException sse) {
            throw new RetrieveException((Throwable)sse);
        }
    }

    public void replayFailedJob(long jobDescriptorId) throws ExecutionException {
        this.replayFailedJob(jobDescriptorId, null);
    }

    public void replayFailedJob(long jobDescriptorId, Map<String, Serializable> parameters) throws ExecutionException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        SchedulerService schedulerService = tenantAccessor.getSchedulerService();
        try {
            if (parameters == null || parameters.isEmpty()) {
                schedulerService.executeAgain(jobDescriptorId);
            } else {
                List<SJobParameter> jobParameters = this.getJobParameters(parameters);
                schedulerService.executeAgain(jobDescriptorId, jobParameters);
            }
        }
        catch (SSchedulerException sse) {
            throw new ExecutionException((Throwable)sse);
        }
    }

    protected List<SJobParameter> getJobParameters(Map<String, Serializable> parameters) {
        ArrayList<SJobParameter> jobParameters = new ArrayList<SJobParameter>();
        for (Map.Entry<String, Serializable> parameter : parameters.entrySet()) {
            jobParameters.add(this.buildSJobParameter(parameter.getKey(), parameter.getValue()));
        }
        return jobParameters;
    }

    protected SJobParameter buildSJobParameter(String parameterKey, Serializable parameterValue) {
        return this.getSJobParameterBuilderFactory().createNewInstance(parameterKey, parameterValue).done();
    }

    protected SJobParameterBuilderFactory getSJobParameterBuilderFactory() {
        return BuilderFactory.get(SJobParameterBuilderFactory.class);
    }

    public ArchivedDataInstance getArchivedProcessDataInstance(String dataName, long processInstanceId) throws ArchivedDataNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        DataInstanceService dataInstanceService = tenantAccessor.getDataInstanceService();
        try {
            SADataInstance dataInstance = dataInstanceService.getLastSADataInstance(dataName, processInstanceId, DataInstanceContainer.PROCESS_INSTANCE.toString());
            return ModelConvertor.toArchivedDataInstance(dataInstance);
        }
        catch (SDataInstanceException sdie) {
            throw new ArchivedDataNotFoundException((Throwable)sdie);
        }
    }

    public ArchivedDataInstance getArchivedActivityDataInstance(String dataName, long activityInstanceId) throws ArchivedDataNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        DataInstanceService dataInstanceService = tenantAccessor.getDataInstanceService();
        try {
            SADataInstance dataInstance = dataInstanceService.getLastSADataInstance(dataName, activityInstanceId, DataInstanceContainer.ACTIVITY_INSTANCE.toString());
            return ModelConvertor.toArchivedDataInstance(dataInstance);
        }
        catch (SDataInstanceException sdie) {
            throw new ArchivedDataNotFoundException((Throwable)sdie);
        }
    }

    public List<ArchivedDataInstance> getArchivedProcessDataInstances(long processInstanceId, int startIndex, int maxResults) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        DataInstanceService dataInstanceService = tenantAccessor.getDataInstanceService();
        try {
            List<SADataInstance> dataInstances = dataInstanceService.getLastLocalSADataInstances(processInstanceId, DataInstanceContainer.PROCESS_INSTANCE.toString(), startIndex, maxResults);
            return ModelConvertor.toArchivedDataInstances(dataInstances);
        }
        catch (SDataInstanceException sdie) {
            throw new RetrieveException((Throwable)sdie);
        }
    }

    public List<ArchivedDataInstance> getArchivedActivityDataInstances(long activityInstanceId, int startIndex, int maxResults) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        DataInstanceService dataInstanceService = tenantAccessor.getDataInstanceService();
        try {
            List<SADataInstance> dataInstances = dataInstanceService.getLastLocalSADataInstances(activityInstanceId, DataInstanceContainer.ACTIVITY_INSTANCE.toString(), startIndex, maxResults);
            return ModelConvertor.toArchivedDataInstances(dataInstances);
        }
        catch (SDataInstanceException sdie) {
            throw new RetrieveException((Throwable)sdie);
        }
    }

    public List<User> getPossibleUsersOfPendingHumanTask(long humanTaskInstanceId, int startIndex, int maxResults) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        try {
            List<Long> userIds = activityInstanceService.getPossibleUserIdsOfPendingTasks(humanTaskInstanceId, startIndex, maxResults);
            IdentityService identityService = this.getTenantAccessor().getIdentityService();
            List<SUser> sUsers = identityService.getUsers(userIds);
            return ModelConvertor.toUsers(sUsers);
        }
        catch (SBonitaException sbe) {
            throw new RetrieveException((Throwable)sbe);
        }
    }

    public List<User> getPossibleUsersOfHumanTask(long processDefinitionId, String humanTaskName, int startIndex, int maxResults) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        try {
            SProcessDefinition processDefinition = processDefinitionService.getProcessDefinition(processDefinitionId);
            SFlowNodeDefinition flowNode = processDefinition.getProcessContainer().getFlowNode(humanTaskName);
            if (!(flowNode instanceof SHumanTaskDefinition)) {
                return Collections.emptyList();
            }
            SHumanTaskDefinition humanTask = (SHumanTaskDefinition)flowNode;
            String actorName = humanTask.getActorName();
            List<Long> userIds = this.getUserIdsForActor(tenantAccessor, processDefinitionId, actorName, startIndex, maxResults);
            List<SUser> users = tenantAccessor.getIdentityService().getUsers(userIds);
            return ModelConvertor.toUsers(users);
        }
        catch (SProcessDefinitionNotFoundException spdnfe) {
            return Collections.emptyList();
        }
        catch (SBonitaException sbe) {
            throw new RetrieveException((Throwable)sbe);
        }
    }

    private List<Long> getUserIdsForActor(TenantServiceAccessor tenantAccessor, long processDefinitionId, String actorName, int startIndex, int maxResults) throws SActorNotFoundException, SBonitaReadException {
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        SActor actor = actorMappingService.getActor(actorName, processDefinitionId);
        return actorMappingService.getPossibleUserIdsOfActorId(actor.getId(), startIndex, maxResults);
    }

    public List<Long> getUserIdsForActor(long processDefinitionId, String actorName, int startIndex, int maxResults) {
        try {
            return this.getUserIdsForActor(this.getTenantAccessor(), processDefinitionId, actorName, startIndex, maxResults);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public SearchResult<User> searchUsersWhoCanExecutePendingHumanTask(long humanTaskInstanceId, SearchOptions searchOptions) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        SearchUserDescriptor searchDescriptor = searchEntitiesDescriptor.getSearchUserDescriptor();
        SearchUsersWhoCanExecutePendingHumanTaskDeploymentInfo searcher = new SearchUsersWhoCanExecutePendingHumanTaskDeploymentInfo(humanTaskInstanceId, activityInstanceService, searchDescriptor, searchOptions);
        try {
            searcher.execute();
        }
        catch (SBonitaException sbe) {
            throw new RetrieveException((Throwable)sbe);
        }
        return searcher.getResult();
    }

    public SearchResult<HumanTaskInstance> searchAssignedAndPendingHumanTasksFor(long rootProcessDefinitionId, long userId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        SearchHumanTaskInstanceDescriptor searchDescriptor = searchEntitiesDescriptor.getSearchHumanTaskInstanceDescriptor();
        SearchAssignedAndPendingHumanTasksFor searcher = new SearchAssignedAndPendingHumanTasksFor(activityInstanceService, flowNodeStateManager, searchDescriptor, rootProcessDefinitionId, userId, searchOptions);
        try {
            searcher.execute();
        }
        catch (SBonitaException sbe) {
            throw new SearchException((Throwable)sbe);
        }
        return searcher.getResult();
    }

    public SearchResult<HumanTaskInstance> searchAssignedAndPendingHumanTasks(long rootProcessDefinitionId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        SearchHumanTaskInstanceDescriptor searchDescriptor = searchEntitiesDescriptor.getSearchHumanTaskInstanceDescriptor();
        SearchAssignedAndPendingHumanTasks searcher = new SearchAssignedAndPendingHumanTasks(activityInstanceService, flowNodeStateManager, searchDescriptor, rootProcessDefinitionId, searchOptions);
        try {
            searcher.execute();
        }
        catch (SBonitaException sbe) {
            throw new SearchException((Throwable)sbe);
        }
        return searcher.getResult();
    }
}

