/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl;

import java.io.File;
import java.io.IOException;
import org.bonitasoft.engine.api.impl.SessionInfos;
import org.bonitasoft.engine.api.impl.transaction.process.DeleteProcess;
import org.bonitasoft.engine.api.impl.transaction.process.DisableProcess;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.event.EventInstanceService;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.home.BonitaHomeServer;
import org.bonitasoft.engine.io.IOUtil;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.scheduler.SchedulerService;
import org.bonitasoft.engine.service.PlatformServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceSingleton;
import org.bonitasoft.engine.service.impl.ServiceAccessorFactory;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;

public class ProcessManagementAPIImplDelegate {
    protected static TenantServiceAccessor getTenantAccessor() {
        try {
            SessionAccessor sessionAccessor = ServiceAccessorFactory.getInstance().createSessionAccessor();
            long tenantId = sessionAccessor.getTenantId();
            return TenantServiceSingleton.getInstance(tenantId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static PlatformServiceAccessor getPlatformServiceAccessor() {
        try {
            return ServiceAccessorFactory.getInstance().createPlatformServiceAccessor();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteProcessDefinition(long processDefinitionId) throws SBonitaException, BonitaHomeNotSetException, IOException {
        TenantServiceAccessor tenantAccessor = ProcessManagementAPIImplDelegate.getTenantAccessor();
        TechnicalLoggerService logger = tenantAccessor.getTechnicalLoggerService();
        DeleteProcess deleteProcess = this.instantiateDeleteProcessTransactionContent(processDefinitionId);
        deleteProcess.execute();
        String processesFolder = BonitaHomeServer.getInstance().getProcessesFolder(tenantAccessor.getTenantId());
        File file = new File(processesFolder);
        if (!file.exists()) {
            file.mkdir();
        }
        File processFolder = new File(file, String.valueOf(processDefinitionId));
        IOUtil.deleteDir((File)processFolder);
        if (logger.isLoggable(this.getClass(), TechnicalLogSeverity.INFO)) {
            logger.log(this.getClass(), TechnicalLogSeverity.INFO, "The user <" + SessionInfos.getUserNameFromSession() + "> has deleted process with id = <" + processDefinitionId + ">");
        }
    }

    @Deprecated
    public void deleteProcess(long processDefinitionId) throws SBonitaException, BonitaHomeNotSetException {
        TenantServiceAccessor tenantAccessor = ProcessManagementAPIImplDelegate.getTenantAccessor();
        DeleteProcess deleteProcess = new DeleteProcess(ProcessManagementAPIImplDelegate.getTenantAccessor(), processDefinitionId);
        deleteProcess.execute();
        String processesFolder = BonitaHomeServer.getInstance().getProcessesFolder(tenantAccessor.getTenantId());
        File file = new File(processesFolder);
        if (!file.exists()) {
            file.mkdir();
        }
    }

    protected DeleteProcess instantiateDeleteProcessTransactionContent(long processId) {
        return new DeleteProcess(ProcessManagementAPIImplDelegate.getTenantAccessor(), processId);
    }

    public void disableProcess(long processId) throws SProcessDefinitionNotFoundException, SBonitaException {
        TenantServiceAccessor tenantAccessor = ProcessManagementAPIImplDelegate.getTenantAccessor();
        PlatformServiceAccessor platformServiceAccessor = ProcessManagementAPIImplDelegate.getPlatformServiceAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        EventInstanceService eventInstanceService = tenantAccessor.getEventInstanceService();
        SchedulerService schedulerService = platformServiceAccessor.getSchedulerService();
        TechnicalLoggerService logger = tenantAccessor.getTechnicalLoggerService();
        ClassLoaderService classLoaderService = tenantAccessor.getClassLoaderService();
        DisableProcess transactionContent = new DisableProcess(processDefinitionService, processId, eventInstanceService, schedulerService, logger, SessionInfos.getUserNameFromSession(), classLoaderService);
        transactionContent.execute();
    }
}

